import { ResourceProps } from 'aws-cdk-lib';
import { Construct } from 'constructs';
export interface ThingWithCertProps extends ResourceProps {
    readonly thingName: string;
    readonly saveToParamStore?: boolean;
    readonly paramPrefix?: string;
}
export declare class ThingWithCert extends Construct {
    readonly thingArn: string;
    readonly certId: string;
    readonly certPem: string;
    readonly privKey: string;
    constructor(scope: Construct, id: string, props: ThingWithCertProps);
}
export declare const getParamStorePath: (thingName: string, paramPrefix?: string | undefined) => string;
