"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
require("@aws-cdk/assert/jest");
const s3 = require("@aws-cdk/aws-s3");
const core_1 = require("@aws-cdk/core");
const lib_1 = require("../../lib");
const cache_behavior_1 = require("../../lib/private/cache-behavior");
let app;
let stack;
beforeEach(() => {
    app = new core_1.App();
    stack = new core_1.Stack(app, 'Stack', {
        env: { account: '1234', region: 'testregion' },
    });
});
test('renders the minimum template with an origin and path specified', () => {
    const origin = lib_1.Origin.fromBucket(new s3.Bucket(stack, 'MyBucket'));
    const behavior = new cache_behavior_1.CacheBehavior({
        origin,
        pathPattern: '*',
    });
    origin._bind(stack, { originIndex: 0 });
    expect(behavior._renderBehavior()).toEqual({
        targetOriginId: behavior.origin.id,
        pathPattern: '*',
        forwardedValues: { queryString: false },
        viewerProtocolPolicy: 'allow-all',
    });
});
test('renders with all properties specified', () => {
    const origin = lib_1.Origin.fromBucket(new s3.Bucket(stack, 'MyBucket'));
    const behavior = new cache_behavior_1.CacheBehavior({
        origin,
        pathPattern: '*',
        allowedMethods: lib_1.AllowedMethods.ALLOW_ALL,
        forwardQueryString: true,
        forwardQueryStringCacheKeys: ['user_id', 'auth'],
    });
    origin._bind(stack, { originIndex: 0 });
    expect(behavior._renderBehavior()).toEqual({
        targetOriginId: behavior.origin.id,
        pathPattern: '*',
        allowedMethods: ['GET', 'HEAD', 'OPTIONS', 'PUT', 'PATCH', 'POST', 'DELETE'],
        forwardedValues: {
            queryString: true,
            queryStringCacheKeys: ['user_id', 'auth'],
        },
        viewerProtocolPolicy: 'allow-all',
    });
});
//# sourceMappingURL=data:application/json;base64,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