import { BehaviorOptions } from '../distribution';
import { Origin } from '../origin';
/**
 * Properties for specifying custom behaviors for origins.
 */
export interface CacheBehaviorProps extends BehaviorOptions {
    /**
     * The pattern (e.g., `images/*.jpg`) that specifies which requests to apply the behavior to.
     * There must be exactly one behavior associated with each `Distribution` that has a path pattern
     * of '*', which acts as the catch-all default behavior.
     */
    readonly pathPattern: string;
}
/**
 * Allows configuring a variety of CloudFront functionality for a given URL path pattern.
 *
 * Note: This really should simply by called 'Behavior', but this name is already taken by the legacy
 * CloudFrontWebDistribution implementation.
 */
export declare class CacheBehavior {
    private readonly props;
    /**
     * Origin that this behavior will route traffic to.
     */
    readonly origin: Origin;
    constructor(props: CacheBehaviorProps);
}
