# -*- coding: utf-8 -*-
from setuptools import setup

package_dir = \
{'': 'src'}

packages = \
['rofi_rbw']

package_data = \
{'': ['*'], 'rofi_rbw': ['docs/*']}

install_requires = \
['ConfigArgParse>0.15,<2.0.0']

entry_points = \
{'console_scripts': ['rofi-rbw = rofi_rbw.__main__:main']}

setup_kwargs = {
    'name': 'rofi-rbw',
    'version': '1.1.0',
    'description': 'Rofi frontend for Bitwarden',
    'long_description': '# rbw-rofi\n## A rofi frontend for Bitwarden\n\nBased on the alternative [Bitwarden](https://bitwarden.com/) CLI [rbw](https://github.com/doy/rbw/) and inspired by [rofi-pass](https://github.com/carnager/rofi-pass), `rbw-rofi` is a simplistic password typer/copier using [rofi](https://github.com/davatorium/rofi) and [wofi](https://hg.sr.ht/~scoopta/wofi).\n\n## Features\n- Autotype password or username (`Enter`/`Alt+3` and `Alt+2`, respectively)\n- Autotype username and password (with a `tab` character in between) with `Alt+1` (and copy TOTP to clipboard)\n- Copy username, password or TOTP to the clipboard (`Alt+u`, `Alt+p` and `Alt+t`, respectively)\n- Show an autotype menu with all fields\n\n## Usage\nFirst, you need to configure `rbw`. See its documentation for that.\nThen, you can start `rofi-rbw`. It is *not* available as a rofi mode.\n\n# Configuration\nYou can configure `rofi-rbw` either with cli arguments or with a config file called `$XDG_CONFIG_HOME/rofi-rbw.rc`. In the file, use the long option names without double dashes.\n\n## Options\n\n| long option          | short option | possible values                                      | description                                                                                                                                                                                                                                                                 |\n|----------------------|--------------|------------------------------------------------------|-----------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------|\n| `--action`           | `-a`         | `type` (default), `copy`, `print`                    | Choose what `rofi-rbw` should do.                                                                                                                                                                                                                                           |\n| `--target`           | `-t`         | `username`, `password`, `totp` (or any custom field) | Choose which components of the selected entry are interesting. Can be passed multiple times to type/copy/print several components. Default is `username` and `password`.                                                                                                    |\n| `--prompt`           | `-r`         | any string                                           | Define the text of the prompt.                                                                                                                                                                                                                                              |\n| `--selector-args`    |              |                                                      | Define arguments that will be passed through to `rofi` or `wofi`.<br/>Please note that you need to specify it as `--selector-args="<args>"` or `--selector-args " <args>"` because of a [bug in argparse](https://github.com/python/cpython/issues/53580)                   |\n| `--selector`         |              | `rofi`, `wofi`                                       | Show the selection dialog with this application. Chosen automatically by default.                                                                                                                                                                                           |\n| `--clipboarder`      |              | `xsel`, `xclip`, `wl-copy`                           | Access the clipboard with this application. Chosen automatically by default.                                                                                                                                                                                                |\n| `--typer`            |              | `xdotool`, `wtype`, `ydotool`                        | Type the characters using this application. Chosen automatically by default.                                                                                                                                                                                                |\n| `--clear-after`      |              | integer number >= 0 (default is `0`)                 | Limit the duration in seconds passwords stay in your clipboard (unless overwritten). When set to 0, passwords will be kept indefinitely.                                                                                                                                    |\n| `--no-help`          |              |                                                      | Don\'t show the help message about the available shortcuts.                                                                                                                                                                                                                  |\n| `--no-folder`        |              |                                                      | Don\'t show the entry\'s folder in the list.                                                                                                                                                                                                                                  |\n| `--keybindings`      |              |                                                      | Define custom keybindings in the format `<shortcut>:<action>:<target>`, for example `Alt+n:copy:username`. Multiple keybindings can be concatenated with `,`; multiple targets for one shortcut can be concatenated with `:`. Note that `wofi` doesn\'t support keybindings. |\n| `--menu-keybindings` |              |                                                      | Define custom keybindings for the target menu in the format `<shortcut>:<action>`, similar to `--keybindings`. Note that `wofi` doesn\'t support keybindings.                                                                                                                |\n\n# Installation\n\n## From distribution repositories\n[![Packaging status](https://repology.org/badge/vertical-allrepos/rofi-rbw.svg)](https://repology.org/project/rofi-rbw/versions)\n\n## From PyPI\n`rofi-rbw` is on [PyPI](https://pypi.org/project/rofi-rbw/). You can install it with `pip install --user rofi-rbw` (or `sudo pip install rofi-rbw`).\n\n## Manually\nDownload the wheel file from releases and install it with  `sudo pip install $filename` (or you can use `pip install --user $filename` to only install it for the local user).\nNote that it needs `configargparse` to work.\n\n## Dependencies\nYou also need:\n- Python 3.7 or higher\n- `rofi` or `wofi`\n- Something to programmatically type characters into other applications. Depending on your display server, it\'s `xdotool`, `wtype` or `ydotool`.\n- Something to copy text to the clipboard. Again, depending on the display server, you want `xclip`, `xsel` or `wl-copy`.\n',
    'author': 'Fabian Winter',
    'author_email': '5821180+fdw@users.noreply.github.com',
    'maintainer': 'None',
    'maintainer_email': 'None',
    'url': 'https://github.com/fdw/rofi-rbw',
    'package_dir': package_dir,
    'packages': packages,
    'package_data': package_data,
    'install_requires': install_requires,
    'entry_points': entry_points,
    'python_requires': '>=3.8,<4.0',
}


setup(**setup_kwargs)
