import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
export interface DataGitlabReleaseLinkConfig extends cdktf.TerraformMetaArguments {
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/gitlab/d/release_link#id DataGitlabReleaseLink#id}
    *
    * Please be aware that the id field is automatically added to all resources in Terraform providers using a Terraform provider SDK version below 2.
    * If you experience problems setting this value it might not be settable. Please take a look at the provider documentation to ensure it should be settable.
    */
    readonly id?: string;
    /**
    * The ID of the link.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/gitlab/d/release_link#link_id DataGitlabReleaseLink#link_id}
    */
    readonly linkId: number;
    /**
    * The ID or [URL-encoded path of the project](https://docs.gitlab.com/ee/api/index.html#namespaced-path-encoding).
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/gitlab/d/release_link#project DataGitlabReleaseLink#project}
    */
    readonly project: string;
    /**
    * The tag associated with the Release.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/gitlab/d/release_link#tag_name DataGitlabReleaseLink#tag_name}
    */
    readonly tagName: string;
}
/**
* Represents a {@link https://www.terraform.io/docs/providers/gitlab/d/release_link gitlab_release_link}
*/
export declare class DataGitlabReleaseLink extends cdktf.TerraformDataSource {
    static readonly tfResourceType = "gitlab_release_link";
    /**
    * Create a new {@link https://www.terraform.io/docs/providers/gitlab/d/release_link gitlab_release_link} Data Source
    *
    * @param scope The scope in which to define this construct
    * @param id The scoped construct ID. Must be unique amongst siblings in the same scope
    * @param options DataGitlabReleaseLinkConfig
    */
    constructor(scope: Construct, id: string, config: DataGitlabReleaseLinkConfig);
    get directAssetUrl(): string;
    get external(): cdktf.IResolvable;
    get filepath(): string;
    private _id?;
    get id(): string;
    set id(value: string);
    resetId(): void;
    get idInput(): string | undefined;
    private _linkId?;
    get linkId(): number;
    set linkId(value: number);
    get linkIdInput(): number | undefined;
    get linkType(): string;
    get name(): string;
    private _project?;
    get project(): string;
    set project(value: string);
    get projectInput(): string | undefined;
    private _tagName?;
    get tagName(): string;
    set tagName(value: string);
    get tagNameInput(): string | undefined;
    get url(): string;
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
}
