var __rest = (this && this.__rest) || function (s, e) {
    var t = {};
    for (var p in s) if (Object.prototype.hasOwnProperty.call(s, p) && e.indexOf(p) < 0)
        t[p] = s[p];
    if (s != null && typeof Object.getOwnPropertySymbols === "function")
        for (var i = 0, p = Object.getOwnPropertySymbols(s); i < p.length; i++) {
            if (e.indexOf(p[i]) < 0 && Object.prototype.propertyIsEnumerable.call(s, p[i]))
                t[p[i]] = s[p[i]];
        }
    return t;
};
import React from 'react';
import { createUseStyles } from 'react-jss';
const useStyles = createUseStyles({
    control: {
        display: 'flex',
        flexDirection: 'row',
        border: (props) => `1px solid ${props.outlineColor || 'var(--jp-border-color1)'}`,
        alignItems: 'stretch'
    },
    input: {
        flex: 1,
        background: 'none',
        border: 'none',
        outline: 'none',
        padding: '8px',
        minWidth: 0,
        color: (props) => props.color || 'var(--jp-ui-font-color1)'
    },
    block: {
        width: '100%'
    }
});
const _TextField = (props, ref) => {
    const { block, before, after, outlineColor, className } = props, carriedProps = __rest(props, ["block", "before", "after", "outlineColor", "className"]);
    const classes = useStyles({ outlineColor });
    const inputClasses = [classes.input];
    if (block) {
        inputClasses.push(classes.block);
    }
    return (React.createElement("div", { className: classes.control },
        before,
        React.createElement("input", Object.assign({ ref: ref, type: "text", className: inputClasses.join(' ') + ' ' + className || '' }, carriedProps)),
        after));
};
export const TextField = React.forwardRef(_TextField);
