# Generated by Django 4.1.3 on 2023-03-16 13:49

import uuid

import django.db.models.deletion
from django.conf import settings
from django.db import migrations, models


class Migration(migrations.Migration):
    dependencies = [
        (
            "django_workflow_engine",
            "0009_rename_taskrecord_taskrecordexecution_and_create_new_taskstatus",
        ),
    ]

    operations = [
        migrations.RenameModel(
            old_name="Target",
            new_name="TaskRecordExecutionTarget",
        ),
        migrations.RenameModel(
            old_name="TaskLog",
            new_name="TaskRecordExecutionTaskLog",
        ),
        migrations.CreateModel(
            name="TaskStatus",
            fields=[
                (
                    "id",
                    models.BigAutoField(
                        auto_created=True,
                        primary_key=True,
                        serialize=False,
                        verbose_name="ID",
                    ),
                ),
                ("uuid", models.UUIDField(default=uuid.uuid4, editable=False)),
                ("started_at", models.DateTimeField(auto_now_add=True)),
                ("executed_at", models.DateTimeField(null=True)),
                ("step_id", models.CharField(max_length=100)),
                ("task_name", models.CharField(max_length=100)),
                ("task_info", models.JSONField(default=dict)),
                ("done", models.BooleanField(default=False)),
                (
                    "executed_by",
                    models.ForeignKey(
                        blank=True,
                        null=True,
                        on_delete=django.db.models.deletion.CASCADE,
                        related_name="tasks",
                        to=settings.AUTH_USER_MODEL,
                    ),
                ),
                (
                    "flow",
                    models.ForeignKey(
                        on_delete=django.db.models.deletion.CASCADE,
                        related_name="tasks",
                        to="django_workflow_engine.flow",
                    ),
                ),
            ],
        ),
        migrations.CreateModel(
            name="TaskLog",
            fields=[
                (
                    "id",
                    models.BigAutoField(
                        auto_created=True,
                        primary_key=True,
                        serialize=False,
                        verbose_name="ID",
                    ),
                ),
                ("logged_at", models.DateTimeField(auto_now_add=True)),
                ("message", models.CharField(max_length=255)),
                (
                    "task_status",
                    models.ForeignKey(
                        on_delete=django.db.models.deletion.CASCADE,
                        related_name="log",
                        to="django_workflow_engine.taskstatus",
                    ),
                ),
            ],
        ),
        migrations.CreateModel(
            name="Target",
            fields=[
                (
                    "id",
                    models.BigAutoField(
                        auto_created=True,
                        primary_key=True,
                        serialize=False,
                        verbose_name="ID",
                    ),
                ),
                (
                    "target_string",
                    models.CharField(blank=True, max_length=100, null=True),
                ),
                (
                    "task_status",
                    models.ForeignKey(
                        on_delete=django.db.models.deletion.CASCADE,
                        related_name="targets",
                        to="django_workflow_engine.taskstatus",
                    ),
                ),
            ],
        ),
    ]
