# Generated by Django 4.0.1 on 2022-01-26 12:30

from django.db import migrations, models

from shaarpy.tools import small_hash


def url_hashing(apps, schema_editor):
    """
        convert classical URL to tiny one
    """
    Links = apps.get_model("shaarpy", "Links")
    db_alias = schema_editor.connection.alias
    links = Links.objects.using(db_alias).all()

    for link in links:
        link.url_hashed = small_hash(link.date_created.strftime("%Y%m%d_%H%M%S"))
        link.save()


class Migration(migrations.Migration):

    dependencies = [
        ('shaarpy', '0003_links_url_hashed_alter_links_id'),
    ]

    operations = [
        migrations.AlterField(
            model_name='links',
            name='url_hashed',
            field=models.SlugField(blank=True, max_length=10, null=True),
        ),
        migrations.RunPython(url_hashing),
    ]
