# Automatically generated code: EDIT AT YOUR OWN RISK
from traits import api as traits
from traitsui.item import Item, spring
from traitsui.group import HGroup
from traitsui.view import View

from tvtk import vtk_module as vtk
from tvtk import tvtk_base
from tvtk.tvtk_base_handler import TVTKBaseHandler
from tvtk import messenger
from tvtk.tvtk_base import deref_vtk
from tvtk import array_handler
from tvtk.array_handler import deref_array
from tvtk.tvtk_classes.tvtk_helper import wrap_vtk

nan = float('nan')


def InstanceEditor(*args, **kw):
    from traitsui.editors.api import InstanceEditor as Editor
    return Editor(view_name="handler.view")

try:
    long
except NameError:
    # Silly workaround for Python3.
    long = int

inf = float('inf')

from tvtk.tvtk_classes.object import Object


class ExprTkFunctionParser(Object):
    r"""
    ExprTkFunctionParser - Parse and evaluate a mathematical expression
    
    Superclass: Object
    
    ExprTkFunctionParser is a wrapper class of the expr_tk library that
    takes in a mathematical expression as a char string, parses it, and
    evaluates it at the specified values of the variables in the input
    string.
    
    The detailed documentation of the supported functionality is
    described in https://github.com/arash_partow/exprtk. In addition to
    the documented functionality, the following vector operations have
    been implemented:
    1) cross(v1, v2), cross product of two vectors,
    2) mag(v), magnitude of a vector,
    3) norm(v), the normalized version of a vector.
    
    @par Thanks: Arash Partow for implementing the expr_tk library.
    
    """
    def __init__(self, obj=None, update=True, **traits):
        tvtk_base.TVTKBase.__init__(self, vtk.vtkExprTkFunctionParser, obj, update, **traits)
    
    replace_invalid_values = tvtk_base.false_bool_trait(desc=\
        r"""
        When replace_invalid_values is on, all invalid values (such as
        sqrt(-2), note that function parser does not handle complex
        numbers) will be replaced by replacement_value. Otherwise an error
        will be reported
        """
    )

    def _replace_invalid_values_changed(self, old_val, new_val):
        self._do_change(self._vtk_obj.SetReplaceInvalidValues,
                        self.replace_invalid_values_)

    function = traits.String('', enter_set=True, auto_set=False, desc=\
        r"""
        Set/Get input string to evaluate.
        """
    )

    def _function_changed(self, old_val, new_val):
        self._do_change(self._vtk_obj.SetFunction,
                        self.function)

    replacement_value = traits.Float(0.0, enter_set=True, auto_set=False, desc=\
        r"""
        
        """
    )

    def _replacement_value_changed(self, old_val, new_val):
        self._do_change(self._vtk_obj.SetReplacementValue,
                        self.replacement_value)

    def get_scalar_variable_value(self, *args):
        """
        get_scalar_variable_value(self, variableName:str) -> float
        C++: double get_scalar_variable_value(
            const std::string &variableName)
        get_scalar_variable_value(self, i:int) -> float
        C++: double get_scalar_variable_value(int i)
        Get the value of a scalar variable.
        """
        ret = self._wrap_call(self._vtk_obj.GetScalarVariableValue, *args)
        return ret

    def set_scalar_variable_value(self, *args):
        """
        set_scalar_variable_value(self, variableName:str, value:float)
            -> None
        C++: void set_scalar_variable_value(const std::string &variableName,
            double value)
        set_scalar_variable_value(self, i:int, value:float) -> None
        C++: void set_scalar_variable_value(int i, double value)
        Set the value of a scalar variable.  If a variable with this name
        exists, then its value will be set to the new value.  If there is
        not already a variable with this name, variableName will be added
        to the list of variables, and its value will be set to the new
        value. If the variable name is not sanitized, it should be
        provided in quotes, and a valid unique string will be used as a
        replacement by the parser.
        
        ote A sanitized variable name is accepted by the following regex:
        ^[a-zA-Z][a-zA-Z_0-9]*.
        """
        ret = self._wrap_call(self._vtk_obj.SetScalarVariableValue, *args)
        return ret

    def get_vector_variable_value(self, *args):
        """
        get_vector_variable_value(self, variableName:str) -> (float, float,
            float)
        C++: double *get_vector_variable_value(
            const std::string &variableName)
        get_vector_variable_value(self, variableName:str, value:[float,
            float, float]) -> None
        C++: void get_vector_variable_value(const std::string &variableName,
            double value[3])
        get_vector_variable_value(self, i:int) -> (float, float, float)
        C++: double *get_vector_variable_value(int i)
        get_vector_variable_value(self, i:int, value:[float, float, float])
            -> None
        C++: void get_vector_variable_value(int i, double value[3])
        Get the value of a vector variable.
        """
        ret = self._wrap_call(self._vtk_obj.GetVectorVariableValue, *args)
        return ret

    def set_vector_variable_value(self, *args):
        """
        set_vector_variable_value(self, variableName:str, xValue:float,
            yValue:float, zValue:float) -> None
        C++: void set_vector_variable_value(const std::string &variableName,
            double xValue, double yValue, double zValue)
        set_vector_variable_value(self, variableName:str, values:[float,
            float, float]) -> None
        C++: void set_vector_variable_value(const std::string &variableName,
            double values[3])
        set_vector_variable_value(self, i:int, xValue:float, yValue:float,
            zValue:float) -> None
        C++: void set_vector_variable_value(int i, double xValue,
            double yValue, double zValue)
        set_vector_variable_value(self, i:int, values:[float, float, float])
            -> None
        C++: void set_vector_variable_value(int i, double values[3])
        Set the value of a vector variable.  If a variable with this name
        exists, then its value will be set to the new value.  If there is
        not already a variable with this name, variableName will be added
        to the list of variables, and its value will be set to the new
        value. If the variable name is not sanitized, it should be
        provided in quotes, and a valid unique string will be used as a
        replacement by the parser.
        
        ote A sanitized variable name is accepted by the following regex:
        ^[a-zA-Z][a-zA-Z_0-9]*.
        """
        ret = self._wrap_call(self._vtk_obj.SetVectorVariableValue, *args)
        return ret

    def _get_number_of_scalar_variables(self):
        return self._vtk_obj.GetNumberOfScalarVariables()
    number_of_scalar_variables = traits.Property(_get_number_of_scalar_variables, desc=\
        r"""
        Get the number of scalar variables.
        """
    )

    def _get_number_of_vector_variables(self):
        return self._vtk_obj.GetNumberOfVectorVariables()
    number_of_vector_variables = traits.Property(_get_number_of_vector_variables, desc=\
        r"""
        Get the number of vector variables.
        """
    )

    def _get_scalar_result(self):
        return self._vtk_obj.GetScalarResult()
    scalar_result = traits.Property(_get_scalar_result, desc=\
        r"""
        Get a scalar result from evaluating the input function.
        
        If replace_invalid_values is not set, then the error value that
        will be return is NaN.
        """
    )

    def get_scalar_variable_index(self, *args):
        """
        get_scalar_variable_index(self, name:str) -> int
        C++: int get_scalar_variable_index(const std::string &name)
        Get scalar variable index or -1 if not found
        """
        ret = self._wrap_call(self._vtk_obj.GetScalarVariableIndex, *args)
        return ret

    def get_scalar_variable_name(self, *args):
        """
        get_scalar_variable_name(self, i:int) -> str
        C++: std::string get_scalar_variable_name(int i)
        Get the ith scalar variable name.
        """
        ret = self._wrap_call(self._vtk_obj.GetScalarVariableName, *args)
        return ret

    def get_scalar_variable_needed(self, *args):
        """
        get_scalar_variable_needed(self, i:int) -> bool
        C++: bool get_scalar_variable_needed(int i)
        get_scalar_variable_needed(self, variableName:str) -> bool
        C++: bool get_scalar_variable_needed(const std::string &variableName)
        Returns whether a scalar variable is needed for the function
        evaluation. This is only valid after a successful Parse(). Thus,
        call get_scalar_result() or is_scalar_result() or similar method
        before calling this.
        """
        ret = self._wrap_call(self._vtk_obj.GetScalarVariableNeeded, *args)
        return ret

    def _get_vector_result(self):
        return self._vtk_obj.GetVectorResult()
    vector_result = traits.Property(_get_vector_result, desc=\
        r"""
        Get a vector result from evaluating the input function.
        
        If replace_invalid_values is not set, then the error value that
        will be return is [NaN, NaN, NaN].
        """
    )

    def get_vector_result(self, *args):
        """
        get_vector_result(self) -> (float, float, float)
        C++: double *get_vector_result()
        get_vector_result(self, result:[float, float, float]) -> None
        C++: void get_vector_result(double result[3])
        Get a vector result from evaluating the input function.
        
        If replace_invalid_values is not set, then the error value that
        will be return is [NaN, NaN, NaN].
        """
        ret = self._wrap_call(self._vtk_obj.GetVectorResult, *args)
        return ret

    def get_vector_variable_index(self, *args):
        """
        get_vector_variable_index(self, name:str) -> int
        C++: int get_vector_variable_index(const std::string &name)
        Get scalar variable index or -1 if not found
        """
        ret = self._wrap_call(self._vtk_obj.GetVectorVariableIndex, *args)
        return ret

    def get_vector_variable_name(self, *args):
        """
        get_vector_variable_name(self, i:int) -> str
        C++: std::string get_vector_variable_name(int i)
        Get the ith vector variable name.
        """
        ret = self._wrap_call(self._vtk_obj.GetVectorVariableName, *args)
        return ret

    def get_vector_variable_needed(self, *args):
        """
        get_vector_variable_needed(self, i:int) -> bool
        C++: bool get_vector_variable_needed(int i)
        get_vector_variable_needed(self, variableName:str) -> bool
        C++: bool get_vector_variable_needed(const std::string &variableName)
        Returns whether a vector variable is needed for the function
        evaluation. This is only valid after a successful Parse(). Thus,
        call get_vector_result() or is_vector_result() or similar method
        before calling this.
        """
        ret = self._wrap_call(self._vtk_obj.GetVectorVariableNeeded, *args)
        return ret

    def invalidate_function(self):
        """
        invalidate_function(self) -> None
        C++: void invalidate_function()
        Allow the user to force the function to be re-parsed
        """
        ret = self._vtk_obj.InvalidateFunction()
        return ret
        

    def is_scalar_result(self):
        """
        is_scalar_result(self) -> int
        C++: int is_scalar_result()
        Check whether the result is a scalar result.  If it isn't, then
        either the result is a vector or an error has occurred.
        """
        ret = self._vtk_obj.IsScalarResult()
        return ret
        

    def is_vector_result(self):
        """
        is_vector_result(self) -> int
        C++: int is_vector_result()
        Check whether the result is a vector result.  If it isn't, then
        either the result is scalar or an error has occurred.
        """
        ret = self._vtk_obj.IsVectorResult()
        return ret
        

    def remove_all_variables(self):
        """
        remove_all_variables(self) -> None
        C++: void remove_all_variables()
        Remove all the current variables.
        """
        ret = self._vtk_obj.RemoveAllVariables()
        return ret
        

    def remove_scalar_variables(self):
        """
        remove_scalar_variables(self) -> None
        C++: void remove_scalar_variables()
        Remove all the scalar variables.
        """
        ret = self._vtk_obj.RemoveScalarVariables()
        return ret
        

    def remove_vector_variables(self):
        """
        remove_vector_variables(self) -> None
        C++: void remove_vector_variables()
        Remove all the vector variables.
        """
        ret = self._vtk_obj.RemoveVectorVariables()
        return ret
        

    def sanitize_name(self, *args):
        """
        sanitize_name(name:str) -> str
        C++: static std::string sanitize_name(const char *name)
        Sanitize a label/name to remove spaces, delimiters etc. Once the
        label/name is sanitized is can be accepted by the following
        regex: ^[a-zA-Z][a-zA-Z_0-9]*.
        
        ote taken from SMCoreUtilities
        """
        ret = self._wrap_call(self._vtk_obj.SanitizeName, *args)
        return ret

    _updateable_traits_ = \
    (('replace_invalid_values', 'GetReplaceInvalidValues'), ('debug',
    'GetDebug'), ('global_warning_display', 'GetGlobalWarningDisplay'),
    ('function', 'GetFunction'), ('replacement_value',
    'GetReplacementValue'), ('object_name', 'GetObjectName'),
    ('reference_count', 'GetReferenceCount'))
    
    _allow_update_failure_ = \
    ()
    
    _full_traitnames_list_ = \
    (['debug', 'global_warning_display', 'replace_invalid_values',
    'function', 'object_name', 'replacement_value'])
    
    def trait_view(self, name=None, view_element=None):
        if view_element is not None or name not in (None, '', 'traits_view', 'full_traits_view', 'view'):
            return super(ExprTkFunctionParser, self).trait_view(name, view_element)
        if name == 'full_traits_view':
            full_traits_view = \
            View((Item("handler._full_traits_list",show_label=False)),
            title='Edit ExprTkFunctionParser properties', scrollable=True, resizable=True,
            handler=TVTKBaseHandler,
            buttons=['OK', 'Cancel'])
            return full_traits_view
        elif name == 'view':
            view = \
            View((['replace_invalid_values'], [], ['function', 'object_name',
            'replacement_value']),
            title='Edit ExprTkFunctionParser properties', scrollable=True, resizable=True,
            handler=TVTKBaseHandler,
            buttons=['OK', 'Cancel'])
            return view
        elif name in (None, 'traits_view'):
            traits_view = \
            View((HGroup(spring, "handler.view_type", show_border=True), 
            Item("handler.info.object", editor = InstanceEditor(view_name="handler.view"), style = "custom", show_label=False)),
            title='Edit ExprTkFunctionParser properties', scrollable=True, resizable=True,
            handler=TVTKBaseHandler,
            buttons=['OK', 'Cancel'])
            return traits_view
            

