# coding=utf-8
# --------------------------------------------------------------------------
# Copyright (c) Microsoft Corporation. All rights reserved.
# Licensed under the MIT License. See License.txt in the project root for
# license information.
#
# Code generated by Microsoft (R) AutoRest Code Generator.
# Changes may cause incorrect behavior and will be lost if the code is
# regenerated.
# --------------------------------------------------------------------------

import uuid
from msrest.pipeline import ClientRawResponse
from msrestazure.azure_exceptions import CloudError

from .. import models


class SqlVulnerabilityAssessmentBaselineRulesOperations(object):
    """SqlVulnerabilityAssessmentBaselineRulesOperations operations.

    You should not instantiate directly this class, but create a Client instance that will create it for you and attach it as attribute.

    :param client: Client for service requests.
    :param config: Configuration of service client.
    :param serializer: An object model serializer.
    :param deserializer: An object model deserializer.
    """

    models = models

    def __init__(self, client, config, serializer, deserializer):

        self._client = client
        self._serialize = serializer
        self._deserialize = deserializer

        self.config = config

    def create_or_update(
            self, rule_id, workspace_id, api_version, resource_id, latest_scan=None, results=None, custom_headers=None, raw=False, **operation_config):
        """Creates a Baseline for a rule in a database. Will overwrite any
        previously existing results.

        :param rule_id: The rule Id.
        :type rule_id: str
        :param workspace_id: The workspace Id.
        :type workspace_id: str
        :param api_version: The api version.
        :type api_version: str
        :param resource_id: The identifier of the resource.
        :type resource_id: str
        :param latest_scan: Take results from latest scan.
        :type latest_scan: bool
        :param results: Expected results to be inserted into the baseline.
         Leave this field empty it LatestScan == true.
        :type results: list[list[str]]
        :param dict custom_headers: headers that will be added to the request
        :param bool raw: returns the direct response alongside the
         deserialized response
        :param operation_config: :ref:`Operation configuration
         overrides<msrest:optionsforoperations>`.
        :return: RuleResults or ClientRawResponse if raw=true
        :rtype: ~azure.mgmt.security.models.RuleResults or
         ~msrest.pipeline.ClientRawResponse
        :raises: :class:`CloudError<msrestazure.azure_exceptions.CloudError>`
        """
        body = None
        if latest_scan is not None or results is not None:
            body = models.RuleResultsInput(latest_scan=latest_scan, results=results)

        # Construct URL
        url = self.create_or_update.metadata['url']
        path_format_arguments = {
            'ruleId': self._serialize.url("rule_id", rule_id, 'str'),
            'resourceId': self._serialize.url("resource_id", resource_id, 'str', skip_quote=True)
        }
        url = self._client.format_url(url, **path_format_arguments)

        # Construct parameters
        query_parameters = {}
        query_parameters['workspaceId'] = self._serialize.query("workspace_id", workspace_id, 'str')
        query_parameters['api-version'] = self._serialize.query("api_version", api_version, 'str')

        # Construct headers
        header_parameters = {}
        header_parameters['Accept'] = 'application/json'
        header_parameters['Content-Type'] = 'application/json; charset=utf-8'
        if self.config.generate_client_request_id:
            header_parameters['x-ms-client-request-id'] = str(uuid.uuid1())
        if custom_headers:
            header_parameters.update(custom_headers)
        if self.config.accept_language is not None:
            header_parameters['accept-language'] = self._serialize.header("self.config.accept_language", self.config.accept_language, 'str')

        # Construct body
        if body is not None:
            body_content = self._serialize.body(body, 'RuleResultsInput')
        else:
            body_content = None

        # Construct and send request
        request = self._client.put(url, query_parameters, header_parameters, body_content)
        response = self._client.send(request, stream=False, **operation_config)

        if response.status_code not in [200]:
            exp = CloudError(response)
            exp.request_id = response.headers.get('x-ms-request-id')
            raise exp

        deserialized = None
        if response.status_code == 200:
            deserialized = self._deserialize('RuleResults', response)

        if raw:
            client_raw_response = ClientRawResponse(deserialized, response)
            return client_raw_response

        return deserialized
    create_or_update.metadata = {'url': '/{resourceId}/providers/Microsoft.Security/sqlVulnerabilityAssessments/default/baselineRules/{ruleId}'}

    def get(
            self, rule_id, workspace_id, api_version, resource_id, custom_headers=None, raw=False, **operation_config):
        """Gets the results for a given rule in the Baseline.

        :param rule_id: The rule Id.
        :type rule_id: str
        :param workspace_id: The workspace Id.
        :type workspace_id: str
        :param api_version: The api version.
        :type api_version: str
        :param resource_id: The identifier of the resource.
        :type resource_id: str
        :param dict custom_headers: headers that will be added to the request
        :param bool raw: returns the direct response alongside the
         deserialized response
        :param operation_config: :ref:`Operation configuration
         overrides<msrest:optionsforoperations>`.
        :return: RuleResults or ClientRawResponse if raw=true
        :rtype: ~azure.mgmt.security.models.RuleResults or
         ~msrest.pipeline.ClientRawResponse
        :raises: :class:`CloudError<msrestazure.azure_exceptions.CloudError>`
        """
        # Construct URL
        url = self.get.metadata['url']
        path_format_arguments = {
            'ruleId': self._serialize.url("rule_id", rule_id, 'str'),
            'resourceId': self._serialize.url("resource_id", resource_id, 'str', skip_quote=True)
        }
        url = self._client.format_url(url, **path_format_arguments)

        # Construct parameters
        query_parameters = {}
        query_parameters['workspaceId'] = self._serialize.query("workspace_id", workspace_id, 'str')
        query_parameters['api-version'] = self._serialize.query("api_version", api_version, 'str')

        # Construct headers
        header_parameters = {}
        header_parameters['Accept'] = 'application/json'
        if self.config.generate_client_request_id:
            header_parameters['x-ms-client-request-id'] = str(uuid.uuid1())
        if custom_headers:
            header_parameters.update(custom_headers)
        if self.config.accept_language is not None:
            header_parameters['accept-language'] = self._serialize.header("self.config.accept_language", self.config.accept_language, 'str')

        # Construct and send request
        request = self._client.get(url, query_parameters, header_parameters)
        response = self._client.send(request, stream=False, **operation_config)

        if response.status_code not in [200]:
            exp = CloudError(response)
            exp.request_id = response.headers.get('x-ms-request-id')
            raise exp

        deserialized = None
        if response.status_code == 200:
            deserialized = self._deserialize('RuleResults', response)

        if raw:
            client_raw_response = ClientRawResponse(deserialized, response)
            return client_raw_response

        return deserialized
    get.metadata = {'url': '/{resourceId}/providers/Microsoft.Security/sqlVulnerabilityAssessments/default/baselineRules/{ruleId}'}

    def delete(
            self, rule_id, workspace_id, api_version, resource_id, custom_headers=None, raw=False, **operation_config):
        """Deletes a rule from the Baseline of a given database.

        :param rule_id: The rule Id.
        :type rule_id: str
        :param workspace_id: The workspace Id.
        :type workspace_id: str
        :param api_version: The api version.
        :type api_version: str
        :param resource_id: The identifier of the resource.
        :type resource_id: str
        :param dict custom_headers: headers that will be added to the request
        :param bool raw: returns the direct response alongside the
         deserialized response
        :param operation_config: :ref:`Operation configuration
         overrides<msrest:optionsforoperations>`.
        :return: None or ClientRawResponse if raw=true
        :rtype: None or ~msrest.pipeline.ClientRawResponse
        :raises: :class:`CloudError<msrestazure.azure_exceptions.CloudError>`
        """
        # Construct URL
        url = self.delete.metadata['url']
        path_format_arguments = {
            'ruleId': self._serialize.url("rule_id", rule_id, 'str'),
            'resourceId': self._serialize.url("resource_id", resource_id, 'str', skip_quote=True)
        }
        url = self._client.format_url(url, **path_format_arguments)

        # Construct parameters
        query_parameters = {}
        query_parameters['workspaceId'] = self._serialize.query("workspace_id", workspace_id, 'str')
        query_parameters['api-version'] = self._serialize.query("api_version", api_version, 'str')

        # Construct headers
        header_parameters = {}
        if self.config.generate_client_request_id:
            header_parameters['x-ms-client-request-id'] = str(uuid.uuid1())
        if custom_headers:
            header_parameters.update(custom_headers)
        if self.config.accept_language is not None:
            header_parameters['accept-language'] = self._serialize.header("self.config.accept_language", self.config.accept_language, 'str')

        # Construct and send request
        request = self._client.delete(url, query_parameters, header_parameters)
        response = self._client.send(request, stream=False, **operation_config)

        if response.status_code not in [200, 204]:
            exp = CloudError(response)
            exp.request_id = response.headers.get('x-ms-request-id')
            raise exp

        if raw:
            client_raw_response = ClientRawResponse(None, response)
            return client_raw_response
    delete.metadata = {'url': '/{resourceId}/providers/Microsoft.Security/sqlVulnerabilityAssessments/default/baselineRules/{ruleId}'}

    def list(
            self, workspace_id, api_version, resource_id, custom_headers=None, raw=False, **operation_config):
        """Gets the results for all rules in the Baseline.

        :param workspace_id: The workspace Id.
        :type workspace_id: str
        :param api_version: The api version.
        :type api_version: str
        :param resource_id: The identifier of the resource.
        :type resource_id: str
        :param dict custom_headers: headers that will be added to the request
        :param bool raw: returns the direct response alongside the
         deserialized response
        :param operation_config: :ref:`Operation configuration
         overrides<msrest:optionsforoperations>`.
        :return: RulesResults or ClientRawResponse if raw=true
        :rtype: ~azure.mgmt.security.models.RulesResults or
         ~msrest.pipeline.ClientRawResponse
        :raises: :class:`CloudError<msrestazure.azure_exceptions.CloudError>`
        """
        # Construct URL
        url = self.list.metadata['url']
        path_format_arguments = {
            'resourceId': self._serialize.url("resource_id", resource_id, 'str', skip_quote=True)
        }
        url = self._client.format_url(url, **path_format_arguments)

        # Construct parameters
        query_parameters = {}
        query_parameters['workspaceId'] = self._serialize.query("workspace_id", workspace_id, 'str')
        query_parameters['api-version'] = self._serialize.query("api_version", api_version, 'str')

        # Construct headers
        header_parameters = {}
        header_parameters['Accept'] = 'application/json'
        if self.config.generate_client_request_id:
            header_parameters['x-ms-client-request-id'] = str(uuid.uuid1())
        if custom_headers:
            header_parameters.update(custom_headers)
        if self.config.accept_language is not None:
            header_parameters['accept-language'] = self._serialize.header("self.config.accept_language", self.config.accept_language, 'str')

        # Construct and send request
        request = self._client.get(url, query_parameters, header_parameters)
        response = self._client.send(request, stream=False, **operation_config)

        if response.status_code not in [200]:
            exp = CloudError(response)
            exp.request_id = response.headers.get('x-ms-request-id')
            raise exp

        deserialized = None
        if response.status_code == 200:
            deserialized = self._deserialize('RulesResults', response)

        if raw:
            client_raw_response = ClientRawResponse(deserialized, response)
            return client_raw_response

        return deserialized
    list.metadata = {'url': '/{resourceId}/providers/Microsoft.Security/sqlVulnerabilityAssessments/default/baselineRules'}

    def add(
            self, workspace_id, api_version, resource_id, latest_scan=None, results=None, custom_headers=None, raw=False, **operation_config):
        """Add a list of baseline rules. Will overwrite any previously existing
        results (for all rules).

        :param workspace_id: The workspace Id.
        :type workspace_id: str
        :param api_version: The api version.
        :type api_version: str
        :param resource_id: The identifier of the resource.
        :type resource_id: str
        :param latest_scan: Take results from latest scan.
        :type latest_scan: bool
        :param results: Expected results to be inserted into the baseline.
         Leave this field empty it LatestScan == true.
        :type results: dict[str, list[list[str]]]
        :param dict custom_headers: headers that will be added to the request
        :param bool raw: returns the direct response alongside the
         deserialized response
        :param operation_config: :ref:`Operation configuration
         overrides<msrest:optionsforoperations>`.
        :return: RulesResults or ClientRawResponse if raw=true
        :rtype: ~azure.mgmt.security.models.RulesResults or
         ~msrest.pipeline.ClientRawResponse
        :raises: :class:`CloudError<msrestazure.azure_exceptions.CloudError>`
        """
        body = None
        if latest_scan is not None or results is not None:
            body = models.RulesResultsInput(latest_scan=latest_scan, results=results)

        # Construct URL
        url = self.add.metadata['url']
        path_format_arguments = {
            'resourceId': self._serialize.url("resource_id", resource_id, 'str', skip_quote=True)
        }
        url = self._client.format_url(url, **path_format_arguments)

        # Construct parameters
        query_parameters = {}
        query_parameters['workspaceId'] = self._serialize.query("workspace_id", workspace_id, 'str')
        query_parameters['api-version'] = self._serialize.query("api_version", api_version, 'str')

        # Construct headers
        header_parameters = {}
        header_parameters['Accept'] = 'application/json'
        header_parameters['Content-Type'] = 'application/json; charset=utf-8'
        if self.config.generate_client_request_id:
            header_parameters['x-ms-client-request-id'] = str(uuid.uuid1())
        if custom_headers:
            header_parameters.update(custom_headers)
        if self.config.accept_language is not None:
            header_parameters['accept-language'] = self._serialize.header("self.config.accept_language", self.config.accept_language, 'str')

        # Construct body
        if body is not None:
            body_content = self._serialize.body(body, 'RulesResultsInput')
        else:
            body_content = None

        # Construct and send request
        request = self._client.post(url, query_parameters, header_parameters, body_content)
        response = self._client.send(request, stream=False, **operation_config)

        if response.status_code not in [200]:
            exp = CloudError(response)
            exp.request_id = response.headers.get('x-ms-request-id')
            raise exp

        deserialized = None
        if response.status_code == 200:
            deserialized = self._deserialize('RulesResults', response)

        if raw:
            client_raw_response = ClientRawResponse(deserialized, response)
            return client_raw_response

        return deserialized
    add.metadata = {'url': '/{resourceId}/providers/Microsoft.Security/sqlVulnerabilityAssessments/default/baselineRules'}
