# Generated by the protocol buffer compiler.  DO NOT EDIT!
# sources: android_checkin.proto
# plugin: python-betterproto
from dataclasses import dataclass

import betterproto


class DeviceType(betterproto.Enum):
    """
    enum values correspond to the type of device. Used in the
    AndroidCheckinProto and Device proto.
    """

    # Android Device
    DEVICE_ANDROID_OS = 1
    # Apple IOS device
    DEVICE_IOS_OS = 2
    # Chrome browser - Not Chrome OS.  No hardware records.
    DEVICE_CHROME_BROWSER = 3
    # Chrome OS
    DEVICE_CHROME_OS = 4


class ChromeBuildProtoPlatform(betterproto.Enum):
    PLATFORM_WIN = 1
    PLATFORM_MAC = 2
    PLATFORM_LINUX = 3
    PLATFORM_CROS = 4
    PLATFORM_IOS = 5
    PLATFORM_ANDROID = 6


class ChromeBuildProtoChannel(betterproto.Enum):
    CHANNEL_STABLE = 1
    CHANNEL_BETA = 2
    CHANNEL_DEV = 3
    CHANNEL_CANARY = 4
    CHANNEL_UNKNOWN = 5


@dataclass
class ChromeBuildProto(betterproto.Message):
    """Build characteristics unique to the Chrome browser, and Chrome OS"""

    # The platform of the device.
    platform: "ChromeBuildProtoPlatform" = betterproto.enum_field(1)
    # The Chrome instance's version.
    chrome_version: str = betterproto.string_field(2)
    # The Channel (build type) of Chrome.
    channel: "ChromeBuildProtoChannel" = betterproto.enum_field(3)


@dataclass
class AndroidCheckinProto(betterproto.Message):
    """Information sent by the device in a "checkin" request."""

    # Miliseconds since the Unix epoch of the device's last successful checkin.
    last_checkin_msec: int = betterproto.int64_field(2)
    # The current MCC+MNC of the mobile device's current cell.
    cell_operator: str = betterproto.string_field(6)
    # The MCC+MNC of the SIM card (different from operator if the device is
    # roaming, for instance).
    sim_operator: str = betterproto.string_field(7)
    # The device's current roaming state (reported starting in eclair builds).
    # Currently one of "{,not}mobile-{,not}roaming", if it is present at all.
    roaming: str = betterproto.string_field(8)
    # For devices supporting multiple user profiles (which may be supported
    # starting in jellybean), the ordinal number of the profile that is checking
    # in.  This is 0 for the primary profile (which can't be changed without
    # wiping the device), and 1,2,3,... for additional profiles (which can be
    # added and deleted freely).
    user_number: int = betterproto.int32_field(9)
    # Class of device.  Indicates the type of build proto
    # (IosBuildProto/ChromeBuildProto/AndroidBuildProto) That is included in this
    # proto
    type: "DeviceType" = betterproto.enum_field(12)
    # For devices running MCS on Chrome, build-specific characteristics of the
    # browser.  There are no hardware aspects (except for ChromeOS). This will
    # only be populated for Chrome builds/ChromeOS devices
    chrome_build: "ChromeBuildProto" = betterproto.message_field(13)
