
# Flint

*Flint* is a source-code static analyzer and quality checker for fortran programming language. It intends to follows the coding conventions mentioned [OMS Documentation Wiki page](https://alm.engr.colostate.edu/cb/wiki/16983)

Many Fortran Linter software exists, and are giants full of wisdom compared to the midget *flint*. The goal of *Flint* is to provide a Free, quickly installed, and soon customizable linter for Continuous Integration.

There is an additional feature to with an interactive graphical scan of the code base, which can help you to monitor the code style enforcement.

## Installation

Install Flint from Python Package index "Flinter" (because Flint name was already taken =_=)


```
>pip install flinter
```

## Usage

FLint provide a CLI with the command currently implemented. 

```
>flint
  --------------------    FLINT  ---------------------

  .      - Flint, because our code stinks... -

  You are now using the Command line interface of Flint, a Fortran linter
  created at CERFACS (https://cerfacs.fr).

  This is a python package currently installed in your python environement.

Options:
  --help  Show this message and exit.


Options:
  --help  Show this message and exit.

Commands:
  config  Copy the default rule file .flint_rc.yml locally
  dump    Dump full stats.
  score   Score the formatting of a Fortran folder
  tree    Visual representation of the score
```

### `flint config`

This will copy locally the default rules coming with flint.
It will look like:

```yaml
# Set active to false is you want to skip  rule
# All are regexp rules, meaning you can add new rules simply by editong this file
# test your rule on https://regex101.com/ if needed
regexp-rules:
  missing-spaces-on-do:
    message: Missing spaces
    regexp: do (\w+)=(\S+),(\S+)
    replacement: do \1 = \2, \3
    active: true

  missing-spaces-around-operator:
    message: Missing spaces around operator
    regexp: (\w|\))({operators})(\w|\()
    replacement: \1 \2 \3
    active: true

  (...)
# These are rules that span over multiple lines, not accessible by regexp
# You you want to edit these rules or add your own, two options:
# - ask us.
# - fork the code.


structure-rules:
  file-line-lenght: 120
  file-line-number: 1000
  max-statements-in-context: 50   # Subroutine of function
  max-declared-locals: 12
  min-varlen: 3
  max-varlen: 20
  max-arguments: 5
  min-arglen: 3
  max-arglen: 20
  max-nesting-levels: 5
```

You can rename the file as e.g. `my_code_my_rules.yml` and  customize this file for your own perusal on all the remaining commands. Simply use the `-r` optional flag:

```bash
>flinter (cmd) (options) -r my_code_my_rules.yml`.
```

### `flint score`

This is simply giving you the score in the terminal. 
If you ask a maximum depth 0, the result is an easily parsable one-liner:

```bash
flint score -d 0 .
Flinter global rating -->|-5.73|<--  (50008 statements)
```

Add more level of depths to get the maximum verbosity:

```bash
>flint score -d 1000 .
  lvl path                                               rate       size (stmt)
  0   .                                                  -5.73      50008     
  1   ./3rd_party                                        1.58       481       
  2   ./3rd_party/nek_in_situ.f                          5.00       12        
  3   ./3rd_party/nek_in_situ.f/in_situ_init             5.00       4         
........ nospace-end :  1
........ not-recommended-bare-end :  1
  3   ./3rd_party/nek_in_situ.f/in_situ_check            5.00       4         
........ nospace-end :  1
........ not-recommended-bare-end :  1
  3   ./3rd_party/nek_in_situ.f/in_situ_end              5.00       4         
........ nospace-end :  1
........ not-recommended-bare-end :  1
  2   ./3rd_party/visit.f                                1.49       469       
  3   ./3rd_party/visit.f/visit_init                     4.83       29        
........ not-recommended-use-include :  2
........ reommended-use-mpi_f08 :  1
........ nospace-end :  3
........ missing-spaces-before-operator :  2
........ missing-spaces-after-operator :  2
........ missing-space-before-parenthesis :  2
........ not-recommended-bare-end :  1
(etc...)
```

### `flint dump`

This command will dump the score information into a YAML datafile.

```bash
>flint dump . tmp.yml
```

Here the file `tmp.yml` will start like:

```yaml
children:
- children:
  - children:
    - children: []
      name: in_situ_init
      path: ./3rd_party/nek_in_situ.f/in_situ_init
      rate: 5.0
      regexp_nberr: 2
      regexp_rules:
        nospace-end: 1
```

With a bit of recursive reading, you can make some funny data-analysis on your code.

### `flint tree`

The command is simply:

```bash
>pip tree .
```

You should get a fancy circular packing view of your codebase, colored by your compliance to the coding style. The process can take some time, around 30 sec for a codebase of 500000 lines.

The real heavy computation is the positioning of circles (and I could not optimize this, since this taken from an external package, sorry). Time rise if your sources are a large heap of highly nested little files.

![exampletree](./avbp_shade.png)

In this circular packing, the relative size of circles is proportional to the number of statements stored inside. 

## Acknowledgement

Flint is a service created in the [EXCELLERAT Center Of Excellence](https://www.excellerat.eu/wp/), funded by the European community.
![logo](http://cerfacs.fr/coop/whatwedo/logo_excellerat.png)