# coding=utf-8
# *** WARNING: this file was generated by the Pulumi Terraform Bridge (tfgen) Tool. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import warnings
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
from . import _utilities

__all__ = [
    'BoardQueryArgs',
    'GetQuerySpecificationCalculationArgs',
    'GetQuerySpecificationFilterArgs',
    'GetQuerySpecificationOrderArgs',
    'TriggerRecipientArgs',
    'TriggerThresholdArgs',
]

@pulumi.input_type
class BoardQueryArgs:
    def __init__(__self__, *,
                 dataset: pulumi.Input[str],
                 query_id: pulumi.Input[str],
                 caption: Optional[pulumi.Input[str]] = None,
                 query_annotation_id: Optional[pulumi.Input[str]] = None,
                 query_style: Optional[pulumi.Input[str]] = None):
        """
        :param pulumi.Input[str] dataset: The dataset this query is associated with.
        :param pulumi.Input[str] query_id: The ID of the Query to run.
        :param pulumi.Input[str] caption: A description of the query that will be displayed on the board. Supports markdown.
        :param pulumi.Input[str] query_annotation_id: The ID of the Query Annotation to associate with this query.
        :param pulumi.Input[str] query_style: How the query should be displayed within the board, either `graph` (the default), `table` or `combo`.
        """
        pulumi.set(__self__, "dataset", dataset)
        pulumi.set(__self__, "query_id", query_id)
        if caption is not None:
            pulumi.set(__self__, "caption", caption)
        if query_annotation_id is not None:
            pulumi.set(__self__, "query_annotation_id", query_annotation_id)
        if query_style is not None:
            pulumi.set(__self__, "query_style", query_style)

    @property
    @pulumi.getter
    def dataset(self) -> pulumi.Input[str]:
        """
        The dataset this query is associated with.
        """
        return pulumi.get(self, "dataset")

    @dataset.setter
    def dataset(self, value: pulumi.Input[str]):
        pulumi.set(self, "dataset", value)

    @property
    @pulumi.getter(name="queryId")
    def query_id(self) -> pulumi.Input[str]:
        """
        The ID of the Query to run.
        """
        return pulumi.get(self, "query_id")

    @query_id.setter
    def query_id(self, value: pulumi.Input[str]):
        pulumi.set(self, "query_id", value)

    @property
    @pulumi.getter
    def caption(self) -> Optional[pulumi.Input[str]]:
        """
        A description of the query that will be displayed on the board. Supports markdown.
        """
        return pulumi.get(self, "caption")

    @caption.setter
    def caption(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "caption", value)

    @property
    @pulumi.getter(name="queryAnnotationId")
    def query_annotation_id(self) -> Optional[pulumi.Input[str]]:
        """
        The ID of the Query Annotation to associate with this query.
        """
        return pulumi.get(self, "query_annotation_id")

    @query_annotation_id.setter
    def query_annotation_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "query_annotation_id", value)

    @property
    @pulumi.getter(name="queryStyle")
    def query_style(self) -> Optional[pulumi.Input[str]]:
        """
        How the query should be displayed within the board, either `graph` (the default), `table` or `combo`.
        """
        return pulumi.get(self, "query_style")

    @query_style.setter
    def query_style(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "query_style", value)


@pulumi.input_type
class GetQuerySpecificationCalculationArgs:
    def __init__(__self__, *,
                 op: str,
                 column: Optional[str] = None):
        """
        :param str op: The operator to apply, see the supported list of calculation operators at [Calculation Operators](https://docs.honeycomb.io/api/query-specification/#calculation-operators).
        :param str column: The column to apply the operator to, not needed with `COUNT`.
        """
        pulumi.set(__self__, "op", op)
        if column is not None:
            pulumi.set(__self__, "column", column)

    @property
    @pulumi.getter
    def op(self) -> str:
        """
        The operator to apply, see the supported list of calculation operators at [Calculation Operators](https://docs.honeycomb.io/api/query-specification/#calculation-operators).
        """
        return pulumi.get(self, "op")

    @op.setter
    def op(self, value: str):
        pulumi.set(self, "op", value)

    @property
    @pulumi.getter
    def column(self) -> Optional[str]:
        """
        The column to apply the operator to, not needed with `COUNT`.
        """
        return pulumi.get(self, "column")

    @column.setter
    def column(self, value: Optional[str]):
        pulumi.set(self, "column", value)


@pulumi.input_type
class GetQuerySpecificationFilterArgs:
    def __init__(__self__, *,
                 column: str,
                 op: str,
                 value: Optional[str] = None,
                 value_boolean: Optional[bool] = None,
                 value_float: Optional[float] = None,
                 value_integer: Optional[int] = None,
                 value_string: Optional[str] = None):
        """
        :param str column: The column to apply the filter to.
        :param str op: The operator to apply, see the supported list of filter operators at [Filter Operators](https://docs.honeycomb.io/api/query-specification/#filter-operators). Not all operators require a value.
        :param str value: Deprecated: use the explicitly typed `value_string` instead. This variant will break queries when used with non-string columns. Mutually exclusive with the other `value_*` options.
        :param bool value_boolean: The value used for the filter when the column is a boolean. Mutually exclusive with `value` and the other `value_*` options.
        :param float value_float: The value used for the filter when the column is a float. Mutually exclusive with `value` and the other `value_*` options.
        :param int value_integer: The value used for the filter when the column is an integer. Mutually exclusive with `value` and the other `value_*` options.
        :param str value_string: The value used for the filter when the column is a string. Mutually exclusive with `value` and the other `value_*` options.
        """
        pulumi.set(__self__, "column", column)
        pulumi.set(__self__, "op", op)
        if value is not None:
            warnings.warn("""Use of attribute `value` is discouraged and will break queries when used with non-string columns. The explicitly typed `value_*` variants are preferred instead.""", DeprecationWarning)
            pulumi.log.warn("""value is deprecated: Use of attribute `value` is discouraged and will break queries when used with non-string columns. The explicitly typed `value_*` variants are preferred instead.""")
        if value is not None:
            pulumi.set(__self__, "value", value)
        if value_boolean is not None:
            pulumi.set(__self__, "value_boolean", value_boolean)
        if value_float is not None:
            pulumi.set(__self__, "value_float", value_float)
        if value_integer is not None:
            pulumi.set(__self__, "value_integer", value_integer)
        if value_string is not None:
            pulumi.set(__self__, "value_string", value_string)

    @property
    @pulumi.getter
    def column(self) -> str:
        """
        The column to apply the filter to.
        """
        return pulumi.get(self, "column")

    @column.setter
    def column(self, value: str):
        pulumi.set(self, "column", value)

    @property
    @pulumi.getter
    def op(self) -> str:
        """
        The operator to apply, see the supported list of filter operators at [Filter Operators](https://docs.honeycomb.io/api/query-specification/#filter-operators). Not all operators require a value.
        """
        return pulumi.get(self, "op")

    @op.setter
    def op(self, value: str):
        pulumi.set(self, "op", value)

    @property
    @pulumi.getter
    def value(self) -> Optional[str]:
        """
        Deprecated: use the explicitly typed `value_string` instead. This variant will break queries when used with non-string columns. Mutually exclusive with the other `value_*` options.
        """
        return pulumi.get(self, "value")

    @value.setter
    def value(self, value: Optional[str]):
        pulumi.set(self, "value", value)

    @property
    @pulumi.getter(name="valueBoolean")
    def value_boolean(self) -> Optional[bool]:
        """
        The value used for the filter when the column is a boolean. Mutually exclusive with `value` and the other `value_*` options.
        """
        return pulumi.get(self, "value_boolean")

    @value_boolean.setter
    def value_boolean(self, value: Optional[bool]):
        pulumi.set(self, "value_boolean", value)

    @property
    @pulumi.getter(name="valueFloat")
    def value_float(self) -> Optional[float]:
        """
        The value used for the filter when the column is a float. Mutually exclusive with `value` and the other `value_*` options.
        """
        return pulumi.get(self, "value_float")

    @value_float.setter
    def value_float(self, value: Optional[float]):
        pulumi.set(self, "value_float", value)

    @property
    @pulumi.getter(name="valueInteger")
    def value_integer(self) -> Optional[int]:
        """
        The value used for the filter when the column is an integer. Mutually exclusive with `value` and the other `value_*` options.
        """
        return pulumi.get(self, "value_integer")

    @value_integer.setter
    def value_integer(self, value: Optional[int]):
        pulumi.set(self, "value_integer", value)

    @property
    @pulumi.getter(name="valueString")
    def value_string(self) -> Optional[str]:
        """
        The value used for the filter when the column is a string. Mutually exclusive with `value` and the other `value_*` options.
        """
        return pulumi.get(self, "value_string")

    @value_string.setter
    def value_string(self, value: Optional[str]):
        pulumi.set(self, "value_string", value)


@pulumi.input_type
class GetQuerySpecificationOrderArgs:
    def __init__(__self__, *,
                 column: Optional[str] = None,
                 op: Optional[str] = None,
                 order: Optional[str] = None):
        """
        :param str column: Either a column present in `breakdown` or a column to `op` applies to.
        :param str op: The calculation operator to apply, see the supported list of calculation operators at [Calculation Operators](https://docs.honeycomb.io/api/query-specification/#calculation-operators).
        :param str order: The sort direction, if set must be `ascending` or `descending`.
        """
        if column is not None:
            pulumi.set(__self__, "column", column)
        if op is not None:
            pulumi.set(__self__, "op", op)
        if order is not None:
            pulumi.set(__self__, "order", order)

    @property
    @pulumi.getter
    def column(self) -> Optional[str]:
        """
        Either a column present in `breakdown` or a column to `op` applies to.
        """
        return pulumi.get(self, "column")

    @column.setter
    def column(self, value: Optional[str]):
        pulumi.set(self, "column", value)

    @property
    @pulumi.getter
    def op(self) -> Optional[str]:
        """
        The calculation operator to apply, see the supported list of calculation operators at [Calculation Operators](https://docs.honeycomb.io/api/query-specification/#calculation-operators).
        """
        return pulumi.get(self, "op")

    @op.setter
    def op(self, value: Optional[str]):
        pulumi.set(self, "op", value)

    @property
    @pulumi.getter
    def order(self) -> Optional[str]:
        """
        The sort direction, if set must be `ascending` or `descending`.
        """
        return pulumi.get(self, "order")

    @order.setter
    def order(self, value: Optional[str]):
        pulumi.set(self, "order", value)


@pulumi.input_type
class TriggerRecipientArgs:
    def __init__(__self__, *,
                 id: Optional[pulumi.Input[str]] = None,
                 target: Optional[pulumi.Input[str]] = None,
                 type: Optional[pulumi.Input[str]] = None):
        """
        :param pulumi.Input[str] id: The ID of an already existing recipient. Should not be used in combination with `type` and `target`.
        :param pulumi.Input[str] target: Target of the trigger recipient, this has another meaning depending on the type of recipient (see the table below). Should not be used in combination with `id`.
        :param pulumi.Input[str] type: The type of the trigger recipient, allowed types are `email`, `marker`, `pagerduty`, `slack` and `webhook`. Should not be used in combination with `id`.
        """
        if id is not None:
            pulumi.set(__self__, "id", id)
        if target is not None:
            pulumi.set(__self__, "target", target)
        if type is not None:
            pulumi.set(__self__, "type", type)

    @property
    @pulumi.getter
    def id(self) -> Optional[pulumi.Input[str]]:
        """
        The ID of an already existing recipient. Should not be used in combination with `type` and `target`.
        """
        return pulumi.get(self, "id")

    @id.setter
    def id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "id", value)

    @property
    @pulumi.getter
    def target(self) -> Optional[pulumi.Input[str]]:
        """
        Target of the trigger recipient, this has another meaning depending on the type of recipient (see the table below). Should not be used in combination with `id`.
        """
        return pulumi.get(self, "target")

    @target.setter
    def target(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "target", value)

    @property
    @pulumi.getter
    def type(self) -> Optional[pulumi.Input[str]]:
        """
        The type of the trigger recipient, allowed types are `email`, `marker`, `pagerduty`, `slack` and `webhook`. Should not be used in combination with `id`.
        """
        return pulumi.get(self, "type")

    @type.setter
    def type(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "type", value)


@pulumi.input_type
class TriggerThresholdArgs:
    def __init__(__self__, *,
                 op: pulumi.Input[str],
                 value: pulumi.Input[float]):
        """
        :param pulumi.Input[str] op: The operator to apply, allowed threshold operators are `>`, `>=`, `<`, and `<=`.
        :param pulumi.Input[float] value: The value to be used with the operator.
        """
        pulumi.set(__self__, "op", op)
        pulumi.set(__self__, "value", value)

    @property
    @pulumi.getter
    def op(self) -> pulumi.Input[str]:
        """
        The operator to apply, allowed threshold operators are `>`, `>=`, `<`, and `<=`.
        """
        return pulumi.get(self, "op")

    @op.setter
    def op(self, value: pulumi.Input[str]):
        pulumi.set(self, "op", value)

    @property
    @pulumi.getter
    def value(self) -> pulumi.Input[float]:
        """
        The value to be used with the operator.
        """
        return pulumi.get(self, "value")

    @value.setter
    def value(self, value: pulumi.Input[float]):
        pulumi.set(self, "value", value)


