# coding: utf-8

"""
    Genomic Data Store Service

    No description provided (generated by Openapi Generator https://github.com/openapitools/openapi-generator)  # noqa: E501

    The version of the OpenAPI document: v1
    Generated by: https://openapi-generator.tech
"""


import pprint
import re  # noqa: F401

import six

from libica.openapi.libgds.configuration import Configuration


class AWSS3ObjectStoreSetting(object):
    """NOTE: This class is auto generated by OpenAPI Generator.
    Ref: https://openapi-generator.tech

    Do not edit the class manually.
    """

    """
    Attributes:
      openapi_types (dict): The key is attribute name
                            and the value is attribute type.
      attribute_map (dict): The key is attribute name
                            and the value is json key in definition.
    """
    openapi_types = {
        'bucket_name': 'str',
        'key_prefix': 'str'
    }

    attribute_map = {
        'bucket_name': 'bucketName',
        'key_prefix': 'keyPrefix'
    }

    def __init__(self, bucket_name=None, key_prefix=None, local_vars_configuration=None):  # noqa: E501
        """AWSS3ObjectStoreSetting - a model defined in OpenAPI"""  # noqa: E501
        if local_vars_configuration is None:
            local_vars_configuration = Configuration()
        self.local_vars_configuration = local_vars_configuration

        self._bucket_name = None
        self._key_prefix = None
        self.discriminator = None

        self.bucket_name = bucket_name
        if key_prefix is not None:
            self.key_prefix = key_prefix

    @property
    def bucket_name(self):
        """Gets the bucket_name of this AWSS3ObjectStoreSetting.  # noqa: E501

        The bucket name  # noqa: E501

        :return: The bucket_name of this AWSS3ObjectStoreSetting.  # noqa: E501
        :rtype: str
        """
        return self._bucket_name

    @bucket_name.setter
    def bucket_name(self, bucket_name):
        """Sets the bucket_name of this AWSS3ObjectStoreSetting.

        The bucket name  # noqa: E501

        :param bucket_name: The bucket_name of this AWSS3ObjectStoreSetting.  # noqa: E501
        :type: str
        """
        if self.local_vars_configuration.client_side_validation and bucket_name is None:  # noqa: E501
            raise ValueError("Invalid value for `bucket_name`, must not be `None`")  # noqa: E501
        if (self.local_vars_configuration.client_side_validation and
                bucket_name is not None and len(bucket_name) > 63):
            raise ValueError("Invalid value for `bucket_name`, length must be less than or equal to `63`")  # noqa: E501
        if (self.local_vars_configuration.client_side_validation and
                bucket_name is not None and len(bucket_name) < 3):
            raise ValueError("Invalid value for `bucket_name`, length must be greater than or equal to `3`")  # noqa: E501

        self._bucket_name = bucket_name

    @property
    def key_prefix(self):
        """Gets the key_prefix of this AWSS3ObjectStoreSetting.  # noqa: E501

        Key prefix within the bucket for GDS to operate within. Volumes may only be created within this prefix and the given credentials need only authorize  access here. If not set, default is to allow operation on the full bucket. No leading slash, and must end with a trailing slash.  # noqa: E501

        :return: The key_prefix of this AWSS3ObjectStoreSetting.  # noqa: E501
        :rtype: str
        """
        return self._key_prefix

    @key_prefix.setter
    def key_prefix(self, key_prefix):
        """Sets the key_prefix of this AWSS3ObjectStoreSetting.

        Key prefix within the bucket for GDS to operate within. Volumes may only be created within this prefix and the given credentials need only authorize  access here. If not set, default is to allow operation on the full bucket. No leading slash, and must end with a trailing slash.  # noqa: E501

        :param key_prefix: The key_prefix of this AWSS3ObjectStoreSetting.  # noqa: E501
        :type: str
        """
        if (self.local_vars_configuration.client_side_validation and
                key_prefix is not None and not re.search(r'^[^\/].*$', key_prefix)):  # noqa: E501
            raise ValueError(r"Invalid value for `key_prefix`, must be a follow pattern or equal to `/^[^\/].*$/`")  # noqa: E501

        self._key_prefix = key_prefix

    def to_dict(self):
        """Returns the model properties as a dict"""
        result = {}

        for attr, _ in six.iteritems(self.openapi_types):
            value = getattr(self, attr)
            if isinstance(value, list):
                result[attr] = list(map(
                    lambda x: x.to_dict() if hasattr(x, "to_dict") else x,
                    value
                ))
            elif hasattr(value, "to_dict"):
                result[attr] = value.to_dict()
            elif isinstance(value, dict):
                result[attr] = dict(map(
                    lambda item: (item[0], item[1].to_dict())
                    if hasattr(item[1], "to_dict") else item,
                    value.items()
                ))
            else:
                result[attr] = value

        return result

    def to_str(self):
        """Returns the string representation of the model"""
        return pprint.pformat(self.to_dict())

    def __repr__(self):
        """For `print` and `pprint`"""
        return self.to_str()

    def __eq__(self, other):
        """Returns true if both objects are equal"""
        if not isinstance(other, AWSS3ObjectStoreSetting):
            return False

        return self.to_dict() == other.to_dict()

    def __ne__(self, other):
        """Returns true if both objects are not equal"""
        if not isinstance(other, AWSS3ObjectStoreSetting):
            return True

        return self.to_dict() != other.to_dict()
