from ......Internal.Core import Core
from ......Internal.CommandsGroup import CommandsGroup
from ......Internal import Conversions


# noinspection PyPep8Naming,PyAttributeOutsideInit,SpellCheckingInspection
class RsPower:
	"""RsPower commands group definition. 1 total commands, 0 Sub-groups, 1 group commands"""

	def __init__(self, core: Core, parent):
		self._core = core
		self._base = CommandsGroup("rsPower", core, parent)

	def get_basic(self) -> float:
		"""SCPI: SENSe:LTE:SIGNaling<instance>:UL[:PCC]:APPower:RSPower:BASic \n
		Snippet: value: float = driver.sense.uplink.pcc.apPower.rsPower.get_basic() \n
		Queries the 'referenceSignalPower' value, signaled to the UE if basic UL power configuration applies. \n
			:return: ref_signal_power: Range: -60 dBm to 50 dBm, Unit: dBm
		"""
		response = self._core.io.query_str('SENSe:LTE:SIGNaling<Instance>:UL:PCC:APPower:RSPower:BASic?')
		return Conversions.str_to_float(response)
