from .....Internal.Core import Core
from .....Internal.CommandsGroup import CommandsGroup
from .....Internal.StructBase import StructBase
from .....Internal.ArgStruct import ArgStruct
from ..... import repcap


# noinspection PyPep8Naming,PyAttributeOutsideInit,SpellCheckingInspection
class Absolute:
	"""Absolute commands group definition. 1 total commands, 0 Sub-groups, 1 group commands"""

	def __init__(self, core: Core, parent):
		self._core = core
		self._base = CommandsGroup("absolute", core, parent)

	# noinspection PyTypeChecker
	class FetchStruct(StructBase):
		"""Response structure. Fields: \n
			- Reliability: int: See 'Reliability Indicator'
			- Ack: int: Number of received acknowledgments Range: 0 to 2E+9
			- Nack: int: Number of received negative acknowledgments Range: 0 to 2E+9
			- Expired_Subframes: int: No parameter help available
			- Throughput: float: Average DL throughput Unit: kbit/s
			- Dtx: int: Number of sent scheduled subframes for which no ACK and no NACK has been received Range: 0 to 2E+9
			- Scheduled: int: Number of already sent scheduled subframes Range: 0 to 2E+9
			- Median_Cqi: int: Median value of received CQI indices Range: 0 to 15"""
		__meta_args_list = [
			ArgStruct.scalar_int('Reliability', 'Reliability'),
			ArgStruct.scalar_int('Ack'),
			ArgStruct.scalar_int('Nack'),
			ArgStruct.scalar_int('Expired_Subframes'),
			ArgStruct.scalar_float('Throughput'),
			ArgStruct.scalar_int('Dtx'),
			ArgStruct.scalar_int('Scheduled'),
			ArgStruct.scalar_int('Median_Cqi')]

		def __init__(self):
			StructBase.__init__(self, self)
			self.Reliability: int = None
			self.Ack: int = None
			self.Nack: int = None
			self.Expired_Subframes: int = None
			self.Throughput: float = None
			self.Dtx: int = None
			self.Scheduled: int = None
			self.Median_Cqi: int = None

	def fetch(self, stream=repcap.Stream.Default) -> FetchStruct:
		"""SCPI: FETCh:LTE:SIGNaling<instance>:EBLer[:PCC]:STReam<Stream>:ABSolute \n
		Snippet: value: FetchStruct = driver.ebler.pcc.stream.absolute.fetch(stream = repcap.Stream.Default) \n
		Returns the absolute results of the BLER measurement for one downlink stream of one carrier. The number to the left of
		each result parameter is provided for easy identification of the parameter position within the result array. \n
			:param stream: optional repeated capability selector. Default value: S1 (settable in the interface 'Stream')
			:return: structure: for return value, see the help for FetchStruct structure arguments."""
		stream_cmd_val = self._base.get_repcap_cmd_value(stream, repcap.Stream)
		return self._core.io.query_struct(f'FETCh:LTE:SIGNaling<Instance>:EBLer:PCC:STReam{stream_cmd_val}:ABSolute?', self.__class__.FetchStruct())
