from ......Internal.Core import Core
from ......Internal.CommandsGroup import CommandsGroup
from ......Internal import Conversions


# noinspection PyPep8Naming,PyAttributeOutsideInit,SpellCheckingInspection
class RsPower:
	"""RsPower commands group definition. 1 total commands, 0 Sub-groups, 1 group commands"""

	def __init__(self, core: Core, parent):
		self._core = core
		self._base = CommandsGroup("rsPower", core, parent)

	def get_advanced(self) -> float:
		"""SCPI: CONFigure:LTE:SIGNaling<instance>:UL:SETB:APPower:RSPower:ADVanced \n
		Snippet: value: float = driver.configure.uplink.setb.apPower.rsPower.get_advanced() \n
		Specifies the 'referenceSignalPower' value, signaled to the UE if advanced UL power configuration applies. \n
			:return: ref_signal_power: Range: -60 dBm to 50 dBm, Unit: dBm
		"""
		response = self._core.io.query_str('CONFigure:LTE:SIGNaling<Instance>:UL:SETB:APPower:RSPower:ADVanced?')
		return Conversions.str_to_float(response)

	def set_advanced(self, ref_signal_power: float) -> None:
		"""SCPI: CONFigure:LTE:SIGNaling<instance>:UL:SETB:APPower:RSPower:ADVanced \n
		Snippet: driver.configure.uplink.setb.apPower.rsPower.set_advanced(ref_signal_power = 1.0) \n
		Specifies the 'referenceSignalPower' value, signaled to the UE if advanced UL power configuration applies. \n
			:param ref_signal_power: Range: -60 dBm to 50 dBm, Unit: dBm
		"""
		param = Conversions.decimal_value_to_str(ref_signal_power)
		self._core.io.write(f'CONFigure:LTE:SIGNaling<Instance>:UL:SETB:APPower:RSPower:ADVanced {param}')
