from .....Internal.Core import Core
from .....Internal.CommandsGroup import CommandsGroup
from .....Internal import Conversions
from ..... import repcap


# noinspection PyPep8Naming,PyAttributeOutsideInit,SpellCheckingInspection
class Sync:
	"""Sync commands group definition. 1 total commands, 0 Sub-groups, 1 group commands"""

	def __init__(self, core: Core, parent):
		self._core = core
		self._base = CommandsGroup("sync", core, parent)

	def set(self, time_10_ms: int, systemInfoBlock=repcap.SystemInfoBlock.Default) -> None:
		"""SCPI: CONFigure:LTE:SIGNaling<instance>:SIB<n>:SYST:SYNC \n
		Snippet: driver.configure.sib.syst.sync.set(time_10_ms = 1, systemInfoBlock = repcap.SystemInfoBlock.Default) \n
		No command help available \n
			:param time_10_ms: No help available
			:param systemInfoBlock: optional repeated capability selector. Default value: Sib8 (settable in the interface 'Sib')"""
		param = Conversions.decimal_value_to_str(time_10_ms)
		systemInfoBlock_cmd_val = self._base.get_repcap_cmd_value(systemInfoBlock, repcap.SystemInfoBlock)
		self._core.io.write(f'CONFigure:LTE:SIGNaling<Instance>:SIB{systemInfoBlock_cmd_val}:SYST:SYNC {param}')

	def get(self, systemInfoBlock=repcap.SystemInfoBlock.Default) -> int:
		"""SCPI: CONFigure:LTE:SIGNaling<instance>:SIB<n>:SYST:SYNC \n
		Snippet: value: int = driver.configure.sib.syst.sync.get(systemInfoBlock = repcap.SystemInfoBlock.Default) \n
		No command help available \n
			:param systemInfoBlock: optional repeated capability selector. Default value: Sib8 (settable in the interface 'Sib')
			:return: time_10_ms: No help available"""
		systemInfoBlock_cmd_val = self._base.get_repcap_cmd_value(systemInfoBlock, repcap.SystemInfoBlock)
		response = self._core.io.query_str(f'CONFigure:LTE:SIGNaling<Instance>:SIB{systemInfoBlock_cmd_val}:SYST:SYNC?')
		return Conversions.str_to_int(response)
