from .....Internal.Core import Core
from .....Internal.CommandsGroup import CommandsGroup


# noinspection PyPep8Naming,PyAttributeOutsideInit,SpellCheckingInspection
class UdChannels:
	"""UdChannels commands group definition. 16 total commands, 4 Sub-groups, 0 group commands"""

	def __init__(self, core: Core, parent):
		self._core = core
		self._base = CommandsGroup("udChannels", core, parent)

	@property
	def mcluster(self):
		"""mcluster commands group. 2 Sub-classes, 0 commands."""
		if not hasattr(self, '_mcluster'):
			from .UdChannels_.Mcluster import Mcluster
			self._mcluster = Mcluster(self._core, self._base)
		return self._mcluster

	@property
	def laa(self):
		"""laa commands group. 2 Sub-classes, 0 commands."""
		if not hasattr(self, '_laa'):
			from .UdChannels_.Laa import Laa
			self._laa = Laa(self._core, self._base)
		return self._laa

	@property
	def downlink(self):
		"""downlink commands group. 0 Sub-classes, 1 commands."""
		if not hasattr(self, '_downlink'):
			from .UdChannels_.Downlink import Downlink
			self._downlink = Downlink(self._core, self._base)
		return self._downlink

	@property
	def uplink(self):
		"""uplink commands group. 0 Sub-classes, 1 commands."""
		if not hasattr(self, '_uplink'):
			from .UdChannels_.Uplink import Uplink
			self._uplink = Uplink(self._core, self._base)
		return self._uplink

	def clone(self) -> 'UdChannels':
		"""Clones the group by creating new object from it and its whole existing sub-groups
		Also copies all the existing default Repeated Capabilities setting,
		which you can change independently without affecting the original group"""
		new_group = UdChannels(self._core, self._base.parent)
		self._base.synchronize_repcaps(new_group)
		return new_group
