"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.handler = void 0;
const assertion_1 = require("./assertion");
const sdk_1 = require("./sdk");
const types = require("./types");
async function handler(event, context) {
    const provider = createResourceHandler(event, context);
    await provider.handle();
}
exports.handler = handler;
function createResourceHandler(event, context) {
    if (event.ResourceType.startsWith(types.SDK_RESOURCE_TYPE_PREFIX)) {
        return new sdk_1.AwsApiCallHandler(event, context);
    }
    switch (event.ResourceType) {
        case types.ASSERT_RESOURCE_TYPE: return new assertion_1.AssertionHandler(event, context);
        default:
            throw new Error(`Unsupported resource type "${event.ResourceType}`);
    }
}
//# sourceMappingURL=data:application/json;base64,eyJ2ZXJzaW9uIjozLCJmaWxlIjoiaW5kZXguanMiLCJzb3VyY2VSb290IjoiIiwic291cmNlcyI6WyJpbmRleC50cyJdLCJuYW1lcyI6W10sIm1hcHBpbmdzIjoiOzs7QUFBQSwyQ0FBK0M7QUFDL0MsK0JBQTBDO0FBQzFDLGlDQUFpQztBQUUxQixLQUFLLFVBQVUsT0FBTyxDQUFDLEtBQWtELEVBQUUsT0FBMEI7SUFDMUcsTUFBTSxRQUFRLEdBQUcscUJBQXFCLENBQUMsS0FBSyxFQUFFLE9BQU8sQ0FBQyxDQUFDO0lBQ3ZELE1BQU0sUUFBUSxDQUFDLE1BQU0sRUFBRSxDQUFDO0FBQzFCLENBQUM7QUFIRCwwQkFHQztBQUVELFNBQVMscUJBQXFCLENBQUMsS0FBa0QsRUFBRSxPQUEwQjtJQUMzRyxJQUFJLEtBQUssQ0FBQyxZQUFZLENBQUMsVUFBVSxDQUFDLEtBQUssQ0FBQyx3QkFBd0IsQ0FBQyxFQUFFO1FBQ2pFLE9BQU8sSUFBSSx1QkFBaUIsQ0FBQyxLQUFLLEVBQUUsT0FBTyxDQUFDLENBQUM7S0FDOUM7SUFDRCxRQUFRLEtBQUssQ0FBQyxZQUFZLEVBQUU7UUFDMUIsS0FBSyxLQUFLLENBQUMsb0JBQW9CLENBQUMsQ0FBQyxPQUFPLElBQUksNEJBQWdCLENBQUMsS0FBSyxFQUFFLE9BQU8sQ0FBQyxDQUFDO1FBQzdFO1lBQ0UsTUFBTSxJQUFJLEtBQUssQ0FBQyw4QkFBOEIsS0FBSyxDQUFDLFlBQVksRUFBRSxDQUFDLENBQUM7S0FDdkU7QUFDSCxDQUFDIiwic291cmNlc0NvbnRlbnQiOlsiaW1wb3J0IHsgQXNzZXJ0aW9uSGFuZGxlciB9IGZyb20gJy4vYXNzZXJ0aW9uJztcbmltcG9ydCB7IEF3c0FwaUNhbGxIYW5kbGVyIH0gZnJvbSAnLi9zZGsnO1xuaW1wb3J0ICogYXMgdHlwZXMgZnJvbSAnLi90eXBlcyc7XG5cbmV4cG9ydCBhc3luYyBmdW5jdGlvbiBoYW5kbGVyKGV2ZW50OiBBV1NMYW1iZGEuQ2xvdWRGb3JtYXRpb25DdXN0b21SZXNvdXJjZUV2ZW50LCBjb250ZXh0OiBBV1NMYW1iZGEuQ29udGV4dCkge1xuICBjb25zdCBwcm92aWRlciA9IGNyZWF0ZVJlc291cmNlSGFuZGxlcihldmVudCwgY29udGV4dCk7XG4gIGF3YWl0IHByb3ZpZGVyLmhhbmRsZSgpO1xufVxuXG5mdW5jdGlvbiBjcmVhdGVSZXNvdXJjZUhhbmRsZXIoZXZlbnQ6IEFXU0xhbWJkYS5DbG91ZEZvcm1hdGlvbkN1c3RvbVJlc291cmNlRXZlbnQsIGNvbnRleHQ6IEFXU0xhbWJkYS5Db250ZXh0KSB7XG4gIGlmIChldmVudC5SZXNvdXJjZVR5cGUuc3RhcnRzV2l0aCh0eXBlcy5TREtfUkVTT1VSQ0VfVFlQRV9QUkVGSVgpKSB7XG4gICAgcmV0dXJuIG5ldyBBd3NBcGlDYWxsSGFuZGxlcihldmVudCwgY29udGV4dCk7XG4gIH1cbiAgc3dpdGNoIChldmVudC5SZXNvdXJjZVR5cGUpIHtcbiAgICBjYXNlIHR5cGVzLkFTU0VSVF9SRVNPVVJDRV9UWVBFOiByZXR1cm4gbmV3IEFzc2VydGlvbkhhbmRsZXIoZXZlbnQsIGNvbnRleHQpO1xuICAgIGRlZmF1bHQ6XG4gICAgICB0aHJvdyBuZXcgRXJyb3IoYFVuc3VwcG9ydGVkIHJlc291cmNlIHR5cGUgXCIke2V2ZW50LlJlc291cmNlVHlwZX1gKTtcbiAgfVxufVxuIl19