"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.setupHashKeyExpression = exports.applyKeyExpressionForCompositeKey = exports.applyCompositeKeyConditionExpression = exports.applyKeyConditionExpression = exports.makeCompositeKeyInputForKey = exports.makeCompositeKeyConditionInputForKey = exports.makeScalarKeyConditionForType = exports.makeScalarKeyConditionInputs = exports.makeModelScalarKeyConditionInputObject = void 0;
const graphql_1 = require("graphql");
const definition_1 = require("./definition");
const ModelResourceIDs_1 = require("./ModelResourceIDs");
const graphql_mapping_template_1 = require("graphql-mapping-template");
const STRING_KEY_CONDITIONS = ['eq', 'le', 'lt', 'ge', 'gt', 'between', 'beginsWith'];
const ID_KEY_CONDITIONS = ['eq', 'le', 'lt', 'ge', 'gt', 'between', 'beginsWith'];
const INT_KEY_CONDITIONS = ['eq', 'le', 'lt', 'ge', 'gt', 'between'];
const FLOAT_KEY_CONDITIONS = ['eq', 'le', 'lt', 'ge', 'gt', 'between'];
function getScalarKeyConditions(type) {
    switch (type) {
        case 'String':
            return STRING_KEY_CONDITIONS;
        case 'ID':
            return ID_KEY_CONDITIONS;
        case 'Int':
            return INT_KEY_CONDITIONS;
        case 'Float':
            return FLOAT_KEY_CONDITIONS;
        default:
            throw 'Valid types are String, ID, Int, Float, Boolean';
    }
}
function makeModelScalarKeyConditionInputObject(type) {
    const name = ModelResourceIDs_1.ModelResourceIDs.ModelKeyConditionInputTypeName(type);
    const conditions = getScalarKeyConditions(type);
    const fields = conditions.map((condition) => ({
        kind: graphql_1.Kind.INPUT_VALUE_DEFINITION,
        name: { kind: 'Name', value: condition },
        type: condition === 'between' ? definition_1.makeListType(definition_1.makeNamedType(type)) : definition_1.makeNamedType(type),
        directives: [],
    }));
    return definition_1.makeInputObjectDefinition(name, fields);
}
exports.makeModelScalarKeyConditionInputObject = makeModelScalarKeyConditionInputObject;
const STRING_KEY_CONDITION = makeModelScalarKeyConditionInputObject('String');
const ID_KEY_CONDITION = makeModelScalarKeyConditionInputObject('ID');
const INT_KEY_CONDITION = makeModelScalarKeyConditionInputObject('Int');
const FLOAT_KEY_CONDITION = makeModelScalarKeyConditionInputObject('Float');
const SCALAR_KEY_CONDITIONS = [STRING_KEY_CONDITION, ID_KEY_CONDITION, INT_KEY_CONDITION, FLOAT_KEY_CONDITION];
function makeScalarKeyConditionInputs() {
    return SCALAR_KEY_CONDITIONS;
}
exports.makeScalarKeyConditionInputs = makeScalarKeyConditionInputs;
function makeScalarKeyConditionForType(type, nonScalarTypeResolver = undefined) {
    const baseType = definition_1.getBaseType(type);
    let resolvedScalarName;
    if (definition_1.isScalar(type)) {
        resolvedScalarName = baseType;
    }
    else if (nonScalarTypeResolver) {
        resolvedScalarName = nonScalarTypeResolver(baseType);
    }
    const inputName = ModelResourceIDs_1.ModelResourceIDs.ModelKeyConditionInputTypeName(resolvedScalarName);
    for (const key of SCALAR_KEY_CONDITIONS) {
        if (key.name.value === inputName) {
            return key;
        }
    }
}
exports.makeScalarKeyConditionForType = makeScalarKeyConditionForType;
function makeCompositeKeyConditionInputForKey(modelName, keyName, fields) {
    const name = ModelResourceIDs_1.ModelResourceIDs.ModelCompositeKeyConditionInputTypeName(modelName, keyName);
    const conditions = STRING_KEY_CONDITIONS;
    const inputValues = conditions.map((condition) => {
        const typeNode = condition === 'between'
            ? definition_1.makeListType(definition_1.makeNamedType(ModelResourceIDs_1.ModelResourceIDs.ModelCompositeKeyInputTypeName(modelName, keyName)))
            : definition_1.makeNamedType(ModelResourceIDs_1.ModelResourceIDs.ModelCompositeKeyInputTypeName(modelName, keyName));
        return definition_1.makeInputValueDefinition(condition, typeNode);
    });
    return definition_1.makeInputObjectDefinition(name, inputValues);
}
exports.makeCompositeKeyConditionInputForKey = makeCompositeKeyConditionInputForKey;
function makeCompositeKeyInputForKey(modelName, keyName, fields) {
    const inputValues = fields.map((field, idx) => {
        const baseTypeName = definition_1.getBaseType(field.type);
        const nameOverride = definition_1.DEFAULT_SCALARS[baseTypeName];
        let typeNode = null;
        if (idx === fields.length - 1 && nameOverride) {
            typeNode = definition_1.makeNamedType(nameOverride);
        }
        else {
            typeNode = definition_1.makeNamedType(baseTypeName);
        }
        return definition_1.makeInputValueDefinition(field.name.value, typeNode);
    });
    const inputName = ModelResourceIDs_1.ModelResourceIDs.ModelCompositeKeyInputTypeName(modelName, keyName);
    return definition_1.makeInputObjectDefinition(inputName, inputValues);
}
exports.makeCompositeKeyInputForKey = makeCompositeKeyInputForKey;
function applyKeyConditionExpression(argName, attributeType = 'S', queryExprReference = 'query', sortKeyName, prefixVariableName) {
    const prefixValue = (value) => (prefixVariableName ? `$${prefixVariableName}#${value}` : value);
    const _sortKeyName = sortKeyName ? sortKeyName : argName;
    return graphql_mapping_template_1.block('Applying Key Condition', [
        graphql_mapping_template_1.iff(graphql_mapping_template_1.raw(`!$util.isNull($ctx.args.${argName}) && !$util.isNull($ctx.args.${argName}.beginsWith)`), graphql_mapping_template_1.compoundExpression([
            graphql_mapping_template_1.set(graphql_mapping_template_1.ref(`${queryExprReference}.expression`), graphql_mapping_template_1.raw(`"$${queryExprReference}.expression AND begins_with(#sortKey, :sortKey)"`)),
            graphql_mapping_template_1.qref(`$${queryExprReference}.expressionNames.put("#sortKey", "${_sortKeyName}")`),
            graphql_mapping_template_1.qref(`$${queryExprReference}.expressionValues.put(":sortKey", { "${attributeType}": "${prefixValue(`$ctx.args.${argName}.beginsWith`)}" })`),
        ])),
        graphql_mapping_template_1.iff(graphql_mapping_template_1.raw(`!$util.isNull($ctx.args.${argName}) && !$util.isNull($ctx.args.${argName}.between)`), graphql_mapping_template_1.compoundExpression([
            graphql_mapping_template_1.set(graphql_mapping_template_1.ref(`${queryExprReference}.expression`), graphql_mapping_template_1.raw(`"$${queryExprReference}.expression AND #sortKey BETWEEN :sortKey0 AND :sortKey1"`)),
            graphql_mapping_template_1.qref(`$${queryExprReference}.expressionNames.put("#sortKey", "${_sortKeyName}")`),
            graphql_mapping_template_1.qref(`$${queryExprReference}.expressionValues.put(":sortKey0", { "${attributeType}": "${prefixValue(`$ctx.args.${argName}.between[0]`)}" })`),
            graphql_mapping_template_1.qref(`$${queryExprReference}.expressionValues.put(":sortKey1", { "${attributeType}": "${prefixValue(`$ctx.args.${argName}.between[1]`)}" })`),
        ])),
        graphql_mapping_template_1.iff(graphql_mapping_template_1.raw(`!$util.isNull($ctx.args.${argName}) && !$util.isNull($ctx.args.${argName}.eq)`), graphql_mapping_template_1.compoundExpression([
            graphql_mapping_template_1.set(graphql_mapping_template_1.ref(`${queryExprReference}.expression`), graphql_mapping_template_1.raw(`"$${queryExprReference}.expression AND #sortKey = :sortKey"`)),
            graphql_mapping_template_1.qref(`$${queryExprReference}.expressionNames.put("#sortKey", "${_sortKeyName}")`),
            graphql_mapping_template_1.qref(`$${queryExprReference}.expressionValues.put(":sortKey", { "${attributeType}": "${prefixValue(`$ctx.args.${argName}.eq`)}" })`),
        ])),
        graphql_mapping_template_1.iff(graphql_mapping_template_1.raw(`!$util.isNull($ctx.args.${argName}) && !$util.isNull($ctx.args.${argName}.lt)`), graphql_mapping_template_1.compoundExpression([
            graphql_mapping_template_1.set(graphql_mapping_template_1.ref(`${queryExprReference}.expression`), graphql_mapping_template_1.raw(`"$${queryExprReference}.expression AND #sortKey < :sortKey"`)),
            graphql_mapping_template_1.qref(`$${queryExprReference}.expressionNames.put("#sortKey", "${_sortKeyName}")`),
            graphql_mapping_template_1.qref(`$${queryExprReference}.expressionValues.put(":sortKey", { "${attributeType}": "${prefixValue(`$ctx.args.${argName}.lt`)}" })`),
        ])),
        graphql_mapping_template_1.iff(graphql_mapping_template_1.raw(`!$util.isNull($ctx.args.${argName}) && !$util.isNull($ctx.args.${argName}.le)`), graphql_mapping_template_1.compoundExpression([
            graphql_mapping_template_1.set(graphql_mapping_template_1.ref(`${queryExprReference}.expression`), graphql_mapping_template_1.raw(`"$${queryExprReference}.expression AND #sortKey <= :sortKey"`)),
            graphql_mapping_template_1.qref(`$${queryExprReference}.expressionNames.put("#sortKey", "${_sortKeyName}")`),
            graphql_mapping_template_1.qref(`$${queryExprReference}.expressionValues.put(":sortKey", { "${attributeType}": "${prefixValue(`$ctx.args.${argName}.le`)}" })`),
        ])),
        graphql_mapping_template_1.iff(graphql_mapping_template_1.raw(`!$util.isNull($ctx.args.${argName}) && !$util.isNull($ctx.args.${argName}.gt)`), graphql_mapping_template_1.compoundExpression([
            graphql_mapping_template_1.set(graphql_mapping_template_1.ref(`${queryExprReference}.expression`), graphql_mapping_template_1.raw(`"$${queryExprReference}.expression AND #sortKey > :sortKey"`)),
            graphql_mapping_template_1.qref(`$${queryExprReference}.expressionNames.put("#sortKey", "${_sortKeyName}")`),
            graphql_mapping_template_1.qref(`$${queryExprReference}.expressionValues.put(":sortKey", { "${attributeType}": "${prefixValue(`$ctx.args.${argName}.gt`)}" })`),
        ])),
        graphql_mapping_template_1.iff(graphql_mapping_template_1.raw(`!$util.isNull($ctx.args.${argName}) && !$util.isNull($ctx.args.${argName}.ge)`), graphql_mapping_template_1.compoundExpression([
            graphql_mapping_template_1.set(graphql_mapping_template_1.ref(`${queryExprReference}.expression`), graphql_mapping_template_1.raw(`"$${queryExprReference}.expression AND #sortKey >= :sortKey"`)),
            graphql_mapping_template_1.qref(`$${queryExprReference}.expressionNames.put("#sortKey", "${_sortKeyName}")`),
            graphql_mapping_template_1.qref(`$${queryExprReference}.expressionValues.put(":sortKey", { "${attributeType}": "${prefixValue(`$ctx.args.${argName}.ge`)}" })`),
        ])),
    ]);
}
exports.applyKeyConditionExpression = applyKeyConditionExpression;
function applyCompositeKeyConditionExpression(keyNames, queryExprReference = 'query', sortKeyArgumentName, sortKeyAttributeName) {
    const accumulatorVar1 = 'sortKeyValue';
    const accumulatorVar2 = 'sortKeyValue2';
    const sep = ModelResourceIDs_1.ModelResourceIDs.ModelCompositeKeySeparator();
    return graphql_mapping_template_1.block('Applying Key Condition', [
        graphql_mapping_template_1.set(graphql_mapping_template_1.ref(accumulatorVar1), graphql_mapping_template_1.str('')),
        graphql_mapping_template_1.set(graphql_mapping_template_1.ref(accumulatorVar2), graphql_mapping_template_1.str('')),
        graphql_mapping_template_1.iff(graphql_mapping_template_1.raw(`!$util.isNull($ctx.args.${sortKeyArgumentName}) && !$util.isNull($ctx.args.${sortKeyArgumentName}.beginsWith)`), graphql_mapping_template_1.compoundExpression([
            ...keyNames.map((keyName, idx) => graphql_mapping_template_1.iff(graphql_mapping_template_1.raw(`!$util.isNull($ctx.args.${sortKeyArgumentName}.beginsWith.${keyName})`), idx === 0
                ? graphql_mapping_template_1.set(graphql_mapping_template_1.ref(accumulatorVar1), graphql_mapping_template_1.str(`$ctx.args.${sortKeyArgumentName}.beginsWith.${keyName}`))
                : graphql_mapping_template_1.set(graphql_mapping_template_1.ref(accumulatorVar1), graphql_mapping_template_1.str(`$${accumulatorVar1}${sep}$ctx.args.${sortKeyArgumentName}.beginsWith.${keyName}`)), true)),
            graphql_mapping_template_1.set(graphql_mapping_template_1.ref(`${queryExprReference}.expression`), graphql_mapping_template_1.raw(`"$${queryExprReference}.expression AND begins_with(#sortKey, :sortKey)"`)),
            graphql_mapping_template_1.qref(`$${queryExprReference}.expressionNames.put("#sortKey", "${sortKeyAttributeName}")`),
            graphql_mapping_template_1.qref(`$${queryExprReference}.expressionValues.put(":sortKey", { "S": "$${accumulatorVar1}" })`),
        ])),
        graphql_mapping_template_1.iff(graphql_mapping_template_1.raw(`!$util.isNull($ctx.args.${sortKeyArgumentName}) && !$util.isNull($ctx.args.${sortKeyArgumentName}.between)`), graphql_mapping_template_1.compoundExpression([
            graphql_mapping_template_1.iff(graphql_mapping_template_1.raw(`$ctx.args.${sortKeyArgumentName}.between.size() != 2`), graphql_mapping_template_1.raw(`$util.error("Argument ${sortKeyArgumentName}.between expects exactly 2 elements.")`)),
            ...keyNames.map((keyName, idx) => graphql_mapping_template_1.iff(graphql_mapping_template_1.raw(`!$util.isNull($ctx.args.${sortKeyArgumentName}.between[0].${keyName})`), idx === 0
                ? graphql_mapping_template_1.set(graphql_mapping_template_1.ref(accumulatorVar1), graphql_mapping_template_1.str(`$ctx.args.${sortKeyArgumentName}.between[0].${keyName}`))
                : graphql_mapping_template_1.set(graphql_mapping_template_1.ref(accumulatorVar1), graphql_mapping_template_1.str(`$${accumulatorVar1}${sep}$ctx.args.${sortKeyArgumentName}.between[0].${keyName}`)), true)),
            ...keyNames.map((keyName, idx) => graphql_mapping_template_1.iff(graphql_mapping_template_1.raw(`!$util.isNull($ctx.args.${sortKeyArgumentName}.between[1].${keyName})`), idx === 0
                ? graphql_mapping_template_1.set(graphql_mapping_template_1.ref(accumulatorVar2), graphql_mapping_template_1.str(`$ctx.args.${sortKeyArgumentName}.between[1].${keyName}`))
                : graphql_mapping_template_1.set(graphql_mapping_template_1.ref(accumulatorVar2), graphql_mapping_template_1.str(`$${accumulatorVar2}${sep}$ctx.args.${sortKeyArgumentName}.between[1].${keyName}`)), true)),
            graphql_mapping_template_1.set(graphql_mapping_template_1.ref(`${queryExprReference}.expression`), graphql_mapping_template_1.raw(`"$${queryExprReference}.expression AND #sortKey BETWEEN :sortKey0 AND :sortKey1"`)),
            graphql_mapping_template_1.qref(`$${queryExprReference}.expressionNames.put("#sortKey", "${sortKeyAttributeName}")`),
            graphql_mapping_template_1.qref(`$${queryExprReference}.expressionValues.put(":sortKey0", { "S": "$${accumulatorVar1}" })`),
            graphql_mapping_template_1.qref(`$${queryExprReference}.expressionValues.put(":sortKey1", { "S": "$${accumulatorVar2}" })`),
        ])),
        graphql_mapping_template_1.iff(graphql_mapping_template_1.raw(`!$util.isNull($ctx.args.${sortKeyArgumentName}) && !$util.isNull($ctx.args.${sortKeyArgumentName}.eq)`), graphql_mapping_template_1.compoundExpression([
            ...keyNames.map((keyName, idx) => graphql_mapping_template_1.iff(graphql_mapping_template_1.raw(`!$util.isNull($ctx.args.${sortKeyArgumentName}.eq.${keyName})`), idx === 0
                ? graphql_mapping_template_1.set(graphql_mapping_template_1.ref(accumulatorVar1), graphql_mapping_template_1.str(`$ctx.args.${sortKeyArgumentName}.eq.${keyName}`))
                : graphql_mapping_template_1.set(graphql_mapping_template_1.ref(accumulatorVar1), graphql_mapping_template_1.str(`$${accumulatorVar1}${sep}$ctx.args.${sortKeyArgumentName}.eq.${keyName}`)), true)),
            graphql_mapping_template_1.set(graphql_mapping_template_1.ref(`${queryExprReference}.expression`), graphql_mapping_template_1.raw(`"$${queryExprReference}.expression AND #sortKey = :sortKey"`)),
            graphql_mapping_template_1.qref(`$${queryExprReference}.expressionNames.put("#sortKey", "${sortKeyAttributeName}")`),
            graphql_mapping_template_1.qref(`$${queryExprReference}.expressionValues.put(":sortKey", { "S": "$${accumulatorVar1}" })`),
        ])),
        graphql_mapping_template_1.iff(graphql_mapping_template_1.raw(`!$util.isNull($ctx.args.${sortKeyArgumentName}) && !$util.isNull($ctx.args.${sortKeyArgumentName}.lt)`), graphql_mapping_template_1.compoundExpression([
            ...keyNames.map((keyName, idx) => graphql_mapping_template_1.iff(graphql_mapping_template_1.raw(`!$util.isNull($ctx.args.${sortKeyArgumentName}.lt.${keyName})`), idx === 0
                ? graphql_mapping_template_1.set(graphql_mapping_template_1.ref(accumulatorVar1), graphql_mapping_template_1.str(`$ctx.args.${sortKeyArgumentName}.lt.${keyName}`))
                : graphql_mapping_template_1.set(graphql_mapping_template_1.ref(accumulatorVar1), graphql_mapping_template_1.str(`$${accumulatorVar1}${sep}$ctx.args.${sortKeyArgumentName}.lt.${keyName}`)), true)),
            graphql_mapping_template_1.set(graphql_mapping_template_1.ref(`${queryExprReference}.expression`), graphql_mapping_template_1.raw(`"$${queryExprReference}.expression AND #sortKey < :sortKey"`)),
            graphql_mapping_template_1.qref(`$${queryExprReference}.expressionNames.put("#sortKey", "${sortKeyAttributeName}")`),
            graphql_mapping_template_1.qref(`$${queryExprReference}.expressionValues.put(":sortKey", { "S": "$${accumulatorVar1}" })`),
        ])),
        graphql_mapping_template_1.iff(graphql_mapping_template_1.raw(`!$util.isNull($ctx.args.${sortKeyArgumentName}) && !$util.isNull($ctx.args.${sortKeyArgumentName}.le)`), graphql_mapping_template_1.compoundExpression([
            ...keyNames.map((keyName, idx) => graphql_mapping_template_1.iff(graphql_mapping_template_1.raw(`!$util.isNull($ctx.args.${sortKeyArgumentName}.le.${keyName})`), idx === 0
                ? graphql_mapping_template_1.set(graphql_mapping_template_1.ref(accumulatorVar1), graphql_mapping_template_1.str(`$ctx.args.${sortKeyArgumentName}.le.${keyName}`))
                : graphql_mapping_template_1.set(graphql_mapping_template_1.ref(accumulatorVar1), graphql_mapping_template_1.str(`$${accumulatorVar1}${sep}$ctx.args.${sortKeyArgumentName}.le.${keyName}`)), true)),
            graphql_mapping_template_1.set(graphql_mapping_template_1.ref(`${queryExprReference}.expression`), graphql_mapping_template_1.raw(`"$${queryExprReference}.expression AND #sortKey <= :sortKey"`)),
            graphql_mapping_template_1.qref(`$${queryExprReference}.expressionNames.put("#sortKey", "${sortKeyAttributeName}")`),
            graphql_mapping_template_1.qref(`$${queryExprReference}.expressionValues.put(":sortKey", { "S": "$${accumulatorVar1}" })`),
        ])),
        graphql_mapping_template_1.iff(graphql_mapping_template_1.raw(`!$util.isNull($ctx.args.${sortKeyArgumentName}) && !$util.isNull($ctx.args.${sortKeyArgumentName}.gt)`), graphql_mapping_template_1.compoundExpression([
            ...keyNames.map((keyName, idx) => graphql_mapping_template_1.iff(graphql_mapping_template_1.raw(`!$util.isNull($ctx.args.${sortKeyArgumentName}.gt.${keyName})`), idx === 0
                ? graphql_mapping_template_1.set(graphql_mapping_template_1.ref(accumulatorVar1), graphql_mapping_template_1.str(`$ctx.args.${sortKeyArgumentName}.gt.${keyName}`))
                : graphql_mapping_template_1.set(graphql_mapping_template_1.ref(accumulatorVar1), graphql_mapping_template_1.str(`$${accumulatorVar1}${sep}$ctx.args.${sortKeyArgumentName}.gt.${keyName}`)), true)),
            graphql_mapping_template_1.set(graphql_mapping_template_1.ref(`${queryExprReference}.expression`), graphql_mapping_template_1.raw(`"$${queryExprReference}.expression AND #sortKey > :sortKey"`)),
            graphql_mapping_template_1.qref(`$${queryExprReference}.expressionNames.put("#sortKey", "${sortKeyAttributeName}")`),
            graphql_mapping_template_1.qref(`$${queryExprReference}.expressionValues.put(":sortKey", { "S": "$${accumulatorVar1}" })`),
        ])),
        graphql_mapping_template_1.iff(graphql_mapping_template_1.raw(`!$util.isNull($ctx.args.${sortKeyArgumentName}) && !$util.isNull($ctx.args.${sortKeyArgumentName}.ge)`), graphql_mapping_template_1.compoundExpression([
            ...keyNames.map((keyName, idx) => graphql_mapping_template_1.iff(graphql_mapping_template_1.raw(`!$util.isNull($ctx.args.${sortKeyArgumentName}.ge.${keyName})`), idx === 0
                ? graphql_mapping_template_1.set(graphql_mapping_template_1.ref(accumulatorVar1), graphql_mapping_template_1.str(`$ctx.args.${sortKeyArgumentName}.ge.${keyName}`))
                : graphql_mapping_template_1.set(graphql_mapping_template_1.ref(accumulatorVar1), graphql_mapping_template_1.str(`$${accumulatorVar1}${sep}$ctx.args.${sortKeyArgumentName}.ge.${keyName}`)), true)),
            graphql_mapping_template_1.set(graphql_mapping_template_1.ref(`${queryExprReference}.expression`), graphql_mapping_template_1.raw(`"$${queryExprReference}.expression AND #sortKey >= :sortKey"`)),
            graphql_mapping_template_1.qref(`$${queryExprReference}.expressionNames.put("#sortKey", "${sortKeyAttributeName}")`),
            graphql_mapping_template_1.qref(`$${queryExprReference}.expressionValues.put(":sortKey", { "S": "$${accumulatorVar1}" })`),
        ])),
        graphql_mapping_template_1.newline(),
    ]);
}
exports.applyCompositeKeyConditionExpression = applyCompositeKeyConditionExpression;
function applyKeyExpressionForCompositeKey(keys, attributeTypes = ['S'], queryExprReference = 'query') {
    if (keys.length > 2) {
        const hashKeyName = keys[0];
        const hashKeyAttributeType = attributeTypes[0];
        const sortKeys = keys.slice(1);
        const sortKeyTypes = attributeTypes.slice(1);
        return graphql_mapping_template_1.compoundExpression([
            validateCompositeKeyArguments(keys),
            setupHashKeyExpression(hashKeyName, hashKeyAttributeType, queryExprReference),
            applyCompositeSortKey(sortKeys, sortKeyTypes, queryExprReference),
        ]);
    }
    else if (keys.length === 2) {
        const hashKeyName = keys[0];
        const hashKeyAttributeType = attributeTypes[0];
        const sortKeyName = keys[1];
        const sortKeyAttributeType = attributeTypes[1];
        return graphql_mapping_template_1.compoundExpression([
            validateKeyArguments(keys),
            setupHashKeyExpression(hashKeyName, hashKeyAttributeType, queryExprReference),
            applyKeyConditionExpression(sortKeyName, sortKeyAttributeType, queryExprReference),
        ]);
    }
    else if (keys.length === 1) {
        const hashKeyName = keys[0];
        const hashKeyAttributeType = attributeTypes[0];
        return setupHashKeyExpression(hashKeyName, hashKeyAttributeType, queryExprReference);
    }
}
exports.applyKeyExpressionForCompositeKey = applyKeyExpressionForCompositeKey;
function setupHashKeyExpression(hashKeyName, hashKeyAttributeType, queryExprReference) {
    return graphql_mapping_template_1.iff(graphql_mapping_template_1.raw(`!$util.isNull($ctx.args.${hashKeyName})`), graphql_mapping_template_1.compoundExpression([
        graphql_mapping_template_1.set(graphql_mapping_template_1.ref(`${queryExprReference}.expression`), graphql_mapping_template_1.str(`#${hashKeyName} = :${hashKeyName}`)),
        graphql_mapping_template_1.set(graphql_mapping_template_1.ref(`${queryExprReference}.expressionNames`), graphql_mapping_template_1.obj({ [`#${hashKeyName}`]: graphql_mapping_template_1.str(hashKeyName) })),
        graphql_mapping_template_1.set(graphql_mapping_template_1.ref(`${queryExprReference}.expressionValues`), graphql_mapping_template_1.obj({ [`:${hashKeyName}`]: graphql_mapping_template_1.obj({ [hashKeyAttributeType]: graphql_mapping_template_1.str(`$ctx.args.${hashKeyName}`) }) })),
    ]));
}
exports.setupHashKeyExpression = setupHashKeyExpression;
function applyCompositeSortKey(sortKeys, sortKeyTypes, queryExprReference) {
    if (sortKeys.length === 0) {
        return graphql_mapping_template_1.newline();
    }
    const sortKeyAttributeName = ModelResourceIDs_1.ModelResourceIDs.ModelCompositeAttributeName(sortKeys);
    const sortKeyArgumentName = ModelResourceIDs_1.ModelResourceIDs.ModelCompositeKeyArgumentName(sortKeys);
    return graphql_mapping_template_1.compoundExpression([
        applyCompositeKeyConditionExpression(sortKeys, queryExprReference, sortKeyArgumentName, sortKeyAttributeName),
    ]);
}
function validateKeyArguments(keys) {
    const exprs = [];
    if (keys.length > 1) {
        for (let index = keys.length - 1; index > 0; index--) {
            const rightKey = keys[index];
            const previousKey = keys[index - 1];
            exprs.push(graphql_mapping_template_1.iff(graphql_mapping_template_1.raw(`!$util.isNull($ctx.args.${rightKey}) && $util.isNull($ctx.args.${previousKey})`), graphql_mapping_template_1.raw(`$util.error("When providing argument '${rightKey}' you must also provide arguments ${keys
                .slice(0, index)
                .join(', ')}", "InvalidArgumentsError")`)));
        }
        return graphql_mapping_template_1.block('Validate key arguments.', exprs);
    }
    else {
        return graphql_mapping_template_1.newline();
    }
}
function invalidArgumentError(err) {
    return graphql_mapping_template_1.raw(`$util.error("${err}", "InvalidArgumentsError")`);
}
function validateCompositeKeyArguments(keys) {
    const sortKeys = keys.slice(1);
    const hashKey = keys[0];
    const sortKeyArgumentName = ModelResourceIDs_1.ModelResourceIDs.ModelCompositeKeyArgumentName(sortKeys);
    const exprs = [
        graphql_mapping_template_1.iff(graphql_mapping_template_1.raw(`!$util.isNull($ctx.args.${sortKeyArgumentName}) && $util.isNullOrBlank($ctx.args.${hashKey})`), invalidArgumentError(`When providing argument '${sortKeyArgumentName}' you must also provide '${hashKey}'.`)),
    ];
    if (sortKeys.length > 1) {
        const loopOverKeys = (fn) => {
            const exprs = [];
            for (let index = sortKeys.length - 1; index > 0; index--) {
                const rightKey = sortKeys[index];
                const previousKey = sortKeys[index - 1];
                exprs.push(fn(rightKey, previousKey));
            }
            return graphql_mapping_template_1.compoundExpression(exprs);
        };
        const validateBetween = () => graphql_mapping_template_1.compoundExpression([
            graphql_mapping_template_1.iff(graphql_mapping_template_1.raw(`$ctx.args.${sortKeyArgumentName}.between.size() != 2`), invalidArgumentError(`Argument '${sortKeyArgumentName}.between' expects exactly two elements.`)),
            loopOverKeys((rightKey, previousKey) => graphql_mapping_template_1.compoundExpression([
                graphql_mapping_template_1.iff(graphql_mapping_template_1.raw(`!$util.isNullOrBlank($ctx.args.${sortKeyArgumentName}.between[0].${rightKey}) && $util.isNullOrBlank($ctx.args.${sortKeyArgumentName}.between[0].${previousKey})`), invalidArgumentError(`When providing argument '${sortKeyArgumentName}.between[0].${rightKey}' you must also provide '${sortKeyArgumentName}.between[0].${previousKey}'.`)),
                graphql_mapping_template_1.iff(graphql_mapping_template_1.raw(`!$util.isNullOrBlank($ctx.args.${sortKeyArgumentName}.between[1].${rightKey}) && $util.isNullOrBlank($ctx.args.${sortKeyArgumentName}.between[1].${previousKey})`), invalidArgumentError(`When providing argument '${sortKeyArgumentName}.between[1].${rightKey}' you must also provide '${sortKeyArgumentName}.between[1].${previousKey}'.`)),
            ])),
        ]);
        const validateOtherOperation = () => loopOverKeys((rightKey, previousKey) => graphql_mapping_template_1.iff(graphql_mapping_template_1.raw(`!$util.isNullOrBlank($ctx.args.${sortKeyArgumentName}.get("$operation").${rightKey}) && $util.isNullOrBlank($ctx.args.${sortKeyArgumentName}.get("$operation").${previousKey})`), invalidArgumentError(`When providing argument '${sortKeyArgumentName}.$operation.${rightKey}' you must also provide '${sortKeyArgumentName}.$operation.${previousKey}'.`)));
        exprs.push(graphql_mapping_template_1.iff(graphql_mapping_template_1.raw(`!$util.isNull($ctx.args.${sortKeyArgumentName})`), graphql_mapping_template_1.compoundExpression([
            graphql_mapping_template_1.set(graphql_mapping_template_1.ref('sortKeyArgumentOperations'), graphql_mapping_template_1.raw(`$ctx.args.${sortKeyArgumentName}.keySet()`)),
            graphql_mapping_template_1.iff(graphql_mapping_template_1.raw(`$sortKeyArgumentOperations.size() > 1`), invalidArgumentError(`Argument ${sortKeyArgumentName} must specify at most one key condition operation.`)),
            graphql_mapping_template_1.forEach(graphql_mapping_template_1.ref('operation'), graphql_mapping_template_1.ref('sortKeyArgumentOperations'), [
                graphql_mapping_template_1.ifElse(graphql_mapping_template_1.raw(`$operation == "between"`), validateBetween(), validateOtherOperation()),
            ]),
        ])));
        return graphql_mapping_template_1.block('Validate key arguments.', exprs);
    }
    else {
        return graphql_mapping_template_1.newline();
    }
}
//# sourceMappingURL=dynamodbUtils.js.map