import { ObjectTypeDefinitionNode, NonNullTypeNode, DirectiveNode, NameNode, OperationTypeNode, FieldDefinitionNode, NamedTypeNode, InputValueDefinitionNode, ValueNode, OperationTypeDefinitionNode, ArgumentNode, ListValueNode, ListTypeNode, StringValueNode, InputObjectTypeDefinitionNode } from 'graphql';
export declare function getNonNullType(typeNode: NamedTypeNode): NonNullTypeNode;
export declare function getNamedType(name: string): NamedTypeNode;
export declare function getInputValueDefinition(typeNode: NamedTypeNode | NonNullTypeNode, name: string): InputValueDefinitionNode;
export declare function getOperationFieldDefinition(name: string, args: InputValueDefinitionNode[], type: NamedTypeNode | ListTypeNode, directives: ReadonlyArray<DirectiveNode>): FieldDefinitionNode;
export declare function getFieldDefinition(fieldName: string, type: NonNullTypeNode | NamedTypeNode): FieldDefinitionNode;
export declare function getTypeDefinition(fields: ReadonlyArray<FieldDefinitionNode>, typeName: string): ObjectTypeDefinitionNode;
export declare function getInputTypeDefinition(fields: ReadonlyArray<InputValueDefinitionNode>, typeName: string): InputObjectTypeDefinitionNode;
export declare function getNameNode(name: string): NameNode;
export declare function getSingletonListTypeNode(name: string): ListTypeNode;
export declare function getListValueNode(values: ReadonlyArray<ValueNode>): ListValueNode;
export declare function getStringValueNode(value: string): StringValueNode;
export declare function getDirectiveNode(mutationName: string): DirectiveNode;
export declare function getOperationTypeDefinition(operationType: OperationTypeNode, operation: NamedTypeNode): OperationTypeDefinitionNode;
export declare function getArgumentNode(argument: string): ArgumentNode;
export declare function getGraphQLTypeFromMySQLType(dbType: string): string;
//# sourceMappingURL=RelationalDBSchemaTransformerUtils.d.ts.map