"""empty message

Revision ID: c59b91455b84
Revises: 
Create Date: 2020-11-09 14:10:20.477339

"""
import sqlalchemy as sa
from alembic import op

# revision identifiers, used by Alembic.
revision = 'c59b91455b84'
down_revision = None
branch_labels = None
depends_on = None


def upgrade():
    # ### commands auto generated by Alembic - please adjust! ###
    op.create_table('users',
    sa.Column('id', sa.Integer(), nullable=False),
    sa.Column('is_active', sa.Boolean(), server_default='1', nullable=False),
    sa.Column('username', sa.String(length=100, collation='NOCASE'), nullable=False),
    sa.Column('password', sa.String(length=255), server_default='', nullable=False),
    sa.Column('email_confirmed_at', sa.DateTime(), nullable=True),
    sa.Column('first_name', sa.String(length=100, collation='NOCASE'), server_default='', nullable=False),
    sa.Column('last_name', sa.String(length=100, collation='NOCASE'), server_default='', nullable=False),
    sa.PrimaryKeyConstraint('id'),
    sa.UniqueConstraint('username')
    )
    op.create_table('ffs',
    sa.Column('id', sa.Integer(), nullable=False),
    sa.Column('ffs_id', sa.String(length=36), nullable=True),
    sa.Column('token', sa.String(length=36), nullable=True),
    sa.Column('creation_date', sa.DateTime(), nullable=True),
    sa.Column('user_id', sa.Integer(), nullable=False),
    sa.ForeignKeyConstraint(['user_id'], ['users.id'], ),
    sa.PrimaryKeyConstraint('id')
    )
    op.create_index(op.f('ix_ffs_ffs_id'), 'ffs', ['ffs_id'], unique=False)
    op.create_index(op.f('ix_ffs_token'), 'ffs', ['token'], unique=False)
    op.create_table('logs',
    sa.Column('id', sa.Integer(), nullable=False),
    sa.Column('timestamp', sa.DateTime(), nullable=True),
    sa.Column('event', sa.String(length=255), nullable=True),
    sa.Column('user_id', sa.Integer(), nullable=False),
    sa.ForeignKeyConstraint(['user_id'], ['users.id'], ),
    sa.PrimaryKeyConstraint('id')
    )
    op.create_table('user_directories',
    sa.Column('id', sa.Integer(), nullable=False),
    sa.Column('platform', sa.String(), nullable=False),
    sa.Column('directory', sa.String(), nullable=False),
    sa.Column('user_id', sa.Integer(), nullable=False),
    sa.ForeignKeyConstraint(['user_id'], ['users.id'], ),
    sa.PrimaryKeyConstraint('id')
    )
    op.create_table('wallets',
    sa.Column('id', sa.Integer(), nullable=False),
    sa.Column('created', sa.DateTime(), nullable=True),
    sa.Column('address', sa.String(length=255), nullable=True),
    sa.Column('ffs', sa.String(length=255), nullable=True),
    sa.Column('user_id', sa.Integer(), nullable=False),
    sa.ForeignKeyConstraint(['user_id'], ['users.id'], ),
    sa.PrimaryKeyConstraint('id')
    )
    op.create_table('files',
    sa.Column('id', sa.Integer(), nullable=False),
    sa.Column('file_path', sa.String(length=255), nullable=True),
    sa.Column('file_name', sa.String(length=255), nullable=True),
    sa.Column('upload_date', sa.DateTime(), nullable=True),
    sa.Column('file_size', sa.Integer(), nullable=True),
    sa.Column('CID', sa.String(length=64), nullable=True),
    sa.Column('platform', sa.String(length=255), nullable=True),
    sa.Column('user_id', sa.Integer(), nullable=False),
    sa.Column('ffs_id', sa.Integer(), nullable=False),
    sa.ForeignKeyConstraint(['ffs_id'], ['ffs.id'], ),
    sa.ForeignKeyConstraint(['user_id'], ['users.id'], ),
    sa.PrimaryKeyConstraint('id')
    )
    op.create_index(op.f('ix_files_CID'), 'files', ['CID'], unique=False)
    op.create_index(op.f('ix_files_file_name'), 'files', ['file_name'], unique=False)
    op.create_index(op.f('ix_files_platform'), 'files', ['platform'], unique=False)
    # ### end Alembic commands ###


def downgrade():
    # ### commands auto generated by Alembic - please adjust! ###
    op.drop_index(op.f('ix_files_platform'), table_name='files')
    op.drop_index(op.f('ix_files_file_name'), table_name='files')
    op.drop_index(op.f('ix_files_CID'), table_name='files')
    op.drop_table('files')
    op.drop_table('wallets')
    op.drop_table('user_directories')
    op.drop_table('logs')
    op.drop_index(op.f('ix_ffs_token'), table_name='ffs')
    op.drop_index(op.f('ix_ffs_ffs_id'), table_name='ffs')
    op.drop_table('ffs')
    op.drop_table('users')
    # ### end Alembic commands ###
