/*!
 * QUnit 2.2.1
 * https://qunitjs.com/
 *
 * Copyright jQuery Foundation and other contributors
 * Released under the MIT license
 * https://jquery.org/license
 *
 * Date: 2017-03-20T00:27Z
 */
(function(global$1){'use strict';global$1='default'in global$1?global$1['default']:global$1;var window=global$1.window;var console=global$1.console;var setTimeout=global$1.setTimeout;var clearTimeout=global$1.clearTimeout;var document=window&&window.document;var navigator=window&&window.navigator;var localSessionStorage=function(){var x="qunit-test-string";try{global$1.sessionStorage.setItem(x,x);global$1.sessionStorage.removeItem(x);return global$1.sessionStorage;}catch(e){return undefined;}}();var _typeof=typeof Symbol==="function"&&typeof Symbol.iterator==="symbol"?function(obj){return typeof obj;}:function(obj){return obj&&typeof Symbol==="function"&&obj.constructor===Symbol&&obj!==Symbol.prototype?"symbol":typeof obj;};var classCallCheck=function(instance,Constructor){if(!(instance instanceof Constructor)){throw new TypeError("Cannot call a class as a function");}};var createClass=function(){function defineProperties(target,props){for(var i=0;i<props.length;i++){var descriptor=props[i];descriptor.enumerable=descriptor.enumerable||false;descriptor.configurable=true;if("value"in descriptor)descriptor.writable=true;Object.defineProperty(target,descriptor.key,descriptor);}}
return function(Constructor,protoProps,staticProps){if(protoProps)defineProperties(Constructor.prototype,protoProps);if(staticProps)defineProperties(Constructor,staticProps);return Constructor;};}();var toConsumableArray=function(arr){if(Array.isArray(arr)){for(var i=0,arr2=Array(arr.length);i<arr.length;i++)arr2[i]=arr[i];return arr2;}else{return Array.from(arr);}};var toString=Object.prototype.toString;var hasOwn=Object.prototype.hasOwnProperty;var now=Date.now||function(){return new Date().getTime();};var defined={document:window&&window.document!==undefined,setTimeout:setTimeout!==undefined};function diff(a,b){var i,j,result=a.slice();for(i=0;i<result.length;i++){for(j=0;j<b.length;j++){if(result[i]===b[j]){result.splice(i,1);i--;break;}}}
return result;}
function inArray(elem,array){return array.indexOf(elem)!==-1;}
function objectValues(obj){var key,val,vals=is("array",obj)?[]:{};for(key in obj){if(hasOwn.call(obj,key)){val=obj[key];vals[key]=val===Object(val)?objectValues(val):val;}}
return vals;}
function extend(a,b,undefOnly){for(var prop in b){if(hasOwn.call(b,prop)){if(b[prop]===undefined){delete a[prop];}else if(!(undefOnly&&typeof a[prop]!=="undefined")){a[prop]=b[prop];}}}
return a;}
function objectType(obj){if(typeof obj==="undefined"){return"undefined";}
if(obj===null){return"null";}
var match=toString.call(obj).match(/^\[object\s(.*)\]$/),type=match&&match[1];switch(type){case"Number":if(isNaN(obj)){return"nan";}
return"number";case"String":case"Boolean":case"Array":case"Set":case"Map":case"Date":case"RegExp":case"Function":case"Symbol":return type.toLowerCase();}
if((typeof obj==="undefined"?"undefined":_typeof(obj))==="object"){return"object";}}
function is(type,obj){return objectType(obj)===type;}
var equiv=(function(){var pairs=[];var getProto=Object.getPrototypeOf||function(obj){return obj.__proto__;};function useStrictEquality(a,b){if((typeof a==="undefined"?"undefined":_typeof(a))==="object"){a=a.valueOf();}
if((typeof b==="undefined"?"undefined":_typeof(b))==="object"){b=b.valueOf();}
return a===b;}
function compareConstructors(a,b){var protoA=getProto(a);var protoB=getProto(b);if(a.constructor===b.constructor){return true;}
if(protoA&&protoA.constructor===null){protoA=null;}
if(protoB&&protoB.constructor===null){protoB=null;}
if(protoA===null&&protoB===Object.prototype||protoB===null&&protoA===Object.prototype){return true;}
return false;}
function getRegExpFlags(regexp){return"flags"in regexp?regexp.flags:regexp.toString().match(/[gimuy]*$/)[0];}
function isContainer(val){return["object","array","map","set"].indexOf(objectType(val))!==-1;}
function breadthFirstCompareChild(a,b){if(a===b){return true;}
if(!isContainer(a)){return typeEquiv(a,b);}
if(pairs.every(function(pair){return pair.a!==a||pair.b!==b;})){pairs.push({a:a,b:b});}
return true;}
var callbacks={"string":useStrictEquality,"boolean":useStrictEquality,"number":useStrictEquality,"null":useStrictEquality,"undefined":useStrictEquality,"symbol":useStrictEquality,"date":useStrictEquality,"nan":function nan(){return true;},"regexp":function regexp(a,b){return a.source===b.source&&getRegExpFlags(a)===getRegExpFlags(b);},"function":function _function(){return false;},"array":function array(a,b){var i,len;len=a.length;if(len!==b.length){return false;}
for(i=0;i<len;i++){if(!breadthFirstCompareChild(a[i],b[i])){return false;}}
return true;},"set":function set$$1(a,b){var innerEq,outerEq=true;if(a.size!==b.size){return false;}
a.forEach(function(aVal){if(!outerEq){return;}
innerEq=false;b.forEach(function(bVal){var parentPairs;if(innerEq){return;}
parentPairs=pairs;if(innerEquiv(bVal,aVal)){innerEq=true;}
pairs=parentPairs;});if(!innerEq){outerEq=false;}});return outerEq;},"map":function map(a,b){var innerEq,outerEq=true;if(a.size!==b.size){return false;}
a.forEach(function(aVal,aKey){if(!outerEq){return;}
innerEq=false;b.forEach(function(bVal,bKey){var parentPairs;if(innerEq){return;}
parentPairs=pairs;if(innerEquiv([bVal,bKey],[aVal,aKey])){innerEq=true;}
pairs=parentPairs;});if(!innerEq){outerEq=false;}});return outerEq;},"object":function object(a,b){var i,aProperties=[],bProperties=[];if(compareConstructors(a,b)===false){return false;}
for(i in a){aProperties.push(i);if(a.constructor!==Object&&typeof a.constructor!=="undefined"&&typeof a[i]==="function"&&typeof b[i]==="function"&&a[i].toString()===b[i].toString()){continue;}
if(!breadthFirstCompareChild(a[i],b[i])){return false;}}
for(i in b){bProperties.push(i);}
return typeEquiv(aProperties.sort(),bProperties.sort());}};function typeEquiv(a,b){var type=objectType(a);return objectType(b)===type&&callbacks[type](a,b);}
function innerEquiv(a,b){var i,pair;if(arguments.length<2){return true;}
pairs=[{a:a,b:b}];for(i=0;i<pairs.length;i++){pair=pairs[i];if(pair.a!==pair.b&&!typeEquiv(pair.a,pair.b)){return false;}}
return arguments.length===2||innerEquiv.apply(this,[].slice.call(arguments,1));}
return innerEquiv;})();var config={queue:[],blocking:true,reorder:true,altertitle:true,collapse:true,scrolltop:true,maxDepth:5,requireExpects:false,urlConfig:[],modules:[],moduleStack:[],currentModule:{name:"",tests:[],childModules:[],testsRun:0},callbacks:{},storage:localSessionStorage};var globalConfig=window&&window.QUnit&&window.QUnit.config;if(window&&window.QUnit&&!window.QUnit.version){extend(config,globalConfig);}
config.modules.push(config.currentModule);var dump=(function(){function quote(str){return"\""+str.toString().replace(/\\/g,"\\\\").replace(/"/g,"\\\"")+"\"";}
function literal(o){return o+"";}
function join(pre,arr,post){var s=dump.separator(),base=dump.indent(),inner=dump.indent(1);if(arr.join){arr=arr.join(","+s+inner);}
if(!arr){return pre+post;}
return[pre,inner+arr,base+post].join(s);}
function array(arr,stack){var i=arr.length,ret=new Array(i);if(dump.maxDepth&&dump.depth>dump.maxDepth){return"[object Array]";}
this.up();while(i--){ret[i]=this.parse(arr[i],undefined,stack);}
this.down();return join("[",ret,"]");}
function isArray(obj){return(toString.call(obj)==="[object Array]"||typeof obj.length==="number"&&obj.item!==undefined&&(obj.length?obj.item(0)===obj[0]:obj.item(0)===null&&obj[0]===undefined));}
var reName=/^function (\w+)/,dump={parse:function parse(obj,objType,stack){stack=stack||[];var res,parser,parserType,objIndex=stack.indexOf(obj);if(objIndex!==-1){return"recursion("+(objIndex-stack.length)+")";}
objType=objType||this.typeOf(obj);parser=this.parsers[objType];parserType=typeof parser==="undefined"?"undefined":_typeof(parser);if(parserType==="function"){stack.push(obj);res=parser.call(this,obj,stack);stack.pop();return res;}
return parserType==="string"?parser:this.parsers.error;},typeOf:function typeOf(obj){var type;if(obj===null){type="null";}else if(typeof obj==="undefined"){type="undefined";}else if(is("regexp",obj)){type="regexp";}else if(is("date",obj)){type="date";}else if(is("function",obj)){type="function";}else if(obj.setInterval!==undefined&&obj.document!==undefined&&obj.nodeType===undefined){type="window";}else if(obj.nodeType===9){type="document";}else if(obj.nodeType){type="node";}else if(isArray(obj)){type="array";}else if(obj.constructor===Error.prototype.constructor){type="error";}else{type=typeof obj==="undefined"?"undefined":_typeof(obj);}
return type;},separator:function separator(){if(this.multiline){return this.HTML?"<br />":"\n";}else{return this.HTML?"&#160;":" ";}},indent:function indent(extra){if(!this.multiline){return"";}
var chr=this.indentChar;if(this.HTML){chr=chr.replace(/\t/g,"   ").replace(/ /g,"&#160;");}
return new Array(this.depth+(extra||0)).join(chr);},up:function up(a){this.depth+=a||1;},down:function down(a){this.depth-=a||1;},setParser:function setParser(name,parser){this.parsers[name]=parser;},quote:quote,literal:literal,join:join,depth:1,maxDepth:config.maxDepth,parsers:{window:"[Window]",document:"[Document]",error:function error(_error){return"Error(\""+_error.message+"\")";},unknown:"[Unknown]","null":"null","undefined":"undefined","function":function _function(fn){var ret="function",name="name"in fn?fn.name:(reName.exec(fn)||[])[1];if(name){ret+=" "+name;}
ret+="(";ret=[ret,dump.parse(fn,"functionArgs"),"){"].join("");return join(ret,dump.parse(fn,"functionCode"),"}");},array:array,nodelist:array,"arguments":array,object:function object(map,stack){var keys,key,val,i,nonEnumerableProperties,ret=[];if(dump.maxDepth&&dump.depth>dump.maxDepth){return"[object Object]";}
dump.up();keys=[];for(key in map){keys.push(key);}
nonEnumerableProperties=["message","name"];for(i in nonEnumerableProperties){key=nonEnumerableProperties[i];if(key in map&&!inArray(key,keys)){keys.push(key);}}
keys.sort();for(i=0;i<keys.length;i++){key=keys[i];val=map[key];ret.push(dump.parse(key,"key")+": "+dump.parse(val,undefined,stack));}
dump.down();return join("{",ret,"}");},node:function node(_node){var len,i,val,open=dump.HTML?"&lt;":"<",close=dump.HTML?"&gt;":">",tag=_node.nodeName.toLowerCase(),ret=open+tag,attrs=_node.attributes;if(attrs){for(i=0,len=attrs.length;i<len;i++){val=attrs[i].nodeValue;if(val&&val!=="inherit"){ret+=" "+attrs[i].nodeName+"="+dump.parse(val,"attribute");}}}
ret+=close;if(_node.nodeType===3||_node.nodeType===4){ret+=_node.nodeValue;}
return ret+open+"/"+tag+close;},functionArgs:function functionArgs(fn){var args,l=fn.length;if(!l){return"";}
args=new Array(l);while(l--){args[l]=String.fromCharCode(97+l);}
return" "+args.join(", ")+" ";},key:quote,functionCode:"[code]",attribute:quote,string:quote,date:quote,regexp:literal,number:literal,"boolean":literal,symbol:function symbol(sym){return sym.toString();}},HTML:false,indentChar:"  ",multiline:true};return dump;})();var LISTENERS=Object.create(null);var SUPPORTED_EVENTS=["runStart","suiteStart","testStart","assertion","testEnd","suiteEnd","runEnd"];function emit(eventName,data){if(objectType(eventName)!=="string"){throw new TypeError("eventName must be a string when emitting an event");}
var originalCallbacks=LISTENERS[eventName];var callbacks=originalCallbacks?[].concat(toConsumableArray(originalCallbacks)):[];for(var i=0;i<callbacks.length;i++){callbacks[i](data);}}
function on(eventName,callback){if(objectType(eventName)!=="string"){throw new TypeError("eventName must be a string when registering a listener");}else if(!inArray(eventName,SUPPORTED_EVENTS)){var events=SUPPORTED_EVENTS.join(", ");throw new Error("\""+eventName+"\" is not a valid event; must be one of: "+events+".");}else if(objectType(callback)!=="function"){throw new TypeError("callback must be a function when registering a listener");}
if(!LISTENERS[eventName]){LISTENERS[eventName]=[];}
if(!inArray(callback,LISTENERS[eventName])){LISTENERS[eventName].push(callback);}}
function registerLoggingCallbacks(obj){var i,l,key,callbackNames=["begin","done","log","testStart","testDone","moduleStart","moduleDone"];function registerLoggingCallback(key){var loggingCallback=function loggingCallback(callback){if(objectType(callback)!=="function"){throw new Error("QUnit logging methods require a callback function as their first parameters.");}
config.callbacks[key].push(callback);};return loggingCallback;}
for(i=0,l=callbackNames.length;i<l;i++){key=callbackNames[i];if(objectType(config.callbacks[key])==="undefined"){config.callbacks[key]=[];}
obj[key]=registerLoggingCallback(key);}}
function runLoggingCallbacks(key,args){var i,l,callbacks;callbacks=config.callbacks[key];for(i=0,l=callbacks.length;i<l;i++){callbacks[i](args);}}
var fileName=(sourceFromStacktrace(0)||"").replace(/(:\d+)+\)?/,"").replace(/.+\//,"");function extractStacktrace(e,offset){offset=offset===undefined?4:offset;var stack,include,i;if(e&&e.stack){stack=e.stack.split("\n");if(/^error$/i.test(stack[0])){stack.shift();}
if(fileName){include=[];for(i=offset;i<stack.length;i++){if(stack[i].indexOf(fileName)!==-1){break;}
include.push(stack[i]);}
if(include.length){return include.join("\n");}}
return stack[offset];}}
function sourceFromStacktrace(offset){var error=new Error();if(!error.stack){try{throw error;}catch(err){error=err;}}
return extractStacktrace(error,offset);}
var TestReport=function(){function TestReport(name,suite,options){classCallCheck(this,TestReport);this.name=name;this.suiteName=suite.name;this.fullName=suite.fullName.concat(name);this.runtime=0;this.assertions=[];this.skipped=!!options.skip;this.todo=!!options.todo;this._startTime=0;this._endTime=0;suite.pushTest(this);}
createClass(TestReport,[{key:"start",value:function start(recordTime){if(recordTime){this._startTime=Date.now();}
return{name:this.name,suiteName:this.suiteName,fullName:this.fullName.slice()};}},{key:"end",value:function end(recordTime){if(recordTime){this._endTime=Date.now();}
return extend(this.start(),{runtime:this.getRuntime(),status:this.getStatus(),errors:this.getFailedAssertions(),assertions:this.getAssertions()});}},{key:"pushAssertion",value:function pushAssertion(assertion){this.assertions.push(assertion);}},{key:"getRuntime",value:function getRuntime(){return this._endTime-this._startTime;}},{key:"getStatus",value:function getStatus(){if(this.skipped){return"skipped";}
var testPassed=this.getFailedAssertions().length>0?this.todo:!this.todo;if(!testPassed){return"failed";}else if(this.todo){return"todo";}else{return"passed";}}},{key:"getFailedAssertions",value:function getFailedAssertions(){return this.assertions.filter(function(assertion){return!assertion.passed;});}},{key:"getAssertions",value:function getAssertions(){return this.assertions.slice();}}]);return TestReport;}();var unitSampler;var focused=false;var priorityCount=0;function Test(settings){var i,l;++Test.count;this.expected=null;extend(this,settings);this.assertions=[];this.semaphore=0;this.usedAsync=false;this.module=config.currentModule;this.stack=sourceFromStacktrace(3);this.steps=[];this.testReport=new TestReport(settings.testName,this.module.suiteReport,{todo:settings.todo,skip:settings.skip});for(i=0,l=this.module.tests;i<l.length;i++){if(this.module.tests[i].name===this.testName){this.testName+=" ";}}
this.testId=generateHash(this.module.name,this.testName);this.module.tests.push({name:this.testName,testId:this.testId});if(settings.skip){this.callback=function(){};this.async=false;this.expected=0;}else{this.assert=new Assert(this);}}
Test.count=0;function getNotStartedModules(startModule){var module=startModule,modules=[];while(module&&module.testsRun===0){modules.push(module);module=module.parentModule;}
return modules;}
Test.prototype={before:function before(){var i,startModule,module=this.module,notStartedModules=getNotStartedModules(module);for(i=notStartedModules.length-1;i>=0;i--){startModule=notStartedModules[i];startModule.stats={all:0,bad:0,started:now()};emit("suiteStart",startModule.suiteReport.start(true));runLoggingCallbacks("moduleStart",{name:startModule.name,tests:startModule.tests});}
config.current=this;if(module.testEnvironment){delete module.testEnvironment.before;delete module.testEnvironment.beforeEach;delete module.testEnvironment.afterEach;delete module.testEnvironment.after;}
this.testEnvironment=extend({},module.testEnvironment);this.started=now();emit("testStart",this.testReport.start(true));runLoggingCallbacks("testStart",{name:this.testName,module:module.name,testId:this.testId,previousFailure:this.previousFailure});if(!config.pollution){saveGlobal();}},run:function run(){var promise;config.current=this;this.callbackStarted=now();if(config.notrycatch){runTest(this);return;}
try{runTest(this);}catch(e){this.pushFailure("Died on test #"+(this.assertions.length+1)+" "+this.stack+": "+(e.message||e),extractStacktrace(e,0));saveGlobal();if(config.blocking){internalRecover(this);}}
function runTest(test){promise=test.callback.call(test.testEnvironment,test.assert);test.resolvePromise(promise);}},after:function after(){checkPollution();},queueHook:function queueHook(hook,hookName,hookOwner){var promise,test=this;return function runHook(){if(hookName==="before"){if(hookOwner.testsRun!==0){return;}
test.preserveEnvironment=true;}
if(hookName==="after"&&hookOwner.testsRun!==numberOfTests(hookOwner)-1){return;}
config.current=test;if(config.notrycatch){callHook();return;}
try{callHook();}catch(error){test.pushFailure(hookName+" failed on "+test.testName+": "+(error.message||error),extractStacktrace(error,0));}
function callHook(){promise=hook.call(test.testEnvironment,test.assert);test.resolvePromise(promise,hookName);}};},hooks:function hooks(handler){var hooks=[];function processHooks(test,module){if(module.parentModule){processHooks(test,module.parentModule);}
if(module.testEnvironment&&objectType(module.testEnvironment[handler])==="function"){hooks.push(test.queueHook(module.testEnvironment[handler],handler,module));}}
if(!this.skip){processHooks(this,this.module);}
return hooks;},finish:function finish(){config.current=this;if(config.requireExpects&&this.expected===null){this.pushFailure("Expected number of assertions to be defined, but expect() was "+"not called.",this.stack);}else if(this.expected!==null&&this.expected!==this.assertions.length){this.pushFailure("Expected "+this.expected+" assertions, but "+this.assertions.length+" were run",this.stack);}else if(this.expected===null&&!this.assertions.length){this.pushFailure("Expected at least one assertion, but none were run - call "+"expect(0) to accept zero assertions.",this.stack);}
var i,module=this.module,moduleName=module.name,testName=this.testName,skipped=!!this.skip,todo=!!this.todo,bad=0,storage=config.storage;this.runtime=now()-this.started;config.stats.all+=this.assertions.length;module.stats.all+=this.assertions.length;for(i=0;i<this.assertions.length;i++){if(!this.assertions[i].result){bad++;config.stats.bad++;module.stats.bad++;}}
notifyTestsRan(module);if(storage){if(bad){storage.setItem("qunit-test-"+moduleName+"-"+testName,bad);}else{storage.removeItem("qunit-test-"+moduleName+"-"+testName);}}
emit("testEnd",this.testReport.end(true));runLoggingCallbacks("testDone",{name:testName,module:moduleName,skipped:skipped,todo:todo,failed:bad,passed:this.assertions.length-bad,total:this.assertions.length,runtime:skipped?0:this.runtime,assertions:this.assertions,testId:this.testId,source:this.stack});if(module.testsRun===numberOfTests(module)){emit("suiteEnd",module.suiteReport.end(true));runLoggingCallbacks("moduleDone",{name:module.name,tests:module.tests,failed:module.stats.bad,passed:module.stats.all-module.stats.bad,total:module.stats.all,runtime:now()-module.stats.started});}
config.current=undefined;},preserveTestEnvironment:function preserveTestEnvironment(){if(this.preserveEnvironment){this.module.testEnvironment=this.testEnvironment;this.testEnvironment=extend({},this.module.testEnvironment);}},queue:function queue(){var priority,previousFailCount,test=this;if(!this.valid()){return;}
function run(){synchronize([function(){test.before();},test.hooks("before"),function(){test.preserveTestEnvironment();},test.hooks("beforeEach"),function(){test.run();},test.hooks("afterEach").reverse(),test.hooks("after").reverse(),function(){test.after();},function(){test.finish();}]);}
previousFailCount=config.storage&&+config.storage.getItem("qunit-test-"+this.module.name+"-"+this.testName);priority=config.reorder&&previousFailCount;this.previousFailure=!!previousFailCount;return synchronize(run,priority,config.seed);},pushResult:function pushResult(resultInfo){var source,details={module:this.module.name,name:this.testName,result:resultInfo.result,message:resultInfo.message,actual:resultInfo.actual,expected:resultInfo.expected,testId:this.testId,negative:resultInfo.negative||false,runtime:now()-this.started,todo:!!this.todo};if(!resultInfo.result){source=resultInfo.source||sourceFromStacktrace();if(source){details.source=source;}}
this.logAssertion(details);this.assertions.push({result:!!resultInfo.result,message:resultInfo.message});},pushFailure:function pushFailure(message,source,actual){if(!(this instanceof Test)){throw new Error("pushFailure() assertion outside test context, was "+sourceFromStacktrace(2));}
this.assert.pushResult({result:false,message:message||"error",actual:actual||null,expected:null,source:source});},logAssertion:function logAssertion(details){runLoggingCallbacks("log",details);var assertion={passed:details.result,actual:details.actual,expected:details.expected,message:details.message,stack:details.source,todo:details.todo};this.testReport.pushAssertion(assertion);emit("assertion",assertion);},resolvePromise:function resolvePromise(promise,phase){var then,resume,message,test=this;if(promise!=null){then=promise.then;if(objectType(then)==="function"){resume=internalStop(test);then.call(promise,function(){resume();},function(error){message="Promise rejected "+(!phase?"during":phase.replace(/Each$/,""))+" \""+test.testName+"\": "+(error&&error.message||error);test.pushFailure(message,extractStacktrace(error,0));saveGlobal();resume();});}}},valid:function valid(){var filter=config.filter,regexFilter=/^(!?)\/([\w\W]*)\/(i?$)/.exec(filter),module=config.module&&config.module.toLowerCase(),fullName=this.module.name+": "+this.testName;function moduleChainNameMatch(testModule){var testModuleName=testModule.name?testModule.name.toLowerCase():null;if(testModuleName===module){return true;}else if(testModule.parentModule){return moduleChainNameMatch(testModule.parentModule);}else{return false;}}
function moduleChainIdMatch(testModule){return inArray(testModule.moduleId,config.moduleId)||testModule.parentModule&&moduleChainIdMatch(testModule.parentModule);}
if(this.callback&&this.callback.validTest){return true;}
if(config.moduleId&&config.moduleId.length>0&&!moduleChainIdMatch(this.module)){return false;}
if(config.testId&&config.testId.length>0&&!inArray(this.testId,config.testId)){return false;}
if(module&&!moduleChainNameMatch(this.module)){return false;}
if(!filter){return true;}
return regexFilter?this.regexFilter(!!regexFilter[1],regexFilter[2],regexFilter[3],fullName):this.stringFilter(filter,fullName);},regexFilter:function regexFilter(exclude,pattern,flags,fullName){var regex=new RegExp(pattern,flags);var match=regex.test(fullName);return match!==exclude;},stringFilter:function stringFilter(filter,fullName){filter=filter.toLowerCase();fullName=fullName.toLowerCase();var include=filter.charAt(0)!=="!";if(!include){filter=filter.slice(1);}
if(fullName.indexOf(filter)!==-1){return include;}
return!include;}};function pushFailure(){if(!config.current){throw new Error("pushFailure() assertion outside test context, in "+sourceFromStacktrace(2));}
var currentTest=config.current;return currentTest.pushFailure.apply(currentTest,arguments);}
function generateHash(module,testName){var hex,i=0,hash=0,str=module+"\x1C"+testName,len=str.length;for(;i<len;i++){hash=(hash<<5)-hash+str.charCodeAt(i);hash|=0;}
hex=(0x100000000+hash).toString(16);if(hex.length<8){hex="0000000"+hex;}
return hex.slice(-8);}
function synchronize(callback,priority,seed){var last=!priority,index;if(objectType(callback)==="array"){while(callback.length){synchronize(callback.shift());}
return;}
if(priority){config.queue.splice(priorityCount++,0,callback);}else if(seed){if(!unitSampler){unitSampler=unitSamplerGenerator(seed);}
index=Math.floor(unitSampler()*(config.queue.length-priorityCount+1));config.queue.splice(priorityCount+index,0,callback);}else{config.queue.push(callback);}
if(internalState.autorun&&!config.blocking){process(last);}}
function unitSamplerGenerator(seed){var sample=parseInt(generateHash(seed),16)||-1;return function(){sample^=sample<<13;sample^=sample>>>17;sample^=sample<<5;if(sample<0){sample+=0x100000000;}
return sample/0x100000000;};}
function saveGlobal(){config.pollution=[];if(config.noglobals){for(var key in global$1){if(hasOwn.call(global$1,key)){if(/^qunit-test-output/.test(key)){continue;}
config.pollution.push(key);}}}}
function checkPollution(){var newGlobals,deletedGlobals,old=config.pollution;saveGlobal();newGlobals=diff(config.pollution,old);if(newGlobals.length>0){pushFailure("Introduced global variable(s): "+newGlobals.join(", "));}
deletedGlobals=diff(old,config.pollution);if(deletedGlobals.length>0){pushFailure("Deleted global variable(s): "+deletedGlobals.join(", "));}}
function test(testName,callback){if(focused){return;}
var newTest=new Test({testName:testName,callback:callback});newTest.queue();}
function todo(testName,callback){if(focused){return;}
var newTest=new Test({testName:testName,callback:callback,todo:true});newTest.queue();}
function skip(testName){if(focused){return;}
var test=new Test({testName:testName,skip:true});test.queue();}
function only(testName,callback){if(focused){return;}
config.queue.length=0;focused=true;var newTest=new Test({testName:testName,callback:callback});newTest.queue();}
function internalStop(test){var released=false;test.semaphore+=1;config.blocking=true;if(config.testTimeout&&defined.setTimeout){clearTimeout(config.timeout);config.timeout=setTimeout(function(){pushFailure("Test timed out",sourceFromStacktrace(2));internalRecover(test);},config.testTimeout);}
return function resume(){if(released){return;}
released=true;test.semaphore-=1;internalStart(test);};}
function internalRecover(test){test.semaphore=0;internalStart(test);}
function internalStart(test){if(isNaN(test.semaphore)){test.semaphore=0;pushFailure("Invalid value on test.semaphore",sourceFromStacktrace(2));return;}
if(test.semaphore>0){return;}
if(test.semaphore<0){test.semaphore=0;pushFailure("Tried to restart test while already started (test's semaphore was 0 already)",sourceFromStacktrace(2));return;}
if(defined.setTimeout){if(config.timeout){clearTimeout(config.timeout);}
config.timeout=setTimeout(function(){if(test.semaphore>0){return;}
if(config.timeout){clearTimeout(config.timeout);}
begin();},13);}else{begin();}}
function numberOfTests(module){var count=module.tests.length,modules=[].concat(toConsumableArray(module.childModules));while(modules.length){var nextModule=modules.shift();count+=nextModule.tests.length;modules.push.apply(modules,toConsumableArray(nextModule.childModules));}
return count;}
function notifyTestsRan(module){module.testsRun++;while(module=module.parentModule){module.testsRun++;}}
function consoleProxy(method){return function(){if(console){console[method].apply(console,arguments);}};}
var Logger={warn:consoleProxy("warn")};var Assert=function(){function Assert(testContext){classCallCheck(this,Assert);this.test=testContext;}
createClass(Assert,[{key:"step",value:function step(message){var result=!!message;this.test.steps.push(message);return this.pushResult({result:result,message:message||"You must provide a message to assert.step"});}},{key:"verifySteps",value:function verifySteps(steps,message){this.deepEqual(this.test.steps,steps,message);}},{key:"expect",value:function expect(asserts){if(arguments.length===1){this.test.expected=asserts;}else{return this.test.expected;}}},{key:"async",value:function async(count){var test$$1=this.test,popped=false,acceptCallCount=count;if(typeof acceptCallCount==="undefined"){acceptCallCount=1;}
test$$1.usedAsync=true;var resume=internalStop(test$$1);return function done(){if(popped){test$$1.pushFailure("Too many calls to the `assert.async` callback",sourceFromStacktrace(2));return;}
acceptCallCount-=1;if(acceptCallCount>0){return;}
popped=true;resume();};}},{key:"push",value:function push(result,actual,expected,message,negative){Logger.warn("assert.push is deprecated and will be removed in QUnit 3.0."+" Please use assert.pushResult instead (http://api.qunitjs.com/pushResult/).");var currentAssert=this instanceof Assert?this:config.current.assert;return currentAssert.pushResult({result:result,actual:actual,expected:expected,message:message,negative:negative});}},{key:"pushResult",value:function pushResult(resultInfo){var assert=this,currentTest=assert instanceof Assert&&assert.test||config.current;if(!currentTest){throw new Error("assertion outside test context, in "+sourceFromStacktrace(2));}
if(currentTest.usedAsync===true&&currentTest.semaphore===0){currentTest.pushFailure("Assertion after the final `assert.async` was resolved",sourceFromStacktrace(2));}
if(!(assert instanceof Assert)){assert=currentTest.assert;}
return assert.test.pushResult(resultInfo);}},{key:"ok",value:function ok(result,message){if(!message){message=result?"okay":"failed, expected argument to be truthy, was: "+dump.parse(result);}
this.pushResult({result:!!result,actual:result,expected:true,message:message});}},{key:"notOk",value:function notOk(result,message){if(!message){message=!result?"okay":"failed, expected argument to be falsy, was: "+dump.parse(result);}
this.pushResult({result:!result,actual:result,expected:false,message:message});}},{key:"equal",value:function equal(actual,expected,message){var result=expected==actual;this.pushResult({result:result,actual:actual,expected:expected,message:message});}},{key:"notEqual",value:function notEqual(actual,expected,message){var result=expected!=actual;this.pushResult({result:result,actual:actual,expected:expected,message:message,negative:true});}},{key:"propEqual",value:function propEqual(actual,expected,message){actual=objectValues(actual);expected=objectValues(expected);this.pushResult({result:equiv(actual,expected),actual:actual,expected:expected,message:message});}},{key:"notPropEqual",value:function notPropEqual(actual,expected,message){actual=objectValues(actual);expected=objectValues(expected);this.pushResult({result:!equiv(actual,expected),actual:actual,expected:expected,message:message,negative:true});}},{key:"deepEqual",value:function deepEqual(actual,expected,message){this.pushResult({result:equiv(actual,expected),actual:actual,expected:expected,message:message});}},{key:"notDeepEqual",value:function notDeepEqual(actual,expected,message){this.pushResult({result:!equiv(actual,expected),actual:actual,expected:expected,message:message,negative:true});}},{key:"strictEqual",value:function strictEqual(actual,expected,message){this.pushResult({result:expected===actual,actual:actual,expected:expected,message:message});}},{key:"notStrictEqual",value:function notStrictEqual(actual,expected,message){this.pushResult({result:expected!==actual,actual:actual,expected:expected,message:message,negative:true});}},{key:"throws",value:function throws(block,expected,message){var actual=void 0,result=false,currentTest=this instanceof Assert&&this.test||config.current;if(objectType(expected)==="string"){if(message==null){message=expected;expected=null;}else{throw new Error("throws/raises does not accept a string value for the expected argument.\n"+"Use a non-string object value (e.g. regExp) instead if it's necessary.");}}
currentTest.ignoreGlobalErrors=true;try{block.call(currentTest.testEnvironment);}catch(e){actual=e;}
currentTest.ignoreGlobalErrors=false;if(actual){var expectedType=objectType(expected);if(!expected){result=true;expected=null;}else if(expectedType==="regexp"){result=expected.test(errorString(actual));}else if(expectedType==="function"&&actual instanceof expected){result=true;}else if(expectedType==="object"){result=actual instanceof expected.constructor&&actual.name===expected.name&&actual.message===expected.message;}else if(expectedType==="function"&&expected.call({},actual)===true){expected=null;result=true;}}
currentTest.assert.pushResult({result:result,actual:actual,expected:expected,message:message});}}]);return Assert;}();Assert.prototype.raises=Assert.prototype["throws"];function errorString(error){var resultErrorString=error.toString();if(resultErrorString.substring(0,7)==="[object"){var name=error.name?error.name.toString():"Error";var message=error.message?error.message.toString():"";if(name&&message){return name+": "+message;}else if(name){return name;}else if(message){return message;}else{return"Error";}}else{return resultErrorString;}}
function exportQUnit(QUnit){if(defined.document){if(window.QUnit&&window.QUnit.version){throw new Error("QUnit has already been defined.");}
window.QUnit=QUnit;}
if(typeof module!=="undefined"&&module&&module.exports){module.exports=QUnit;module.exports.QUnit=QUnit;}
if(typeof exports!=="undefined"&&exports){exports.QUnit=QUnit;}
if(typeof define==="function"&&define.amd){define(function(){return QUnit;});QUnit.config.autostart=false;}}
var SuiteReport=function(){function SuiteReport(name,parentSuite){classCallCheck(this,SuiteReport);this.name=name;this.fullName=parentSuite?parentSuite.fullName.concat(name):[];this.tests=[];this.childSuites=[];if(parentSuite){parentSuite.pushChildSuite(this);}}
createClass(SuiteReport,[{key:"start",value:function start(recordTime){if(recordTime){this._startTime=Date.now();}
return{name:this.name,fullName:this.fullName.slice(),tests:this.tests.map(function(test){return test.start();}),childSuites:this.childSuites.map(function(suite){return suite.start();}),testCounts:{total:this.getTestCounts().total}};}},{key:"end",value:function end(recordTime){if(recordTime){this._endTime=Date.now();}
return{name:this.name,fullName:this.fullName.slice(),tests:this.tests.map(function(test){return test.end();}),childSuites:this.childSuites.map(function(suite){return suite.end();}),testCounts:this.getTestCounts(),runtime:this.getRuntime(),status:this.getStatus()};}},{key:"pushChildSuite",value:function pushChildSuite(suite){this.childSuites.push(suite);}},{key:"pushTest",value:function pushTest(test){this.tests.push(test);}},{key:"getRuntime",value:function getRuntime(){return this._endTime-this._startTime;}},{key:"getTestCounts",value:function getTestCounts(){var counts=arguments.length>0&&arguments[0]!==undefined?arguments[0]:{passed:0,failed:0,skipped:0,todo:0,total:0};counts=this.tests.reduce(function(counts,test){counts[test.getStatus()]++;counts.total++;return counts;},counts);return this.childSuites.reduce(function(counts,suite){return suite.getTestCounts(counts);},counts);}},{key:"getStatus",value:function getStatus(){var _getTestCounts=this.getTestCounts(),total=_getTestCounts.total,failed=_getTestCounts.failed,skipped=_getTestCounts.skipped,todo=_getTestCounts.todo;if(failed){return"failed";}else{if(skipped===total){return"skipped";}else if(todo===total){return"todo";}else{return"passed";}}}}]);return SuiteReport;}();function onError(error){for(var _len=arguments.length,args=Array(_len>1?_len-1:0),_key=1;_key<_len;_key++){args[_key-1]=arguments[_key];}
if(config.current){if(config.current.ignoreGlobalErrors){return true;}
pushFailure.apply(undefined,[error.message,error.fileName+":"+error.lineNumber].concat(args));}else{test("global failure",extend(function(){pushFailure.apply(undefined,[error.message,error.fileName+":"+error.lineNumber].concat(args));},{validTest:true}));}
return false;}
var QUnit={};var globalSuite=new SuiteReport();config.currentModule.suiteReport=globalSuite;var globalStartCalled=false;var runStarted=false;var internalState={autorun:false};QUnit.isLocal=!(defined.document&&window.location.protocol!=="file:");QUnit.version="2.2.1";extend(QUnit,{on:on,module:function module(name,testEnvironment,executeNow){var module,moduleFns;var currentModule=config.currentModule;if(arguments.length===2){if(objectType(testEnvironment)==="function"){executeNow=testEnvironment;testEnvironment=undefined;}}
module=createModule();moduleFns={before:setHook(module,"before"),beforeEach:setHook(module,"beforeEach"),afterEach:setHook(module,"afterEach"),after:setHook(module,"after")};if(objectType(executeNow)==="function"){config.moduleStack.push(module);setCurrentModule(module);executeNow.call(module.testEnvironment,moduleFns);config.moduleStack.pop();module=module.parentModule||currentModule;}
setCurrentModule(module);function createModule(){var parentModule=config.moduleStack.length?config.moduleStack.slice(-1)[0]:null;var moduleName=parentModule!==null?[parentModule.name,name].join(" > "):name;var parentSuite=parentModule?parentModule.suiteReport:globalSuite;var module={name:moduleName,parentModule:parentModule,tests:[],moduleId:generateHash(moduleName),testsRun:0,childModules:[],suiteReport:new SuiteReport(name,parentSuite)};var env={};if(parentModule){parentModule.childModules.push(module);extend(env,parentModule.testEnvironment);delete env.beforeEach;delete env.afterEach;}
extend(env,testEnvironment);module.testEnvironment=env;config.modules.push(module);return module;}
function setCurrentModule(module){config.currentModule=module;}},test:test,todo:todo,skip:skip,only:only,start:function start(count){var globalStartAlreadyCalled=globalStartCalled;if(!config.current){globalStartCalled=true;if(runStarted){throw new Error("Called start() while test already started running");}else if(globalStartAlreadyCalled||count>1){throw new Error("Called start() outside of a test context too many times");}else if(config.autostart){throw new Error("Called start() outside of a test context when "+"QUnit.config.autostart was true");}else if(!config.pageLoaded){config.autostart=true;if(!defined.document){QUnit.load();}
return;}}else{throw new Error("QUnit.start cannot be called inside a test context.");}
scheduleBegin();},config:config,is:is,objectType:objectType,extend:extend,load:function load(){config.pageLoaded=true;extend(config,{stats:{all:0,bad:0},started:0,updateRate:1000,autostart:true,filter:""},true);if(!runStarted){config.blocking=false;if(config.autostart){scheduleBegin();}}},stack:function stack(offset){offset=(offset||0)+2;return sourceFromStacktrace(offset);},onError:onError});QUnit.pushFailure=pushFailure;QUnit.assert=Assert.prototype;QUnit.equiv=equiv;QUnit.dump=dump;registerLoggingCallbacks(QUnit);function scheduleBegin(){runStarted=true;if(defined.setTimeout){setTimeout(function(){begin();},13);}else{begin();}}
function begin(){var i,l,modulesLog=[];if(!config.started){config.started=now();if(config.modules[0].name===""&&config.modules[0].tests.length===0){config.modules.shift();}
for(i=0,l=config.modules.length;i<l;i++){modulesLog.push({name:config.modules[i].name,tests:config.modules[i].tests});}
emit("runStart",globalSuite.start(true));runLoggingCallbacks("begin",{totalTests:Test.count,modules:modulesLog});}
config.blocking=false;process(true);}
function process(last){function next(){process(last);}
var start=now();config.depth=(config.depth||0)+1;while(config.queue.length&&!config.blocking){if(!defined.setTimeout||config.updateRate<=0||now()-start<config.updateRate){if(config.current){config.current.usedAsync=false;}
config.queue.shift()();}else{setTimeout(next,13);break;}}
config.depth--;if(last&&!config.blocking&&!config.queue.length&&config.depth===0){done();}}
function done(){var runtime,passed,i,key,storage=config.storage;internalState.autorun=true;runtime=now()-config.started;passed=config.stats.all-config.stats.bad;emit("runEnd",globalSuite.end(true));runLoggingCallbacks("done",{failed:config.stats.bad,passed:passed,total:config.stats.all,runtime:runtime});if(storage&&config.stats.bad===0){for(i=storage.length-1;i>=0;i--){key=storage.key(i);if(key.indexOf("qunit-test-")===0){storage.removeItem(key);}}}}
function setHook(module,hookName){if(module.testEnvironment===undefined){module.testEnvironment={};}
return function(callback){module.testEnvironment[hookName]=callback;};}
exportQUnit(QUnit);(function(){if(typeof window==="undefined"||typeof document==="undefined"){return;}
var config=QUnit.config,hasOwn=Object.prototype.hasOwnProperty;function storeFixture(){if(hasOwn.call(config,"fixture")){return;}
var fixture=document.getElementById("qunit-fixture");if(fixture){config.fixture=fixture.innerHTML;}}
QUnit.begin(storeFixture);function resetFixture(){if(config.fixture==null){return;}
var fixture=document.getElementById("qunit-fixture");if(fixture){fixture.innerHTML=config.fixture;}}
QUnit.testStart(resetFixture);})();(function(){var location=typeof window!=="undefined"&&window.location;if(!location){return;}
var urlParams=getUrlParams();QUnit.urlParams=urlParams;QUnit.config.moduleId=[].concat(urlParams.moduleId||[]);QUnit.config.testId=[].concat(urlParams.testId||[]);QUnit.config.module=urlParams.module;QUnit.config.filter=urlParams.filter;if(urlParams.seed===true){QUnit.config.seed=Math.random().toString(36).slice(2);}else if(urlParams.seed){QUnit.config.seed=urlParams.seed;}
QUnit.config.urlConfig.push({id:"hidepassed",label:"Hide passed tests",tooltip:"Only show tests and assertions that fail. Stored as query-strings."},{id:"noglobals",label:"Check for Globals",tooltip:"Enabling this will test if any test introduces new properties on the "+"global object (`window` in Browsers). Stored as query-strings."},{id:"notrycatch",label:"No try-catch",tooltip:"Enabling this will run tests outside of a try-catch block. Makes debugging "+"exceptions in IE reasonable. Stored as query-strings."});QUnit.begin(function(){var i,option,urlConfig=QUnit.config.urlConfig;for(i=0;i<urlConfig.length;i++){option=QUnit.config.urlConfig[i];if(typeof option!=="string"){option=option.id;}
if(QUnit.config[option]===undefined){QUnit.config[option]=urlParams[option];}}});function getUrlParams(){var i,param,name,value;var urlParams=Object.create(null);var params=location.search.slice(1).split("&");var length=params.length;for(i=0;i<length;i++){if(params[i]){param=params[i].split("=");name=decodeQueryParam(param[0]);value=param.length===1||decodeQueryParam(param.slice(1).join("="));if(name in urlParams){urlParams[name]=[].concat(urlParams[name],value);}else{urlParams[name]=value;}}}
return urlParams;}
function decodeQueryParam(param){return decodeURIComponent(param.replace(/\+/g,"%20"));}})();var stats={passedTests:0,failedTests:0,skippedTests:0,todoTests:0};function escapeText(s){if(!s){return"";}
s=s+"";return s.replace(/['"<>&]/g,function(s){switch(s){case"'":return"&#039;";case"\"":return"&quot;";case"<":return"&lt;";case">":return"&gt;";case"&":return"&amp;";}});}
(function(){if(typeof window==="undefined"||!window.document){return;}
var config=QUnit.config,document$$1=window.document,collapseNext=false,hasOwn=Object.prototype.hasOwnProperty,unfilteredUrl=setUrl({filter:undefined,module:undefined,moduleId:undefined,testId:undefined}),modulesList=[];function addEvent(elem,type,fn){elem.addEventListener(type,fn,false);}
function removeEvent(elem,type,fn){elem.removeEventListener(type,fn,false);}
function addEvents(elems,type,fn){var i=elems.length;while(i--){addEvent(elems[i],type,fn);}}
function hasClass(elem,name){return(" "+elem.className+" ").indexOf(" "+name+" ")>=0;}
function addClass(elem,name){if(!hasClass(elem,name)){elem.className+=(elem.className?" ":"")+name;}}
function toggleClass(elem,name,force){if(force||typeof force==="undefined"&&!hasClass(elem,name)){addClass(elem,name);}else{removeClass(elem,name);}}
function removeClass(elem,name){var set=" "+elem.className+" ";while(set.indexOf(" "+name+" ")>=0){set=set.replace(" "+name+" "," ");}
elem.className=typeof set.trim==="function"?set.trim():set.replace(/^\s+|\s+$/g,"");}
function id(name){return document$$1.getElementById&&document$$1.getElementById(name);}
function abortTests(){var abortButton=id("qunit-abort-tests-button");if(abortButton){abortButton.disabled=true;abortButton.innerHTML="Aborting...";}
QUnit.config.queue.length=0;return false;}
function interceptNavigation(ev){applyUrlParams();if(ev&&ev.preventDefault){ev.preventDefault();}
return false;}
function getUrlConfigHtml(){var i,j,val,escaped,escapedTooltip,selection=false,urlConfig=config.urlConfig,urlConfigHtml="";for(i=0;i<urlConfig.length;i++){val=config.urlConfig[i];if(typeof val==="string"){val={id:val,label:val};}
escaped=escapeText(val.id);escapedTooltip=escapeText(val.tooltip);if(!val.value||typeof val.value==="string"){urlConfigHtml+="<label for='qunit-urlconfig-"+escaped+"' title='"+escapedTooltip+"'><input id='qunit-urlconfig-"+escaped+"' name='"+escaped+"' type='checkbox'"+(val.value?" value='"+escapeText(val.value)+"'":"")+(config[val.id]?" checked='checked'":"")+" title='"+escapedTooltip+"' />"+escapeText(val.label)+"</label>";}else{urlConfigHtml+="<label for='qunit-urlconfig-"+escaped+"' title='"+escapedTooltip+"'>"+val.label+": </label><select id='qunit-urlconfig-"+escaped+"' name='"+escaped+"' title='"+escapedTooltip+"'><option></option>";if(QUnit.is("array",val.value)){for(j=0;j<val.value.length;j++){escaped=escapeText(val.value[j]);urlConfigHtml+="<option value='"+escaped+"'"+(config[val.id]===val.value[j]?(selection=true)&&" selected='selected'":"")+">"+escaped+"</option>";}}else{for(j in val.value){if(hasOwn.call(val.value,j)){urlConfigHtml+="<option value='"+escapeText(j)+"'"+(config[val.id]===j?(selection=true)&&" selected='selected'":"")+">"+escapeText(val.value[j])+"</option>";}}}
if(config[val.id]&&!selection){escaped=escapeText(config[val.id]);urlConfigHtml+="<option value='"+escaped+"' selected='selected' disabled='disabled'>"+escaped+"</option>";}
urlConfigHtml+="</select>";}}
return urlConfigHtml;}
function toolbarChanged(){var updatedUrl,value,tests,field=this,params={};if("selectedIndex"in field){value=field.options[field.selectedIndex].value||undefined;}else{value=field.checked?field.defaultValue||true:undefined;}
params[field.name]=value;updatedUrl=setUrl(params);if("hidepassed"===field.name&&"replaceState"in window.history){QUnit.urlParams[field.name]=value;config[field.name]=value||false;tests=id("qunit-tests");if(tests){toggleClass(tests,"hidepass",value||false);}
window.history.replaceState(null,"",updatedUrl);}else{window.location=updatedUrl;}}
function setUrl(params){var key,arrValue,i,querystring="?",location=window.location;params=QUnit.extend(QUnit.extend({},QUnit.urlParams),params);for(key in params){if(hasOwn.call(params,key)&&params[key]!==undefined){arrValue=[].concat(params[key]);for(i=0;i<arrValue.length;i++){querystring+=encodeURIComponent(key);if(arrValue[i]!==true){querystring+="="+encodeURIComponent(arrValue[i]);}
querystring+="&";}}}
return location.protocol+"//"+location.host+location.pathname+querystring.slice(0,-1);}
function applyUrlParams(){var i,selectedModules=[],modulesList=id("qunit-modulefilter-dropdown-list").getElementsByTagName("input"),filter=id("qunit-filter-input").value;for(i=0;i<modulesList.length;i++){if(modulesList[i].checked){selectedModules.push(modulesList[i].value);}}
window.location=setUrl({filter:filter===""?undefined:filter,moduleId:selectedModules.length===0?undefined:selectedModules,module:undefined,testId:undefined});}
function toolbarUrlConfigContainer(){var urlConfigContainer=document$$1.createElement("span");urlConfigContainer.innerHTML=getUrlConfigHtml();addClass(urlConfigContainer,"qunit-url-config");addEvents(urlConfigContainer.getElementsByTagName("input"),"change",toolbarChanged);addEvents(urlConfigContainer.getElementsByTagName("select"),"change",toolbarChanged);return urlConfigContainer;}
function abortTestsButton(){var button=document$$1.createElement("button");button.id="qunit-abort-tests-button";button.innerHTML="Abort";addEvent(button,"click",abortTests);return button;}
function toolbarLooseFilter(){var filter=document$$1.createElement("form"),label=document$$1.createElement("label"),input=document$$1.createElement("input"),button=document$$1.createElement("button");addClass(filter,"qunit-filter");label.innerHTML="Filter: ";input.type="text";input.value=config.filter||"";input.name="filter";input.id="qunit-filter-input";button.innerHTML="Go";label.appendChild(input);filter.appendChild(label);filter.appendChild(document$$1.createTextNode(" "));filter.appendChild(button);addEvent(filter,"submit",interceptNavigation);return filter;}
function moduleListHtml(){var i,checked,html="";for(i=0;i<config.modules.length;i++){if(config.modules[i].name!==""){checked=config.moduleId.indexOf(config.modules[i].moduleId)>-1;html+="<li><label class='clickable"+(checked?" checked":"")+"'><input type='checkbox' "+"value='"+config.modules[i].moduleId+"'"+(checked?" checked='checked'":"")+" />"+escapeText(config.modules[i].name)+"</label></li>";}}
return html;}
function toolbarModuleFilter(){var allCheckbox,commit,reset,moduleFilter=document$$1.createElement("form"),label=document$$1.createElement("label"),moduleSearch=document$$1.createElement("input"),dropDown=document$$1.createElement("div"),actions=document$$1.createElement("span"),dropDownList=document$$1.createElement("ul"),dirty=false;moduleSearch.id="qunit-modulefilter-search";addEvent(moduleSearch,"input",searchInput);addEvent(moduleSearch,"input",searchFocus);addEvent(moduleSearch,"focus",searchFocus);addEvent(moduleSearch,"click",searchFocus);label.id="qunit-modulefilter-search-container";label.innerHTML="Module: ";label.appendChild(moduleSearch);actions.id="qunit-modulefilter-actions";actions.innerHTML="<button style='display:none'>Apply</button>"+"<button type='reset' style='display:none'>Reset</button>"+"<label class='clickable"+(config.moduleId.length?"":" checked")+"'><input type='checkbox'"+(config.moduleId.length?"":" checked='checked'")+">All modules</label>";allCheckbox=actions.lastChild.firstChild;commit=actions.firstChild;reset=commit.nextSibling;addEvent(commit,"click",applyUrlParams);dropDownList.id="qunit-modulefilter-dropdown-list";dropDownList.innerHTML=moduleListHtml();dropDown.id="qunit-modulefilter-dropdown";dropDown.style.display="none";dropDown.appendChild(actions);dropDown.appendChild(dropDownList);addEvent(dropDown,"change",selectionChange);selectionChange();moduleFilter.id="qunit-modulefilter";moduleFilter.appendChild(label);moduleFilter.appendChild(dropDown);addEvent(moduleFilter,"submit",interceptNavigation);addEvent(moduleFilter,"reset",function(){window.setTimeout(selectionChange);});function searchFocus(){if(dropDown.style.display!=="none"){return;}
dropDown.style.display="block";addEvent(document$$1,"click",hideHandler);addEvent(document$$1,"keydown",hideHandler);function hideHandler(e){var inContainer=moduleFilter.contains(e.target);if(e.keyCode===27||!inContainer){if(e.keyCode===27&&inContainer){moduleSearch.focus();}
dropDown.style.display="none";removeEvent(document$$1,"click",hideHandler);removeEvent(document$$1,"keydown",hideHandler);moduleSearch.value="";searchInput();}}}
function searchInput(){var i,item,searchText=moduleSearch.value.toLowerCase(),listItems=dropDownList.children;for(i=0;i<listItems.length;i++){item=listItems[i];if(!searchText||item.textContent.toLowerCase().indexOf(searchText)>-1){item.style.display="";}else{item.style.display="none";}}}
function selectionChange(evt){var i,item,checkbox=evt&&evt.target||allCheckbox,modulesList=dropDownList.getElementsByTagName("input"),selectedNames=[];toggleClass(checkbox.parentNode,"checked",checkbox.checked);dirty=false;if(checkbox.checked&&checkbox!==allCheckbox){allCheckbox.checked=false;removeClass(allCheckbox.parentNode,"checked");}
for(i=0;i<modulesList.length;i++){item=modulesList[i];if(!evt){toggleClass(item.parentNode,"checked",item.checked);}else if(checkbox===allCheckbox&&checkbox.checked){item.checked=false;removeClass(item.parentNode,"checked");}
dirty=dirty||item.checked!==item.defaultChecked;if(item.checked){selectedNames.push(item.parentNode.textContent);}}
commit.style.display=reset.style.display=dirty?"":"none";moduleSearch.placeholder=selectedNames.join(", ")||allCheckbox.parentNode.textContent;moduleSearch.title="Type to filter list. Current selection:\n"+(selectedNames.join("\n")||allCheckbox.parentNode.textContent);}
return moduleFilter;}
function appendToolbar(){var toolbar=id("qunit-testrunner-toolbar");if(toolbar){toolbar.appendChild(toolbarUrlConfigContainer());toolbar.appendChild(toolbarModuleFilter());toolbar.appendChild(toolbarLooseFilter());toolbar.appendChild(document$$1.createElement("div")).className="clearfix";}}
function appendHeader(){var header=id("qunit-header");if(header){header.innerHTML="<a href='"+escapeText(unfilteredUrl)+"'>"+header.innerHTML+"</a> ";}}
function appendBanner(){var banner=id("qunit-banner");if(banner){banner.className="";}}
function appendTestResults(){var tests=id("qunit-tests"),result=id("qunit-testresult"),controls;if(result){result.parentNode.removeChild(result);}
if(tests){tests.innerHTML="";result=document$$1.createElement("p");result.id="qunit-testresult";result.className="result";tests.parentNode.insertBefore(result,tests);result.innerHTML="<div id=\"qunit-testresult-display\">Running...<br />&#160;</div>"+"<div id=\"qunit-testresult-controls\"></div>"+"<div class=\"clearfix\"></div>";controls=id("qunit-testresult-controls");}
if(controls){controls.appendChild(abortTestsButton());}}
function appendFilteredTest(){var testId=QUnit.config.testId;if(!testId||testId.length<=0){return"";}
return"<div id='qunit-filteredTest'>Rerunning selected tests: "+escapeText(testId.join(", "))+" <a id='qunit-clearFilter' href='"+escapeText(unfilteredUrl)+"'>Run all tests</a></div>";}
function appendUserAgent(){var userAgent=id("qunit-userAgent");if(userAgent){userAgent.innerHTML="";userAgent.appendChild(document$$1.createTextNode("QUnit "+QUnit.version+"; "+navigator.userAgent));}}
function appendInterface(){var qunit=id("qunit");if(qunit){qunit.innerHTML="<h1 id='qunit-header'>"+escapeText(document$$1.title)+"</h1>"+"<h2 id='qunit-banner'></h2>"+"<div id='qunit-testrunner-toolbar'></div>"+appendFilteredTest()+"<h2 id='qunit-userAgent'></h2>"+"<ol id='qunit-tests'></ol>";}
appendHeader();appendBanner();appendTestResults();appendUserAgent();appendToolbar();}
function appendTestsList(modules){var i,l,x,z,test,moduleObj;for(i=0,l=modules.length;i<l;i++){moduleObj=modules[i];for(x=0,z=moduleObj.tests.length;x<z;x++){test=moduleObj.tests[x];appendTest(test.name,test.testId,moduleObj.name);}}}
function appendTest(name,testId,moduleName){var title,rerunTrigger,testBlock,assertList,tests=id("qunit-tests");if(!tests){return;}
title=document$$1.createElement("strong");title.innerHTML=getNameHtml(name,moduleName);rerunTrigger=document$$1.createElement("a");rerunTrigger.innerHTML="Rerun";rerunTrigger.href=setUrl({testId:testId});testBlock=document$$1.createElement("li");testBlock.appendChild(title);testBlock.appendChild(rerunTrigger);testBlock.id="qunit-test-output-"+testId;assertList=document$$1.createElement("ol");assertList.className="qunit-assert-list";testBlock.appendChild(assertList);tests.appendChild(testBlock);}
QUnit.begin(function(details){var i,moduleObj,tests;for(i=0;i<details.modules.length;i++){moduleObj=details.modules[i];if(moduleObj.name){modulesList.push(moduleObj.name);}}
modulesList.sort(function(a,b){return a.localeCompare(b);});appendInterface();appendTestsList(details.modules);tests=id("qunit-tests");if(tests&&config.hidepassed){addClass(tests,"hidepass");}});QUnit.done(function(details){var banner=id("qunit-banner"),tests=id("qunit-tests"),abortButton=id("qunit-abort-tests-button"),totalTests=stats.passedTests+stats.skippedTests+stats.todoTests+stats.failedTests,html=[totalTests," tests completed in ",details.runtime," milliseconds, with ",stats.failedTests," failed, ",stats.skippedTests," skipped, and ",stats.todoTests," todo.<br />","<span class='passed'>",details.passed,"</span> assertions of <span class='total'>",details.total,"</span> passed, <span class='failed'>",details.failed,"</span> failed."].join(""),test,assertLi,assertList;if(abortButton&&abortButton.disabled){html="Tests aborted after "+details.runtime+" milliseconds.";for(var i=0;i<tests.children.length;i++){test=tests.children[i];if(test.className===""||test.className==="running"){test.className="aborted";assertList=test.getElementsByTagName("ol")[0];assertLi=document$$1.createElement("li");assertLi.className="fail";assertLi.innerHTML="Test aborted.";assertList.appendChild(assertLi);}}}
if(banner&&(!abortButton||abortButton.disabled===false)){banner.className=stats.failedTests?"qunit-fail":"qunit-pass";}
if(abortButton){abortButton.parentNode.removeChild(abortButton);}
if(tests){id("qunit-testresult-display").innerHTML=html;}
if(config.altertitle&&document$$1.title){document$$1.title=[stats.failedTests?"\u2716":"\u2714",document$$1.title.replace(/^[\u2714\u2716] /i,"")].join(" ");}
if(config.scrolltop&&window.scrollTo){window.scrollTo(0,0);}});function getNameHtml(name,module){var nameHtml="";if(module){nameHtml="<span class='module-name'>"+escapeText(module)+"</span>: ";}
nameHtml+="<span class='test-name'>"+escapeText(name)+"</span>";return nameHtml;}
QUnit.testStart(function(details){var running,testBlock,bad;testBlock=id("qunit-test-output-"+details.testId);if(testBlock){testBlock.className="running";}else{appendTest(details.name,details.testId,details.module);}
running=id("qunit-testresult-display");if(running){bad=QUnit.config.reorder&&details.previousFailure;running.innerHTML=(bad?"Rerunning previously failed test: <br />":"Running: <br />")+getNameHtml(details.name,details.module);}});function stripHtml(string){return string.replace(/<\/?[^>]+(>|$)/g,"").replace(/\&quot;/g,"").replace(/\s+/g,"");}
QUnit.log(function(details){var assertList,assertLi,message,expected,actual,diff,showDiff=false,testItem=id("qunit-test-output-"+details.testId);if(!testItem){return;}
message=escapeText(details.message)||(details.result?"okay":"failed");message="<span class='test-message'>"+message+"</span>";message+="<span class='runtime'>@ "+details.runtime+" ms</span>";if(!details.result&&hasOwn.call(details,"expected")){if(details.negative){expected="NOT "+QUnit.dump.parse(details.expected);}else{expected=QUnit.dump.parse(details.expected);}
actual=QUnit.dump.parse(details.actual);message+="<table><tr class='test-expected'><th>Expected: </th><td><pre>"+escapeText(expected)+"</pre></td></tr>";if(actual!==expected){message+="<tr class='test-actual'><th>Result: </th><td><pre>"+escapeText(actual)+"</pre></td></tr>";if(!/^(true|false)$/.test(actual)&&!/^(true|false)$/.test(expected)){diff=QUnit.diff(expected,actual);showDiff=stripHtml(diff).length!==stripHtml(expected).length+stripHtml(actual).length;}
if(showDiff){message+="<tr class='test-diff'><th>Diff: </th><td><pre>"+diff+"</pre></td></tr>";}}else if(expected.indexOf("[object Array]")!==-1||expected.indexOf("[object Object]")!==-1){message+="<tr class='test-message'><th>Message: </th><td>"+"Diff suppressed as the depth of object is more than current max depth ("+QUnit.config.maxDepth+").<p>Hint: Use <code>QUnit.dump.maxDepth</code> to "+" run with a higher max depth or <a href='"+escapeText(setUrl({maxDepth:-1}))+"'>"+"Rerun</a> without max depth.</p></td></tr>";}else{message+="<tr class='test-message'><th>Message: </th><td>"+"Diff suppressed as the expected and actual results have an equivalent"+" serialization</td></tr>";}
if(details.source){message+="<tr class='test-source'><th>Source: </th><td><pre>"+escapeText(details.source)+"</pre></td></tr>";}
message+="</table>";}else if(!details.result&&details.source){message+="<table>"+"<tr class='test-source'><th>Source: </th><td><pre>"+escapeText(details.source)+"</pre></td></tr>"+"</table>";}
assertList=testItem.getElementsByTagName("ol")[0];assertLi=document$$1.createElement("li");assertLi.className=details.result?"pass":"fail";assertLi.innerHTML=message;assertList.appendChild(assertLi);});QUnit.testDone(function(details){var testTitle,time,testItem,assertList,good,bad,testCounts,skipped,sourceName,tests=id("qunit-tests");if(!tests){return;}
testItem=id("qunit-test-output-"+details.testId);assertList=testItem.getElementsByTagName("ol")[0];good=details.passed;bad=details.failed;var testPassed=details.failed>0?details.todo:!details.todo;if(testPassed){addClass(assertList,"qunit-collapsed");}else if(config.collapse){if(!collapseNext){collapseNext=true;}else{addClass(assertList,"qunit-collapsed");}}
testTitle=testItem.firstChild;testCounts=bad?"<b class='failed'>"+bad+"</b>, "+"<b class='passed'>"+good+"</b>, ":"";testTitle.innerHTML+=" <b class='counts'>("+testCounts+details.assertions.length+")</b>";if(details.skipped){stats.skippedTests++;testItem.className="skipped";skipped=document$$1.createElement("em");skipped.className="qunit-skipped-label";skipped.innerHTML="skipped";testItem.insertBefore(skipped,testTitle);}else{addEvent(testTitle,"click",function(){toggleClass(assertList,"qunit-collapsed");});testItem.className=testPassed?"pass":"fail";if(details.todo){var todoLabel=document$$1.createElement("em");todoLabel.className="qunit-todo-label";todoLabel.innerHTML="todo";testItem.insertBefore(todoLabel,testTitle);}
time=document$$1.createElement("span");time.className="runtime";time.innerHTML=details.runtime+" ms";testItem.insertBefore(time,assertList);if(!testPassed){stats.failedTests++;}else if(details.todo){stats.todoTests++;}else{stats.passedTests++;}}
if(details.source){sourceName=document$$1.createElement("p");sourceName.innerHTML="<strong>Source: </strong>"+details.source;addClass(sourceName,"qunit-source");if(testPassed){addClass(sourceName,"qunit-collapsed");}
addEvent(testTitle,"click",function(){toggleClass(sourceName,"qunit-collapsed");});testItem.appendChild(sourceName);}});var notPhantom=function(p){return!(p&&p.version&&p.version.major>0);}(window.phantom);if(notPhantom&&document$$1.readyState==="complete"){QUnit.load();}else{addEvent(window,"load",QUnit.load);}
var originalWindowOnError=window.onerror;window.onerror=function(message,fileName,lineNumber){var ret=false;if(originalWindowOnError){for(var _len=arguments.length,args=Array(_len>3?_len-3:0),_key=3;_key<_len;_key++){args[_key-3]=arguments[_key];}
ret=originalWindowOnError.call.apply(originalWindowOnError,[this,message,fileName,lineNumber].concat(args));}
if(ret!==true){var error={message:message,fileName:fileName,lineNumber:lineNumber};ret=QUnit.onError(error);}
return ret;};})();QUnit.diff=function(){function DiffMatchPatch(){}
var DIFF_DELETE=-1,DIFF_INSERT=1,DIFF_EQUAL=0;DiffMatchPatch.prototype.DiffMain=function(text1,text2,optChecklines){var deadline,checklines,commonlength,commonprefix,commonsuffix,diffs;deadline=new Date().getTime()+1000;if(text1===null||text2===null){throw new Error("Null input. (DiffMain)");}
if(text1===text2){if(text1){return[[DIFF_EQUAL,text1]];}
return[];}
if(typeof optChecklines==="undefined"){optChecklines=true;}
checklines=optChecklines;commonlength=this.diffCommonPrefix(text1,text2);commonprefix=text1.substring(0,commonlength);text1=text1.substring(commonlength);text2=text2.substring(commonlength);commonlength=this.diffCommonSuffix(text1,text2);commonsuffix=text1.substring(text1.length-commonlength);text1=text1.substring(0,text1.length-commonlength);text2=text2.substring(0,text2.length-commonlength);diffs=this.diffCompute(text1,text2,checklines,deadline);if(commonprefix){diffs.unshift([DIFF_EQUAL,commonprefix]);}
if(commonsuffix){diffs.push([DIFF_EQUAL,commonsuffix]);}
this.diffCleanupMerge(diffs);return diffs;};DiffMatchPatch.prototype.diffCleanupEfficiency=function(diffs){var changes,equalities,equalitiesLength,lastequality,pointer,preIns,preDel,postIns,postDel;changes=false;equalities=[];equalitiesLength=0;lastequality=null;pointer=0;preIns=false;preDel=false;postIns=false;postDel=false;while(pointer<diffs.length){if(diffs[pointer][0]===DIFF_EQUAL){if(diffs[pointer][1].length<4&&(postIns||postDel)){equalities[equalitiesLength++]=pointer;preIns=postIns;preDel=postDel;lastequality=diffs[pointer][1];}else{equalitiesLength=0;lastequality=null;}
postIns=postDel=false;}else{if(diffs[pointer][0]===DIFF_DELETE){postDel=true;}else{postIns=true;}
if(lastequality&&(preIns&&preDel&&postIns&&postDel||lastequality.length<2&&preIns+preDel+postIns+postDel===3)){diffs.splice(equalities[equalitiesLength-1],0,[DIFF_DELETE,lastequality]);diffs[equalities[equalitiesLength-1]+1][0]=DIFF_INSERT;equalitiesLength--;lastequality=null;if(preIns&&preDel){postIns=postDel=true;equalitiesLength=0;}else{equalitiesLength--;pointer=equalitiesLength>0?equalities[equalitiesLength-1]:-1;postIns=postDel=false;}
changes=true;}}
pointer++;}
if(changes){this.diffCleanupMerge(diffs);}};DiffMatchPatch.prototype.diffPrettyHtml=function(diffs){var op,data,x,html=[];for(x=0;x<diffs.length;x++){op=diffs[x][0];data=diffs[x][1];switch(op){case DIFF_INSERT:html[x]="<ins>"+escapeText(data)+"</ins>";break;case DIFF_DELETE:html[x]="<del>"+escapeText(data)+"</del>";break;case DIFF_EQUAL:html[x]="<span>"+escapeText(data)+"</span>";break;}}
return html.join("");};DiffMatchPatch.prototype.diffCommonPrefix=function(text1,text2){var pointermid,pointermax,pointermin,pointerstart;if(!text1||!text2||text1.charAt(0)!==text2.charAt(0)){return 0;}
pointermin=0;pointermax=Math.min(text1.length,text2.length);pointermid=pointermax;pointerstart=0;while(pointermin<pointermid){if(text1.substring(pointerstart,pointermid)===text2.substring(pointerstart,pointermid)){pointermin=pointermid;pointerstart=pointermin;}else{pointermax=pointermid;}
pointermid=Math.floor((pointermax-pointermin)/2+pointermin);}
return pointermid;};DiffMatchPatch.prototype.diffCommonSuffix=function(text1,text2){var pointermid,pointermax,pointermin,pointerend;if(!text1||!text2||text1.charAt(text1.length-1)!==text2.charAt(text2.length-1)){return 0;}
pointermin=0;pointermax=Math.min(text1.length,text2.length);pointermid=pointermax;pointerend=0;while(pointermin<pointermid){if(text1.substring(text1.length-pointermid,text1.length-pointerend)===text2.substring(text2.length-pointermid,text2.length-pointerend)){pointermin=pointermid;pointerend=pointermin;}else{pointermax=pointermid;}
pointermid=Math.floor((pointermax-pointermin)/2+pointermin);}
return pointermid;};DiffMatchPatch.prototype.diffCompute=function(text1,text2,checklines,deadline){var diffs,longtext,shorttext,i,hm,text1A,text2A,text1B,text2B,midCommon,diffsA,diffsB;if(!text1){return[[DIFF_INSERT,text2]];}
if(!text2){return[[DIFF_DELETE,text1]];}
longtext=text1.length>text2.length?text1:text2;shorttext=text1.length>text2.length?text2:text1;i=longtext.indexOf(shorttext);if(i!==-1){diffs=[[DIFF_INSERT,longtext.substring(0,i)],[DIFF_EQUAL,shorttext],[DIFF_INSERT,longtext.substring(i+shorttext.length)]];if(text1.length>text2.length){diffs[0][0]=diffs[2][0]=DIFF_DELETE;}
return diffs;}
if(shorttext.length===1){return[[DIFF_DELETE,text1],[DIFF_INSERT,text2]];}
hm=this.diffHalfMatch(text1,text2);if(hm){text1A=hm[0];text1B=hm[1];text2A=hm[2];text2B=hm[3];midCommon=hm[4];diffsA=this.DiffMain(text1A,text2A,checklines,deadline);diffsB=this.DiffMain(text1B,text2B,checklines,deadline);return diffsA.concat([[DIFF_EQUAL,midCommon]],diffsB);}
if(checklines&&text1.length>100&&text2.length>100){return this.diffLineMode(text1,text2,deadline);}
return this.diffBisect(text1,text2,deadline);};DiffMatchPatch.prototype.diffHalfMatch=function(text1,text2){var longtext,shorttext,dmp,text1A,text2B,text2A,text1B,midCommon,hm1,hm2,hm;longtext=text1.length>text2.length?text1:text2;shorttext=text1.length>text2.length?text2:text1;if(longtext.length<4||shorttext.length*2<longtext.length){return null;}
dmp=this;function diffHalfMatchI(longtext,shorttext,i){var seed,j,bestCommon,prefixLength,suffixLength,bestLongtextA,bestLongtextB,bestShorttextA,bestShorttextB;seed=longtext.substring(i,i+Math.floor(longtext.length/4));j=-1;bestCommon="";while((j=shorttext.indexOf(seed,j+1))!==-1){prefixLength=dmp.diffCommonPrefix(longtext.substring(i),shorttext.substring(j));suffixLength=dmp.diffCommonSuffix(longtext.substring(0,i),shorttext.substring(0,j));if(bestCommon.length<suffixLength+prefixLength){bestCommon=shorttext.substring(j-suffixLength,j)+shorttext.substring(j,j+prefixLength);bestLongtextA=longtext.substring(0,i-suffixLength);bestLongtextB=longtext.substring(i+prefixLength);bestShorttextA=shorttext.substring(0,j-suffixLength);bestShorttextB=shorttext.substring(j+prefixLength);}}
if(bestCommon.length*2>=longtext.length){return[bestLongtextA,bestLongtextB,bestShorttextA,bestShorttextB,bestCommon];}else{return null;}}
hm1=diffHalfMatchI(longtext,shorttext,Math.ceil(longtext.length/4));hm2=diffHalfMatchI(longtext,shorttext,Math.ceil(longtext.length/2));if(!hm1&&!hm2){return null;}else if(!hm2){hm=hm1;}else if(!hm1){hm=hm2;}else{hm=hm1[4].length>hm2[4].length?hm1:hm2;}
if(text1.length>text2.length){text1A=hm[0];text1B=hm[1];text2A=hm[2];text2B=hm[3];}else{text2A=hm[0];text2B=hm[1];text1A=hm[2];text1B=hm[3];}
midCommon=hm[4];return[text1A,text1B,text2A,text2B,midCommon];};DiffMatchPatch.prototype.diffLineMode=function(text1,text2,deadline){var a,diffs,linearray,pointer,countInsert,countDelete,textInsert,textDelete,j;a=this.diffLinesToChars(text1,text2);text1=a.chars1;text2=a.chars2;linearray=a.lineArray;diffs=this.DiffMain(text1,text2,false,deadline);this.diffCharsToLines(diffs,linearray);this.diffCleanupSemantic(diffs);diffs.push([DIFF_EQUAL,""]);pointer=0;countDelete=0;countInsert=0;textDelete="";textInsert="";while(pointer<diffs.length){switch(diffs[pointer][0]){case DIFF_INSERT:countInsert++;textInsert+=diffs[pointer][1];break;case DIFF_DELETE:countDelete++;textDelete+=diffs[pointer][1];break;case DIFF_EQUAL:if(countDelete>=1&&countInsert>=1){diffs.splice(pointer-countDelete-countInsert,countDelete+countInsert);pointer=pointer-countDelete-countInsert;a=this.DiffMain(textDelete,textInsert,false,deadline);for(j=a.length-1;j>=0;j--){diffs.splice(pointer,0,a[j]);}
pointer=pointer+a.length;}
countInsert=0;countDelete=0;textDelete="";textInsert="";break;}
pointer++;}
diffs.pop();return diffs;};DiffMatchPatch.prototype.diffBisect=function(text1,text2,deadline){var text1Length,text2Length,maxD,vOffset,vLength,v1,v2,x,delta,front,k1start,k1end,k2start,k2end,k2Offset,k1Offset,x1,x2,y1,y2,d,k1,k2;text1Length=text1.length;text2Length=text2.length;maxD=Math.ceil((text1Length+text2Length)/2);vOffset=maxD;vLength=2*maxD;v1=new Array(vLength);v2=new Array(vLength);for(x=0;x<vLength;x++){v1[x]=-1;v2[x]=-1;}
v1[vOffset+1]=0;v2[vOffset+1]=0;delta=text1Length-text2Length;front=delta%2!==0;k1start=0;k1end=0;k2start=0;k2end=0;for(d=0;d<maxD;d++){if(new Date().getTime()>deadline){break;}
for(k1=-d+k1start;k1<=d-k1end;k1+=2){k1Offset=vOffset+k1;if(k1===-d||k1!==d&&v1[k1Offset-1]<v1[k1Offset+1]){x1=v1[k1Offset+1];}else{x1=v1[k1Offset-1]+1;}
y1=x1-k1;while(x1<text1Length&&y1<text2Length&&text1.charAt(x1)===text2.charAt(y1)){x1++;y1++;}
v1[k1Offset]=x1;if(x1>text1Length){k1end+=2;}else if(y1>text2Length){k1start+=2;}else if(front){k2Offset=vOffset+delta-k1;if(k2Offset>=0&&k2Offset<vLength&&v2[k2Offset]!==-1){x2=text1Length-v2[k2Offset];if(x1>=x2){return this.diffBisectSplit(text1,text2,x1,y1,deadline);}}}}
for(k2=-d+k2start;k2<=d-k2end;k2+=2){k2Offset=vOffset+k2;if(k2===-d||k2!==d&&v2[k2Offset-1]<v2[k2Offset+1]){x2=v2[k2Offset+1];}else{x2=v2[k2Offset-1]+1;}
y2=x2-k2;while(x2<text1Length&&y2<text2Length&&text1.charAt(text1Length-x2-1)===text2.charAt(text2Length-y2-1)){x2++;y2++;}
v2[k2Offset]=x2;if(x2>text1Length){k2end+=2;}else if(y2>text2Length){k2start+=2;}else if(!front){k1Offset=vOffset+delta-k2;if(k1Offset>=0&&k1Offset<vLength&&v1[k1Offset]!==-1){x1=v1[k1Offset];y1=vOffset+x1-k1Offset;x2=text1Length-x2;if(x1>=x2){return this.diffBisectSplit(text1,text2,x1,y1,deadline);}}}}}
return[[DIFF_DELETE,text1],[DIFF_INSERT,text2]];};DiffMatchPatch.prototype.diffBisectSplit=function(text1,text2,x,y,deadline){var text1a,text1b,text2a,text2b,diffs,diffsb;text1a=text1.substring(0,x);text2a=text2.substring(0,y);text1b=text1.substring(x);text2b=text2.substring(y);diffs=this.DiffMain(text1a,text2a,false,deadline);diffsb=this.DiffMain(text1b,text2b,false,deadline);return diffs.concat(diffsb);};DiffMatchPatch.prototype.diffCleanupSemantic=function(diffs){var changes,equalities,equalitiesLength,lastequality,pointer,lengthInsertions2,lengthDeletions2,lengthInsertions1,lengthDeletions1,deletion,insertion,overlapLength1,overlapLength2;changes=false;equalities=[];equalitiesLength=0;lastequality=null;pointer=0;lengthInsertions1=0;lengthDeletions1=0;lengthInsertions2=0;lengthDeletions2=0;while(pointer<diffs.length){if(diffs[pointer][0]===DIFF_EQUAL){equalities[equalitiesLength++]=pointer;lengthInsertions1=lengthInsertions2;lengthDeletions1=lengthDeletions2;lengthInsertions2=0;lengthDeletions2=0;lastequality=diffs[pointer][1];}else{if(diffs[pointer][0]===DIFF_INSERT){lengthInsertions2+=diffs[pointer][1].length;}else{lengthDeletions2+=diffs[pointer][1].length;}
if(lastequality&&lastequality.length<=Math.max(lengthInsertions1,lengthDeletions1)&&lastequality.length<=Math.max(lengthInsertions2,lengthDeletions2)){diffs.splice(equalities[equalitiesLength-1],0,[DIFF_DELETE,lastequality]);diffs[equalities[equalitiesLength-1]+1][0]=DIFF_INSERT;equalitiesLength--;equalitiesLength--;pointer=equalitiesLength>0?equalities[equalitiesLength-1]:-1;lengthInsertions1=0;lengthDeletions1=0;lengthInsertions2=0;lengthDeletions2=0;lastequality=null;changes=true;}}
pointer++;}
if(changes){this.diffCleanupMerge(diffs);}
pointer=1;while(pointer<diffs.length){if(diffs[pointer-1][0]===DIFF_DELETE&&diffs[pointer][0]===DIFF_INSERT){deletion=diffs[pointer-1][1];insertion=diffs[pointer][1];overlapLength1=this.diffCommonOverlap(deletion,insertion);overlapLength2=this.diffCommonOverlap(insertion,deletion);if(overlapLength1>=overlapLength2){if(overlapLength1>=deletion.length/2||overlapLength1>=insertion.length/2){diffs.splice(pointer,0,[DIFF_EQUAL,insertion.substring(0,overlapLength1)]);diffs[pointer-1][1]=deletion.substring(0,deletion.length-overlapLength1);diffs[pointer+1][1]=insertion.substring(overlapLength1);pointer++;}}else{if(overlapLength2>=deletion.length/2||overlapLength2>=insertion.length/2){diffs.splice(pointer,0,[DIFF_EQUAL,deletion.substring(0,overlapLength2)]);diffs[pointer-1][0]=DIFF_INSERT;diffs[pointer-1][1]=insertion.substring(0,insertion.length-overlapLength2);diffs[pointer+1][0]=DIFF_DELETE;diffs[pointer+1][1]=deletion.substring(overlapLength2);pointer++;}}
pointer++;}
pointer++;}};DiffMatchPatch.prototype.diffCommonOverlap=function(text1,text2){var text1Length,text2Length,textLength,best,length,pattern,found;text1Length=text1.length;text2Length=text2.length;if(text1Length===0||text2Length===0){return 0;}
if(text1Length>text2Length){text1=text1.substring(text1Length-text2Length);}else if(text1Length<text2Length){text2=text2.substring(0,text1Length);}
textLength=Math.min(text1Length,text2Length);if(text1===text2){return textLength;}
best=0;length=1;while(true){pattern=text1.substring(textLength-length);found=text2.indexOf(pattern);if(found===-1){return best;}
length+=found;if(found===0||text1.substring(textLength-length)===text2.substring(0,length)){best=length;length++;}}};DiffMatchPatch.prototype.diffLinesToChars=function(text1,text2){var lineArray,lineHash,chars1,chars2;lineArray=[];lineHash={};lineArray[0]="";function diffLinesToCharsMunge(text){var chars,lineStart,lineEnd,lineArrayLength,line;chars="";lineStart=0;lineEnd=-1;lineArrayLength=lineArray.length;while(lineEnd<text.length-1){lineEnd=text.indexOf("\n",lineStart);if(lineEnd===-1){lineEnd=text.length-1;}
line=text.substring(lineStart,lineEnd+1);lineStart=lineEnd+1;if(lineHash.hasOwnProperty?lineHash.hasOwnProperty(line):lineHash[line]!==undefined){chars+=String.fromCharCode(lineHash[line]);}else{chars+=String.fromCharCode(lineArrayLength);lineHash[line]=lineArrayLength;lineArray[lineArrayLength++]=line;}}
return chars;}
chars1=diffLinesToCharsMunge(text1);chars2=diffLinesToCharsMunge(text2);return{chars1:chars1,chars2:chars2,lineArray:lineArray};};DiffMatchPatch.prototype.diffCharsToLines=function(diffs,lineArray){var x,chars,text,y;for(x=0;x<diffs.length;x++){chars=diffs[x][1];text=[];for(y=0;y<chars.length;y++){text[y]=lineArray[chars.charCodeAt(y)];}
diffs[x][1]=text.join("");}};DiffMatchPatch.prototype.diffCleanupMerge=function(diffs){var pointer,countDelete,countInsert,textInsert,textDelete,commonlength,changes,diffPointer,position;diffs.push([DIFF_EQUAL,""]);pointer=0;countDelete=0;countInsert=0;textDelete="";textInsert="";while(pointer<diffs.length){switch(diffs[pointer][0]){case DIFF_INSERT:countInsert++;textInsert+=diffs[pointer][1];pointer++;break;case DIFF_DELETE:countDelete++;textDelete+=diffs[pointer][1];pointer++;break;case DIFF_EQUAL:if(countDelete+countInsert>1){if(countDelete!==0&&countInsert!==0){commonlength=this.diffCommonPrefix(textInsert,textDelete);if(commonlength!==0){if(pointer-countDelete-countInsert>0&&diffs[pointer-countDelete-countInsert-1][0]===DIFF_EQUAL){diffs[pointer-countDelete-countInsert-1][1]+=textInsert.substring(0,commonlength);}else{diffs.splice(0,0,[DIFF_EQUAL,textInsert.substring(0,commonlength)]);pointer++;}
textInsert=textInsert.substring(commonlength);textDelete=textDelete.substring(commonlength);}
commonlength=this.diffCommonSuffix(textInsert,textDelete);if(commonlength!==0){diffs[pointer][1]=textInsert.substring(textInsert.length-commonlength)+diffs[pointer][1];textInsert=textInsert.substring(0,textInsert.length-commonlength);textDelete=textDelete.substring(0,textDelete.length-commonlength);}}
if(countDelete===0){diffs.splice(pointer-countInsert,countDelete+countInsert,[DIFF_INSERT,textInsert]);}else if(countInsert===0){diffs.splice(pointer-countDelete,countDelete+countInsert,[DIFF_DELETE,textDelete]);}else{diffs.splice(pointer-countDelete-countInsert,countDelete+countInsert,[DIFF_DELETE,textDelete],[DIFF_INSERT,textInsert]);}
pointer=pointer-countDelete-countInsert+(countDelete?1:0)+(countInsert?1:0)+1;}else if(pointer!==0&&diffs[pointer-1][0]===DIFF_EQUAL){diffs[pointer-1][1]+=diffs[pointer][1];diffs.splice(pointer,1);}else{pointer++;}
countInsert=0;countDelete=0;textDelete="";textInsert="";break;}}
if(diffs[diffs.length-1][1]===""){diffs.pop();}
changes=false;pointer=1;while(pointer<diffs.length-1){if(diffs[pointer-1][0]===DIFF_EQUAL&&diffs[pointer+1][0]===DIFF_EQUAL){diffPointer=diffs[pointer][1];position=diffPointer.substring(diffPointer.length-diffs[pointer-1][1].length);if(position===diffs[pointer-1][1]){diffs[pointer][1]=diffs[pointer-1][1]+diffs[pointer][1].substring(0,diffs[pointer][1].length-diffs[pointer-1][1].length);diffs[pointer+1][1]=diffs[pointer-1][1]+diffs[pointer+1][1];diffs.splice(pointer-1,1);changes=true;}else if(diffPointer.substring(0,diffs[pointer+1][1].length)===diffs[pointer+1][1]){diffs[pointer-1][1]+=diffs[pointer+1][1];diffs[pointer][1]=diffs[pointer][1].substring(diffs[pointer+1][1].length)+diffs[pointer+1][1];diffs.splice(pointer+1,1);changes=true;}}
pointer++;}
if(changes){this.diffCleanupMerge(diffs);}};return function(o,n){var diff,output,text;diff=new DiffMatchPatch();output=diff.DiffMain(o,n);diff.diffCleanupEfficiency(output);text=diff.diffPrettyHtml(output);return text;};}();}((function(){return this;}())));