/*
 * Decompiled with CFR 0.152.
 */
package codeintelligence.codeanalysis.utils.graph;

import codeintelligence.codeanalysis.utils.graph.AbstractPropertyGraph;
import codeintelligence.codeanalysis.utils.graph.Edge;
import java.util.Iterator;
import java.util.Set;

public interface Graph<V, E> {
    public boolean isDirected();

    public boolean addVertex(V var1);

    public boolean removeVertex(V var1);

    public boolean addEdge(Edge<V, E> var1);

    public boolean addEdge(V var1, V var2);

    public boolean removeEdge(Edge<V, E> var1);

    public Set<Edge<V, E>> removeEdges(V var1, V var2);

    public boolean addGraph(AbstractPropertyGraph<V, E> var1);

    public int vertexCount();

    public int edgeCount();

    public Iterator<Edge<V, E>> allEdgesIterator();

    public Iterator<V> allVerticesIterator();

    public Set<Edge<V, E>> copyEdgeSet();

    public Set<V> copyVertexSet();

    public Iterator<Edge<V, E>> incomingEdgesIterator(V var1);

    public Iterator<Edge<V, E>> outgoingEdgesIterator(V var1);

    public Set<Edge<V, E>> copyIncomingEdges(V var1);

    public Set<Edge<V, E>> copyOutgoingEdges(V var1);

    public int getInDegree(V var1);

    public int getOutDegree(V var1);

    public Set<Edge<V, E>> getEdgesWithLabel(E var1);

    public boolean containsEdge(Edge<V, E> var1);

    public boolean containsEdge(V var1, V var2);

    public boolean containsVertex(V var1);

    public boolean containsAllEdges(Set<Edge<V, E>> var1);

    public boolean containsAllVertices(Set<V> var1);

    public boolean isSubgraphOf(Graph<V, E> var1);

    public boolean isProperSubgraphOf(Graph<V, E> var1);

    public boolean isConnected();
}

