# coding=utf-8
# *** WARNING: this file was generated by the Pulumi Terraform Bridge (tfgen) Tool. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import copy
import warnings
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
from . import _utilities

__all__ = [
    'IngestProcessorNetworkDirectionResult',
    'AwaitableIngestProcessorNetworkDirectionResult',
    'ingest_processor_network_direction',
    'ingest_processor_network_direction_output',
]

@pulumi.output_type
class IngestProcessorNetworkDirectionResult:
    """
    A collection of values returned by IngestProcessorNetworkDirection.
    """
    def __init__(__self__, description=None, destination_ip=None, id=None, if_=None, ignore_failure=None, ignore_missing=None, internal_networks=None, internal_networks_field=None, json=None, on_failures=None, source_ip=None, tag=None, target_field=None):
        if description and not isinstance(description, str):
            raise TypeError("Expected argument 'description' to be a str")
        pulumi.set(__self__, "description", description)
        if destination_ip and not isinstance(destination_ip, str):
            raise TypeError("Expected argument 'destination_ip' to be a str")
        pulumi.set(__self__, "destination_ip", destination_ip)
        if id and not isinstance(id, str):
            raise TypeError("Expected argument 'id' to be a str")
        pulumi.set(__self__, "id", id)
        if if_ and not isinstance(if_, str):
            raise TypeError("Expected argument 'if_' to be a str")
        pulumi.set(__self__, "if_", if_)
        if ignore_failure and not isinstance(ignore_failure, bool):
            raise TypeError("Expected argument 'ignore_failure' to be a bool")
        pulumi.set(__self__, "ignore_failure", ignore_failure)
        if ignore_missing and not isinstance(ignore_missing, bool):
            raise TypeError("Expected argument 'ignore_missing' to be a bool")
        pulumi.set(__self__, "ignore_missing", ignore_missing)
        if internal_networks and not isinstance(internal_networks, list):
            raise TypeError("Expected argument 'internal_networks' to be a list")
        pulumi.set(__self__, "internal_networks", internal_networks)
        if internal_networks_field and not isinstance(internal_networks_field, str):
            raise TypeError("Expected argument 'internal_networks_field' to be a str")
        pulumi.set(__self__, "internal_networks_field", internal_networks_field)
        if json and not isinstance(json, str):
            raise TypeError("Expected argument 'json' to be a str")
        pulumi.set(__self__, "json", json)
        if on_failures and not isinstance(on_failures, list):
            raise TypeError("Expected argument 'on_failures' to be a list")
        pulumi.set(__self__, "on_failures", on_failures)
        if source_ip and not isinstance(source_ip, str):
            raise TypeError("Expected argument 'source_ip' to be a str")
        pulumi.set(__self__, "source_ip", source_ip)
        if tag and not isinstance(tag, str):
            raise TypeError("Expected argument 'tag' to be a str")
        pulumi.set(__self__, "tag", tag)
        if target_field and not isinstance(target_field, str):
            raise TypeError("Expected argument 'target_field' to be a str")
        pulumi.set(__self__, "target_field", target_field)

    @property
    @pulumi.getter
    def description(self) -> Optional[str]:
        """
        Description of the processor.
        """
        return pulumi.get(self, "description")

    @property
    @pulumi.getter(name="destinationIp")
    def destination_ip(self) -> Optional[str]:
        """
        Field containing the destination IP address.
        """
        return pulumi.get(self, "destination_ip")

    @property
    @pulumi.getter
    def id(self) -> str:
        """
        Internal identifier of the resource.
        """
        return pulumi.get(self, "id")

    @property
    @pulumi.getter(name="if")
    def if_(self) -> Optional[str]:
        """
        Conditionally execute the processor
        """
        return pulumi.get(self, "if_")

    @property
    @pulumi.getter(name="ignoreFailure")
    def ignore_failure(self) -> Optional[bool]:
        """
        Ignore failures for the processor.
        """
        return pulumi.get(self, "ignore_failure")

    @property
    @pulumi.getter(name="ignoreMissing")
    def ignore_missing(self) -> Optional[bool]:
        """
        If `true` and `field` does not exist or is `null`, the processor quietly exits without modifying the document.
        """
        return pulumi.get(self, "ignore_missing")

    @property
    @pulumi.getter(name="internalNetworks")
    def internal_networks(self) -> Optional[Sequence[str]]:
        """
        List of internal networks.
        """
        return pulumi.get(self, "internal_networks")

    @property
    @pulumi.getter(name="internalNetworksField")
    def internal_networks_field(self) -> Optional[str]:
        """
        A field on the given document to read the internal_networks configuration from.
        """
        return pulumi.get(self, "internal_networks_field")

    @property
    @pulumi.getter
    def json(self) -> str:
        """
        JSON representation of this data source.
        """
        return pulumi.get(self, "json")

    @property
    @pulumi.getter(name="onFailures")
    def on_failures(self) -> Optional[Sequence[str]]:
        """
        Handle failures for the processor.
        """
        return pulumi.get(self, "on_failures")

    @property
    @pulumi.getter(name="sourceIp")
    def source_ip(self) -> Optional[str]:
        """
        Field containing the source IP address.
        """
        return pulumi.get(self, "source_ip")

    @property
    @pulumi.getter
    def tag(self) -> Optional[str]:
        """
        Identifier for the processor.
        """
        return pulumi.get(self, "tag")

    @property
    @pulumi.getter(name="targetField")
    def target_field(self) -> Optional[str]:
        """
        Output field for the network direction.
        """
        return pulumi.get(self, "target_field")


class AwaitableIngestProcessorNetworkDirectionResult(IngestProcessorNetworkDirectionResult):
    # pylint: disable=using-constant-test
    def __await__(self):
        if False:
            yield self
        return IngestProcessorNetworkDirectionResult(
            description=self.description,
            destination_ip=self.destination_ip,
            id=self.id,
            if_=self.if_,
            ignore_failure=self.ignore_failure,
            ignore_missing=self.ignore_missing,
            internal_networks=self.internal_networks,
            internal_networks_field=self.internal_networks_field,
            json=self.json,
            on_failures=self.on_failures,
            source_ip=self.source_ip,
            tag=self.tag,
            target_field=self.target_field)


def ingest_processor_network_direction(description: Optional[str] = None,
                                       destination_ip: Optional[str] = None,
                                       if_: Optional[str] = None,
                                       ignore_failure: Optional[bool] = None,
                                       ignore_missing: Optional[bool] = None,
                                       internal_networks: Optional[Sequence[str]] = None,
                                       internal_networks_field: Optional[str] = None,
                                       on_failures: Optional[Sequence[str]] = None,
                                       source_ip: Optional[str] = None,
                                       tag: Optional[str] = None,
                                       target_field: Optional[str] = None,
                                       opts: Optional[pulumi.InvokeOptions] = None) -> AwaitableIngestProcessorNetworkDirectionResult:
    """
    Calculates the network direction given a source IP address, destination IP address, and a list of internal networks.

    The network direction processor reads IP addresses from Elastic Common Schema (ECS) fields by default. If you use the ECS, only the `internal_networks` option must be specified.

    One of either `internal_networks` or `internal_networks_field` must be specified. If `internal_networks_field` is specified, it follows the behavior specified by `ignore_missing`.

    ## Example Usage

    ```python
    import pulumi
    import pulumi_elasticstack as elasticstack

    network_direction = elasticstack.ingest_processor_network_direction(internal_networks=["private"])
    my_ingest_pipeline = elasticstack.IngestPipeline("myIngestPipeline", processors=[network_direction.json])
    ```


    :param str description: Description of the processor.
    :param str destination_ip: Field containing the destination IP address.
    :param str if_: Conditionally execute the processor
    :param bool ignore_failure: Ignore failures for the processor.
    :param bool ignore_missing: If `true` and `field` does not exist or is `null`, the processor quietly exits without modifying the document.
    :param Sequence[str] internal_networks: List of internal networks.
    :param str internal_networks_field: A field on the given document to read the internal_networks configuration from.
    :param Sequence[str] on_failures: Handle failures for the processor.
    :param str source_ip: Field containing the source IP address.
    :param str tag: Identifier for the processor.
    :param str target_field: Output field for the network direction.
    """
    __args__ = dict()
    __args__['description'] = description
    __args__['destinationIp'] = destination_ip
    __args__['if'] = if_
    __args__['ignoreFailure'] = ignore_failure
    __args__['ignoreMissing'] = ignore_missing
    __args__['internalNetworks'] = internal_networks
    __args__['internalNetworksField'] = internal_networks_field
    __args__['onFailures'] = on_failures
    __args__['sourceIp'] = source_ip
    __args__['tag'] = tag
    __args__['targetField'] = target_field
    opts = pulumi.InvokeOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke('elasticstack:index/ingestProcessorNetworkDirection:IngestProcessorNetworkDirection', __args__, opts=opts, typ=IngestProcessorNetworkDirectionResult).value

    return AwaitableIngestProcessorNetworkDirectionResult(
        description=__ret__.description,
        destination_ip=__ret__.destination_ip,
        id=__ret__.id,
        if_=__ret__.if_,
        ignore_failure=__ret__.ignore_failure,
        ignore_missing=__ret__.ignore_missing,
        internal_networks=__ret__.internal_networks,
        internal_networks_field=__ret__.internal_networks_field,
        json=__ret__.json,
        on_failures=__ret__.on_failures,
        source_ip=__ret__.source_ip,
        tag=__ret__.tag,
        target_field=__ret__.target_field)


@_utilities.lift_output_func(ingest_processor_network_direction)
def ingest_processor_network_direction_output(description: Optional[pulumi.Input[Optional[str]]] = None,
                                              destination_ip: Optional[pulumi.Input[Optional[str]]] = None,
                                              if_: Optional[pulumi.Input[Optional[str]]] = None,
                                              ignore_failure: Optional[pulumi.Input[Optional[bool]]] = None,
                                              ignore_missing: Optional[pulumi.Input[Optional[bool]]] = None,
                                              internal_networks: Optional[pulumi.Input[Optional[Sequence[str]]]] = None,
                                              internal_networks_field: Optional[pulumi.Input[Optional[str]]] = None,
                                              on_failures: Optional[pulumi.Input[Optional[Sequence[str]]]] = None,
                                              source_ip: Optional[pulumi.Input[Optional[str]]] = None,
                                              tag: Optional[pulumi.Input[Optional[str]]] = None,
                                              target_field: Optional[pulumi.Input[Optional[str]]] = None,
                                              opts: Optional[pulumi.InvokeOptions] = None) -> pulumi.Output[IngestProcessorNetworkDirectionResult]:
    """
    Calculates the network direction given a source IP address, destination IP address, and a list of internal networks.

    The network direction processor reads IP addresses from Elastic Common Schema (ECS) fields by default. If you use the ECS, only the `internal_networks` option must be specified.

    One of either `internal_networks` or `internal_networks_field` must be specified. If `internal_networks_field` is specified, it follows the behavior specified by `ignore_missing`.

    ## Example Usage

    ```python
    import pulumi
    import pulumi_elasticstack as elasticstack

    network_direction = elasticstack.ingest_processor_network_direction(internal_networks=["private"])
    my_ingest_pipeline = elasticstack.IngestPipeline("myIngestPipeline", processors=[network_direction.json])
    ```


    :param str description: Description of the processor.
    :param str destination_ip: Field containing the destination IP address.
    :param str if_: Conditionally execute the processor
    :param bool ignore_failure: Ignore failures for the processor.
    :param bool ignore_missing: If `true` and `field` does not exist or is `null`, the processor quietly exits without modifying the document.
    :param Sequence[str] internal_networks: List of internal networks.
    :param str internal_networks_field: A field on the given document to read the internal_networks configuration from.
    :param Sequence[str] on_failures: Handle failures for the processor.
    :param str source_ip: Field containing the source IP address.
    :param str tag: Identifier for the processor.
    :param str target_field: Output field for the network direction.
    """
    ...
