# coding=utf-8
# *** WARNING: this file was generated by the Pulumi Terraform Bridge (tfgen) Tool. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import copy
import warnings
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
from . import _utilities

__all__ = [
    'IngestProcessorJsonResult',
    'AwaitableIngestProcessorJsonResult',
    'ingest_processor_json',
    'ingest_processor_json_output',
]

@pulumi.output_type
class IngestProcessorJsonResult:
    """
    A collection of values returned by IngestProcessorJson.
    """
    def __init__(__self__, add_to_root=None, add_to_root_conflict_strategy=None, allow_duplicate_keys=None, description=None, field=None, id=None, if_=None, ignore_failure=None, json=None, on_failures=None, tag=None, target_field=None):
        if add_to_root and not isinstance(add_to_root, bool):
            raise TypeError("Expected argument 'add_to_root' to be a bool")
        pulumi.set(__self__, "add_to_root", add_to_root)
        if add_to_root_conflict_strategy and not isinstance(add_to_root_conflict_strategy, str):
            raise TypeError("Expected argument 'add_to_root_conflict_strategy' to be a str")
        pulumi.set(__self__, "add_to_root_conflict_strategy", add_to_root_conflict_strategy)
        if allow_duplicate_keys and not isinstance(allow_duplicate_keys, bool):
            raise TypeError("Expected argument 'allow_duplicate_keys' to be a bool")
        pulumi.set(__self__, "allow_duplicate_keys", allow_duplicate_keys)
        if description and not isinstance(description, str):
            raise TypeError("Expected argument 'description' to be a str")
        pulumi.set(__self__, "description", description)
        if field and not isinstance(field, str):
            raise TypeError("Expected argument 'field' to be a str")
        pulumi.set(__self__, "field", field)
        if id and not isinstance(id, str):
            raise TypeError("Expected argument 'id' to be a str")
        pulumi.set(__self__, "id", id)
        if if_ and not isinstance(if_, str):
            raise TypeError("Expected argument 'if_' to be a str")
        pulumi.set(__self__, "if_", if_)
        if ignore_failure and not isinstance(ignore_failure, bool):
            raise TypeError("Expected argument 'ignore_failure' to be a bool")
        pulumi.set(__self__, "ignore_failure", ignore_failure)
        if json and not isinstance(json, str):
            raise TypeError("Expected argument 'json' to be a str")
        pulumi.set(__self__, "json", json)
        if on_failures and not isinstance(on_failures, list):
            raise TypeError("Expected argument 'on_failures' to be a list")
        pulumi.set(__self__, "on_failures", on_failures)
        if tag and not isinstance(tag, str):
            raise TypeError("Expected argument 'tag' to be a str")
        pulumi.set(__self__, "tag", tag)
        if target_field and not isinstance(target_field, str):
            raise TypeError("Expected argument 'target_field' to be a str")
        pulumi.set(__self__, "target_field", target_field)

    @property
    @pulumi.getter(name="addToRoot")
    def add_to_root(self) -> Optional[bool]:
        """
        Flag that forces the parsed JSON to be added at the top level of the document. `target_field` must not be set when this option is chosen.
        """
        return pulumi.get(self, "add_to_root")

    @property
    @pulumi.getter(name="addToRootConflictStrategy")
    def add_to_root_conflict_strategy(self) -> Optional[str]:
        """
        When set to `replace`, root fields that conflict with fields from the parsed JSON will be overridden. When set to `merge`, conflicting fields will be merged. Only applicable if `add_to_root` is set to `true`.
        """
        return pulumi.get(self, "add_to_root_conflict_strategy")

    @property
    @pulumi.getter(name="allowDuplicateKeys")
    def allow_duplicate_keys(self) -> Optional[bool]:
        """
        When set to `true`, the JSON parser will not fail if the JSON contains duplicate keys. Instead, the last encountered value for any duplicate key wins.
        """
        return pulumi.get(self, "allow_duplicate_keys")

    @property
    @pulumi.getter
    def description(self) -> Optional[str]:
        """
        Description of the processor.
        """
        return pulumi.get(self, "description")

    @property
    @pulumi.getter
    def field(self) -> str:
        """
        The field to be parsed.
        """
        return pulumi.get(self, "field")

    @property
    @pulumi.getter
    def id(self) -> str:
        """
        Internal identifier of the resource.
        """
        return pulumi.get(self, "id")

    @property
    @pulumi.getter(name="if")
    def if_(self) -> Optional[str]:
        """
        Conditionally execute the processor
        """
        return pulumi.get(self, "if_")

    @property
    @pulumi.getter(name="ignoreFailure")
    def ignore_failure(self) -> Optional[bool]:
        """
        Ignore failures for the processor.
        """
        return pulumi.get(self, "ignore_failure")

    @property
    @pulumi.getter
    def json(self) -> str:
        """
        JSON representation of this data source.
        """
        return pulumi.get(self, "json")

    @property
    @pulumi.getter(name="onFailures")
    def on_failures(self) -> Optional[Sequence[str]]:
        """
        Handle failures for the processor.
        """
        return pulumi.get(self, "on_failures")

    @property
    @pulumi.getter
    def tag(self) -> Optional[str]:
        """
        Identifier for the processor.
        """
        return pulumi.get(self, "tag")

    @property
    @pulumi.getter(name="targetField")
    def target_field(self) -> Optional[str]:
        """
        The field that the converted structured object will be written into. Any existing content in this field will be overwritten.
        """
        return pulumi.get(self, "target_field")


class AwaitableIngestProcessorJsonResult(IngestProcessorJsonResult):
    # pylint: disable=using-constant-test
    def __await__(self):
        if False:
            yield self
        return IngestProcessorJsonResult(
            add_to_root=self.add_to_root,
            add_to_root_conflict_strategy=self.add_to_root_conflict_strategy,
            allow_duplicate_keys=self.allow_duplicate_keys,
            description=self.description,
            field=self.field,
            id=self.id,
            if_=self.if_,
            ignore_failure=self.ignore_failure,
            json=self.json,
            on_failures=self.on_failures,
            tag=self.tag,
            target_field=self.target_field)


def ingest_processor_json(add_to_root: Optional[bool] = None,
                          add_to_root_conflict_strategy: Optional[str] = None,
                          allow_duplicate_keys: Optional[bool] = None,
                          description: Optional[str] = None,
                          field: Optional[str] = None,
                          if_: Optional[str] = None,
                          ignore_failure: Optional[bool] = None,
                          on_failures: Optional[Sequence[str]] = None,
                          tag: Optional[str] = None,
                          target_field: Optional[str] = None,
                          opts: Optional[pulumi.InvokeOptions] = None) -> AwaitableIngestProcessorJsonResult:
    """
    Converts a JSON string into a structured JSON object.

    See: https://www.elastic.co/guide/en/elasticsearch/reference/current/json-processor.html

    ## Example Usage

    ```python
    import pulumi
    import pulumi_elasticstack as elasticstack

    json_proc = elasticstack.ingest_processor_json(field="string_source",
        target_field="json_target")
    my_ingest_pipeline = elasticstack.IngestPipeline("myIngestPipeline", processors=[json_proc.json])
    ```


    :param bool add_to_root: Flag that forces the parsed JSON to be added at the top level of the document. `target_field` must not be set when this option is chosen.
    :param str add_to_root_conflict_strategy: When set to `replace`, root fields that conflict with fields from the parsed JSON will be overridden. When set to `merge`, conflicting fields will be merged. Only applicable if `add_to_root` is set to `true`.
    :param bool allow_duplicate_keys: When set to `true`, the JSON parser will not fail if the JSON contains duplicate keys. Instead, the last encountered value for any duplicate key wins.
    :param str description: Description of the processor.
    :param str field: The field to be parsed.
    :param str if_: Conditionally execute the processor
    :param bool ignore_failure: Ignore failures for the processor.
    :param Sequence[str] on_failures: Handle failures for the processor.
    :param str tag: Identifier for the processor.
    :param str target_field: The field that the converted structured object will be written into. Any existing content in this field will be overwritten.
    """
    __args__ = dict()
    __args__['addToRoot'] = add_to_root
    __args__['addToRootConflictStrategy'] = add_to_root_conflict_strategy
    __args__['allowDuplicateKeys'] = allow_duplicate_keys
    __args__['description'] = description
    __args__['field'] = field
    __args__['if'] = if_
    __args__['ignoreFailure'] = ignore_failure
    __args__['onFailures'] = on_failures
    __args__['tag'] = tag
    __args__['targetField'] = target_field
    opts = pulumi.InvokeOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke('elasticstack:index/ingestProcessorJson:IngestProcessorJson', __args__, opts=opts, typ=IngestProcessorJsonResult).value

    return AwaitableIngestProcessorJsonResult(
        add_to_root=__ret__.add_to_root,
        add_to_root_conflict_strategy=__ret__.add_to_root_conflict_strategy,
        allow_duplicate_keys=__ret__.allow_duplicate_keys,
        description=__ret__.description,
        field=__ret__.field,
        id=__ret__.id,
        if_=__ret__.if_,
        ignore_failure=__ret__.ignore_failure,
        json=__ret__.json,
        on_failures=__ret__.on_failures,
        tag=__ret__.tag,
        target_field=__ret__.target_field)


@_utilities.lift_output_func(ingest_processor_json)
def ingest_processor_json_output(add_to_root: Optional[pulumi.Input[Optional[bool]]] = None,
                                 add_to_root_conflict_strategy: Optional[pulumi.Input[Optional[str]]] = None,
                                 allow_duplicate_keys: Optional[pulumi.Input[Optional[bool]]] = None,
                                 description: Optional[pulumi.Input[Optional[str]]] = None,
                                 field: Optional[pulumi.Input[str]] = None,
                                 if_: Optional[pulumi.Input[Optional[str]]] = None,
                                 ignore_failure: Optional[pulumi.Input[Optional[bool]]] = None,
                                 on_failures: Optional[pulumi.Input[Optional[Sequence[str]]]] = None,
                                 tag: Optional[pulumi.Input[Optional[str]]] = None,
                                 target_field: Optional[pulumi.Input[Optional[str]]] = None,
                                 opts: Optional[pulumi.InvokeOptions] = None) -> pulumi.Output[IngestProcessorJsonResult]:
    """
    Converts a JSON string into a structured JSON object.

    See: https://www.elastic.co/guide/en/elasticsearch/reference/current/json-processor.html

    ## Example Usage

    ```python
    import pulumi
    import pulumi_elasticstack as elasticstack

    json_proc = elasticstack.ingest_processor_json(field="string_source",
        target_field="json_target")
    my_ingest_pipeline = elasticstack.IngestPipeline("myIngestPipeline", processors=[json_proc.json])
    ```


    :param bool add_to_root: Flag that forces the parsed JSON to be added at the top level of the document. `target_field` must not be set when this option is chosen.
    :param str add_to_root_conflict_strategy: When set to `replace`, root fields that conflict with fields from the parsed JSON will be overridden. When set to `merge`, conflicting fields will be merged. Only applicable if `add_to_root` is set to `true`.
    :param bool allow_duplicate_keys: When set to `true`, the JSON parser will not fail if the JSON contains duplicate keys. Instead, the last encountered value for any duplicate key wins.
    :param str description: Description of the processor.
    :param str field: The field to be parsed.
    :param str if_: Conditionally execute the processor
    :param bool ignore_failure: Ignore failures for the processor.
    :param Sequence[str] on_failures: Handle failures for the processor.
    :param str tag: Identifier for the processor.
    :param str target_field: The field that the converted structured object will be written into. Any existing content in this field will be overwritten.
    """
    ...
