# coding=utf-8
# *** WARNING: this file was generated by the Pulumi Terraform Bridge (tfgen) Tool. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import copy
import warnings
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
from . import _utilities
from . import outputs
from ._inputs import *

__all__ = ['IndexTemplateArgs', 'IndexTemplate']

@pulumi.input_type
class IndexTemplateArgs:
    def __init__(__self__, *,
                 index_patterns: pulumi.Input[Sequence[pulumi.Input[str]]],
                 composed_ofs: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 data_stream: Optional[pulumi.Input['IndexTemplateDataStreamArgs']] = None,
                 elasticsearch_connection: Optional[pulumi.Input['IndexTemplateElasticsearchConnectionArgs']] = None,
                 metadata: Optional[pulumi.Input[str]] = None,
                 name: Optional[pulumi.Input[str]] = None,
                 priority: Optional[pulumi.Input[int]] = None,
                 template: Optional[pulumi.Input['IndexTemplateTemplateArgs']] = None,
                 version: Optional[pulumi.Input[int]] = None):
        """
        The set of arguments for constructing a IndexTemplate resource.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] index_patterns: Array of wildcard (*) expressions used to match the names of data streams and indices during creation.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] composed_ofs: An ordered list of component template names.
        :param pulumi.Input['IndexTemplateDataStreamArgs'] data_stream: If this object is included, the template is used to create data streams and their backing indices. Supports an empty object.
        :param pulumi.Input['IndexTemplateElasticsearchConnectionArgs'] elasticsearch_connection: Elasticsearch connection configuration block.
        :param pulumi.Input[str] metadata: Optional user metadata about the index template.
        :param pulumi.Input[str] name: Name of the index template to create.
        :param pulumi.Input[int] priority: Priority to determine index template precedence when a new data stream or index is created.
        :param pulumi.Input['IndexTemplateTemplateArgs'] template: Template to be applied. It may optionally include an aliases, mappings, or settings configuration.
        :param pulumi.Input[int] version: Version number used to manage index templates externally.
        """
        pulumi.set(__self__, "index_patterns", index_patterns)
        if composed_ofs is not None:
            pulumi.set(__self__, "composed_ofs", composed_ofs)
        if data_stream is not None:
            pulumi.set(__self__, "data_stream", data_stream)
        if elasticsearch_connection is not None:
            pulumi.set(__self__, "elasticsearch_connection", elasticsearch_connection)
        if metadata is not None:
            pulumi.set(__self__, "metadata", metadata)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if priority is not None:
            pulumi.set(__self__, "priority", priority)
        if template is not None:
            pulumi.set(__self__, "template", template)
        if version is not None:
            pulumi.set(__self__, "version", version)

    @property
    @pulumi.getter(name="indexPatterns")
    def index_patterns(self) -> pulumi.Input[Sequence[pulumi.Input[str]]]:
        """
        Array of wildcard (*) expressions used to match the names of data streams and indices during creation.
        """
        return pulumi.get(self, "index_patterns")

    @index_patterns.setter
    def index_patterns(self, value: pulumi.Input[Sequence[pulumi.Input[str]]]):
        pulumi.set(self, "index_patterns", value)

    @property
    @pulumi.getter(name="composedOfs")
    def composed_ofs(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]:
        """
        An ordered list of component template names.
        """
        return pulumi.get(self, "composed_ofs")

    @composed_ofs.setter
    def composed_ofs(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]):
        pulumi.set(self, "composed_ofs", value)

    @property
    @pulumi.getter(name="dataStream")
    def data_stream(self) -> Optional[pulumi.Input['IndexTemplateDataStreamArgs']]:
        """
        If this object is included, the template is used to create data streams and their backing indices. Supports an empty object.
        """
        return pulumi.get(self, "data_stream")

    @data_stream.setter
    def data_stream(self, value: Optional[pulumi.Input['IndexTemplateDataStreamArgs']]):
        pulumi.set(self, "data_stream", value)

    @property
    @pulumi.getter(name="elasticsearchConnection")
    def elasticsearch_connection(self) -> Optional[pulumi.Input['IndexTemplateElasticsearchConnectionArgs']]:
        """
        Elasticsearch connection configuration block.
        """
        return pulumi.get(self, "elasticsearch_connection")

    @elasticsearch_connection.setter
    def elasticsearch_connection(self, value: Optional[pulumi.Input['IndexTemplateElasticsearchConnectionArgs']]):
        pulumi.set(self, "elasticsearch_connection", value)

    @property
    @pulumi.getter
    def metadata(self) -> Optional[pulumi.Input[str]]:
        """
        Optional user metadata about the index template.
        """
        return pulumi.get(self, "metadata")

    @metadata.setter
    def metadata(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "metadata", value)

    @property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[str]]:
        """
        Name of the index template to create.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "name", value)

    @property
    @pulumi.getter
    def priority(self) -> Optional[pulumi.Input[int]]:
        """
        Priority to determine index template precedence when a new data stream or index is created.
        """
        return pulumi.get(self, "priority")

    @priority.setter
    def priority(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "priority", value)

    @property
    @pulumi.getter
    def template(self) -> Optional[pulumi.Input['IndexTemplateTemplateArgs']]:
        """
        Template to be applied. It may optionally include an aliases, mappings, or settings configuration.
        """
        return pulumi.get(self, "template")

    @template.setter
    def template(self, value: Optional[pulumi.Input['IndexTemplateTemplateArgs']]):
        pulumi.set(self, "template", value)

    @property
    @pulumi.getter
    def version(self) -> Optional[pulumi.Input[int]]:
        """
        Version number used to manage index templates externally.
        """
        return pulumi.get(self, "version")

    @version.setter
    def version(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "version", value)


@pulumi.input_type
class _IndexTemplateState:
    def __init__(__self__, *,
                 composed_ofs: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 data_stream: Optional[pulumi.Input['IndexTemplateDataStreamArgs']] = None,
                 elasticsearch_connection: Optional[pulumi.Input['IndexTemplateElasticsearchConnectionArgs']] = None,
                 index_patterns: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 metadata: Optional[pulumi.Input[str]] = None,
                 name: Optional[pulumi.Input[str]] = None,
                 priority: Optional[pulumi.Input[int]] = None,
                 template: Optional[pulumi.Input['IndexTemplateTemplateArgs']] = None,
                 version: Optional[pulumi.Input[int]] = None):
        """
        Input properties used for looking up and filtering IndexTemplate resources.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] composed_ofs: An ordered list of component template names.
        :param pulumi.Input['IndexTemplateDataStreamArgs'] data_stream: If this object is included, the template is used to create data streams and their backing indices. Supports an empty object.
        :param pulumi.Input['IndexTemplateElasticsearchConnectionArgs'] elasticsearch_connection: Elasticsearch connection configuration block.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] index_patterns: Array of wildcard (*) expressions used to match the names of data streams and indices during creation.
        :param pulumi.Input[str] metadata: Optional user metadata about the index template.
        :param pulumi.Input[str] name: Name of the index template to create.
        :param pulumi.Input[int] priority: Priority to determine index template precedence when a new data stream or index is created.
        :param pulumi.Input['IndexTemplateTemplateArgs'] template: Template to be applied. It may optionally include an aliases, mappings, or settings configuration.
        :param pulumi.Input[int] version: Version number used to manage index templates externally.
        """
        if composed_ofs is not None:
            pulumi.set(__self__, "composed_ofs", composed_ofs)
        if data_stream is not None:
            pulumi.set(__self__, "data_stream", data_stream)
        if elasticsearch_connection is not None:
            pulumi.set(__self__, "elasticsearch_connection", elasticsearch_connection)
        if index_patterns is not None:
            pulumi.set(__self__, "index_patterns", index_patterns)
        if metadata is not None:
            pulumi.set(__self__, "metadata", metadata)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if priority is not None:
            pulumi.set(__self__, "priority", priority)
        if template is not None:
            pulumi.set(__self__, "template", template)
        if version is not None:
            pulumi.set(__self__, "version", version)

    @property
    @pulumi.getter(name="composedOfs")
    def composed_ofs(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]:
        """
        An ordered list of component template names.
        """
        return pulumi.get(self, "composed_ofs")

    @composed_ofs.setter
    def composed_ofs(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]):
        pulumi.set(self, "composed_ofs", value)

    @property
    @pulumi.getter(name="dataStream")
    def data_stream(self) -> Optional[pulumi.Input['IndexTemplateDataStreamArgs']]:
        """
        If this object is included, the template is used to create data streams and their backing indices. Supports an empty object.
        """
        return pulumi.get(self, "data_stream")

    @data_stream.setter
    def data_stream(self, value: Optional[pulumi.Input['IndexTemplateDataStreamArgs']]):
        pulumi.set(self, "data_stream", value)

    @property
    @pulumi.getter(name="elasticsearchConnection")
    def elasticsearch_connection(self) -> Optional[pulumi.Input['IndexTemplateElasticsearchConnectionArgs']]:
        """
        Elasticsearch connection configuration block.
        """
        return pulumi.get(self, "elasticsearch_connection")

    @elasticsearch_connection.setter
    def elasticsearch_connection(self, value: Optional[pulumi.Input['IndexTemplateElasticsearchConnectionArgs']]):
        pulumi.set(self, "elasticsearch_connection", value)

    @property
    @pulumi.getter(name="indexPatterns")
    def index_patterns(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]:
        """
        Array of wildcard (*) expressions used to match the names of data streams and indices during creation.
        """
        return pulumi.get(self, "index_patterns")

    @index_patterns.setter
    def index_patterns(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]):
        pulumi.set(self, "index_patterns", value)

    @property
    @pulumi.getter
    def metadata(self) -> Optional[pulumi.Input[str]]:
        """
        Optional user metadata about the index template.
        """
        return pulumi.get(self, "metadata")

    @metadata.setter
    def metadata(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "metadata", value)

    @property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[str]]:
        """
        Name of the index template to create.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "name", value)

    @property
    @pulumi.getter
    def priority(self) -> Optional[pulumi.Input[int]]:
        """
        Priority to determine index template precedence when a new data stream or index is created.
        """
        return pulumi.get(self, "priority")

    @priority.setter
    def priority(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "priority", value)

    @property
    @pulumi.getter
    def template(self) -> Optional[pulumi.Input['IndexTemplateTemplateArgs']]:
        """
        Template to be applied. It may optionally include an aliases, mappings, or settings configuration.
        """
        return pulumi.get(self, "template")

    @template.setter
    def template(self, value: Optional[pulumi.Input['IndexTemplateTemplateArgs']]):
        pulumi.set(self, "template", value)

    @property
    @pulumi.getter
    def version(self) -> Optional[pulumi.Input[int]]:
        """
        Version number used to manage index templates externally.
        """
        return pulumi.get(self, "version")

    @version.setter
    def version(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "version", value)


class IndexTemplate(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 composed_ofs: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 data_stream: Optional[pulumi.Input[pulumi.InputType['IndexTemplateDataStreamArgs']]] = None,
                 elasticsearch_connection: Optional[pulumi.Input[pulumi.InputType['IndexTemplateElasticsearchConnectionArgs']]] = None,
                 index_patterns: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 metadata: Optional[pulumi.Input[str]] = None,
                 name: Optional[pulumi.Input[str]] = None,
                 priority: Optional[pulumi.Input[int]] = None,
                 template: Optional[pulumi.Input[pulumi.InputType['IndexTemplateTemplateArgs']]] = None,
                 version: Optional[pulumi.Input[int]] = None,
                 __props__=None):
        """
        Creates or updates an index template. Index templates define settings, mappings, and aliases that can be applied automatically to new indices. See, https://www.elastic.co/guide/en/elasticsearch/reference/current/indices-put-template.html

        ## Example Usage

        ```python
        import pulumi
        import json
        import pulumi_elasticstack as elasticstack

        my_template = elasticstack.IndexTemplate("myTemplate",
            priority=42,
            index_patterns=[
                "logstash*",
                "filebeat*",
            ],
            template=elasticstack.IndexTemplateTemplateArgs(
                aliases=[
                    elasticstack.IndexTemplateTemplateAliasArgs(
                        name="my_template_test",
                    ),
                    elasticstack.IndexTemplateTemplateAliasArgs(
                        name="another_test",
                    ),
                ],
                settings=json.dumps({
                    "number_of_shards": "3",
                }),
            ))
        my_data_stream = elasticstack.IndexTemplate("myDataStream",
            index_patterns=["stream*"],
            data_stream=elasticstack.IndexTemplateDataStreamArgs())
        ```

        ## Import

        ```sh
         $ pulumi import elasticstack:index/indexTemplate:IndexTemplate my_template <cluster_uuid>/<template_name>
        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] composed_ofs: An ordered list of component template names.
        :param pulumi.Input[pulumi.InputType['IndexTemplateDataStreamArgs']] data_stream: If this object is included, the template is used to create data streams and their backing indices. Supports an empty object.
        :param pulumi.Input[pulumi.InputType['IndexTemplateElasticsearchConnectionArgs']] elasticsearch_connection: Elasticsearch connection configuration block.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] index_patterns: Array of wildcard (*) expressions used to match the names of data streams and indices during creation.
        :param pulumi.Input[str] metadata: Optional user metadata about the index template.
        :param pulumi.Input[str] name: Name of the index template to create.
        :param pulumi.Input[int] priority: Priority to determine index template precedence when a new data stream or index is created.
        :param pulumi.Input[pulumi.InputType['IndexTemplateTemplateArgs']] template: Template to be applied. It may optionally include an aliases, mappings, or settings configuration.
        :param pulumi.Input[int] version: Version number used to manage index templates externally.
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: IndexTemplateArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        Creates or updates an index template. Index templates define settings, mappings, and aliases that can be applied automatically to new indices. See, https://www.elastic.co/guide/en/elasticsearch/reference/current/indices-put-template.html

        ## Example Usage

        ```python
        import pulumi
        import json
        import pulumi_elasticstack as elasticstack

        my_template = elasticstack.IndexTemplate("myTemplate",
            priority=42,
            index_patterns=[
                "logstash*",
                "filebeat*",
            ],
            template=elasticstack.IndexTemplateTemplateArgs(
                aliases=[
                    elasticstack.IndexTemplateTemplateAliasArgs(
                        name="my_template_test",
                    ),
                    elasticstack.IndexTemplateTemplateAliasArgs(
                        name="another_test",
                    ),
                ],
                settings=json.dumps({
                    "number_of_shards": "3",
                }),
            ))
        my_data_stream = elasticstack.IndexTemplate("myDataStream",
            index_patterns=["stream*"],
            data_stream=elasticstack.IndexTemplateDataStreamArgs())
        ```

        ## Import

        ```sh
         $ pulumi import elasticstack:index/indexTemplate:IndexTemplate my_template <cluster_uuid>/<template_name>
        ```

        :param str resource_name: The name of the resource.
        :param IndexTemplateArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(IndexTemplateArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 composed_ofs: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 data_stream: Optional[pulumi.Input[pulumi.InputType['IndexTemplateDataStreamArgs']]] = None,
                 elasticsearch_connection: Optional[pulumi.Input[pulumi.InputType['IndexTemplateElasticsearchConnectionArgs']]] = None,
                 index_patterns: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 metadata: Optional[pulumi.Input[str]] = None,
                 name: Optional[pulumi.Input[str]] = None,
                 priority: Optional[pulumi.Input[int]] = None,
                 template: Optional[pulumi.Input[pulumi.InputType['IndexTemplateTemplateArgs']]] = None,
                 version: Optional[pulumi.Input[int]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = IndexTemplateArgs.__new__(IndexTemplateArgs)

            __props__.__dict__["composed_ofs"] = composed_ofs
            __props__.__dict__["data_stream"] = data_stream
            __props__.__dict__["elasticsearch_connection"] = elasticsearch_connection
            if index_patterns is None and not opts.urn:
                raise TypeError("Missing required property 'index_patterns'")
            __props__.__dict__["index_patterns"] = index_patterns
            __props__.__dict__["metadata"] = metadata
            __props__.__dict__["name"] = name
            __props__.__dict__["priority"] = priority
            __props__.__dict__["template"] = template
            __props__.__dict__["version"] = version
        super(IndexTemplate, __self__).__init__(
            'elasticstack:index/indexTemplate:IndexTemplate',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            composed_ofs: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
            data_stream: Optional[pulumi.Input[pulumi.InputType['IndexTemplateDataStreamArgs']]] = None,
            elasticsearch_connection: Optional[pulumi.Input[pulumi.InputType['IndexTemplateElasticsearchConnectionArgs']]] = None,
            index_patterns: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
            metadata: Optional[pulumi.Input[str]] = None,
            name: Optional[pulumi.Input[str]] = None,
            priority: Optional[pulumi.Input[int]] = None,
            template: Optional[pulumi.Input[pulumi.InputType['IndexTemplateTemplateArgs']]] = None,
            version: Optional[pulumi.Input[int]] = None) -> 'IndexTemplate':
        """
        Get an existing IndexTemplate resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] composed_ofs: An ordered list of component template names.
        :param pulumi.Input[pulumi.InputType['IndexTemplateDataStreamArgs']] data_stream: If this object is included, the template is used to create data streams and their backing indices. Supports an empty object.
        :param pulumi.Input[pulumi.InputType['IndexTemplateElasticsearchConnectionArgs']] elasticsearch_connection: Elasticsearch connection configuration block.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] index_patterns: Array of wildcard (*) expressions used to match the names of data streams and indices during creation.
        :param pulumi.Input[str] metadata: Optional user metadata about the index template.
        :param pulumi.Input[str] name: Name of the index template to create.
        :param pulumi.Input[int] priority: Priority to determine index template precedence when a new data stream or index is created.
        :param pulumi.Input[pulumi.InputType['IndexTemplateTemplateArgs']] template: Template to be applied. It may optionally include an aliases, mappings, or settings configuration.
        :param pulumi.Input[int] version: Version number used to manage index templates externally.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _IndexTemplateState.__new__(_IndexTemplateState)

        __props__.__dict__["composed_ofs"] = composed_ofs
        __props__.__dict__["data_stream"] = data_stream
        __props__.__dict__["elasticsearch_connection"] = elasticsearch_connection
        __props__.__dict__["index_patterns"] = index_patterns
        __props__.__dict__["metadata"] = metadata
        __props__.__dict__["name"] = name
        __props__.__dict__["priority"] = priority
        __props__.__dict__["template"] = template
        __props__.__dict__["version"] = version
        return IndexTemplate(resource_name, opts=opts, __props__=__props__)

    @property
    @pulumi.getter(name="composedOfs")
    def composed_ofs(self) -> pulumi.Output[Sequence[str]]:
        """
        An ordered list of component template names.
        """
        return pulumi.get(self, "composed_ofs")

    @property
    @pulumi.getter(name="dataStream")
    def data_stream(self) -> pulumi.Output[Optional['outputs.IndexTemplateDataStream']]:
        """
        If this object is included, the template is used to create data streams and their backing indices. Supports an empty object.
        """
        return pulumi.get(self, "data_stream")

    @property
    @pulumi.getter(name="elasticsearchConnection")
    def elasticsearch_connection(self) -> pulumi.Output[Optional['outputs.IndexTemplateElasticsearchConnection']]:
        """
        Elasticsearch connection configuration block.
        """
        return pulumi.get(self, "elasticsearch_connection")

    @property
    @pulumi.getter(name="indexPatterns")
    def index_patterns(self) -> pulumi.Output[Sequence[str]]:
        """
        Array of wildcard (*) expressions used to match the names of data streams and indices during creation.
        """
        return pulumi.get(self, "index_patterns")

    @property
    @pulumi.getter
    def metadata(self) -> pulumi.Output[Optional[str]]:
        """
        Optional user metadata about the index template.
        """
        return pulumi.get(self, "metadata")

    @property
    @pulumi.getter
    def name(self) -> pulumi.Output[str]:
        """
        Name of the index template to create.
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter
    def priority(self) -> pulumi.Output[Optional[int]]:
        """
        Priority to determine index template precedence when a new data stream or index is created.
        """
        return pulumi.get(self, "priority")

    @property
    @pulumi.getter
    def template(self) -> pulumi.Output[Optional['outputs.IndexTemplateTemplate']]:
        """
        Template to be applied. It may optionally include an aliases, mappings, or settings configuration.
        """
        return pulumi.get(self, "template")

    @property
    @pulumi.getter
    def version(self) -> pulumi.Output[Optional[int]]:
        """
        Version number used to manage index templates externally.
        """
        return pulumi.get(self, "version")

