# coding=utf-8
# *** WARNING: this file was generated by the Pulumi Terraform Bridge (tfgen) Tool. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import copy
import warnings
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
from . import _utilities
from . import outputs
from ._inputs import *

__all__ = ['IndexArgs', 'Index']

@pulumi.input_type
class IndexArgs:
    def __init__(__self__, *,
                 aliases: Optional[pulumi.Input[Sequence[pulumi.Input['IndexAliasArgs']]]] = None,
                 analysis_analyzer: Optional[pulumi.Input[str]] = None,
                 analysis_char_filter: Optional[pulumi.Input[str]] = None,
                 analysis_filter: Optional[pulumi.Input[str]] = None,
                 analysis_normalizer: Optional[pulumi.Input[str]] = None,
                 analysis_tokenizer: Optional[pulumi.Input[str]] = None,
                 analyze_max_token_count: Optional[pulumi.Input[int]] = None,
                 auto_expand_replicas: Optional[pulumi.Input[str]] = None,
                 blocks_metadata: Optional[pulumi.Input[bool]] = None,
                 blocks_read: Optional[pulumi.Input[bool]] = None,
                 blocks_read_only: Optional[pulumi.Input[bool]] = None,
                 blocks_read_only_allow_delete: Optional[pulumi.Input[bool]] = None,
                 blocks_write: Optional[pulumi.Input[bool]] = None,
                 codec: Optional[pulumi.Input[str]] = None,
                 default_pipeline: Optional[pulumi.Input[str]] = None,
                 elasticsearch_connection: Optional[pulumi.Input['IndexElasticsearchConnectionArgs']] = None,
                 final_pipeline: Optional[pulumi.Input[str]] = None,
                 gc_deletes: Optional[pulumi.Input[str]] = None,
                 highlight_max_analyzed_offset: Optional[pulumi.Input[int]] = None,
                 indexing_slowlog_level: Optional[pulumi.Input[str]] = None,
                 indexing_slowlog_source: Optional[pulumi.Input[str]] = None,
                 indexing_slowlog_threshold_index_debug: Optional[pulumi.Input[str]] = None,
                 indexing_slowlog_threshold_index_info: Optional[pulumi.Input[str]] = None,
                 indexing_slowlog_threshold_index_trace: Optional[pulumi.Input[str]] = None,
                 indexing_slowlog_threshold_index_warn: Optional[pulumi.Input[str]] = None,
                 load_fixed_bitset_filters_eagerly: Optional[pulumi.Input[bool]] = None,
                 mappings: Optional[pulumi.Input[str]] = None,
                 max_docvalue_fields_search: Optional[pulumi.Input[int]] = None,
                 max_inner_result_window: Optional[pulumi.Input[int]] = None,
                 max_ngram_diff: Optional[pulumi.Input[int]] = None,
                 max_refresh_listeners: Optional[pulumi.Input[int]] = None,
                 max_regex_length: Optional[pulumi.Input[int]] = None,
                 max_rescore_window: Optional[pulumi.Input[int]] = None,
                 max_result_window: Optional[pulumi.Input[int]] = None,
                 max_script_fields: Optional[pulumi.Input[int]] = None,
                 max_shingle_diff: Optional[pulumi.Input[int]] = None,
                 max_terms_count: Optional[pulumi.Input[int]] = None,
                 name: Optional[pulumi.Input[str]] = None,
                 number_of_replicas: Optional[pulumi.Input[int]] = None,
                 number_of_routing_shards: Optional[pulumi.Input[int]] = None,
                 number_of_shards: Optional[pulumi.Input[int]] = None,
                 query_default_fields: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 refresh_interval: Optional[pulumi.Input[str]] = None,
                 routing_allocation_enable: Optional[pulumi.Input[str]] = None,
                 routing_partition_size: Optional[pulumi.Input[int]] = None,
                 routing_rebalance_enable: Optional[pulumi.Input[str]] = None,
                 search_idle_after: Optional[pulumi.Input[str]] = None,
                 search_slowlog_level: Optional[pulumi.Input[str]] = None,
                 search_slowlog_threshold_fetch_debug: Optional[pulumi.Input[str]] = None,
                 search_slowlog_threshold_fetch_info: Optional[pulumi.Input[str]] = None,
                 search_slowlog_threshold_fetch_trace: Optional[pulumi.Input[str]] = None,
                 search_slowlog_threshold_fetch_warn: Optional[pulumi.Input[str]] = None,
                 search_slowlog_threshold_query_debug: Optional[pulumi.Input[str]] = None,
                 search_slowlog_threshold_query_info: Optional[pulumi.Input[str]] = None,
                 search_slowlog_threshold_query_trace: Optional[pulumi.Input[str]] = None,
                 search_slowlog_threshold_query_warn: Optional[pulumi.Input[str]] = None,
                 settings: Optional[pulumi.Input['IndexSettingsArgs']] = None,
                 shard_check_on_startup: Optional[pulumi.Input[str]] = None,
                 sort_fields: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 sort_orders: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 unassigned_node_left_delayed_timeout: Optional[pulumi.Input[str]] = None):
        """
        The set of arguments for constructing a Index resource.
        :param pulumi.Input[Sequence[pulumi.Input['IndexAliasArgs']]] aliases: Aliases for the index.
        :param pulumi.Input[str] analysis_analyzer: A JSON string describing the analyzers applied to the index.
        :param pulumi.Input[str] analysis_char_filter: A JSON string describing the char_filters applied to the index.
        :param pulumi.Input[str] analysis_filter: A JSON string describing the filters applied to the index.
        :param pulumi.Input[str] analysis_normalizer: A JSON string describing the normalizers applied to the index.
        :param pulumi.Input[str] analysis_tokenizer: A JSON string describing the tokenizers applied to the index.
        :param pulumi.Input[int] analyze_max_token_count: The maximum number of tokens that can be produced using _analyze API.
        :param pulumi.Input[str] auto_expand_replicas: Set the number of replicas to the node count in the cluster. Set to a dash delimited lower and upper bound (e.g. 0-5) or use all for the upper bound (e.g. 0-all)
        :param pulumi.Input[bool] blocks_metadata: Set to `true` to disable index metadata reads and writes.
        :param pulumi.Input[bool] blocks_read: Set to `true` to disable read operations against the index.
        :param pulumi.Input[bool] blocks_read_only: Set to `true` to make the index and index metadata read only, `false` to allow writes and metadata changes.
        :param pulumi.Input[bool] blocks_read_only_allow_delete: Identical to `index.blocks.read_only` but allows deleting the index to free up resources.
        :param pulumi.Input[bool] blocks_write: Set to `true` to disable data write operations against the index. This setting does not affect metadata.
        :param pulumi.Input[str] codec: The `default` value compresses stored data with LZ4 compression, but this can be set to `best_compression` which uses DEFLATE for a higher compression ratio. This can be set only on creation.
        :param pulumi.Input[str] default_pipeline: The default ingest node pipeline for this index. Index requests will fail if the default pipeline is set and the pipeline does not exist.
        :param pulumi.Input['IndexElasticsearchConnectionArgs'] elasticsearch_connection: Elasticsearch connection configuration block.
        :param pulumi.Input[str] final_pipeline: Final ingest pipeline for the index. Indexing requests will fail if the final pipeline is set and the pipeline does not exist. The final pipeline always runs after the request pipeline (if specified) and the default pipeline (if it exists). The special pipeline name _none indicates no ingest pipeline will run.
        :param pulumi.Input[str] gc_deletes: The length of time that a deleted document's version number remains available for further versioned operations.
        :param pulumi.Input[int] highlight_max_analyzed_offset: The maximum number of characters that will be analyzed for a highlight request.
        :param pulumi.Input[str] indexing_slowlog_level: Set which logging level to use for the search slow log, can be: `warn`, `info`, `debug`, `trace`
        :param pulumi.Input[str] indexing_slowlog_source: Set the number of characters of the `_source` to include in the slowlog lines, `false` or `0` will skip logging the source entirely and setting it to `true` will log the entire source regardless of size. The original `_source` is reformatted by default to make sure that it fits on a single log line.
        :param pulumi.Input[str] indexing_slowlog_threshold_index_debug: Set the cutoff for shard level slow search logging of slow searches for indexing queries, in time units, e.g. `2s`
        :param pulumi.Input[str] indexing_slowlog_threshold_index_info: Set the cutoff for shard level slow search logging of slow searches for indexing queries, in time units, e.g. `5s`
        :param pulumi.Input[str] indexing_slowlog_threshold_index_trace: Set the cutoff for shard level slow search logging of slow searches for indexing queries, in time units, e.g. `500ms`
        :param pulumi.Input[str] indexing_slowlog_threshold_index_warn: Set the cutoff for shard level slow search logging of slow searches for indexing queries, in time units, e.g. `10s`
        :param pulumi.Input[bool] load_fixed_bitset_filters_eagerly: Indicates whether cached filters are pre-loaded for nested queries. This can be set only on creation.
        :param pulumi.Input[str] mappings: Mapping for fields in the index.
               If specified, this mapping can include: field names, [field data types](https://www.elastic.co/guide/en/elasticsearch/reference/current/mapping-types.html), [mapping parameters](https://www.elastic.co/guide/en/elasticsearch/reference/current/mapping-params.html).
               **NOTE:** changing datatypes in the existing *mappings* will force index to be re-created.
        :param pulumi.Input[int] max_docvalue_fields_search: The maximum number of `docvalue_fields` that are allowed in a query.
        :param pulumi.Input[int] max_inner_result_window: The maximum value of `from + size` for inner hits definition and top hits aggregations to this index.
        :param pulumi.Input[int] max_ngram_diff: The maximum allowed difference between min*gram and max*gram for NGramTokenizer and NGramTokenFilter.
        :param pulumi.Input[int] max_refresh_listeners: Maximum number of refresh listeners available on each shard of the index.
        :param pulumi.Input[int] max_regex_length: The maximum length of regex that can be used in Regexp Query.
        :param pulumi.Input[int] max_rescore_window: The maximum value of `window_size` for `rescore` requests in searches of this index.
        :param pulumi.Input[int] max_result_window: The maximum value of `from + size` for searches to this index.
        :param pulumi.Input[int] max_script_fields: The maximum number of `script_fields` that are allowed in a query.
        :param pulumi.Input[int] max_shingle_diff: The maximum allowed difference between max*shingle*size and min*shingle*size for ShingleTokenFilter.
        :param pulumi.Input[int] max_terms_count: The maximum number of terms that can be used in Terms Query.
        :param pulumi.Input[str] name: Name of the index you wish to create.
        :param pulumi.Input[int] number_of_replicas: Number of shard replicas.
        :param pulumi.Input[int] number_of_routing_shards: Value used with number*of*shards to route documents to a primary shard. This can be set only on creation.
        :param pulumi.Input[int] number_of_shards: Number of shards for the index. This can be set only on creation.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] query_default_fields: Wildcard (*) patterns matching one or more fields. Defaults to '*', which matches all fields eligible for term-level queries, excluding metadata fields.
        :param pulumi.Input[str] refresh_interval: How often to perform a refresh operation, which makes recent changes to the index visible to search. Can be set to `-1` to disable refresh.
        :param pulumi.Input[str] routing_allocation_enable: Controls shard allocation for this index. It can be set to: `all` , `primaries` , `new_primaries` , `none`.
        :param pulumi.Input[int] routing_partition_size: The number of shards a custom routing value can go to. This can be set only on creation.
        :param pulumi.Input[str] routing_rebalance_enable: Enables shard rebalancing for this index. It can be set to: `all`, `primaries` , `replicas` , `none`.
        :param pulumi.Input[str] search_idle_after: How long a shard can not receive a search or get request until it’s considered search idle.
        :param pulumi.Input[str] search_slowlog_level: Set which logging level to use for the search slow log, can be: `warn`, `info`, `debug`, `trace`
        :param pulumi.Input[str] search_slowlog_threshold_fetch_debug: Set the cutoff for shard level slow search logging of slow searches in the fetch phase, in time units, e.g. `2s`
        :param pulumi.Input[str] search_slowlog_threshold_fetch_info: Set the cutoff for shard level slow search logging of slow searches in the fetch phase, in time units, e.g. `5s`
        :param pulumi.Input[str] search_slowlog_threshold_fetch_trace: Set the cutoff for shard level slow search logging of slow searches in the fetch phase, in time units, e.g. `500ms`
        :param pulumi.Input[str] search_slowlog_threshold_fetch_warn: Set the cutoff for shard level slow search logging of slow searches in the fetch phase, in time units, e.g. `10s`
        :param pulumi.Input[str] search_slowlog_threshold_query_debug: Set the cutoff for shard level slow search logging of slow searches in the query phase, in time units, e.g. `2s`
        :param pulumi.Input[str] search_slowlog_threshold_query_info: Set the cutoff for shard level slow search logging of slow searches in the query phase, in time units, e.g. `5s`
        :param pulumi.Input[str] search_slowlog_threshold_query_trace: Set the cutoff for shard level slow search logging of slow searches in the query phase, in time units, e.g. `500ms`
        :param pulumi.Input[str] search_slowlog_threshold_query_warn: Set the cutoff for shard level slow search logging of slow searches in the query phase, in time units, e.g. `10s`
        :param pulumi.Input['IndexSettingsArgs'] settings: DEPRECATED: Please use dedicated setting field. Configuration options for the index. See, https://www.elastic.co/guide/en/elasticsearch/reference/current/index-modules.html#index-modules-settings.
               **NOTE:** Static index settings (see: https://www.elastic.co/guide/en/elasticsearch/reference/current/index-modules.html#*static*index_settings) can be only set on the index creation and later cannot be removed or updated - *apply* will return error
        :param pulumi.Input[str] shard_check_on_startup: Whether or not shards should be checked for corruption before opening. When corruption is detected, it will prevent the shard from being opened. Accepts `false`, `true`, `checksum`.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] sort_fields: The field to sort shards in this index by.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] sort_orders: The direction to sort shards in. Accepts `asc`, `desc`.
        :param pulumi.Input[str] unassigned_node_left_delayed_timeout: Time to delay the allocation of replica shards which become unassigned because a node has left, in time units, e.g. `10s`
        """
        if aliases is not None:
            pulumi.set(__self__, "aliases", aliases)
        if analysis_analyzer is not None:
            pulumi.set(__self__, "analysis_analyzer", analysis_analyzer)
        if analysis_char_filter is not None:
            pulumi.set(__self__, "analysis_char_filter", analysis_char_filter)
        if analysis_filter is not None:
            pulumi.set(__self__, "analysis_filter", analysis_filter)
        if analysis_normalizer is not None:
            pulumi.set(__self__, "analysis_normalizer", analysis_normalizer)
        if analysis_tokenizer is not None:
            pulumi.set(__self__, "analysis_tokenizer", analysis_tokenizer)
        if analyze_max_token_count is not None:
            pulumi.set(__self__, "analyze_max_token_count", analyze_max_token_count)
        if auto_expand_replicas is not None:
            pulumi.set(__self__, "auto_expand_replicas", auto_expand_replicas)
        if blocks_metadata is not None:
            pulumi.set(__self__, "blocks_metadata", blocks_metadata)
        if blocks_read is not None:
            pulumi.set(__self__, "blocks_read", blocks_read)
        if blocks_read_only is not None:
            pulumi.set(__self__, "blocks_read_only", blocks_read_only)
        if blocks_read_only_allow_delete is not None:
            pulumi.set(__self__, "blocks_read_only_allow_delete", blocks_read_only_allow_delete)
        if blocks_write is not None:
            pulumi.set(__self__, "blocks_write", blocks_write)
        if codec is not None:
            pulumi.set(__self__, "codec", codec)
        if default_pipeline is not None:
            pulumi.set(__self__, "default_pipeline", default_pipeline)
        if elasticsearch_connection is not None:
            pulumi.set(__self__, "elasticsearch_connection", elasticsearch_connection)
        if final_pipeline is not None:
            pulumi.set(__self__, "final_pipeline", final_pipeline)
        if gc_deletes is not None:
            pulumi.set(__self__, "gc_deletes", gc_deletes)
        if highlight_max_analyzed_offset is not None:
            pulumi.set(__self__, "highlight_max_analyzed_offset", highlight_max_analyzed_offset)
        if indexing_slowlog_level is not None:
            pulumi.set(__self__, "indexing_slowlog_level", indexing_slowlog_level)
        if indexing_slowlog_source is not None:
            pulumi.set(__self__, "indexing_slowlog_source", indexing_slowlog_source)
        if indexing_slowlog_threshold_index_debug is not None:
            pulumi.set(__self__, "indexing_slowlog_threshold_index_debug", indexing_slowlog_threshold_index_debug)
        if indexing_slowlog_threshold_index_info is not None:
            pulumi.set(__self__, "indexing_slowlog_threshold_index_info", indexing_slowlog_threshold_index_info)
        if indexing_slowlog_threshold_index_trace is not None:
            pulumi.set(__self__, "indexing_slowlog_threshold_index_trace", indexing_slowlog_threshold_index_trace)
        if indexing_slowlog_threshold_index_warn is not None:
            pulumi.set(__self__, "indexing_slowlog_threshold_index_warn", indexing_slowlog_threshold_index_warn)
        if load_fixed_bitset_filters_eagerly is not None:
            pulumi.set(__self__, "load_fixed_bitset_filters_eagerly", load_fixed_bitset_filters_eagerly)
        if mappings is not None:
            pulumi.set(__self__, "mappings", mappings)
        if max_docvalue_fields_search is not None:
            pulumi.set(__self__, "max_docvalue_fields_search", max_docvalue_fields_search)
        if max_inner_result_window is not None:
            pulumi.set(__self__, "max_inner_result_window", max_inner_result_window)
        if max_ngram_diff is not None:
            pulumi.set(__self__, "max_ngram_diff", max_ngram_diff)
        if max_refresh_listeners is not None:
            pulumi.set(__self__, "max_refresh_listeners", max_refresh_listeners)
        if max_regex_length is not None:
            pulumi.set(__self__, "max_regex_length", max_regex_length)
        if max_rescore_window is not None:
            pulumi.set(__self__, "max_rescore_window", max_rescore_window)
        if max_result_window is not None:
            pulumi.set(__self__, "max_result_window", max_result_window)
        if max_script_fields is not None:
            pulumi.set(__self__, "max_script_fields", max_script_fields)
        if max_shingle_diff is not None:
            pulumi.set(__self__, "max_shingle_diff", max_shingle_diff)
        if max_terms_count is not None:
            pulumi.set(__self__, "max_terms_count", max_terms_count)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if number_of_replicas is not None:
            pulumi.set(__self__, "number_of_replicas", number_of_replicas)
        if number_of_routing_shards is not None:
            pulumi.set(__self__, "number_of_routing_shards", number_of_routing_shards)
        if number_of_shards is not None:
            pulumi.set(__self__, "number_of_shards", number_of_shards)
        if query_default_fields is not None:
            pulumi.set(__self__, "query_default_fields", query_default_fields)
        if refresh_interval is not None:
            pulumi.set(__self__, "refresh_interval", refresh_interval)
        if routing_allocation_enable is not None:
            pulumi.set(__self__, "routing_allocation_enable", routing_allocation_enable)
        if routing_partition_size is not None:
            pulumi.set(__self__, "routing_partition_size", routing_partition_size)
        if routing_rebalance_enable is not None:
            pulumi.set(__self__, "routing_rebalance_enable", routing_rebalance_enable)
        if search_idle_after is not None:
            pulumi.set(__self__, "search_idle_after", search_idle_after)
        if search_slowlog_level is not None:
            pulumi.set(__self__, "search_slowlog_level", search_slowlog_level)
        if search_slowlog_threshold_fetch_debug is not None:
            pulumi.set(__self__, "search_slowlog_threshold_fetch_debug", search_slowlog_threshold_fetch_debug)
        if search_slowlog_threshold_fetch_info is not None:
            pulumi.set(__self__, "search_slowlog_threshold_fetch_info", search_slowlog_threshold_fetch_info)
        if search_slowlog_threshold_fetch_trace is not None:
            pulumi.set(__self__, "search_slowlog_threshold_fetch_trace", search_slowlog_threshold_fetch_trace)
        if search_slowlog_threshold_fetch_warn is not None:
            pulumi.set(__self__, "search_slowlog_threshold_fetch_warn", search_slowlog_threshold_fetch_warn)
        if search_slowlog_threshold_query_debug is not None:
            pulumi.set(__self__, "search_slowlog_threshold_query_debug", search_slowlog_threshold_query_debug)
        if search_slowlog_threshold_query_info is not None:
            pulumi.set(__self__, "search_slowlog_threshold_query_info", search_slowlog_threshold_query_info)
        if search_slowlog_threshold_query_trace is not None:
            pulumi.set(__self__, "search_slowlog_threshold_query_trace", search_slowlog_threshold_query_trace)
        if search_slowlog_threshold_query_warn is not None:
            pulumi.set(__self__, "search_slowlog_threshold_query_warn", search_slowlog_threshold_query_warn)
        if settings is not None:
            warnings.warn("""Using settings makes it easier to misconfigure.  Use dedicated field for the each setting instead.""", DeprecationWarning)
            pulumi.log.warn("""settings is deprecated: Using settings makes it easier to misconfigure.  Use dedicated field for the each setting instead.""")
        if settings is not None:
            pulumi.set(__self__, "settings", settings)
        if shard_check_on_startup is not None:
            pulumi.set(__self__, "shard_check_on_startup", shard_check_on_startup)
        if sort_fields is not None:
            pulumi.set(__self__, "sort_fields", sort_fields)
        if sort_orders is not None:
            pulumi.set(__self__, "sort_orders", sort_orders)
        if unassigned_node_left_delayed_timeout is not None:
            pulumi.set(__self__, "unassigned_node_left_delayed_timeout", unassigned_node_left_delayed_timeout)

    @property
    @pulumi.getter
    def aliases(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['IndexAliasArgs']]]]:
        """
        Aliases for the index.
        """
        return pulumi.get(self, "aliases")

    @aliases.setter
    def aliases(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['IndexAliasArgs']]]]):
        pulumi.set(self, "aliases", value)

    @property
    @pulumi.getter(name="analysisAnalyzer")
    def analysis_analyzer(self) -> Optional[pulumi.Input[str]]:
        """
        A JSON string describing the analyzers applied to the index.
        """
        return pulumi.get(self, "analysis_analyzer")

    @analysis_analyzer.setter
    def analysis_analyzer(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "analysis_analyzer", value)

    @property
    @pulumi.getter(name="analysisCharFilter")
    def analysis_char_filter(self) -> Optional[pulumi.Input[str]]:
        """
        A JSON string describing the char_filters applied to the index.
        """
        return pulumi.get(self, "analysis_char_filter")

    @analysis_char_filter.setter
    def analysis_char_filter(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "analysis_char_filter", value)

    @property
    @pulumi.getter(name="analysisFilter")
    def analysis_filter(self) -> Optional[pulumi.Input[str]]:
        """
        A JSON string describing the filters applied to the index.
        """
        return pulumi.get(self, "analysis_filter")

    @analysis_filter.setter
    def analysis_filter(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "analysis_filter", value)

    @property
    @pulumi.getter(name="analysisNormalizer")
    def analysis_normalizer(self) -> Optional[pulumi.Input[str]]:
        """
        A JSON string describing the normalizers applied to the index.
        """
        return pulumi.get(self, "analysis_normalizer")

    @analysis_normalizer.setter
    def analysis_normalizer(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "analysis_normalizer", value)

    @property
    @pulumi.getter(name="analysisTokenizer")
    def analysis_tokenizer(self) -> Optional[pulumi.Input[str]]:
        """
        A JSON string describing the tokenizers applied to the index.
        """
        return pulumi.get(self, "analysis_tokenizer")

    @analysis_tokenizer.setter
    def analysis_tokenizer(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "analysis_tokenizer", value)

    @property
    @pulumi.getter(name="analyzeMaxTokenCount")
    def analyze_max_token_count(self) -> Optional[pulumi.Input[int]]:
        """
        The maximum number of tokens that can be produced using _analyze API.
        """
        return pulumi.get(self, "analyze_max_token_count")

    @analyze_max_token_count.setter
    def analyze_max_token_count(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "analyze_max_token_count", value)

    @property
    @pulumi.getter(name="autoExpandReplicas")
    def auto_expand_replicas(self) -> Optional[pulumi.Input[str]]:
        """
        Set the number of replicas to the node count in the cluster. Set to a dash delimited lower and upper bound (e.g. 0-5) or use all for the upper bound (e.g. 0-all)
        """
        return pulumi.get(self, "auto_expand_replicas")

    @auto_expand_replicas.setter
    def auto_expand_replicas(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "auto_expand_replicas", value)

    @property
    @pulumi.getter(name="blocksMetadata")
    def blocks_metadata(self) -> Optional[pulumi.Input[bool]]:
        """
        Set to `true` to disable index metadata reads and writes.
        """
        return pulumi.get(self, "blocks_metadata")

    @blocks_metadata.setter
    def blocks_metadata(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "blocks_metadata", value)

    @property
    @pulumi.getter(name="blocksRead")
    def blocks_read(self) -> Optional[pulumi.Input[bool]]:
        """
        Set to `true` to disable read operations against the index.
        """
        return pulumi.get(self, "blocks_read")

    @blocks_read.setter
    def blocks_read(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "blocks_read", value)

    @property
    @pulumi.getter(name="blocksReadOnly")
    def blocks_read_only(self) -> Optional[pulumi.Input[bool]]:
        """
        Set to `true` to make the index and index metadata read only, `false` to allow writes and metadata changes.
        """
        return pulumi.get(self, "blocks_read_only")

    @blocks_read_only.setter
    def blocks_read_only(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "blocks_read_only", value)

    @property
    @pulumi.getter(name="blocksReadOnlyAllowDelete")
    def blocks_read_only_allow_delete(self) -> Optional[pulumi.Input[bool]]:
        """
        Identical to `index.blocks.read_only` but allows deleting the index to free up resources.
        """
        return pulumi.get(self, "blocks_read_only_allow_delete")

    @blocks_read_only_allow_delete.setter
    def blocks_read_only_allow_delete(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "blocks_read_only_allow_delete", value)

    @property
    @pulumi.getter(name="blocksWrite")
    def blocks_write(self) -> Optional[pulumi.Input[bool]]:
        """
        Set to `true` to disable data write operations against the index. This setting does not affect metadata.
        """
        return pulumi.get(self, "blocks_write")

    @blocks_write.setter
    def blocks_write(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "blocks_write", value)

    @property
    @pulumi.getter
    def codec(self) -> Optional[pulumi.Input[str]]:
        """
        The `default` value compresses stored data with LZ4 compression, but this can be set to `best_compression` which uses DEFLATE for a higher compression ratio. This can be set only on creation.
        """
        return pulumi.get(self, "codec")

    @codec.setter
    def codec(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "codec", value)

    @property
    @pulumi.getter(name="defaultPipeline")
    def default_pipeline(self) -> Optional[pulumi.Input[str]]:
        """
        The default ingest node pipeline for this index. Index requests will fail if the default pipeline is set and the pipeline does not exist.
        """
        return pulumi.get(self, "default_pipeline")

    @default_pipeline.setter
    def default_pipeline(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "default_pipeline", value)

    @property
    @pulumi.getter(name="elasticsearchConnection")
    def elasticsearch_connection(self) -> Optional[pulumi.Input['IndexElasticsearchConnectionArgs']]:
        """
        Elasticsearch connection configuration block.
        """
        return pulumi.get(self, "elasticsearch_connection")

    @elasticsearch_connection.setter
    def elasticsearch_connection(self, value: Optional[pulumi.Input['IndexElasticsearchConnectionArgs']]):
        pulumi.set(self, "elasticsearch_connection", value)

    @property
    @pulumi.getter(name="finalPipeline")
    def final_pipeline(self) -> Optional[pulumi.Input[str]]:
        """
        Final ingest pipeline for the index. Indexing requests will fail if the final pipeline is set and the pipeline does not exist. The final pipeline always runs after the request pipeline (if specified) and the default pipeline (if it exists). The special pipeline name _none indicates no ingest pipeline will run.
        """
        return pulumi.get(self, "final_pipeline")

    @final_pipeline.setter
    def final_pipeline(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "final_pipeline", value)

    @property
    @pulumi.getter(name="gcDeletes")
    def gc_deletes(self) -> Optional[pulumi.Input[str]]:
        """
        The length of time that a deleted document's version number remains available for further versioned operations.
        """
        return pulumi.get(self, "gc_deletes")

    @gc_deletes.setter
    def gc_deletes(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "gc_deletes", value)

    @property
    @pulumi.getter(name="highlightMaxAnalyzedOffset")
    def highlight_max_analyzed_offset(self) -> Optional[pulumi.Input[int]]:
        """
        The maximum number of characters that will be analyzed for a highlight request.
        """
        return pulumi.get(self, "highlight_max_analyzed_offset")

    @highlight_max_analyzed_offset.setter
    def highlight_max_analyzed_offset(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "highlight_max_analyzed_offset", value)

    @property
    @pulumi.getter(name="indexingSlowlogLevel")
    def indexing_slowlog_level(self) -> Optional[pulumi.Input[str]]:
        """
        Set which logging level to use for the search slow log, can be: `warn`, `info`, `debug`, `trace`
        """
        return pulumi.get(self, "indexing_slowlog_level")

    @indexing_slowlog_level.setter
    def indexing_slowlog_level(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "indexing_slowlog_level", value)

    @property
    @pulumi.getter(name="indexingSlowlogSource")
    def indexing_slowlog_source(self) -> Optional[pulumi.Input[str]]:
        """
        Set the number of characters of the `_source` to include in the slowlog lines, `false` or `0` will skip logging the source entirely and setting it to `true` will log the entire source regardless of size. The original `_source` is reformatted by default to make sure that it fits on a single log line.
        """
        return pulumi.get(self, "indexing_slowlog_source")

    @indexing_slowlog_source.setter
    def indexing_slowlog_source(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "indexing_slowlog_source", value)

    @property
    @pulumi.getter(name="indexingSlowlogThresholdIndexDebug")
    def indexing_slowlog_threshold_index_debug(self) -> Optional[pulumi.Input[str]]:
        """
        Set the cutoff for shard level slow search logging of slow searches for indexing queries, in time units, e.g. `2s`
        """
        return pulumi.get(self, "indexing_slowlog_threshold_index_debug")

    @indexing_slowlog_threshold_index_debug.setter
    def indexing_slowlog_threshold_index_debug(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "indexing_slowlog_threshold_index_debug", value)

    @property
    @pulumi.getter(name="indexingSlowlogThresholdIndexInfo")
    def indexing_slowlog_threshold_index_info(self) -> Optional[pulumi.Input[str]]:
        """
        Set the cutoff for shard level slow search logging of slow searches for indexing queries, in time units, e.g. `5s`
        """
        return pulumi.get(self, "indexing_slowlog_threshold_index_info")

    @indexing_slowlog_threshold_index_info.setter
    def indexing_slowlog_threshold_index_info(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "indexing_slowlog_threshold_index_info", value)

    @property
    @pulumi.getter(name="indexingSlowlogThresholdIndexTrace")
    def indexing_slowlog_threshold_index_trace(self) -> Optional[pulumi.Input[str]]:
        """
        Set the cutoff for shard level slow search logging of slow searches for indexing queries, in time units, e.g. `500ms`
        """
        return pulumi.get(self, "indexing_slowlog_threshold_index_trace")

    @indexing_slowlog_threshold_index_trace.setter
    def indexing_slowlog_threshold_index_trace(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "indexing_slowlog_threshold_index_trace", value)

    @property
    @pulumi.getter(name="indexingSlowlogThresholdIndexWarn")
    def indexing_slowlog_threshold_index_warn(self) -> Optional[pulumi.Input[str]]:
        """
        Set the cutoff for shard level slow search logging of slow searches for indexing queries, in time units, e.g. `10s`
        """
        return pulumi.get(self, "indexing_slowlog_threshold_index_warn")

    @indexing_slowlog_threshold_index_warn.setter
    def indexing_slowlog_threshold_index_warn(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "indexing_slowlog_threshold_index_warn", value)

    @property
    @pulumi.getter(name="loadFixedBitsetFiltersEagerly")
    def load_fixed_bitset_filters_eagerly(self) -> Optional[pulumi.Input[bool]]:
        """
        Indicates whether cached filters are pre-loaded for nested queries. This can be set only on creation.
        """
        return pulumi.get(self, "load_fixed_bitset_filters_eagerly")

    @load_fixed_bitset_filters_eagerly.setter
    def load_fixed_bitset_filters_eagerly(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "load_fixed_bitset_filters_eagerly", value)

    @property
    @pulumi.getter
    def mappings(self) -> Optional[pulumi.Input[str]]:
        """
        Mapping for fields in the index.
        If specified, this mapping can include: field names, [field data types](https://www.elastic.co/guide/en/elasticsearch/reference/current/mapping-types.html), [mapping parameters](https://www.elastic.co/guide/en/elasticsearch/reference/current/mapping-params.html).
        **NOTE:** changing datatypes in the existing *mappings* will force index to be re-created.
        """
        return pulumi.get(self, "mappings")

    @mappings.setter
    def mappings(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "mappings", value)

    @property
    @pulumi.getter(name="maxDocvalueFieldsSearch")
    def max_docvalue_fields_search(self) -> Optional[pulumi.Input[int]]:
        """
        The maximum number of `docvalue_fields` that are allowed in a query.
        """
        return pulumi.get(self, "max_docvalue_fields_search")

    @max_docvalue_fields_search.setter
    def max_docvalue_fields_search(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "max_docvalue_fields_search", value)

    @property
    @pulumi.getter(name="maxInnerResultWindow")
    def max_inner_result_window(self) -> Optional[pulumi.Input[int]]:
        """
        The maximum value of `from + size` for inner hits definition and top hits aggregations to this index.
        """
        return pulumi.get(self, "max_inner_result_window")

    @max_inner_result_window.setter
    def max_inner_result_window(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "max_inner_result_window", value)

    @property
    @pulumi.getter(name="maxNgramDiff")
    def max_ngram_diff(self) -> Optional[pulumi.Input[int]]:
        """
        The maximum allowed difference between min*gram and max*gram for NGramTokenizer and NGramTokenFilter.
        """
        return pulumi.get(self, "max_ngram_diff")

    @max_ngram_diff.setter
    def max_ngram_diff(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "max_ngram_diff", value)

    @property
    @pulumi.getter(name="maxRefreshListeners")
    def max_refresh_listeners(self) -> Optional[pulumi.Input[int]]:
        """
        Maximum number of refresh listeners available on each shard of the index.
        """
        return pulumi.get(self, "max_refresh_listeners")

    @max_refresh_listeners.setter
    def max_refresh_listeners(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "max_refresh_listeners", value)

    @property
    @pulumi.getter(name="maxRegexLength")
    def max_regex_length(self) -> Optional[pulumi.Input[int]]:
        """
        The maximum length of regex that can be used in Regexp Query.
        """
        return pulumi.get(self, "max_regex_length")

    @max_regex_length.setter
    def max_regex_length(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "max_regex_length", value)

    @property
    @pulumi.getter(name="maxRescoreWindow")
    def max_rescore_window(self) -> Optional[pulumi.Input[int]]:
        """
        The maximum value of `window_size` for `rescore` requests in searches of this index.
        """
        return pulumi.get(self, "max_rescore_window")

    @max_rescore_window.setter
    def max_rescore_window(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "max_rescore_window", value)

    @property
    @pulumi.getter(name="maxResultWindow")
    def max_result_window(self) -> Optional[pulumi.Input[int]]:
        """
        The maximum value of `from + size` for searches to this index.
        """
        return pulumi.get(self, "max_result_window")

    @max_result_window.setter
    def max_result_window(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "max_result_window", value)

    @property
    @pulumi.getter(name="maxScriptFields")
    def max_script_fields(self) -> Optional[pulumi.Input[int]]:
        """
        The maximum number of `script_fields` that are allowed in a query.
        """
        return pulumi.get(self, "max_script_fields")

    @max_script_fields.setter
    def max_script_fields(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "max_script_fields", value)

    @property
    @pulumi.getter(name="maxShingleDiff")
    def max_shingle_diff(self) -> Optional[pulumi.Input[int]]:
        """
        The maximum allowed difference between max*shingle*size and min*shingle*size for ShingleTokenFilter.
        """
        return pulumi.get(self, "max_shingle_diff")

    @max_shingle_diff.setter
    def max_shingle_diff(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "max_shingle_diff", value)

    @property
    @pulumi.getter(name="maxTermsCount")
    def max_terms_count(self) -> Optional[pulumi.Input[int]]:
        """
        The maximum number of terms that can be used in Terms Query.
        """
        return pulumi.get(self, "max_terms_count")

    @max_terms_count.setter
    def max_terms_count(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "max_terms_count", value)

    @property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[str]]:
        """
        Name of the index you wish to create.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "name", value)

    @property
    @pulumi.getter(name="numberOfReplicas")
    def number_of_replicas(self) -> Optional[pulumi.Input[int]]:
        """
        Number of shard replicas.
        """
        return pulumi.get(self, "number_of_replicas")

    @number_of_replicas.setter
    def number_of_replicas(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "number_of_replicas", value)

    @property
    @pulumi.getter(name="numberOfRoutingShards")
    def number_of_routing_shards(self) -> Optional[pulumi.Input[int]]:
        """
        Value used with number*of*shards to route documents to a primary shard. This can be set only on creation.
        """
        return pulumi.get(self, "number_of_routing_shards")

    @number_of_routing_shards.setter
    def number_of_routing_shards(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "number_of_routing_shards", value)

    @property
    @pulumi.getter(name="numberOfShards")
    def number_of_shards(self) -> Optional[pulumi.Input[int]]:
        """
        Number of shards for the index. This can be set only on creation.
        """
        return pulumi.get(self, "number_of_shards")

    @number_of_shards.setter
    def number_of_shards(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "number_of_shards", value)

    @property
    @pulumi.getter(name="queryDefaultFields")
    def query_default_fields(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]:
        """
        Wildcard (*) patterns matching one or more fields. Defaults to '*', which matches all fields eligible for term-level queries, excluding metadata fields.
        """
        return pulumi.get(self, "query_default_fields")

    @query_default_fields.setter
    def query_default_fields(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]):
        pulumi.set(self, "query_default_fields", value)

    @property
    @pulumi.getter(name="refreshInterval")
    def refresh_interval(self) -> Optional[pulumi.Input[str]]:
        """
        How often to perform a refresh operation, which makes recent changes to the index visible to search. Can be set to `-1` to disable refresh.
        """
        return pulumi.get(self, "refresh_interval")

    @refresh_interval.setter
    def refresh_interval(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "refresh_interval", value)

    @property
    @pulumi.getter(name="routingAllocationEnable")
    def routing_allocation_enable(self) -> Optional[pulumi.Input[str]]:
        """
        Controls shard allocation for this index. It can be set to: `all` , `primaries` , `new_primaries` , `none`.
        """
        return pulumi.get(self, "routing_allocation_enable")

    @routing_allocation_enable.setter
    def routing_allocation_enable(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "routing_allocation_enable", value)

    @property
    @pulumi.getter(name="routingPartitionSize")
    def routing_partition_size(self) -> Optional[pulumi.Input[int]]:
        """
        The number of shards a custom routing value can go to. This can be set only on creation.
        """
        return pulumi.get(self, "routing_partition_size")

    @routing_partition_size.setter
    def routing_partition_size(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "routing_partition_size", value)

    @property
    @pulumi.getter(name="routingRebalanceEnable")
    def routing_rebalance_enable(self) -> Optional[pulumi.Input[str]]:
        """
        Enables shard rebalancing for this index. It can be set to: `all`, `primaries` , `replicas` , `none`.
        """
        return pulumi.get(self, "routing_rebalance_enable")

    @routing_rebalance_enable.setter
    def routing_rebalance_enable(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "routing_rebalance_enable", value)

    @property
    @pulumi.getter(name="searchIdleAfter")
    def search_idle_after(self) -> Optional[pulumi.Input[str]]:
        """
        How long a shard can not receive a search or get request until it’s considered search idle.
        """
        return pulumi.get(self, "search_idle_after")

    @search_idle_after.setter
    def search_idle_after(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "search_idle_after", value)

    @property
    @pulumi.getter(name="searchSlowlogLevel")
    def search_slowlog_level(self) -> Optional[pulumi.Input[str]]:
        """
        Set which logging level to use for the search slow log, can be: `warn`, `info`, `debug`, `trace`
        """
        return pulumi.get(self, "search_slowlog_level")

    @search_slowlog_level.setter
    def search_slowlog_level(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "search_slowlog_level", value)

    @property
    @pulumi.getter(name="searchSlowlogThresholdFetchDebug")
    def search_slowlog_threshold_fetch_debug(self) -> Optional[pulumi.Input[str]]:
        """
        Set the cutoff for shard level slow search logging of slow searches in the fetch phase, in time units, e.g. `2s`
        """
        return pulumi.get(self, "search_slowlog_threshold_fetch_debug")

    @search_slowlog_threshold_fetch_debug.setter
    def search_slowlog_threshold_fetch_debug(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "search_slowlog_threshold_fetch_debug", value)

    @property
    @pulumi.getter(name="searchSlowlogThresholdFetchInfo")
    def search_slowlog_threshold_fetch_info(self) -> Optional[pulumi.Input[str]]:
        """
        Set the cutoff for shard level slow search logging of slow searches in the fetch phase, in time units, e.g. `5s`
        """
        return pulumi.get(self, "search_slowlog_threshold_fetch_info")

    @search_slowlog_threshold_fetch_info.setter
    def search_slowlog_threshold_fetch_info(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "search_slowlog_threshold_fetch_info", value)

    @property
    @pulumi.getter(name="searchSlowlogThresholdFetchTrace")
    def search_slowlog_threshold_fetch_trace(self) -> Optional[pulumi.Input[str]]:
        """
        Set the cutoff for shard level slow search logging of slow searches in the fetch phase, in time units, e.g. `500ms`
        """
        return pulumi.get(self, "search_slowlog_threshold_fetch_trace")

    @search_slowlog_threshold_fetch_trace.setter
    def search_slowlog_threshold_fetch_trace(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "search_slowlog_threshold_fetch_trace", value)

    @property
    @pulumi.getter(name="searchSlowlogThresholdFetchWarn")
    def search_slowlog_threshold_fetch_warn(self) -> Optional[pulumi.Input[str]]:
        """
        Set the cutoff for shard level slow search logging of slow searches in the fetch phase, in time units, e.g. `10s`
        """
        return pulumi.get(self, "search_slowlog_threshold_fetch_warn")

    @search_slowlog_threshold_fetch_warn.setter
    def search_slowlog_threshold_fetch_warn(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "search_slowlog_threshold_fetch_warn", value)

    @property
    @pulumi.getter(name="searchSlowlogThresholdQueryDebug")
    def search_slowlog_threshold_query_debug(self) -> Optional[pulumi.Input[str]]:
        """
        Set the cutoff for shard level slow search logging of slow searches in the query phase, in time units, e.g. `2s`
        """
        return pulumi.get(self, "search_slowlog_threshold_query_debug")

    @search_slowlog_threshold_query_debug.setter
    def search_slowlog_threshold_query_debug(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "search_slowlog_threshold_query_debug", value)

    @property
    @pulumi.getter(name="searchSlowlogThresholdQueryInfo")
    def search_slowlog_threshold_query_info(self) -> Optional[pulumi.Input[str]]:
        """
        Set the cutoff for shard level slow search logging of slow searches in the query phase, in time units, e.g. `5s`
        """
        return pulumi.get(self, "search_slowlog_threshold_query_info")

    @search_slowlog_threshold_query_info.setter
    def search_slowlog_threshold_query_info(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "search_slowlog_threshold_query_info", value)

    @property
    @pulumi.getter(name="searchSlowlogThresholdQueryTrace")
    def search_slowlog_threshold_query_trace(self) -> Optional[pulumi.Input[str]]:
        """
        Set the cutoff for shard level slow search logging of slow searches in the query phase, in time units, e.g. `500ms`
        """
        return pulumi.get(self, "search_slowlog_threshold_query_trace")

    @search_slowlog_threshold_query_trace.setter
    def search_slowlog_threshold_query_trace(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "search_slowlog_threshold_query_trace", value)

    @property
    @pulumi.getter(name="searchSlowlogThresholdQueryWarn")
    def search_slowlog_threshold_query_warn(self) -> Optional[pulumi.Input[str]]:
        """
        Set the cutoff for shard level slow search logging of slow searches in the query phase, in time units, e.g. `10s`
        """
        return pulumi.get(self, "search_slowlog_threshold_query_warn")

    @search_slowlog_threshold_query_warn.setter
    def search_slowlog_threshold_query_warn(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "search_slowlog_threshold_query_warn", value)

    @property
    @pulumi.getter
    def settings(self) -> Optional[pulumi.Input['IndexSettingsArgs']]:
        """
        DEPRECATED: Please use dedicated setting field. Configuration options for the index. See, https://www.elastic.co/guide/en/elasticsearch/reference/current/index-modules.html#index-modules-settings.
        **NOTE:** Static index settings (see: https://www.elastic.co/guide/en/elasticsearch/reference/current/index-modules.html#*static*index_settings) can be only set on the index creation and later cannot be removed or updated - *apply* will return error
        """
        return pulumi.get(self, "settings")

    @settings.setter
    def settings(self, value: Optional[pulumi.Input['IndexSettingsArgs']]):
        pulumi.set(self, "settings", value)

    @property
    @pulumi.getter(name="shardCheckOnStartup")
    def shard_check_on_startup(self) -> Optional[pulumi.Input[str]]:
        """
        Whether or not shards should be checked for corruption before opening. When corruption is detected, it will prevent the shard from being opened. Accepts `false`, `true`, `checksum`.
        """
        return pulumi.get(self, "shard_check_on_startup")

    @shard_check_on_startup.setter
    def shard_check_on_startup(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "shard_check_on_startup", value)

    @property
    @pulumi.getter(name="sortFields")
    def sort_fields(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]:
        """
        The field to sort shards in this index by.
        """
        return pulumi.get(self, "sort_fields")

    @sort_fields.setter
    def sort_fields(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]):
        pulumi.set(self, "sort_fields", value)

    @property
    @pulumi.getter(name="sortOrders")
    def sort_orders(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]:
        """
        The direction to sort shards in. Accepts `asc`, `desc`.
        """
        return pulumi.get(self, "sort_orders")

    @sort_orders.setter
    def sort_orders(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]):
        pulumi.set(self, "sort_orders", value)

    @property
    @pulumi.getter(name="unassignedNodeLeftDelayedTimeout")
    def unassigned_node_left_delayed_timeout(self) -> Optional[pulumi.Input[str]]:
        """
        Time to delay the allocation of replica shards which become unassigned because a node has left, in time units, e.g. `10s`
        """
        return pulumi.get(self, "unassigned_node_left_delayed_timeout")

    @unassigned_node_left_delayed_timeout.setter
    def unassigned_node_left_delayed_timeout(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "unassigned_node_left_delayed_timeout", value)


@pulumi.input_type
class _IndexState:
    def __init__(__self__, *,
                 aliases: Optional[pulumi.Input[Sequence[pulumi.Input['IndexAliasArgs']]]] = None,
                 analysis_analyzer: Optional[pulumi.Input[str]] = None,
                 analysis_char_filter: Optional[pulumi.Input[str]] = None,
                 analysis_filter: Optional[pulumi.Input[str]] = None,
                 analysis_normalizer: Optional[pulumi.Input[str]] = None,
                 analysis_tokenizer: Optional[pulumi.Input[str]] = None,
                 analyze_max_token_count: Optional[pulumi.Input[int]] = None,
                 auto_expand_replicas: Optional[pulumi.Input[str]] = None,
                 blocks_metadata: Optional[pulumi.Input[bool]] = None,
                 blocks_read: Optional[pulumi.Input[bool]] = None,
                 blocks_read_only: Optional[pulumi.Input[bool]] = None,
                 blocks_read_only_allow_delete: Optional[pulumi.Input[bool]] = None,
                 blocks_write: Optional[pulumi.Input[bool]] = None,
                 codec: Optional[pulumi.Input[str]] = None,
                 default_pipeline: Optional[pulumi.Input[str]] = None,
                 elasticsearch_connection: Optional[pulumi.Input['IndexElasticsearchConnectionArgs']] = None,
                 final_pipeline: Optional[pulumi.Input[str]] = None,
                 gc_deletes: Optional[pulumi.Input[str]] = None,
                 highlight_max_analyzed_offset: Optional[pulumi.Input[int]] = None,
                 indexing_slowlog_level: Optional[pulumi.Input[str]] = None,
                 indexing_slowlog_source: Optional[pulumi.Input[str]] = None,
                 indexing_slowlog_threshold_index_debug: Optional[pulumi.Input[str]] = None,
                 indexing_slowlog_threshold_index_info: Optional[pulumi.Input[str]] = None,
                 indexing_slowlog_threshold_index_trace: Optional[pulumi.Input[str]] = None,
                 indexing_slowlog_threshold_index_warn: Optional[pulumi.Input[str]] = None,
                 load_fixed_bitset_filters_eagerly: Optional[pulumi.Input[bool]] = None,
                 mappings: Optional[pulumi.Input[str]] = None,
                 max_docvalue_fields_search: Optional[pulumi.Input[int]] = None,
                 max_inner_result_window: Optional[pulumi.Input[int]] = None,
                 max_ngram_diff: Optional[pulumi.Input[int]] = None,
                 max_refresh_listeners: Optional[pulumi.Input[int]] = None,
                 max_regex_length: Optional[pulumi.Input[int]] = None,
                 max_rescore_window: Optional[pulumi.Input[int]] = None,
                 max_result_window: Optional[pulumi.Input[int]] = None,
                 max_script_fields: Optional[pulumi.Input[int]] = None,
                 max_shingle_diff: Optional[pulumi.Input[int]] = None,
                 max_terms_count: Optional[pulumi.Input[int]] = None,
                 name: Optional[pulumi.Input[str]] = None,
                 number_of_replicas: Optional[pulumi.Input[int]] = None,
                 number_of_routing_shards: Optional[pulumi.Input[int]] = None,
                 number_of_shards: Optional[pulumi.Input[int]] = None,
                 query_default_fields: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 refresh_interval: Optional[pulumi.Input[str]] = None,
                 routing_allocation_enable: Optional[pulumi.Input[str]] = None,
                 routing_partition_size: Optional[pulumi.Input[int]] = None,
                 routing_rebalance_enable: Optional[pulumi.Input[str]] = None,
                 search_idle_after: Optional[pulumi.Input[str]] = None,
                 search_slowlog_level: Optional[pulumi.Input[str]] = None,
                 search_slowlog_threshold_fetch_debug: Optional[pulumi.Input[str]] = None,
                 search_slowlog_threshold_fetch_info: Optional[pulumi.Input[str]] = None,
                 search_slowlog_threshold_fetch_trace: Optional[pulumi.Input[str]] = None,
                 search_slowlog_threshold_fetch_warn: Optional[pulumi.Input[str]] = None,
                 search_slowlog_threshold_query_debug: Optional[pulumi.Input[str]] = None,
                 search_slowlog_threshold_query_info: Optional[pulumi.Input[str]] = None,
                 search_slowlog_threshold_query_trace: Optional[pulumi.Input[str]] = None,
                 search_slowlog_threshold_query_warn: Optional[pulumi.Input[str]] = None,
                 settings: Optional[pulumi.Input['IndexSettingsArgs']] = None,
                 settings_raw: Optional[pulumi.Input[str]] = None,
                 shard_check_on_startup: Optional[pulumi.Input[str]] = None,
                 sort_fields: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 sort_orders: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 unassigned_node_left_delayed_timeout: Optional[pulumi.Input[str]] = None):
        """
        Input properties used for looking up and filtering Index resources.
        :param pulumi.Input[Sequence[pulumi.Input['IndexAliasArgs']]] aliases: Aliases for the index.
        :param pulumi.Input[str] analysis_analyzer: A JSON string describing the analyzers applied to the index.
        :param pulumi.Input[str] analysis_char_filter: A JSON string describing the char_filters applied to the index.
        :param pulumi.Input[str] analysis_filter: A JSON string describing the filters applied to the index.
        :param pulumi.Input[str] analysis_normalizer: A JSON string describing the normalizers applied to the index.
        :param pulumi.Input[str] analysis_tokenizer: A JSON string describing the tokenizers applied to the index.
        :param pulumi.Input[int] analyze_max_token_count: The maximum number of tokens that can be produced using _analyze API.
        :param pulumi.Input[str] auto_expand_replicas: Set the number of replicas to the node count in the cluster. Set to a dash delimited lower and upper bound (e.g. 0-5) or use all for the upper bound (e.g. 0-all)
        :param pulumi.Input[bool] blocks_metadata: Set to `true` to disable index metadata reads and writes.
        :param pulumi.Input[bool] blocks_read: Set to `true` to disable read operations against the index.
        :param pulumi.Input[bool] blocks_read_only: Set to `true` to make the index and index metadata read only, `false` to allow writes and metadata changes.
        :param pulumi.Input[bool] blocks_read_only_allow_delete: Identical to `index.blocks.read_only` but allows deleting the index to free up resources.
        :param pulumi.Input[bool] blocks_write: Set to `true` to disable data write operations against the index. This setting does not affect metadata.
        :param pulumi.Input[str] codec: The `default` value compresses stored data with LZ4 compression, but this can be set to `best_compression` which uses DEFLATE for a higher compression ratio. This can be set only on creation.
        :param pulumi.Input[str] default_pipeline: The default ingest node pipeline for this index. Index requests will fail if the default pipeline is set and the pipeline does not exist.
        :param pulumi.Input['IndexElasticsearchConnectionArgs'] elasticsearch_connection: Elasticsearch connection configuration block.
        :param pulumi.Input[str] final_pipeline: Final ingest pipeline for the index. Indexing requests will fail if the final pipeline is set and the pipeline does not exist. The final pipeline always runs after the request pipeline (if specified) and the default pipeline (if it exists). The special pipeline name _none indicates no ingest pipeline will run.
        :param pulumi.Input[str] gc_deletes: The length of time that a deleted document's version number remains available for further versioned operations.
        :param pulumi.Input[int] highlight_max_analyzed_offset: The maximum number of characters that will be analyzed for a highlight request.
        :param pulumi.Input[str] indexing_slowlog_level: Set which logging level to use for the search slow log, can be: `warn`, `info`, `debug`, `trace`
        :param pulumi.Input[str] indexing_slowlog_source: Set the number of characters of the `_source` to include in the slowlog lines, `false` or `0` will skip logging the source entirely and setting it to `true` will log the entire source regardless of size. The original `_source` is reformatted by default to make sure that it fits on a single log line.
        :param pulumi.Input[str] indexing_slowlog_threshold_index_debug: Set the cutoff for shard level slow search logging of slow searches for indexing queries, in time units, e.g. `2s`
        :param pulumi.Input[str] indexing_slowlog_threshold_index_info: Set the cutoff for shard level slow search logging of slow searches for indexing queries, in time units, e.g. `5s`
        :param pulumi.Input[str] indexing_slowlog_threshold_index_trace: Set the cutoff for shard level slow search logging of slow searches for indexing queries, in time units, e.g. `500ms`
        :param pulumi.Input[str] indexing_slowlog_threshold_index_warn: Set the cutoff for shard level slow search logging of slow searches for indexing queries, in time units, e.g. `10s`
        :param pulumi.Input[bool] load_fixed_bitset_filters_eagerly: Indicates whether cached filters are pre-loaded for nested queries. This can be set only on creation.
        :param pulumi.Input[str] mappings: Mapping for fields in the index.
               If specified, this mapping can include: field names, [field data types](https://www.elastic.co/guide/en/elasticsearch/reference/current/mapping-types.html), [mapping parameters](https://www.elastic.co/guide/en/elasticsearch/reference/current/mapping-params.html).
               **NOTE:** changing datatypes in the existing *mappings* will force index to be re-created.
        :param pulumi.Input[int] max_docvalue_fields_search: The maximum number of `docvalue_fields` that are allowed in a query.
        :param pulumi.Input[int] max_inner_result_window: The maximum value of `from + size` for inner hits definition and top hits aggregations to this index.
        :param pulumi.Input[int] max_ngram_diff: The maximum allowed difference between min*gram and max*gram for NGramTokenizer and NGramTokenFilter.
        :param pulumi.Input[int] max_refresh_listeners: Maximum number of refresh listeners available on each shard of the index.
        :param pulumi.Input[int] max_regex_length: The maximum length of regex that can be used in Regexp Query.
        :param pulumi.Input[int] max_rescore_window: The maximum value of `window_size` for `rescore` requests in searches of this index.
        :param pulumi.Input[int] max_result_window: The maximum value of `from + size` for searches to this index.
        :param pulumi.Input[int] max_script_fields: The maximum number of `script_fields` that are allowed in a query.
        :param pulumi.Input[int] max_shingle_diff: The maximum allowed difference between max*shingle*size and min*shingle*size for ShingleTokenFilter.
        :param pulumi.Input[int] max_terms_count: The maximum number of terms that can be used in Terms Query.
        :param pulumi.Input[str] name: Name of the index you wish to create.
        :param pulumi.Input[int] number_of_replicas: Number of shard replicas.
        :param pulumi.Input[int] number_of_routing_shards: Value used with number*of*shards to route documents to a primary shard. This can be set only on creation.
        :param pulumi.Input[int] number_of_shards: Number of shards for the index. This can be set only on creation.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] query_default_fields: Wildcard (*) patterns matching one or more fields. Defaults to '*', which matches all fields eligible for term-level queries, excluding metadata fields.
        :param pulumi.Input[str] refresh_interval: How often to perform a refresh operation, which makes recent changes to the index visible to search. Can be set to `-1` to disable refresh.
        :param pulumi.Input[str] routing_allocation_enable: Controls shard allocation for this index. It can be set to: `all` , `primaries` , `new_primaries` , `none`.
        :param pulumi.Input[int] routing_partition_size: The number of shards a custom routing value can go to. This can be set only on creation.
        :param pulumi.Input[str] routing_rebalance_enable: Enables shard rebalancing for this index. It can be set to: `all`, `primaries` , `replicas` , `none`.
        :param pulumi.Input[str] search_idle_after: How long a shard can not receive a search or get request until it’s considered search idle.
        :param pulumi.Input[str] search_slowlog_level: Set which logging level to use for the search slow log, can be: `warn`, `info`, `debug`, `trace`
        :param pulumi.Input[str] search_slowlog_threshold_fetch_debug: Set the cutoff for shard level slow search logging of slow searches in the fetch phase, in time units, e.g. `2s`
        :param pulumi.Input[str] search_slowlog_threshold_fetch_info: Set the cutoff for shard level slow search logging of slow searches in the fetch phase, in time units, e.g. `5s`
        :param pulumi.Input[str] search_slowlog_threshold_fetch_trace: Set the cutoff for shard level slow search logging of slow searches in the fetch phase, in time units, e.g. `500ms`
        :param pulumi.Input[str] search_slowlog_threshold_fetch_warn: Set the cutoff for shard level slow search logging of slow searches in the fetch phase, in time units, e.g. `10s`
        :param pulumi.Input[str] search_slowlog_threshold_query_debug: Set the cutoff for shard level slow search logging of slow searches in the query phase, in time units, e.g. `2s`
        :param pulumi.Input[str] search_slowlog_threshold_query_info: Set the cutoff for shard level slow search logging of slow searches in the query phase, in time units, e.g. `5s`
        :param pulumi.Input[str] search_slowlog_threshold_query_trace: Set the cutoff for shard level slow search logging of slow searches in the query phase, in time units, e.g. `500ms`
        :param pulumi.Input[str] search_slowlog_threshold_query_warn: Set the cutoff for shard level slow search logging of slow searches in the query phase, in time units, e.g. `10s`
        :param pulumi.Input['IndexSettingsArgs'] settings: DEPRECATED: Please use dedicated setting field. Configuration options for the index. See, https://www.elastic.co/guide/en/elasticsearch/reference/current/index-modules.html#index-modules-settings.
               **NOTE:** Static index settings (see: https://www.elastic.co/guide/en/elasticsearch/reference/current/index-modules.html#*static*index_settings) can be only set on the index creation and later cannot be removed or updated - *apply* will return error
        :param pulumi.Input[str] settings_raw: All raw settings fetched from the cluster.
        :param pulumi.Input[str] shard_check_on_startup: Whether or not shards should be checked for corruption before opening. When corruption is detected, it will prevent the shard from being opened. Accepts `false`, `true`, `checksum`.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] sort_fields: The field to sort shards in this index by.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] sort_orders: The direction to sort shards in. Accepts `asc`, `desc`.
        :param pulumi.Input[str] unassigned_node_left_delayed_timeout: Time to delay the allocation of replica shards which become unassigned because a node has left, in time units, e.g. `10s`
        """
        if aliases is not None:
            pulumi.set(__self__, "aliases", aliases)
        if analysis_analyzer is not None:
            pulumi.set(__self__, "analysis_analyzer", analysis_analyzer)
        if analysis_char_filter is not None:
            pulumi.set(__self__, "analysis_char_filter", analysis_char_filter)
        if analysis_filter is not None:
            pulumi.set(__self__, "analysis_filter", analysis_filter)
        if analysis_normalizer is not None:
            pulumi.set(__self__, "analysis_normalizer", analysis_normalizer)
        if analysis_tokenizer is not None:
            pulumi.set(__self__, "analysis_tokenizer", analysis_tokenizer)
        if analyze_max_token_count is not None:
            pulumi.set(__self__, "analyze_max_token_count", analyze_max_token_count)
        if auto_expand_replicas is not None:
            pulumi.set(__self__, "auto_expand_replicas", auto_expand_replicas)
        if blocks_metadata is not None:
            pulumi.set(__self__, "blocks_metadata", blocks_metadata)
        if blocks_read is not None:
            pulumi.set(__self__, "blocks_read", blocks_read)
        if blocks_read_only is not None:
            pulumi.set(__self__, "blocks_read_only", blocks_read_only)
        if blocks_read_only_allow_delete is not None:
            pulumi.set(__self__, "blocks_read_only_allow_delete", blocks_read_only_allow_delete)
        if blocks_write is not None:
            pulumi.set(__self__, "blocks_write", blocks_write)
        if codec is not None:
            pulumi.set(__self__, "codec", codec)
        if default_pipeline is not None:
            pulumi.set(__self__, "default_pipeline", default_pipeline)
        if elasticsearch_connection is not None:
            pulumi.set(__self__, "elasticsearch_connection", elasticsearch_connection)
        if final_pipeline is not None:
            pulumi.set(__self__, "final_pipeline", final_pipeline)
        if gc_deletes is not None:
            pulumi.set(__self__, "gc_deletes", gc_deletes)
        if highlight_max_analyzed_offset is not None:
            pulumi.set(__self__, "highlight_max_analyzed_offset", highlight_max_analyzed_offset)
        if indexing_slowlog_level is not None:
            pulumi.set(__self__, "indexing_slowlog_level", indexing_slowlog_level)
        if indexing_slowlog_source is not None:
            pulumi.set(__self__, "indexing_slowlog_source", indexing_slowlog_source)
        if indexing_slowlog_threshold_index_debug is not None:
            pulumi.set(__self__, "indexing_slowlog_threshold_index_debug", indexing_slowlog_threshold_index_debug)
        if indexing_slowlog_threshold_index_info is not None:
            pulumi.set(__self__, "indexing_slowlog_threshold_index_info", indexing_slowlog_threshold_index_info)
        if indexing_slowlog_threshold_index_trace is not None:
            pulumi.set(__self__, "indexing_slowlog_threshold_index_trace", indexing_slowlog_threshold_index_trace)
        if indexing_slowlog_threshold_index_warn is not None:
            pulumi.set(__self__, "indexing_slowlog_threshold_index_warn", indexing_slowlog_threshold_index_warn)
        if load_fixed_bitset_filters_eagerly is not None:
            pulumi.set(__self__, "load_fixed_bitset_filters_eagerly", load_fixed_bitset_filters_eagerly)
        if mappings is not None:
            pulumi.set(__self__, "mappings", mappings)
        if max_docvalue_fields_search is not None:
            pulumi.set(__self__, "max_docvalue_fields_search", max_docvalue_fields_search)
        if max_inner_result_window is not None:
            pulumi.set(__self__, "max_inner_result_window", max_inner_result_window)
        if max_ngram_diff is not None:
            pulumi.set(__self__, "max_ngram_diff", max_ngram_diff)
        if max_refresh_listeners is not None:
            pulumi.set(__self__, "max_refresh_listeners", max_refresh_listeners)
        if max_regex_length is not None:
            pulumi.set(__self__, "max_regex_length", max_regex_length)
        if max_rescore_window is not None:
            pulumi.set(__self__, "max_rescore_window", max_rescore_window)
        if max_result_window is not None:
            pulumi.set(__self__, "max_result_window", max_result_window)
        if max_script_fields is not None:
            pulumi.set(__self__, "max_script_fields", max_script_fields)
        if max_shingle_diff is not None:
            pulumi.set(__self__, "max_shingle_diff", max_shingle_diff)
        if max_terms_count is not None:
            pulumi.set(__self__, "max_terms_count", max_terms_count)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if number_of_replicas is not None:
            pulumi.set(__self__, "number_of_replicas", number_of_replicas)
        if number_of_routing_shards is not None:
            pulumi.set(__self__, "number_of_routing_shards", number_of_routing_shards)
        if number_of_shards is not None:
            pulumi.set(__self__, "number_of_shards", number_of_shards)
        if query_default_fields is not None:
            pulumi.set(__self__, "query_default_fields", query_default_fields)
        if refresh_interval is not None:
            pulumi.set(__self__, "refresh_interval", refresh_interval)
        if routing_allocation_enable is not None:
            pulumi.set(__self__, "routing_allocation_enable", routing_allocation_enable)
        if routing_partition_size is not None:
            pulumi.set(__self__, "routing_partition_size", routing_partition_size)
        if routing_rebalance_enable is not None:
            pulumi.set(__self__, "routing_rebalance_enable", routing_rebalance_enable)
        if search_idle_after is not None:
            pulumi.set(__self__, "search_idle_after", search_idle_after)
        if search_slowlog_level is not None:
            pulumi.set(__self__, "search_slowlog_level", search_slowlog_level)
        if search_slowlog_threshold_fetch_debug is not None:
            pulumi.set(__self__, "search_slowlog_threshold_fetch_debug", search_slowlog_threshold_fetch_debug)
        if search_slowlog_threshold_fetch_info is not None:
            pulumi.set(__self__, "search_slowlog_threshold_fetch_info", search_slowlog_threshold_fetch_info)
        if search_slowlog_threshold_fetch_trace is not None:
            pulumi.set(__self__, "search_slowlog_threshold_fetch_trace", search_slowlog_threshold_fetch_trace)
        if search_slowlog_threshold_fetch_warn is not None:
            pulumi.set(__self__, "search_slowlog_threshold_fetch_warn", search_slowlog_threshold_fetch_warn)
        if search_slowlog_threshold_query_debug is not None:
            pulumi.set(__self__, "search_slowlog_threshold_query_debug", search_slowlog_threshold_query_debug)
        if search_slowlog_threshold_query_info is not None:
            pulumi.set(__self__, "search_slowlog_threshold_query_info", search_slowlog_threshold_query_info)
        if search_slowlog_threshold_query_trace is not None:
            pulumi.set(__self__, "search_slowlog_threshold_query_trace", search_slowlog_threshold_query_trace)
        if search_slowlog_threshold_query_warn is not None:
            pulumi.set(__self__, "search_slowlog_threshold_query_warn", search_slowlog_threshold_query_warn)
        if settings is not None:
            warnings.warn("""Using settings makes it easier to misconfigure.  Use dedicated field for the each setting instead.""", DeprecationWarning)
            pulumi.log.warn("""settings is deprecated: Using settings makes it easier to misconfigure.  Use dedicated field for the each setting instead.""")
        if settings is not None:
            pulumi.set(__self__, "settings", settings)
        if settings_raw is not None:
            pulumi.set(__self__, "settings_raw", settings_raw)
        if shard_check_on_startup is not None:
            pulumi.set(__self__, "shard_check_on_startup", shard_check_on_startup)
        if sort_fields is not None:
            pulumi.set(__self__, "sort_fields", sort_fields)
        if sort_orders is not None:
            pulumi.set(__self__, "sort_orders", sort_orders)
        if unassigned_node_left_delayed_timeout is not None:
            pulumi.set(__self__, "unassigned_node_left_delayed_timeout", unassigned_node_left_delayed_timeout)

    @property
    @pulumi.getter
    def aliases(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['IndexAliasArgs']]]]:
        """
        Aliases for the index.
        """
        return pulumi.get(self, "aliases")

    @aliases.setter
    def aliases(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['IndexAliasArgs']]]]):
        pulumi.set(self, "aliases", value)

    @property
    @pulumi.getter(name="analysisAnalyzer")
    def analysis_analyzer(self) -> Optional[pulumi.Input[str]]:
        """
        A JSON string describing the analyzers applied to the index.
        """
        return pulumi.get(self, "analysis_analyzer")

    @analysis_analyzer.setter
    def analysis_analyzer(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "analysis_analyzer", value)

    @property
    @pulumi.getter(name="analysisCharFilter")
    def analysis_char_filter(self) -> Optional[pulumi.Input[str]]:
        """
        A JSON string describing the char_filters applied to the index.
        """
        return pulumi.get(self, "analysis_char_filter")

    @analysis_char_filter.setter
    def analysis_char_filter(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "analysis_char_filter", value)

    @property
    @pulumi.getter(name="analysisFilter")
    def analysis_filter(self) -> Optional[pulumi.Input[str]]:
        """
        A JSON string describing the filters applied to the index.
        """
        return pulumi.get(self, "analysis_filter")

    @analysis_filter.setter
    def analysis_filter(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "analysis_filter", value)

    @property
    @pulumi.getter(name="analysisNormalizer")
    def analysis_normalizer(self) -> Optional[pulumi.Input[str]]:
        """
        A JSON string describing the normalizers applied to the index.
        """
        return pulumi.get(self, "analysis_normalizer")

    @analysis_normalizer.setter
    def analysis_normalizer(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "analysis_normalizer", value)

    @property
    @pulumi.getter(name="analysisTokenizer")
    def analysis_tokenizer(self) -> Optional[pulumi.Input[str]]:
        """
        A JSON string describing the tokenizers applied to the index.
        """
        return pulumi.get(self, "analysis_tokenizer")

    @analysis_tokenizer.setter
    def analysis_tokenizer(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "analysis_tokenizer", value)

    @property
    @pulumi.getter(name="analyzeMaxTokenCount")
    def analyze_max_token_count(self) -> Optional[pulumi.Input[int]]:
        """
        The maximum number of tokens that can be produced using _analyze API.
        """
        return pulumi.get(self, "analyze_max_token_count")

    @analyze_max_token_count.setter
    def analyze_max_token_count(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "analyze_max_token_count", value)

    @property
    @pulumi.getter(name="autoExpandReplicas")
    def auto_expand_replicas(self) -> Optional[pulumi.Input[str]]:
        """
        Set the number of replicas to the node count in the cluster. Set to a dash delimited lower and upper bound (e.g. 0-5) or use all for the upper bound (e.g. 0-all)
        """
        return pulumi.get(self, "auto_expand_replicas")

    @auto_expand_replicas.setter
    def auto_expand_replicas(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "auto_expand_replicas", value)

    @property
    @pulumi.getter(name="blocksMetadata")
    def blocks_metadata(self) -> Optional[pulumi.Input[bool]]:
        """
        Set to `true` to disable index metadata reads and writes.
        """
        return pulumi.get(self, "blocks_metadata")

    @blocks_metadata.setter
    def blocks_metadata(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "blocks_metadata", value)

    @property
    @pulumi.getter(name="blocksRead")
    def blocks_read(self) -> Optional[pulumi.Input[bool]]:
        """
        Set to `true` to disable read operations against the index.
        """
        return pulumi.get(self, "blocks_read")

    @blocks_read.setter
    def blocks_read(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "blocks_read", value)

    @property
    @pulumi.getter(name="blocksReadOnly")
    def blocks_read_only(self) -> Optional[pulumi.Input[bool]]:
        """
        Set to `true` to make the index and index metadata read only, `false` to allow writes and metadata changes.
        """
        return pulumi.get(self, "blocks_read_only")

    @blocks_read_only.setter
    def blocks_read_only(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "blocks_read_only", value)

    @property
    @pulumi.getter(name="blocksReadOnlyAllowDelete")
    def blocks_read_only_allow_delete(self) -> Optional[pulumi.Input[bool]]:
        """
        Identical to `index.blocks.read_only` but allows deleting the index to free up resources.
        """
        return pulumi.get(self, "blocks_read_only_allow_delete")

    @blocks_read_only_allow_delete.setter
    def blocks_read_only_allow_delete(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "blocks_read_only_allow_delete", value)

    @property
    @pulumi.getter(name="blocksWrite")
    def blocks_write(self) -> Optional[pulumi.Input[bool]]:
        """
        Set to `true` to disable data write operations against the index. This setting does not affect metadata.
        """
        return pulumi.get(self, "blocks_write")

    @blocks_write.setter
    def blocks_write(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "blocks_write", value)

    @property
    @pulumi.getter
    def codec(self) -> Optional[pulumi.Input[str]]:
        """
        The `default` value compresses stored data with LZ4 compression, but this can be set to `best_compression` which uses DEFLATE for a higher compression ratio. This can be set only on creation.
        """
        return pulumi.get(self, "codec")

    @codec.setter
    def codec(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "codec", value)

    @property
    @pulumi.getter(name="defaultPipeline")
    def default_pipeline(self) -> Optional[pulumi.Input[str]]:
        """
        The default ingest node pipeline for this index. Index requests will fail if the default pipeline is set and the pipeline does not exist.
        """
        return pulumi.get(self, "default_pipeline")

    @default_pipeline.setter
    def default_pipeline(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "default_pipeline", value)

    @property
    @pulumi.getter(name="elasticsearchConnection")
    def elasticsearch_connection(self) -> Optional[pulumi.Input['IndexElasticsearchConnectionArgs']]:
        """
        Elasticsearch connection configuration block.
        """
        return pulumi.get(self, "elasticsearch_connection")

    @elasticsearch_connection.setter
    def elasticsearch_connection(self, value: Optional[pulumi.Input['IndexElasticsearchConnectionArgs']]):
        pulumi.set(self, "elasticsearch_connection", value)

    @property
    @pulumi.getter(name="finalPipeline")
    def final_pipeline(self) -> Optional[pulumi.Input[str]]:
        """
        Final ingest pipeline for the index. Indexing requests will fail if the final pipeline is set and the pipeline does not exist. The final pipeline always runs after the request pipeline (if specified) and the default pipeline (if it exists). The special pipeline name _none indicates no ingest pipeline will run.
        """
        return pulumi.get(self, "final_pipeline")

    @final_pipeline.setter
    def final_pipeline(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "final_pipeline", value)

    @property
    @pulumi.getter(name="gcDeletes")
    def gc_deletes(self) -> Optional[pulumi.Input[str]]:
        """
        The length of time that a deleted document's version number remains available for further versioned operations.
        """
        return pulumi.get(self, "gc_deletes")

    @gc_deletes.setter
    def gc_deletes(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "gc_deletes", value)

    @property
    @pulumi.getter(name="highlightMaxAnalyzedOffset")
    def highlight_max_analyzed_offset(self) -> Optional[pulumi.Input[int]]:
        """
        The maximum number of characters that will be analyzed for a highlight request.
        """
        return pulumi.get(self, "highlight_max_analyzed_offset")

    @highlight_max_analyzed_offset.setter
    def highlight_max_analyzed_offset(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "highlight_max_analyzed_offset", value)

    @property
    @pulumi.getter(name="indexingSlowlogLevel")
    def indexing_slowlog_level(self) -> Optional[pulumi.Input[str]]:
        """
        Set which logging level to use for the search slow log, can be: `warn`, `info`, `debug`, `trace`
        """
        return pulumi.get(self, "indexing_slowlog_level")

    @indexing_slowlog_level.setter
    def indexing_slowlog_level(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "indexing_slowlog_level", value)

    @property
    @pulumi.getter(name="indexingSlowlogSource")
    def indexing_slowlog_source(self) -> Optional[pulumi.Input[str]]:
        """
        Set the number of characters of the `_source` to include in the slowlog lines, `false` or `0` will skip logging the source entirely and setting it to `true` will log the entire source regardless of size. The original `_source` is reformatted by default to make sure that it fits on a single log line.
        """
        return pulumi.get(self, "indexing_slowlog_source")

    @indexing_slowlog_source.setter
    def indexing_slowlog_source(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "indexing_slowlog_source", value)

    @property
    @pulumi.getter(name="indexingSlowlogThresholdIndexDebug")
    def indexing_slowlog_threshold_index_debug(self) -> Optional[pulumi.Input[str]]:
        """
        Set the cutoff for shard level slow search logging of slow searches for indexing queries, in time units, e.g. `2s`
        """
        return pulumi.get(self, "indexing_slowlog_threshold_index_debug")

    @indexing_slowlog_threshold_index_debug.setter
    def indexing_slowlog_threshold_index_debug(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "indexing_slowlog_threshold_index_debug", value)

    @property
    @pulumi.getter(name="indexingSlowlogThresholdIndexInfo")
    def indexing_slowlog_threshold_index_info(self) -> Optional[pulumi.Input[str]]:
        """
        Set the cutoff for shard level slow search logging of slow searches for indexing queries, in time units, e.g. `5s`
        """
        return pulumi.get(self, "indexing_slowlog_threshold_index_info")

    @indexing_slowlog_threshold_index_info.setter
    def indexing_slowlog_threshold_index_info(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "indexing_slowlog_threshold_index_info", value)

    @property
    @pulumi.getter(name="indexingSlowlogThresholdIndexTrace")
    def indexing_slowlog_threshold_index_trace(self) -> Optional[pulumi.Input[str]]:
        """
        Set the cutoff for shard level slow search logging of slow searches for indexing queries, in time units, e.g. `500ms`
        """
        return pulumi.get(self, "indexing_slowlog_threshold_index_trace")

    @indexing_slowlog_threshold_index_trace.setter
    def indexing_slowlog_threshold_index_trace(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "indexing_slowlog_threshold_index_trace", value)

    @property
    @pulumi.getter(name="indexingSlowlogThresholdIndexWarn")
    def indexing_slowlog_threshold_index_warn(self) -> Optional[pulumi.Input[str]]:
        """
        Set the cutoff for shard level slow search logging of slow searches for indexing queries, in time units, e.g. `10s`
        """
        return pulumi.get(self, "indexing_slowlog_threshold_index_warn")

    @indexing_slowlog_threshold_index_warn.setter
    def indexing_slowlog_threshold_index_warn(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "indexing_slowlog_threshold_index_warn", value)

    @property
    @pulumi.getter(name="loadFixedBitsetFiltersEagerly")
    def load_fixed_bitset_filters_eagerly(self) -> Optional[pulumi.Input[bool]]:
        """
        Indicates whether cached filters are pre-loaded for nested queries. This can be set only on creation.
        """
        return pulumi.get(self, "load_fixed_bitset_filters_eagerly")

    @load_fixed_bitset_filters_eagerly.setter
    def load_fixed_bitset_filters_eagerly(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "load_fixed_bitset_filters_eagerly", value)

    @property
    @pulumi.getter
    def mappings(self) -> Optional[pulumi.Input[str]]:
        """
        Mapping for fields in the index.
        If specified, this mapping can include: field names, [field data types](https://www.elastic.co/guide/en/elasticsearch/reference/current/mapping-types.html), [mapping parameters](https://www.elastic.co/guide/en/elasticsearch/reference/current/mapping-params.html).
        **NOTE:** changing datatypes in the existing *mappings* will force index to be re-created.
        """
        return pulumi.get(self, "mappings")

    @mappings.setter
    def mappings(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "mappings", value)

    @property
    @pulumi.getter(name="maxDocvalueFieldsSearch")
    def max_docvalue_fields_search(self) -> Optional[pulumi.Input[int]]:
        """
        The maximum number of `docvalue_fields` that are allowed in a query.
        """
        return pulumi.get(self, "max_docvalue_fields_search")

    @max_docvalue_fields_search.setter
    def max_docvalue_fields_search(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "max_docvalue_fields_search", value)

    @property
    @pulumi.getter(name="maxInnerResultWindow")
    def max_inner_result_window(self) -> Optional[pulumi.Input[int]]:
        """
        The maximum value of `from + size` for inner hits definition and top hits aggregations to this index.
        """
        return pulumi.get(self, "max_inner_result_window")

    @max_inner_result_window.setter
    def max_inner_result_window(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "max_inner_result_window", value)

    @property
    @pulumi.getter(name="maxNgramDiff")
    def max_ngram_diff(self) -> Optional[pulumi.Input[int]]:
        """
        The maximum allowed difference between min*gram and max*gram for NGramTokenizer and NGramTokenFilter.
        """
        return pulumi.get(self, "max_ngram_diff")

    @max_ngram_diff.setter
    def max_ngram_diff(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "max_ngram_diff", value)

    @property
    @pulumi.getter(name="maxRefreshListeners")
    def max_refresh_listeners(self) -> Optional[pulumi.Input[int]]:
        """
        Maximum number of refresh listeners available on each shard of the index.
        """
        return pulumi.get(self, "max_refresh_listeners")

    @max_refresh_listeners.setter
    def max_refresh_listeners(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "max_refresh_listeners", value)

    @property
    @pulumi.getter(name="maxRegexLength")
    def max_regex_length(self) -> Optional[pulumi.Input[int]]:
        """
        The maximum length of regex that can be used in Regexp Query.
        """
        return pulumi.get(self, "max_regex_length")

    @max_regex_length.setter
    def max_regex_length(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "max_regex_length", value)

    @property
    @pulumi.getter(name="maxRescoreWindow")
    def max_rescore_window(self) -> Optional[pulumi.Input[int]]:
        """
        The maximum value of `window_size` for `rescore` requests in searches of this index.
        """
        return pulumi.get(self, "max_rescore_window")

    @max_rescore_window.setter
    def max_rescore_window(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "max_rescore_window", value)

    @property
    @pulumi.getter(name="maxResultWindow")
    def max_result_window(self) -> Optional[pulumi.Input[int]]:
        """
        The maximum value of `from + size` for searches to this index.
        """
        return pulumi.get(self, "max_result_window")

    @max_result_window.setter
    def max_result_window(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "max_result_window", value)

    @property
    @pulumi.getter(name="maxScriptFields")
    def max_script_fields(self) -> Optional[pulumi.Input[int]]:
        """
        The maximum number of `script_fields` that are allowed in a query.
        """
        return pulumi.get(self, "max_script_fields")

    @max_script_fields.setter
    def max_script_fields(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "max_script_fields", value)

    @property
    @pulumi.getter(name="maxShingleDiff")
    def max_shingle_diff(self) -> Optional[pulumi.Input[int]]:
        """
        The maximum allowed difference between max*shingle*size and min*shingle*size for ShingleTokenFilter.
        """
        return pulumi.get(self, "max_shingle_diff")

    @max_shingle_diff.setter
    def max_shingle_diff(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "max_shingle_diff", value)

    @property
    @pulumi.getter(name="maxTermsCount")
    def max_terms_count(self) -> Optional[pulumi.Input[int]]:
        """
        The maximum number of terms that can be used in Terms Query.
        """
        return pulumi.get(self, "max_terms_count")

    @max_terms_count.setter
    def max_terms_count(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "max_terms_count", value)

    @property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[str]]:
        """
        Name of the index you wish to create.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "name", value)

    @property
    @pulumi.getter(name="numberOfReplicas")
    def number_of_replicas(self) -> Optional[pulumi.Input[int]]:
        """
        Number of shard replicas.
        """
        return pulumi.get(self, "number_of_replicas")

    @number_of_replicas.setter
    def number_of_replicas(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "number_of_replicas", value)

    @property
    @pulumi.getter(name="numberOfRoutingShards")
    def number_of_routing_shards(self) -> Optional[pulumi.Input[int]]:
        """
        Value used with number*of*shards to route documents to a primary shard. This can be set only on creation.
        """
        return pulumi.get(self, "number_of_routing_shards")

    @number_of_routing_shards.setter
    def number_of_routing_shards(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "number_of_routing_shards", value)

    @property
    @pulumi.getter(name="numberOfShards")
    def number_of_shards(self) -> Optional[pulumi.Input[int]]:
        """
        Number of shards for the index. This can be set only on creation.
        """
        return pulumi.get(self, "number_of_shards")

    @number_of_shards.setter
    def number_of_shards(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "number_of_shards", value)

    @property
    @pulumi.getter(name="queryDefaultFields")
    def query_default_fields(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]:
        """
        Wildcard (*) patterns matching one or more fields. Defaults to '*', which matches all fields eligible for term-level queries, excluding metadata fields.
        """
        return pulumi.get(self, "query_default_fields")

    @query_default_fields.setter
    def query_default_fields(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]):
        pulumi.set(self, "query_default_fields", value)

    @property
    @pulumi.getter(name="refreshInterval")
    def refresh_interval(self) -> Optional[pulumi.Input[str]]:
        """
        How often to perform a refresh operation, which makes recent changes to the index visible to search. Can be set to `-1` to disable refresh.
        """
        return pulumi.get(self, "refresh_interval")

    @refresh_interval.setter
    def refresh_interval(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "refresh_interval", value)

    @property
    @pulumi.getter(name="routingAllocationEnable")
    def routing_allocation_enable(self) -> Optional[pulumi.Input[str]]:
        """
        Controls shard allocation for this index. It can be set to: `all` , `primaries` , `new_primaries` , `none`.
        """
        return pulumi.get(self, "routing_allocation_enable")

    @routing_allocation_enable.setter
    def routing_allocation_enable(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "routing_allocation_enable", value)

    @property
    @pulumi.getter(name="routingPartitionSize")
    def routing_partition_size(self) -> Optional[pulumi.Input[int]]:
        """
        The number of shards a custom routing value can go to. This can be set only on creation.
        """
        return pulumi.get(self, "routing_partition_size")

    @routing_partition_size.setter
    def routing_partition_size(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "routing_partition_size", value)

    @property
    @pulumi.getter(name="routingRebalanceEnable")
    def routing_rebalance_enable(self) -> Optional[pulumi.Input[str]]:
        """
        Enables shard rebalancing for this index. It can be set to: `all`, `primaries` , `replicas` , `none`.
        """
        return pulumi.get(self, "routing_rebalance_enable")

    @routing_rebalance_enable.setter
    def routing_rebalance_enable(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "routing_rebalance_enable", value)

    @property
    @pulumi.getter(name="searchIdleAfter")
    def search_idle_after(self) -> Optional[pulumi.Input[str]]:
        """
        How long a shard can not receive a search or get request until it’s considered search idle.
        """
        return pulumi.get(self, "search_idle_after")

    @search_idle_after.setter
    def search_idle_after(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "search_idle_after", value)

    @property
    @pulumi.getter(name="searchSlowlogLevel")
    def search_slowlog_level(self) -> Optional[pulumi.Input[str]]:
        """
        Set which logging level to use for the search slow log, can be: `warn`, `info`, `debug`, `trace`
        """
        return pulumi.get(self, "search_slowlog_level")

    @search_slowlog_level.setter
    def search_slowlog_level(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "search_slowlog_level", value)

    @property
    @pulumi.getter(name="searchSlowlogThresholdFetchDebug")
    def search_slowlog_threshold_fetch_debug(self) -> Optional[pulumi.Input[str]]:
        """
        Set the cutoff for shard level slow search logging of slow searches in the fetch phase, in time units, e.g. `2s`
        """
        return pulumi.get(self, "search_slowlog_threshold_fetch_debug")

    @search_slowlog_threshold_fetch_debug.setter
    def search_slowlog_threshold_fetch_debug(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "search_slowlog_threshold_fetch_debug", value)

    @property
    @pulumi.getter(name="searchSlowlogThresholdFetchInfo")
    def search_slowlog_threshold_fetch_info(self) -> Optional[pulumi.Input[str]]:
        """
        Set the cutoff for shard level slow search logging of slow searches in the fetch phase, in time units, e.g. `5s`
        """
        return pulumi.get(self, "search_slowlog_threshold_fetch_info")

    @search_slowlog_threshold_fetch_info.setter
    def search_slowlog_threshold_fetch_info(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "search_slowlog_threshold_fetch_info", value)

    @property
    @pulumi.getter(name="searchSlowlogThresholdFetchTrace")
    def search_slowlog_threshold_fetch_trace(self) -> Optional[pulumi.Input[str]]:
        """
        Set the cutoff for shard level slow search logging of slow searches in the fetch phase, in time units, e.g. `500ms`
        """
        return pulumi.get(self, "search_slowlog_threshold_fetch_trace")

    @search_slowlog_threshold_fetch_trace.setter
    def search_slowlog_threshold_fetch_trace(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "search_slowlog_threshold_fetch_trace", value)

    @property
    @pulumi.getter(name="searchSlowlogThresholdFetchWarn")
    def search_slowlog_threshold_fetch_warn(self) -> Optional[pulumi.Input[str]]:
        """
        Set the cutoff for shard level slow search logging of slow searches in the fetch phase, in time units, e.g. `10s`
        """
        return pulumi.get(self, "search_slowlog_threshold_fetch_warn")

    @search_slowlog_threshold_fetch_warn.setter
    def search_slowlog_threshold_fetch_warn(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "search_slowlog_threshold_fetch_warn", value)

    @property
    @pulumi.getter(name="searchSlowlogThresholdQueryDebug")
    def search_slowlog_threshold_query_debug(self) -> Optional[pulumi.Input[str]]:
        """
        Set the cutoff for shard level slow search logging of slow searches in the query phase, in time units, e.g. `2s`
        """
        return pulumi.get(self, "search_slowlog_threshold_query_debug")

    @search_slowlog_threshold_query_debug.setter
    def search_slowlog_threshold_query_debug(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "search_slowlog_threshold_query_debug", value)

    @property
    @pulumi.getter(name="searchSlowlogThresholdQueryInfo")
    def search_slowlog_threshold_query_info(self) -> Optional[pulumi.Input[str]]:
        """
        Set the cutoff for shard level slow search logging of slow searches in the query phase, in time units, e.g. `5s`
        """
        return pulumi.get(self, "search_slowlog_threshold_query_info")

    @search_slowlog_threshold_query_info.setter
    def search_slowlog_threshold_query_info(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "search_slowlog_threshold_query_info", value)

    @property
    @pulumi.getter(name="searchSlowlogThresholdQueryTrace")
    def search_slowlog_threshold_query_trace(self) -> Optional[pulumi.Input[str]]:
        """
        Set the cutoff for shard level slow search logging of slow searches in the query phase, in time units, e.g. `500ms`
        """
        return pulumi.get(self, "search_slowlog_threshold_query_trace")

    @search_slowlog_threshold_query_trace.setter
    def search_slowlog_threshold_query_trace(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "search_slowlog_threshold_query_trace", value)

    @property
    @pulumi.getter(name="searchSlowlogThresholdQueryWarn")
    def search_slowlog_threshold_query_warn(self) -> Optional[pulumi.Input[str]]:
        """
        Set the cutoff for shard level slow search logging of slow searches in the query phase, in time units, e.g. `10s`
        """
        return pulumi.get(self, "search_slowlog_threshold_query_warn")

    @search_slowlog_threshold_query_warn.setter
    def search_slowlog_threshold_query_warn(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "search_slowlog_threshold_query_warn", value)

    @property
    @pulumi.getter
    def settings(self) -> Optional[pulumi.Input['IndexSettingsArgs']]:
        """
        DEPRECATED: Please use dedicated setting field. Configuration options for the index. See, https://www.elastic.co/guide/en/elasticsearch/reference/current/index-modules.html#index-modules-settings.
        **NOTE:** Static index settings (see: https://www.elastic.co/guide/en/elasticsearch/reference/current/index-modules.html#*static*index_settings) can be only set on the index creation and later cannot be removed or updated - *apply* will return error
        """
        return pulumi.get(self, "settings")

    @settings.setter
    def settings(self, value: Optional[pulumi.Input['IndexSettingsArgs']]):
        pulumi.set(self, "settings", value)

    @property
    @pulumi.getter(name="settingsRaw")
    def settings_raw(self) -> Optional[pulumi.Input[str]]:
        """
        All raw settings fetched from the cluster.
        """
        return pulumi.get(self, "settings_raw")

    @settings_raw.setter
    def settings_raw(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "settings_raw", value)

    @property
    @pulumi.getter(name="shardCheckOnStartup")
    def shard_check_on_startup(self) -> Optional[pulumi.Input[str]]:
        """
        Whether or not shards should be checked for corruption before opening. When corruption is detected, it will prevent the shard from being opened. Accepts `false`, `true`, `checksum`.
        """
        return pulumi.get(self, "shard_check_on_startup")

    @shard_check_on_startup.setter
    def shard_check_on_startup(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "shard_check_on_startup", value)

    @property
    @pulumi.getter(name="sortFields")
    def sort_fields(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]:
        """
        The field to sort shards in this index by.
        """
        return pulumi.get(self, "sort_fields")

    @sort_fields.setter
    def sort_fields(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]):
        pulumi.set(self, "sort_fields", value)

    @property
    @pulumi.getter(name="sortOrders")
    def sort_orders(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]:
        """
        The direction to sort shards in. Accepts `asc`, `desc`.
        """
        return pulumi.get(self, "sort_orders")

    @sort_orders.setter
    def sort_orders(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]):
        pulumi.set(self, "sort_orders", value)

    @property
    @pulumi.getter(name="unassignedNodeLeftDelayedTimeout")
    def unassigned_node_left_delayed_timeout(self) -> Optional[pulumi.Input[str]]:
        """
        Time to delay the allocation of replica shards which become unassigned because a node has left, in time units, e.g. `10s`
        """
        return pulumi.get(self, "unassigned_node_left_delayed_timeout")

    @unassigned_node_left_delayed_timeout.setter
    def unassigned_node_left_delayed_timeout(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "unassigned_node_left_delayed_timeout", value)


class Index(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 aliases: Optional[pulumi.Input[Sequence[pulumi.Input[pulumi.InputType['IndexAliasArgs']]]]] = None,
                 analysis_analyzer: Optional[pulumi.Input[str]] = None,
                 analysis_char_filter: Optional[pulumi.Input[str]] = None,
                 analysis_filter: Optional[pulumi.Input[str]] = None,
                 analysis_normalizer: Optional[pulumi.Input[str]] = None,
                 analysis_tokenizer: Optional[pulumi.Input[str]] = None,
                 analyze_max_token_count: Optional[pulumi.Input[int]] = None,
                 auto_expand_replicas: Optional[pulumi.Input[str]] = None,
                 blocks_metadata: Optional[pulumi.Input[bool]] = None,
                 blocks_read: Optional[pulumi.Input[bool]] = None,
                 blocks_read_only: Optional[pulumi.Input[bool]] = None,
                 blocks_read_only_allow_delete: Optional[pulumi.Input[bool]] = None,
                 blocks_write: Optional[pulumi.Input[bool]] = None,
                 codec: Optional[pulumi.Input[str]] = None,
                 default_pipeline: Optional[pulumi.Input[str]] = None,
                 elasticsearch_connection: Optional[pulumi.Input[pulumi.InputType['IndexElasticsearchConnectionArgs']]] = None,
                 final_pipeline: Optional[pulumi.Input[str]] = None,
                 gc_deletes: Optional[pulumi.Input[str]] = None,
                 highlight_max_analyzed_offset: Optional[pulumi.Input[int]] = None,
                 indexing_slowlog_level: Optional[pulumi.Input[str]] = None,
                 indexing_slowlog_source: Optional[pulumi.Input[str]] = None,
                 indexing_slowlog_threshold_index_debug: Optional[pulumi.Input[str]] = None,
                 indexing_slowlog_threshold_index_info: Optional[pulumi.Input[str]] = None,
                 indexing_slowlog_threshold_index_trace: Optional[pulumi.Input[str]] = None,
                 indexing_slowlog_threshold_index_warn: Optional[pulumi.Input[str]] = None,
                 load_fixed_bitset_filters_eagerly: Optional[pulumi.Input[bool]] = None,
                 mappings: Optional[pulumi.Input[str]] = None,
                 max_docvalue_fields_search: Optional[pulumi.Input[int]] = None,
                 max_inner_result_window: Optional[pulumi.Input[int]] = None,
                 max_ngram_diff: Optional[pulumi.Input[int]] = None,
                 max_refresh_listeners: Optional[pulumi.Input[int]] = None,
                 max_regex_length: Optional[pulumi.Input[int]] = None,
                 max_rescore_window: Optional[pulumi.Input[int]] = None,
                 max_result_window: Optional[pulumi.Input[int]] = None,
                 max_script_fields: Optional[pulumi.Input[int]] = None,
                 max_shingle_diff: Optional[pulumi.Input[int]] = None,
                 max_terms_count: Optional[pulumi.Input[int]] = None,
                 name: Optional[pulumi.Input[str]] = None,
                 number_of_replicas: Optional[pulumi.Input[int]] = None,
                 number_of_routing_shards: Optional[pulumi.Input[int]] = None,
                 number_of_shards: Optional[pulumi.Input[int]] = None,
                 query_default_fields: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 refresh_interval: Optional[pulumi.Input[str]] = None,
                 routing_allocation_enable: Optional[pulumi.Input[str]] = None,
                 routing_partition_size: Optional[pulumi.Input[int]] = None,
                 routing_rebalance_enable: Optional[pulumi.Input[str]] = None,
                 search_idle_after: Optional[pulumi.Input[str]] = None,
                 search_slowlog_level: Optional[pulumi.Input[str]] = None,
                 search_slowlog_threshold_fetch_debug: Optional[pulumi.Input[str]] = None,
                 search_slowlog_threshold_fetch_info: Optional[pulumi.Input[str]] = None,
                 search_slowlog_threshold_fetch_trace: Optional[pulumi.Input[str]] = None,
                 search_slowlog_threshold_fetch_warn: Optional[pulumi.Input[str]] = None,
                 search_slowlog_threshold_query_debug: Optional[pulumi.Input[str]] = None,
                 search_slowlog_threshold_query_info: Optional[pulumi.Input[str]] = None,
                 search_slowlog_threshold_query_trace: Optional[pulumi.Input[str]] = None,
                 search_slowlog_threshold_query_warn: Optional[pulumi.Input[str]] = None,
                 settings: Optional[pulumi.Input[pulumi.InputType['IndexSettingsArgs']]] = None,
                 shard_check_on_startup: Optional[pulumi.Input[str]] = None,
                 sort_fields: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 sort_orders: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 unassigned_node_left_delayed_timeout: Optional[pulumi.Input[str]] = None,
                 __props__=None):
        """
        Creates or updates an index. This resource can define settings, mappings and aliases. See: https://www.elastic.co/guide/en/elasticsearch/reference/current/indices-create-index.html

        ## Import

        You can later adjust the index configuration to account for those imported settings. Some of the default settings, which could be imported are`index.number_of_replicas`, `index.number_of_shards` and `index.routing.allocation.include._tier_preference`. NOTEwhile importing index resource, keep in mind, that some of the default index settings will be imported into the TF state too You can later adjust the index configuration to account for those imported settings

        ```sh
         $ pulumi import elasticstack:index/index:Index my_index <cluster_uuid>/<index_name>
        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[Sequence[pulumi.Input[pulumi.InputType['IndexAliasArgs']]]] aliases: Aliases for the index.
        :param pulumi.Input[str] analysis_analyzer: A JSON string describing the analyzers applied to the index.
        :param pulumi.Input[str] analysis_char_filter: A JSON string describing the char_filters applied to the index.
        :param pulumi.Input[str] analysis_filter: A JSON string describing the filters applied to the index.
        :param pulumi.Input[str] analysis_normalizer: A JSON string describing the normalizers applied to the index.
        :param pulumi.Input[str] analysis_tokenizer: A JSON string describing the tokenizers applied to the index.
        :param pulumi.Input[int] analyze_max_token_count: The maximum number of tokens that can be produced using _analyze API.
        :param pulumi.Input[str] auto_expand_replicas: Set the number of replicas to the node count in the cluster. Set to a dash delimited lower and upper bound (e.g. 0-5) or use all for the upper bound (e.g. 0-all)
        :param pulumi.Input[bool] blocks_metadata: Set to `true` to disable index metadata reads and writes.
        :param pulumi.Input[bool] blocks_read: Set to `true` to disable read operations against the index.
        :param pulumi.Input[bool] blocks_read_only: Set to `true` to make the index and index metadata read only, `false` to allow writes and metadata changes.
        :param pulumi.Input[bool] blocks_read_only_allow_delete: Identical to `index.blocks.read_only` but allows deleting the index to free up resources.
        :param pulumi.Input[bool] blocks_write: Set to `true` to disable data write operations against the index. This setting does not affect metadata.
        :param pulumi.Input[str] codec: The `default` value compresses stored data with LZ4 compression, but this can be set to `best_compression` which uses DEFLATE for a higher compression ratio. This can be set only on creation.
        :param pulumi.Input[str] default_pipeline: The default ingest node pipeline for this index. Index requests will fail if the default pipeline is set and the pipeline does not exist.
        :param pulumi.Input[pulumi.InputType['IndexElasticsearchConnectionArgs']] elasticsearch_connection: Elasticsearch connection configuration block.
        :param pulumi.Input[str] final_pipeline: Final ingest pipeline for the index. Indexing requests will fail if the final pipeline is set and the pipeline does not exist. The final pipeline always runs after the request pipeline (if specified) and the default pipeline (if it exists). The special pipeline name _none indicates no ingest pipeline will run.
        :param pulumi.Input[str] gc_deletes: The length of time that a deleted document's version number remains available for further versioned operations.
        :param pulumi.Input[int] highlight_max_analyzed_offset: The maximum number of characters that will be analyzed for a highlight request.
        :param pulumi.Input[str] indexing_slowlog_level: Set which logging level to use for the search slow log, can be: `warn`, `info`, `debug`, `trace`
        :param pulumi.Input[str] indexing_slowlog_source: Set the number of characters of the `_source` to include in the slowlog lines, `false` or `0` will skip logging the source entirely and setting it to `true` will log the entire source regardless of size. The original `_source` is reformatted by default to make sure that it fits on a single log line.
        :param pulumi.Input[str] indexing_slowlog_threshold_index_debug: Set the cutoff for shard level slow search logging of slow searches for indexing queries, in time units, e.g. `2s`
        :param pulumi.Input[str] indexing_slowlog_threshold_index_info: Set the cutoff for shard level slow search logging of slow searches for indexing queries, in time units, e.g. `5s`
        :param pulumi.Input[str] indexing_slowlog_threshold_index_trace: Set the cutoff for shard level slow search logging of slow searches for indexing queries, in time units, e.g. `500ms`
        :param pulumi.Input[str] indexing_slowlog_threshold_index_warn: Set the cutoff for shard level slow search logging of slow searches for indexing queries, in time units, e.g. `10s`
        :param pulumi.Input[bool] load_fixed_bitset_filters_eagerly: Indicates whether cached filters are pre-loaded for nested queries. This can be set only on creation.
        :param pulumi.Input[str] mappings: Mapping for fields in the index.
               If specified, this mapping can include: field names, [field data types](https://www.elastic.co/guide/en/elasticsearch/reference/current/mapping-types.html), [mapping parameters](https://www.elastic.co/guide/en/elasticsearch/reference/current/mapping-params.html).
               **NOTE:** changing datatypes in the existing *mappings* will force index to be re-created.
        :param pulumi.Input[int] max_docvalue_fields_search: The maximum number of `docvalue_fields` that are allowed in a query.
        :param pulumi.Input[int] max_inner_result_window: The maximum value of `from + size` for inner hits definition and top hits aggregations to this index.
        :param pulumi.Input[int] max_ngram_diff: The maximum allowed difference between min*gram and max*gram for NGramTokenizer and NGramTokenFilter.
        :param pulumi.Input[int] max_refresh_listeners: Maximum number of refresh listeners available on each shard of the index.
        :param pulumi.Input[int] max_regex_length: The maximum length of regex that can be used in Regexp Query.
        :param pulumi.Input[int] max_rescore_window: The maximum value of `window_size` for `rescore` requests in searches of this index.
        :param pulumi.Input[int] max_result_window: The maximum value of `from + size` for searches to this index.
        :param pulumi.Input[int] max_script_fields: The maximum number of `script_fields` that are allowed in a query.
        :param pulumi.Input[int] max_shingle_diff: The maximum allowed difference between max*shingle*size and min*shingle*size for ShingleTokenFilter.
        :param pulumi.Input[int] max_terms_count: The maximum number of terms that can be used in Terms Query.
        :param pulumi.Input[str] name: Name of the index you wish to create.
        :param pulumi.Input[int] number_of_replicas: Number of shard replicas.
        :param pulumi.Input[int] number_of_routing_shards: Value used with number*of*shards to route documents to a primary shard. This can be set only on creation.
        :param pulumi.Input[int] number_of_shards: Number of shards for the index. This can be set only on creation.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] query_default_fields: Wildcard (*) patterns matching one or more fields. Defaults to '*', which matches all fields eligible for term-level queries, excluding metadata fields.
        :param pulumi.Input[str] refresh_interval: How often to perform a refresh operation, which makes recent changes to the index visible to search. Can be set to `-1` to disable refresh.
        :param pulumi.Input[str] routing_allocation_enable: Controls shard allocation for this index. It can be set to: `all` , `primaries` , `new_primaries` , `none`.
        :param pulumi.Input[int] routing_partition_size: The number of shards a custom routing value can go to. This can be set only on creation.
        :param pulumi.Input[str] routing_rebalance_enable: Enables shard rebalancing for this index. It can be set to: `all`, `primaries` , `replicas` , `none`.
        :param pulumi.Input[str] search_idle_after: How long a shard can not receive a search or get request until it’s considered search idle.
        :param pulumi.Input[str] search_slowlog_level: Set which logging level to use for the search slow log, can be: `warn`, `info`, `debug`, `trace`
        :param pulumi.Input[str] search_slowlog_threshold_fetch_debug: Set the cutoff for shard level slow search logging of slow searches in the fetch phase, in time units, e.g. `2s`
        :param pulumi.Input[str] search_slowlog_threshold_fetch_info: Set the cutoff for shard level slow search logging of slow searches in the fetch phase, in time units, e.g. `5s`
        :param pulumi.Input[str] search_slowlog_threshold_fetch_trace: Set the cutoff for shard level slow search logging of slow searches in the fetch phase, in time units, e.g. `500ms`
        :param pulumi.Input[str] search_slowlog_threshold_fetch_warn: Set the cutoff for shard level slow search logging of slow searches in the fetch phase, in time units, e.g. `10s`
        :param pulumi.Input[str] search_slowlog_threshold_query_debug: Set the cutoff for shard level slow search logging of slow searches in the query phase, in time units, e.g. `2s`
        :param pulumi.Input[str] search_slowlog_threshold_query_info: Set the cutoff for shard level slow search logging of slow searches in the query phase, in time units, e.g. `5s`
        :param pulumi.Input[str] search_slowlog_threshold_query_trace: Set the cutoff for shard level slow search logging of slow searches in the query phase, in time units, e.g. `500ms`
        :param pulumi.Input[str] search_slowlog_threshold_query_warn: Set the cutoff for shard level slow search logging of slow searches in the query phase, in time units, e.g. `10s`
        :param pulumi.Input[pulumi.InputType['IndexSettingsArgs']] settings: DEPRECATED: Please use dedicated setting field. Configuration options for the index. See, https://www.elastic.co/guide/en/elasticsearch/reference/current/index-modules.html#index-modules-settings.
               **NOTE:** Static index settings (see: https://www.elastic.co/guide/en/elasticsearch/reference/current/index-modules.html#*static*index_settings) can be only set on the index creation and later cannot be removed or updated - *apply* will return error
        :param pulumi.Input[str] shard_check_on_startup: Whether or not shards should be checked for corruption before opening. When corruption is detected, it will prevent the shard from being opened. Accepts `false`, `true`, `checksum`.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] sort_fields: The field to sort shards in this index by.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] sort_orders: The direction to sort shards in. Accepts `asc`, `desc`.
        :param pulumi.Input[str] unassigned_node_left_delayed_timeout: Time to delay the allocation of replica shards which become unassigned because a node has left, in time units, e.g. `10s`
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: Optional[IndexArgs] = None,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        Creates or updates an index. This resource can define settings, mappings and aliases. See: https://www.elastic.co/guide/en/elasticsearch/reference/current/indices-create-index.html

        ## Import

        You can later adjust the index configuration to account for those imported settings. Some of the default settings, which could be imported are`index.number_of_replicas`, `index.number_of_shards` and `index.routing.allocation.include._tier_preference`. NOTEwhile importing index resource, keep in mind, that some of the default index settings will be imported into the TF state too You can later adjust the index configuration to account for those imported settings

        ```sh
         $ pulumi import elasticstack:index/index:Index my_index <cluster_uuid>/<index_name>
        ```

        :param str resource_name: The name of the resource.
        :param IndexArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(IndexArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 aliases: Optional[pulumi.Input[Sequence[pulumi.Input[pulumi.InputType['IndexAliasArgs']]]]] = None,
                 analysis_analyzer: Optional[pulumi.Input[str]] = None,
                 analysis_char_filter: Optional[pulumi.Input[str]] = None,
                 analysis_filter: Optional[pulumi.Input[str]] = None,
                 analysis_normalizer: Optional[pulumi.Input[str]] = None,
                 analysis_tokenizer: Optional[pulumi.Input[str]] = None,
                 analyze_max_token_count: Optional[pulumi.Input[int]] = None,
                 auto_expand_replicas: Optional[pulumi.Input[str]] = None,
                 blocks_metadata: Optional[pulumi.Input[bool]] = None,
                 blocks_read: Optional[pulumi.Input[bool]] = None,
                 blocks_read_only: Optional[pulumi.Input[bool]] = None,
                 blocks_read_only_allow_delete: Optional[pulumi.Input[bool]] = None,
                 blocks_write: Optional[pulumi.Input[bool]] = None,
                 codec: Optional[pulumi.Input[str]] = None,
                 default_pipeline: Optional[pulumi.Input[str]] = None,
                 elasticsearch_connection: Optional[pulumi.Input[pulumi.InputType['IndexElasticsearchConnectionArgs']]] = None,
                 final_pipeline: Optional[pulumi.Input[str]] = None,
                 gc_deletes: Optional[pulumi.Input[str]] = None,
                 highlight_max_analyzed_offset: Optional[pulumi.Input[int]] = None,
                 indexing_slowlog_level: Optional[pulumi.Input[str]] = None,
                 indexing_slowlog_source: Optional[pulumi.Input[str]] = None,
                 indexing_slowlog_threshold_index_debug: Optional[pulumi.Input[str]] = None,
                 indexing_slowlog_threshold_index_info: Optional[pulumi.Input[str]] = None,
                 indexing_slowlog_threshold_index_trace: Optional[pulumi.Input[str]] = None,
                 indexing_slowlog_threshold_index_warn: Optional[pulumi.Input[str]] = None,
                 load_fixed_bitset_filters_eagerly: Optional[pulumi.Input[bool]] = None,
                 mappings: Optional[pulumi.Input[str]] = None,
                 max_docvalue_fields_search: Optional[pulumi.Input[int]] = None,
                 max_inner_result_window: Optional[pulumi.Input[int]] = None,
                 max_ngram_diff: Optional[pulumi.Input[int]] = None,
                 max_refresh_listeners: Optional[pulumi.Input[int]] = None,
                 max_regex_length: Optional[pulumi.Input[int]] = None,
                 max_rescore_window: Optional[pulumi.Input[int]] = None,
                 max_result_window: Optional[pulumi.Input[int]] = None,
                 max_script_fields: Optional[pulumi.Input[int]] = None,
                 max_shingle_diff: Optional[pulumi.Input[int]] = None,
                 max_terms_count: Optional[pulumi.Input[int]] = None,
                 name: Optional[pulumi.Input[str]] = None,
                 number_of_replicas: Optional[pulumi.Input[int]] = None,
                 number_of_routing_shards: Optional[pulumi.Input[int]] = None,
                 number_of_shards: Optional[pulumi.Input[int]] = None,
                 query_default_fields: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 refresh_interval: Optional[pulumi.Input[str]] = None,
                 routing_allocation_enable: Optional[pulumi.Input[str]] = None,
                 routing_partition_size: Optional[pulumi.Input[int]] = None,
                 routing_rebalance_enable: Optional[pulumi.Input[str]] = None,
                 search_idle_after: Optional[pulumi.Input[str]] = None,
                 search_slowlog_level: Optional[pulumi.Input[str]] = None,
                 search_slowlog_threshold_fetch_debug: Optional[pulumi.Input[str]] = None,
                 search_slowlog_threshold_fetch_info: Optional[pulumi.Input[str]] = None,
                 search_slowlog_threshold_fetch_trace: Optional[pulumi.Input[str]] = None,
                 search_slowlog_threshold_fetch_warn: Optional[pulumi.Input[str]] = None,
                 search_slowlog_threshold_query_debug: Optional[pulumi.Input[str]] = None,
                 search_slowlog_threshold_query_info: Optional[pulumi.Input[str]] = None,
                 search_slowlog_threshold_query_trace: Optional[pulumi.Input[str]] = None,
                 search_slowlog_threshold_query_warn: Optional[pulumi.Input[str]] = None,
                 settings: Optional[pulumi.Input[pulumi.InputType['IndexSettingsArgs']]] = None,
                 shard_check_on_startup: Optional[pulumi.Input[str]] = None,
                 sort_fields: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 sort_orders: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 unassigned_node_left_delayed_timeout: Optional[pulumi.Input[str]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = IndexArgs.__new__(IndexArgs)

            __props__.__dict__["aliases"] = aliases
            __props__.__dict__["analysis_analyzer"] = analysis_analyzer
            __props__.__dict__["analysis_char_filter"] = analysis_char_filter
            __props__.__dict__["analysis_filter"] = analysis_filter
            __props__.__dict__["analysis_normalizer"] = analysis_normalizer
            __props__.__dict__["analysis_tokenizer"] = analysis_tokenizer
            __props__.__dict__["analyze_max_token_count"] = analyze_max_token_count
            __props__.__dict__["auto_expand_replicas"] = auto_expand_replicas
            __props__.__dict__["blocks_metadata"] = blocks_metadata
            __props__.__dict__["blocks_read"] = blocks_read
            __props__.__dict__["blocks_read_only"] = blocks_read_only
            __props__.__dict__["blocks_read_only_allow_delete"] = blocks_read_only_allow_delete
            __props__.__dict__["blocks_write"] = blocks_write
            __props__.__dict__["codec"] = codec
            __props__.__dict__["default_pipeline"] = default_pipeline
            __props__.__dict__["elasticsearch_connection"] = elasticsearch_connection
            __props__.__dict__["final_pipeline"] = final_pipeline
            __props__.__dict__["gc_deletes"] = gc_deletes
            __props__.__dict__["highlight_max_analyzed_offset"] = highlight_max_analyzed_offset
            __props__.__dict__["indexing_slowlog_level"] = indexing_slowlog_level
            __props__.__dict__["indexing_slowlog_source"] = indexing_slowlog_source
            __props__.__dict__["indexing_slowlog_threshold_index_debug"] = indexing_slowlog_threshold_index_debug
            __props__.__dict__["indexing_slowlog_threshold_index_info"] = indexing_slowlog_threshold_index_info
            __props__.__dict__["indexing_slowlog_threshold_index_trace"] = indexing_slowlog_threshold_index_trace
            __props__.__dict__["indexing_slowlog_threshold_index_warn"] = indexing_slowlog_threshold_index_warn
            __props__.__dict__["load_fixed_bitset_filters_eagerly"] = load_fixed_bitset_filters_eagerly
            __props__.__dict__["mappings"] = mappings
            __props__.__dict__["max_docvalue_fields_search"] = max_docvalue_fields_search
            __props__.__dict__["max_inner_result_window"] = max_inner_result_window
            __props__.__dict__["max_ngram_diff"] = max_ngram_diff
            __props__.__dict__["max_refresh_listeners"] = max_refresh_listeners
            __props__.__dict__["max_regex_length"] = max_regex_length
            __props__.__dict__["max_rescore_window"] = max_rescore_window
            __props__.__dict__["max_result_window"] = max_result_window
            __props__.__dict__["max_script_fields"] = max_script_fields
            __props__.__dict__["max_shingle_diff"] = max_shingle_diff
            __props__.__dict__["max_terms_count"] = max_terms_count
            __props__.__dict__["name"] = name
            __props__.__dict__["number_of_replicas"] = number_of_replicas
            __props__.__dict__["number_of_routing_shards"] = number_of_routing_shards
            __props__.__dict__["number_of_shards"] = number_of_shards
            __props__.__dict__["query_default_fields"] = query_default_fields
            __props__.__dict__["refresh_interval"] = refresh_interval
            __props__.__dict__["routing_allocation_enable"] = routing_allocation_enable
            __props__.__dict__["routing_partition_size"] = routing_partition_size
            __props__.__dict__["routing_rebalance_enable"] = routing_rebalance_enable
            __props__.__dict__["search_idle_after"] = search_idle_after
            __props__.__dict__["search_slowlog_level"] = search_slowlog_level
            __props__.__dict__["search_slowlog_threshold_fetch_debug"] = search_slowlog_threshold_fetch_debug
            __props__.__dict__["search_slowlog_threshold_fetch_info"] = search_slowlog_threshold_fetch_info
            __props__.__dict__["search_slowlog_threshold_fetch_trace"] = search_slowlog_threshold_fetch_trace
            __props__.__dict__["search_slowlog_threshold_fetch_warn"] = search_slowlog_threshold_fetch_warn
            __props__.__dict__["search_slowlog_threshold_query_debug"] = search_slowlog_threshold_query_debug
            __props__.__dict__["search_slowlog_threshold_query_info"] = search_slowlog_threshold_query_info
            __props__.__dict__["search_slowlog_threshold_query_trace"] = search_slowlog_threshold_query_trace
            __props__.__dict__["search_slowlog_threshold_query_warn"] = search_slowlog_threshold_query_warn
            if settings is not None and not opts.urn:
                warnings.warn("""Using settings makes it easier to misconfigure.  Use dedicated field for the each setting instead.""", DeprecationWarning)
                pulumi.log.warn("""settings is deprecated: Using settings makes it easier to misconfigure.  Use dedicated field for the each setting instead.""")
            __props__.__dict__["settings"] = settings
            __props__.__dict__["shard_check_on_startup"] = shard_check_on_startup
            __props__.__dict__["sort_fields"] = sort_fields
            __props__.__dict__["sort_orders"] = sort_orders
            __props__.__dict__["unassigned_node_left_delayed_timeout"] = unassigned_node_left_delayed_timeout
            __props__.__dict__["settings_raw"] = None
        super(Index, __self__).__init__(
            'elasticstack:index/index:Index',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            aliases: Optional[pulumi.Input[Sequence[pulumi.Input[pulumi.InputType['IndexAliasArgs']]]]] = None,
            analysis_analyzer: Optional[pulumi.Input[str]] = None,
            analysis_char_filter: Optional[pulumi.Input[str]] = None,
            analysis_filter: Optional[pulumi.Input[str]] = None,
            analysis_normalizer: Optional[pulumi.Input[str]] = None,
            analysis_tokenizer: Optional[pulumi.Input[str]] = None,
            analyze_max_token_count: Optional[pulumi.Input[int]] = None,
            auto_expand_replicas: Optional[pulumi.Input[str]] = None,
            blocks_metadata: Optional[pulumi.Input[bool]] = None,
            blocks_read: Optional[pulumi.Input[bool]] = None,
            blocks_read_only: Optional[pulumi.Input[bool]] = None,
            blocks_read_only_allow_delete: Optional[pulumi.Input[bool]] = None,
            blocks_write: Optional[pulumi.Input[bool]] = None,
            codec: Optional[pulumi.Input[str]] = None,
            default_pipeline: Optional[pulumi.Input[str]] = None,
            elasticsearch_connection: Optional[pulumi.Input[pulumi.InputType['IndexElasticsearchConnectionArgs']]] = None,
            final_pipeline: Optional[pulumi.Input[str]] = None,
            gc_deletes: Optional[pulumi.Input[str]] = None,
            highlight_max_analyzed_offset: Optional[pulumi.Input[int]] = None,
            indexing_slowlog_level: Optional[pulumi.Input[str]] = None,
            indexing_slowlog_source: Optional[pulumi.Input[str]] = None,
            indexing_slowlog_threshold_index_debug: Optional[pulumi.Input[str]] = None,
            indexing_slowlog_threshold_index_info: Optional[pulumi.Input[str]] = None,
            indexing_slowlog_threshold_index_trace: Optional[pulumi.Input[str]] = None,
            indexing_slowlog_threshold_index_warn: Optional[pulumi.Input[str]] = None,
            load_fixed_bitset_filters_eagerly: Optional[pulumi.Input[bool]] = None,
            mappings: Optional[pulumi.Input[str]] = None,
            max_docvalue_fields_search: Optional[pulumi.Input[int]] = None,
            max_inner_result_window: Optional[pulumi.Input[int]] = None,
            max_ngram_diff: Optional[pulumi.Input[int]] = None,
            max_refresh_listeners: Optional[pulumi.Input[int]] = None,
            max_regex_length: Optional[pulumi.Input[int]] = None,
            max_rescore_window: Optional[pulumi.Input[int]] = None,
            max_result_window: Optional[pulumi.Input[int]] = None,
            max_script_fields: Optional[pulumi.Input[int]] = None,
            max_shingle_diff: Optional[pulumi.Input[int]] = None,
            max_terms_count: Optional[pulumi.Input[int]] = None,
            name: Optional[pulumi.Input[str]] = None,
            number_of_replicas: Optional[pulumi.Input[int]] = None,
            number_of_routing_shards: Optional[pulumi.Input[int]] = None,
            number_of_shards: Optional[pulumi.Input[int]] = None,
            query_default_fields: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
            refresh_interval: Optional[pulumi.Input[str]] = None,
            routing_allocation_enable: Optional[pulumi.Input[str]] = None,
            routing_partition_size: Optional[pulumi.Input[int]] = None,
            routing_rebalance_enable: Optional[pulumi.Input[str]] = None,
            search_idle_after: Optional[pulumi.Input[str]] = None,
            search_slowlog_level: Optional[pulumi.Input[str]] = None,
            search_slowlog_threshold_fetch_debug: Optional[pulumi.Input[str]] = None,
            search_slowlog_threshold_fetch_info: Optional[pulumi.Input[str]] = None,
            search_slowlog_threshold_fetch_trace: Optional[pulumi.Input[str]] = None,
            search_slowlog_threshold_fetch_warn: Optional[pulumi.Input[str]] = None,
            search_slowlog_threshold_query_debug: Optional[pulumi.Input[str]] = None,
            search_slowlog_threshold_query_info: Optional[pulumi.Input[str]] = None,
            search_slowlog_threshold_query_trace: Optional[pulumi.Input[str]] = None,
            search_slowlog_threshold_query_warn: Optional[pulumi.Input[str]] = None,
            settings: Optional[pulumi.Input[pulumi.InputType['IndexSettingsArgs']]] = None,
            settings_raw: Optional[pulumi.Input[str]] = None,
            shard_check_on_startup: Optional[pulumi.Input[str]] = None,
            sort_fields: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
            sort_orders: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
            unassigned_node_left_delayed_timeout: Optional[pulumi.Input[str]] = None) -> 'Index':
        """
        Get an existing Index resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[Sequence[pulumi.Input[pulumi.InputType['IndexAliasArgs']]]] aliases: Aliases for the index.
        :param pulumi.Input[str] analysis_analyzer: A JSON string describing the analyzers applied to the index.
        :param pulumi.Input[str] analysis_char_filter: A JSON string describing the char_filters applied to the index.
        :param pulumi.Input[str] analysis_filter: A JSON string describing the filters applied to the index.
        :param pulumi.Input[str] analysis_normalizer: A JSON string describing the normalizers applied to the index.
        :param pulumi.Input[str] analysis_tokenizer: A JSON string describing the tokenizers applied to the index.
        :param pulumi.Input[int] analyze_max_token_count: The maximum number of tokens that can be produced using _analyze API.
        :param pulumi.Input[str] auto_expand_replicas: Set the number of replicas to the node count in the cluster. Set to a dash delimited lower and upper bound (e.g. 0-5) or use all for the upper bound (e.g. 0-all)
        :param pulumi.Input[bool] blocks_metadata: Set to `true` to disable index metadata reads and writes.
        :param pulumi.Input[bool] blocks_read: Set to `true` to disable read operations against the index.
        :param pulumi.Input[bool] blocks_read_only: Set to `true` to make the index and index metadata read only, `false` to allow writes and metadata changes.
        :param pulumi.Input[bool] blocks_read_only_allow_delete: Identical to `index.blocks.read_only` but allows deleting the index to free up resources.
        :param pulumi.Input[bool] blocks_write: Set to `true` to disable data write operations against the index. This setting does not affect metadata.
        :param pulumi.Input[str] codec: The `default` value compresses stored data with LZ4 compression, but this can be set to `best_compression` which uses DEFLATE for a higher compression ratio. This can be set only on creation.
        :param pulumi.Input[str] default_pipeline: The default ingest node pipeline for this index. Index requests will fail if the default pipeline is set and the pipeline does not exist.
        :param pulumi.Input[pulumi.InputType['IndexElasticsearchConnectionArgs']] elasticsearch_connection: Elasticsearch connection configuration block.
        :param pulumi.Input[str] final_pipeline: Final ingest pipeline for the index. Indexing requests will fail if the final pipeline is set and the pipeline does not exist. The final pipeline always runs after the request pipeline (if specified) and the default pipeline (if it exists). The special pipeline name _none indicates no ingest pipeline will run.
        :param pulumi.Input[str] gc_deletes: The length of time that a deleted document's version number remains available for further versioned operations.
        :param pulumi.Input[int] highlight_max_analyzed_offset: The maximum number of characters that will be analyzed for a highlight request.
        :param pulumi.Input[str] indexing_slowlog_level: Set which logging level to use for the search slow log, can be: `warn`, `info`, `debug`, `trace`
        :param pulumi.Input[str] indexing_slowlog_source: Set the number of characters of the `_source` to include in the slowlog lines, `false` or `0` will skip logging the source entirely and setting it to `true` will log the entire source regardless of size. The original `_source` is reformatted by default to make sure that it fits on a single log line.
        :param pulumi.Input[str] indexing_slowlog_threshold_index_debug: Set the cutoff for shard level slow search logging of slow searches for indexing queries, in time units, e.g. `2s`
        :param pulumi.Input[str] indexing_slowlog_threshold_index_info: Set the cutoff for shard level slow search logging of slow searches for indexing queries, in time units, e.g. `5s`
        :param pulumi.Input[str] indexing_slowlog_threshold_index_trace: Set the cutoff for shard level slow search logging of slow searches for indexing queries, in time units, e.g. `500ms`
        :param pulumi.Input[str] indexing_slowlog_threshold_index_warn: Set the cutoff for shard level slow search logging of slow searches for indexing queries, in time units, e.g. `10s`
        :param pulumi.Input[bool] load_fixed_bitset_filters_eagerly: Indicates whether cached filters are pre-loaded for nested queries. This can be set only on creation.
        :param pulumi.Input[str] mappings: Mapping for fields in the index.
               If specified, this mapping can include: field names, [field data types](https://www.elastic.co/guide/en/elasticsearch/reference/current/mapping-types.html), [mapping parameters](https://www.elastic.co/guide/en/elasticsearch/reference/current/mapping-params.html).
               **NOTE:** changing datatypes in the existing *mappings* will force index to be re-created.
        :param pulumi.Input[int] max_docvalue_fields_search: The maximum number of `docvalue_fields` that are allowed in a query.
        :param pulumi.Input[int] max_inner_result_window: The maximum value of `from + size` for inner hits definition and top hits aggregations to this index.
        :param pulumi.Input[int] max_ngram_diff: The maximum allowed difference between min*gram and max*gram for NGramTokenizer and NGramTokenFilter.
        :param pulumi.Input[int] max_refresh_listeners: Maximum number of refresh listeners available on each shard of the index.
        :param pulumi.Input[int] max_regex_length: The maximum length of regex that can be used in Regexp Query.
        :param pulumi.Input[int] max_rescore_window: The maximum value of `window_size` for `rescore` requests in searches of this index.
        :param pulumi.Input[int] max_result_window: The maximum value of `from + size` for searches to this index.
        :param pulumi.Input[int] max_script_fields: The maximum number of `script_fields` that are allowed in a query.
        :param pulumi.Input[int] max_shingle_diff: The maximum allowed difference between max*shingle*size and min*shingle*size for ShingleTokenFilter.
        :param pulumi.Input[int] max_terms_count: The maximum number of terms that can be used in Terms Query.
        :param pulumi.Input[str] name: Name of the index you wish to create.
        :param pulumi.Input[int] number_of_replicas: Number of shard replicas.
        :param pulumi.Input[int] number_of_routing_shards: Value used with number*of*shards to route documents to a primary shard. This can be set only on creation.
        :param pulumi.Input[int] number_of_shards: Number of shards for the index. This can be set only on creation.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] query_default_fields: Wildcard (*) patterns matching one or more fields. Defaults to '*', which matches all fields eligible for term-level queries, excluding metadata fields.
        :param pulumi.Input[str] refresh_interval: How often to perform a refresh operation, which makes recent changes to the index visible to search. Can be set to `-1` to disable refresh.
        :param pulumi.Input[str] routing_allocation_enable: Controls shard allocation for this index. It can be set to: `all` , `primaries` , `new_primaries` , `none`.
        :param pulumi.Input[int] routing_partition_size: The number of shards a custom routing value can go to. This can be set only on creation.
        :param pulumi.Input[str] routing_rebalance_enable: Enables shard rebalancing for this index. It can be set to: `all`, `primaries` , `replicas` , `none`.
        :param pulumi.Input[str] search_idle_after: How long a shard can not receive a search or get request until it’s considered search idle.
        :param pulumi.Input[str] search_slowlog_level: Set which logging level to use for the search slow log, can be: `warn`, `info`, `debug`, `trace`
        :param pulumi.Input[str] search_slowlog_threshold_fetch_debug: Set the cutoff for shard level slow search logging of slow searches in the fetch phase, in time units, e.g. `2s`
        :param pulumi.Input[str] search_slowlog_threshold_fetch_info: Set the cutoff for shard level slow search logging of slow searches in the fetch phase, in time units, e.g. `5s`
        :param pulumi.Input[str] search_slowlog_threshold_fetch_trace: Set the cutoff for shard level slow search logging of slow searches in the fetch phase, in time units, e.g. `500ms`
        :param pulumi.Input[str] search_slowlog_threshold_fetch_warn: Set the cutoff for shard level slow search logging of slow searches in the fetch phase, in time units, e.g. `10s`
        :param pulumi.Input[str] search_slowlog_threshold_query_debug: Set the cutoff for shard level slow search logging of slow searches in the query phase, in time units, e.g. `2s`
        :param pulumi.Input[str] search_slowlog_threshold_query_info: Set the cutoff for shard level slow search logging of slow searches in the query phase, in time units, e.g. `5s`
        :param pulumi.Input[str] search_slowlog_threshold_query_trace: Set the cutoff for shard level slow search logging of slow searches in the query phase, in time units, e.g. `500ms`
        :param pulumi.Input[str] search_slowlog_threshold_query_warn: Set the cutoff for shard level slow search logging of slow searches in the query phase, in time units, e.g. `10s`
        :param pulumi.Input[pulumi.InputType['IndexSettingsArgs']] settings: DEPRECATED: Please use dedicated setting field. Configuration options for the index. See, https://www.elastic.co/guide/en/elasticsearch/reference/current/index-modules.html#index-modules-settings.
               **NOTE:** Static index settings (see: https://www.elastic.co/guide/en/elasticsearch/reference/current/index-modules.html#*static*index_settings) can be only set on the index creation and later cannot be removed or updated - *apply* will return error
        :param pulumi.Input[str] settings_raw: All raw settings fetched from the cluster.
        :param pulumi.Input[str] shard_check_on_startup: Whether or not shards should be checked for corruption before opening. When corruption is detected, it will prevent the shard from being opened. Accepts `false`, `true`, `checksum`.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] sort_fields: The field to sort shards in this index by.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] sort_orders: The direction to sort shards in. Accepts `asc`, `desc`.
        :param pulumi.Input[str] unassigned_node_left_delayed_timeout: Time to delay the allocation of replica shards which become unassigned because a node has left, in time units, e.g. `10s`
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _IndexState.__new__(_IndexState)

        __props__.__dict__["aliases"] = aliases
        __props__.__dict__["analysis_analyzer"] = analysis_analyzer
        __props__.__dict__["analysis_char_filter"] = analysis_char_filter
        __props__.__dict__["analysis_filter"] = analysis_filter
        __props__.__dict__["analysis_normalizer"] = analysis_normalizer
        __props__.__dict__["analysis_tokenizer"] = analysis_tokenizer
        __props__.__dict__["analyze_max_token_count"] = analyze_max_token_count
        __props__.__dict__["auto_expand_replicas"] = auto_expand_replicas
        __props__.__dict__["blocks_metadata"] = blocks_metadata
        __props__.__dict__["blocks_read"] = blocks_read
        __props__.__dict__["blocks_read_only"] = blocks_read_only
        __props__.__dict__["blocks_read_only_allow_delete"] = blocks_read_only_allow_delete
        __props__.__dict__["blocks_write"] = blocks_write
        __props__.__dict__["codec"] = codec
        __props__.__dict__["default_pipeline"] = default_pipeline
        __props__.__dict__["elasticsearch_connection"] = elasticsearch_connection
        __props__.__dict__["final_pipeline"] = final_pipeline
        __props__.__dict__["gc_deletes"] = gc_deletes
        __props__.__dict__["highlight_max_analyzed_offset"] = highlight_max_analyzed_offset
        __props__.__dict__["indexing_slowlog_level"] = indexing_slowlog_level
        __props__.__dict__["indexing_slowlog_source"] = indexing_slowlog_source
        __props__.__dict__["indexing_slowlog_threshold_index_debug"] = indexing_slowlog_threshold_index_debug
        __props__.__dict__["indexing_slowlog_threshold_index_info"] = indexing_slowlog_threshold_index_info
        __props__.__dict__["indexing_slowlog_threshold_index_trace"] = indexing_slowlog_threshold_index_trace
        __props__.__dict__["indexing_slowlog_threshold_index_warn"] = indexing_slowlog_threshold_index_warn
        __props__.__dict__["load_fixed_bitset_filters_eagerly"] = load_fixed_bitset_filters_eagerly
        __props__.__dict__["mappings"] = mappings
        __props__.__dict__["max_docvalue_fields_search"] = max_docvalue_fields_search
        __props__.__dict__["max_inner_result_window"] = max_inner_result_window
        __props__.__dict__["max_ngram_diff"] = max_ngram_diff
        __props__.__dict__["max_refresh_listeners"] = max_refresh_listeners
        __props__.__dict__["max_regex_length"] = max_regex_length
        __props__.__dict__["max_rescore_window"] = max_rescore_window
        __props__.__dict__["max_result_window"] = max_result_window
        __props__.__dict__["max_script_fields"] = max_script_fields
        __props__.__dict__["max_shingle_diff"] = max_shingle_diff
        __props__.__dict__["max_terms_count"] = max_terms_count
        __props__.__dict__["name"] = name
        __props__.__dict__["number_of_replicas"] = number_of_replicas
        __props__.__dict__["number_of_routing_shards"] = number_of_routing_shards
        __props__.__dict__["number_of_shards"] = number_of_shards
        __props__.__dict__["query_default_fields"] = query_default_fields
        __props__.__dict__["refresh_interval"] = refresh_interval
        __props__.__dict__["routing_allocation_enable"] = routing_allocation_enable
        __props__.__dict__["routing_partition_size"] = routing_partition_size
        __props__.__dict__["routing_rebalance_enable"] = routing_rebalance_enable
        __props__.__dict__["search_idle_after"] = search_idle_after
        __props__.__dict__["search_slowlog_level"] = search_slowlog_level
        __props__.__dict__["search_slowlog_threshold_fetch_debug"] = search_slowlog_threshold_fetch_debug
        __props__.__dict__["search_slowlog_threshold_fetch_info"] = search_slowlog_threshold_fetch_info
        __props__.__dict__["search_slowlog_threshold_fetch_trace"] = search_slowlog_threshold_fetch_trace
        __props__.__dict__["search_slowlog_threshold_fetch_warn"] = search_slowlog_threshold_fetch_warn
        __props__.__dict__["search_slowlog_threshold_query_debug"] = search_slowlog_threshold_query_debug
        __props__.__dict__["search_slowlog_threshold_query_info"] = search_slowlog_threshold_query_info
        __props__.__dict__["search_slowlog_threshold_query_trace"] = search_slowlog_threshold_query_trace
        __props__.__dict__["search_slowlog_threshold_query_warn"] = search_slowlog_threshold_query_warn
        __props__.__dict__["settings"] = settings
        __props__.__dict__["settings_raw"] = settings_raw
        __props__.__dict__["shard_check_on_startup"] = shard_check_on_startup
        __props__.__dict__["sort_fields"] = sort_fields
        __props__.__dict__["sort_orders"] = sort_orders
        __props__.__dict__["unassigned_node_left_delayed_timeout"] = unassigned_node_left_delayed_timeout
        return Index(resource_name, opts=opts, __props__=__props__)

    @property
    @pulumi.getter
    def aliases(self) -> pulumi.Output[Optional[Sequence['outputs.IndexAlias']]]:
        """
        Aliases for the index.
        """
        return pulumi.get(self, "aliases")

    @property
    @pulumi.getter(name="analysisAnalyzer")
    def analysis_analyzer(self) -> pulumi.Output[Optional[str]]:
        """
        A JSON string describing the analyzers applied to the index.
        """
        return pulumi.get(self, "analysis_analyzer")

    @property
    @pulumi.getter(name="analysisCharFilter")
    def analysis_char_filter(self) -> pulumi.Output[Optional[str]]:
        """
        A JSON string describing the char_filters applied to the index.
        """
        return pulumi.get(self, "analysis_char_filter")

    @property
    @pulumi.getter(name="analysisFilter")
    def analysis_filter(self) -> pulumi.Output[Optional[str]]:
        """
        A JSON string describing the filters applied to the index.
        """
        return pulumi.get(self, "analysis_filter")

    @property
    @pulumi.getter(name="analysisNormalizer")
    def analysis_normalizer(self) -> pulumi.Output[Optional[str]]:
        """
        A JSON string describing the normalizers applied to the index.
        """
        return pulumi.get(self, "analysis_normalizer")

    @property
    @pulumi.getter(name="analysisTokenizer")
    def analysis_tokenizer(self) -> pulumi.Output[Optional[str]]:
        """
        A JSON string describing the tokenizers applied to the index.
        """
        return pulumi.get(self, "analysis_tokenizer")

    @property
    @pulumi.getter(name="analyzeMaxTokenCount")
    def analyze_max_token_count(self) -> pulumi.Output[Optional[int]]:
        """
        The maximum number of tokens that can be produced using _analyze API.
        """
        return pulumi.get(self, "analyze_max_token_count")

    @property
    @pulumi.getter(name="autoExpandReplicas")
    def auto_expand_replicas(self) -> pulumi.Output[Optional[str]]:
        """
        Set the number of replicas to the node count in the cluster. Set to a dash delimited lower and upper bound (e.g. 0-5) or use all for the upper bound (e.g. 0-all)
        """
        return pulumi.get(self, "auto_expand_replicas")

    @property
    @pulumi.getter(name="blocksMetadata")
    def blocks_metadata(self) -> pulumi.Output[Optional[bool]]:
        """
        Set to `true` to disable index metadata reads and writes.
        """
        return pulumi.get(self, "blocks_metadata")

    @property
    @pulumi.getter(name="blocksRead")
    def blocks_read(self) -> pulumi.Output[Optional[bool]]:
        """
        Set to `true` to disable read operations against the index.
        """
        return pulumi.get(self, "blocks_read")

    @property
    @pulumi.getter(name="blocksReadOnly")
    def blocks_read_only(self) -> pulumi.Output[Optional[bool]]:
        """
        Set to `true` to make the index and index metadata read only, `false` to allow writes and metadata changes.
        """
        return pulumi.get(self, "blocks_read_only")

    @property
    @pulumi.getter(name="blocksReadOnlyAllowDelete")
    def blocks_read_only_allow_delete(self) -> pulumi.Output[Optional[bool]]:
        """
        Identical to `index.blocks.read_only` but allows deleting the index to free up resources.
        """
        return pulumi.get(self, "blocks_read_only_allow_delete")

    @property
    @pulumi.getter(name="blocksWrite")
    def blocks_write(self) -> pulumi.Output[Optional[bool]]:
        """
        Set to `true` to disable data write operations against the index. This setting does not affect metadata.
        """
        return pulumi.get(self, "blocks_write")

    @property
    @pulumi.getter
    def codec(self) -> pulumi.Output[Optional[str]]:
        """
        The `default` value compresses stored data with LZ4 compression, but this can be set to `best_compression` which uses DEFLATE for a higher compression ratio. This can be set only on creation.
        """
        return pulumi.get(self, "codec")

    @property
    @pulumi.getter(name="defaultPipeline")
    def default_pipeline(self) -> pulumi.Output[Optional[str]]:
        """
        The default ingest node pipeline for this index. Index requests will fail if the default pipeline is set and the pipeline does not exist.
        """
        return pulumi.get(self, "default_pipeline")

    @property
    @pulumi.getter(name="elasticsearchConnection")
    def elasticsearch_connection(self) -> pulumi.Output[Optional['outputs.IndexElasticsearchConnection']]:
        """
        Elasticsearch connection configuration block.
        """
        return pulumi.get(self, "elasticsearch_connection")

    @property
    @pulumi.getter(name="finalPipeline")
    def final_pipeline(self) -> pulumi.Output[Optional[str]]:
        """
        Final ingest pipeline for the index. Indexing requests will fail if the final pipeline is set and the pipeline does not exist. The final pipeline always runs after the request pipeline (if specified) and the default pipeline (if it exists). The special pipeline name _none indicates no ingest pipeline will run.
        """
        return pulumi.get(self, "final_pipeline")

    @property
    @pulumi.getter(name="gcDeletes")
    def gc_deletes(self) -> pulumi.Output[Optional[str]]:
        """
        The length of time that a deleted document's version number remains available for further versioned operations.
        """
        return pulumi.get(self, "gc_deletes")

    @property
    @pulumi.getter(name="highlightMaxAnalyzedOffset")
    def highlight_max_analyzed_offset(self) -> pulumi.Output[Optional[int]]:
        """
        The maximum number of characters that will be analyzed for a highlight request.
        """
        return pulumi.get(self, "highlight_max_analyzed_offset")

    @property
    @pulumi.getter(name="indexingSlowlogLevel")
    def indexing_slowlog_level(self) -> pulumi.Output[Optional[str]]:
        """
        Set which logging level to use for the search slow log, can be: `warn`, `info`, `debug`, `trace`
        """
        return pulumi.get(self, "indexing_slowlog_level")

    @property
    @pulumi.getter(name="indexingSlowlogSource")
    def indexing_slowlog_source(self) -> pulumi.Output[Optional[str]]:
        """
        Set the number of characters of the `_source` to include in the slowlog lines, `false` or `0` will skip logging the source entirely and setting it to `true` will log the entire source regardless of size. The original `_source` is reformatted by default to make sure that it fits on a single log line.
        """
        return pulumi.get(self, "indexing_slowlog_source")

    @property
    @pulumi.getter(name="indexingSlowlogThresholdIndexDebug")
    def indexing_slowlog_threshold_index_debug(self) -> pulumi.Output[Optional[str]]:
        """
        Set the cutoff for shard level slow search logging of slow searches for indexing queries, in time units, e.g. `2s`
        """
        return pulumi.get(self, "indexing_slowlog_threshold_index_debug")

    @property
    @pulumi.getter(name="indexingSlowlogThresholdIndexInfo")
    def indexing_slowlog_threshold_index_info(self) -> pulumi.Output[Optional[str]]:
        """
        Set the cutoff for shard level slow search logging of slow searches for indexing queries, in time units, e.g. `5s`
        """
        return pulumi.get(self, "indexing_slowlog_threshold_index_info")

    @property
    @pulumi.getter(name="indexingSlowlogThresholdIndexTrace")
    def indexing_slowlog_threshold_index_trace(self) -> pulumi.Output[Optional[str]]:
        """
        Set the cutoff for shard level slow search logging of slow searches for indexing queries, in time units, e.g. `500ms`
        """
        return pulumi.get(self, "indexing_slowlog_threshold_index_trace")

    @property
    @pulumi.getter(name="indexingSlowlogThresholdIndexWarn")
    def indexing_slowlog_threshold_index_warn(self) -> pulumi.Output[Optional[str]]:
        """
        Set the cutoff for shard level slow search logging of slow searches for indexing queries, in time units, e.g. `10s`
        """
        return pulumi.get(self, "indexing_slowlog_threshold_index_warn")

    @property
    @pulumi.getter(name="loadFixedBitsetFiltersEagerly")
    def load_fixed_bitset_filters_eagerly(self) -> pulumi.Output[Optional[bool]]:
        """
        Indicates whether cached filters are pre-loaded for nested queries. This can be set only on creation.
        """
        return pulumi.get(self, "load_fixed_bitset_filters_eagerly")

    @property
    @pulumi.getter
    def mappings(self) -> pulumi.Output[Optional[str]]:
        """
        Mapping for fields in the index.
        If specified, this mapping can include: field names, [field data types](https://www.elastic.co/guide/en/elasticsearch/reference/current/mapping-types.html), [mapping parameters](https://www.elastic.co/guide/en/elasticsearch/reference/current/mapping-params.html).
        **NOTE:** changing datatypes in the existing *mappings* will force index to be re-created.
        """
        return pulumi.get(self, "mappings")

    @property
    @pulumi.getter(name="maxDocvalueFieldsSearch")
    def max_docvalue_fields_search(self) -> pulumi.Output[Optional[int]]:
        """
        The maximum number of `docvalue_fields` that are allowed in a query.
        """
        return pulumi.get(self, "max_docvalue_fields_search")

    @property
    @pulumi.getter(name="maxInnerResultWindow")
    def max_inner_result_window(self) -> pulumi.Output[Optional[int]]:
        """
        The maximum value of `from + size` for inner hits definition and top hits aggregations to this index.
        """
        return pulumi.get(self, "max_inner_result_window")

    @property
    @pulumi.getter(name="maxNgramDiff")
    def max_ngram_diff(self) -> pulumi.Output[Optional[int]]:
        """
        The maximum allowed difference between min*gram and max*gram for NGramTokenizer and NGramTokenFilter.
        """
        return pulumi.get(self, "max_ngram_diff")

    @property
    @pulumi.getter(name="maxRefreshListeners")
    def max_refresh_listeners(self) -> pulumi.Output[Optional[int]]:
        """
        Maximum number of refresh listeners available on each shard of the index.
        """
        return pulumi.get(self, "max_refresh_listeners")

    @property
    @pulumi.getter(name="maxRegexLength")
    def max_regex_length(self) -> pulumi.Output[Optional[int]]:
        """
        The maximum length of regex that can be used in Regexp Query.
        """
        return pulumi.get(self, "max_regex_length")

    @property
    @pulumi.getter(name="maxRescoreWindow")
    def max_rescore_window(self) -> pulumi.Output[Optional[int]]:
        """
        The maximum value of `window_size` for `rescore` requests in searches of this index.
        """
        return pulumi.get(self, "max_rescore_window")

    @property
    @pulumi.getter(name="maxResultWindow")
    def max_result_window(self) -> pulumi.Output[Optional[int]]:
        """
        The maximum value of `from + size` for searches to this index.
        """
        return pulumi.get(self, "max_result_window")

    @property
    @pulumi.getter(name="maxScriptFields")
    def max_script_fields(self) -> pulumi.Output[Optional[int]]:
        """
        The maximum number of `script_fields` that are allowed in a query.
        """
        return pulumi.get(self, "max_script_fields")

    @property
    @pulumi.getter(name="maxShingleDiff")
    def max_shingle_diff(self) -> pulumi.Output[Optional[int]]:
        """
        The maximum allowed difference between max*shingle*size and min*shingle*size for ShingleTokenFilter.
        """
        return pulumi.get(self, "max_shingle_diff")

    @property
    @pulumi.getter(name="maxTermsCount")
    def max_terms_count(self) -> pulumi.Output[Optional[int]]:
        """
        The maximum number of terms that can be used in Terms Query.
        """
        return pulumi.get(self, "max_terms_count")

    @property
    @pulumi.getter
    def name(self) -> pulumi.Output[str]:
        """
        Name of the index you wish to create.
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter(name="numberOfReplicas")
    def number_of_replicas(self) -> pulumi.Output[int]:
        """
        Number of shard replicas.
        """
        return pulumi.get(self, "number_of_replicas")

    @property
    @pulumi.getter(name="numberOfRoutingShards")
    def number_of_routing_shards(self) -> pulumi.Output[Optional[int]]:
        """
        Value used with number*of*shards to route documents to a primary shard. This can be set only on creation.
        """
        return pulumi.get(self, "number_of_routing_shards")

    @property
    @pulumi.getter(name="numberOfShards")
    def number_of_shards(self) -> pulumi.Output[Optional[int]]:
        """
        Number of shards for the index. This can be set only on creation.
        """
        return pulumi.get(self, "number_of_shards")

    @property
    @pulumi.getter(name="queryDefaultFields")
    def query_default_fields(self) -> pulumi.Output[Optional[Sequence[str]]]:
        """
        Wildcard (*) patterns matching one or more fields. Defaults to '*', which matches all fields eligible for term-level queries, excluding metadata fields.
        """
        return pulumi.get(self, "query_default_fields")

    @property
    @pulumi.getter(name="refreshInterval")
    def refresh_interval(self) -> pulumi.Output[Optional[str]]:
        """
        How often to perform a refresh operation, which makes recent changes to the index visible to search. Can be set to `-1` to disable refresh.
        """
        return pulumi.get(self, "refresh_interval")

    @property
    @pulumi.getter(name="routingAllocationEnable")
    def routing_allocation_enable(self) -> pulumi.Output[Optional[str]]:
        """
        Controls shard allocation for this index. It can be set to: `all` , `primaries` , `new_primaries` , `none`.
        """
        return pulumi.get(self, "routing_allocation_enable")

    @property
    @pulumi.getter(name="routingPartitionSize")
    def routing_partition_size(self) -> pulumi.Output[Optional[int]]:
        """
        The number of shards a custom routing value can go to. This can be set only on creation.
        """
        return pulumi.get(self, "routing_partition_size")

    @property
    @pulumi.getter(name="routingRebalanceEnable")
    def routing_rebalance_enable(self) -> pulumi.Output[Optional[str]]:
        """
        Enables shard rebalancing for this index. It can be set to: `all`, `primaries` , `replicas` , `none`.
        """
        return pulumi.get(self, "routing_rebalance_enable")

    @property
    @pulumi.getter(name="searchIdleAfter")
    def search_idle_after(self) -> pulumi.Output[Optional[str]]:
        """
        How long a shard can not receive a search or get request until it’s considered search idle.
        """
        return pulumi.get(self, "search_idle_after")

    @property
    @pulumi.getter(name="searchSlowlogLevel")
    def search_slowlog_level(self) -> pulumi.Output[Optional[str]]:
        """
        Set which logging level to use for the search slow log, can be: `warn`, `info`, `debug`, `trace`
        """
        return pulumi.get(self, "search_slowlog_level")

    @property
    @pulumi.getter(name="searchSlowlogThresholdFetchDebug")
    def search_slowlog_threshold_fetch_debug(self) -> pulumi.Output[Optional[str]]:
        """
        Set the cutoff for shard level slow search logging of slow searches in the fetch phase, in time units, e.g. `2s`
        """
        return pulumi.get(self, "search_slowlog_threshold_fetch_debug")

    @property
    @pulumi.getter(name="searchSlowlogThresholdFetchInfo")
    def search_slowlog_threshold_fetch_info(self) -> pulumi.Output[Optional[str]]:
        """
        Set the cutoff for shard level slow search logging of slow searches in the fetch phase, in time units, e.g. `5s`
        """
        return pulumi.get(self, "search_slowlog_threshold_fetch_info")

    @property
    @pulumi.getter(name="searchSlowlogThresholdFetchTrace")
    def search_slowlog_threshold_fetch_trace(self) -> pulumi.Output[Optional[str]]:
        """
        Set the cutoff for shard level slow search logging of slow searches in the fetch phase, in time units, e.g. `500ms`
        """
        return pulumi.get(self, "search_slowlog_threshold_fetch_trace")

    @property
    @pulumi.getter(name="searchSlowlogThresholdFetchWarn")
    def search_slowlog_threshold_fetch_warn(self) -> pulumi.Output[Optional[str]]:
        """
        Set the cutoff for shard level slow search logging of slow searches in the fetch phase, in time units, e.g. `10s`
        """
        return pulumi.get(self, "search_slowlog_threshold_fetch_warn")

    @property
    @pulumi.getter(name="searchSlowlogThresholdQueryDebug")
    def search_slowlog_threshold_query_debug(self) -> pulumi.Output[Optional[str]]:
        """
        Set the cutoff for shard level slow search logging of slow searches in the query phase, in time units, e.g. `2s`
        """
        return pulumi.get(self, "search_slowlog_threshold_query_debug")

    @property
    @pulumi.getter(name="searchSlowlogThresholdQueryInfo")
    def search_slowlog_threshold_query_info(self) -> pulumi.Output[Optional[str]]:
        """
        Set the cutoff for shard level slow search logging of slow searches in the query phase, in time units, e.g. `5s`
        """
        return pulumi.get(self, "search_slowlog_threshold_query_info")

    @property
    @pulumi.getter(name="searchSlowlogThresholdQueryTrace")
    def search_slowlog_threshold_query_trace(self) -> pulumi.Output[Optional[str]]:
        """
        Set the cutoff for shard level slow search logging of slow searches in the query phase, in time units, e.g. `500ms`
        """
        return pulumi.get(self, "search_slowlog_threshold_query_trace")

    @property
    @pulumi.getter(name="searchSlowlogThresholdQueryWarn")
    def search_slowlog_threshold_query_warn(self) -> pulumi.Output[Optional[str]]:
        """
        Set the cutoff for shard level slow search logging of slow searches in the query phase, in time units, e.g. `10s`
        """
        return pulumi.get(self, "search_slowlog_threshold_query_warn")

    @property
    @pulumi.getter
    def settings(self) -> pulumi.Output[Optional['outputs.IndexSettings']]:
        """
        DEPRECATED: Please use dedicated setting field. Configuration options for the index. See, https://www.elastic.co/guide/en/elasticsearch/reference/current/index-modules.html#index-modules-settings.
        **NOTE:** Static index settings (see: https://www.elastic.co/guide/en/elasticsearch/reference/current/index-modules.html#*static*index_settings) can be only set on the index creation and later cannot be removed or updated - *apply* will return error
        """
        return pulumi.get(self, "settings")

    @property
    @pulumi.getter(name="settingsRaw")
    def settings_raw(self) -> pulumi.Output[str]:
        """
        All raw settings fetched from the cluster.
        """
        return pulumi.get(self, "settings_raw")

    @property
    @pulumi.getter(name="shardCheckOnStartup")
    def shard_check_on_startup(self) -> pulumi.Output[Optional[str]]:
        """
        Whether or not shards should be checked for corruption before opening. When corruption is detected, it will prevent the shard from being opened. Accepts `false`, `true`, `checksum`.
        """
        return pulumi.get(self, "shard_check_on_startup")

    @property
    @pulumi.getter(name="sortFields")
    def sort_fields(self) -> pulumi.Output[Optional[Sequence[str]]]:
        """
        The field to sort shards in this index by.
        """
        return pulumi.get(self, "sort_fields")

    @property
    @pulumi.getter(name="sortOrders")
    def sort_orders(self) -> pulumi.Output[Optional[Sequence[str]]]:
        """
        The direction to sort shards in. Accepts `asc`, `desc`.
        """
        return pulumi.get(self, "sort_orders")

    @property
    @pulumi.getter(name="unassignedNodeLeftDelayedTimeout")
    def unassigned_node_left_delayed_timeout(self) -> pulumi.Output[Optional[str]]:
        """
        Time to delay the allocation of replica shards which become unassigned because a node has left, in time units, e.g. `10s`
        """
        return pulumi.get(self, "unassigned_node_left_delayed_timeout")

