# coding=utf-8
# *** WARNING: this file was generated by the Pulumi Terraform Bridge (tfgen) Tool. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import copy
import warnings
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
from . import _utilities
from . import outputs
from ._inputs import *

__all__ = ['DataStreamArgs', 'DataStream']

@pulumi.input_type
class DataStreamArgs:
    def __init__(__self__, *,
                 elasticsearch_connection: Optional[pulumi.Input['DataStreamElasticsearchConnectionArgs']] = None,
                 name: Optional[pulumi.Input[str]] = None):
        """
        The set of arguments for constructing a DataStream resource.
        :param pulumi.Input['DataStreamElasticsearchConnectionArgs'] elasticsearch_connection: Elasticsearch connection configuration block.
        :param pulumi.Input[str] name: Name of the data stream to create.
        """
        if elasticsearch_connection is not None:
            pulumi.set(__self__, "elasticsearch_connection", elasticsearch_connection)
        if name is not None:
            pulumi.set(__self__, "name", name)

    @property
    @pulumi.getter(name="elasticsearchConnection")
    def elasticsearch_connection(self) -> Optional[pulumi.Input['DataStreamElasticsearchConnectionArgs']]:
        """
        Elasticsearch connection configuration block.
        """
        return pulumi.get(self, "elasticsearch_connection")

    @elasticsearch_connection.setter
    def elasticsearch_connection(self, value: Optional[pulumi.Input['DataStreamElasticsearchConnectionArgs']]):
        pulumi.set(self, "elasticsearch_connection", value)

    @property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[str]]:
        """
        Name of the data stream to create.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "name", value)


@pulumi.input_type
class _DataStreamState:
    def __init__(__self__, *,
                 elasticsearch_connection: Optional[pulumi.Input['DataStreamElasticsearchConnectionArgs']] = None,
                 generation: Optional[pulumi.Input[int]] = None,
                 hidden: Optional[pulumi.Input[bool]] = None,
                 ilm_policy: Optional[pulumi.Input[str]] = None,
                 indices: Optional[pulumi.Input[Sequence[pulumi.Input['DataStreamIndexArgs']]]] = None,
                 metadata: Optional[pulumi.Input[str]] = None,
                 name: Optional[pulumi.Input[str]] = None,
                 replicated: Optional[pulumi.Input[bool]] = None,
                 status: Optional[pulumi.Input[str]] = None,
                 system: Optional[pulumi.Input[bool]] = None,
                 template: Optional[pulumi.Input[str]] = None,
                 timestamp_field: Optional[pulumi.Input[str]] = None):
        """
        Input properties used for looking up and filtering DataStream resources.
        :param pulumi.Input['DataStreamElasticsearchConnectionArgs'] elasticsearch_connection: Elasticsearch connection configuration block.
        :param pulumi.Input[int] generation: Current generation for the data stream.
        :param pulumi.Input[bool] hidden: If `true`, the data stream is hidden.
        :param pulumi.Input[str] ilm_policy: Name of the current ILM lifecycle policy in the stream’s matching index template.
        :param pulumi.Input[Sequence[pulumi.Input['DataStreamIndexArgs']]] indices: Array of objects containing information about the data stream’s backing indices. The last item in this array contains information about the stream’s current write index.
        :param pulumi.Input[str] metadata: Custom metadata for the stream, copied from the _meta object of the stream’s matching index template.
        :param pulumi.Input[str] name: Name of the data stream to create.
        :param pulumi.Input[bool] replicated: If `true`, the data stream is created and managed by cross-cluster replication and the local cluster can not write into this data stream or change its mappings.
        :param pulumi.Input[str] status: Health status of the data stream.
        :param pulumi.Input[bool] system: If `true`, the data stream is created and managed by an Elastic stack component and cannot be modified through normal user interaction.
        :param pulumi.Input[str] template: Name of the index template used to create the data stream’s backing indices.
        :param pulumi.Input[str] timestamp_field: Contains information about the data stream’s @timestamp field.
        """
        if elasticsearch_connection is not None:
            pulumi.set(__self__, "elasticsearch_connection", elasticsearch_connection)
        if generation is not None:
            pulumi.set(__self__, "generation", generation)
        if hidden is not None:
            pulumi.set(__self__, "hidden", hidden)
        if ilm_policy is not None:
            pulumi.set(__self__, "ilm_policy", ilm_policy)
        if indices is not None:
            pulumi.set(__self__, "indices", indices)
        if metadata is not None:
            pulumi.set(__self__, "metadata", metadata)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if replicated is not None:
            pulumi.set(__self__, "replicated", replicated)
        if status is not None:
            pulumi.set(__self__, "status", status)
        if system is not None:
            pulumi.set(__self__, "system", system)
        if template is not None:
            pulumi.set(__self__, "template", template)
        if timestamp_field is not None:
            pulumi.set(__self__, "timestamp_field", timestamp_field)

    @property
    @pulumi.getter(name="elasticsearchConnection")
    def elasticsearch_connection(self) -> Optional[pulumi.Input['DataStreamElasticsearchConnectionArgs']]:
        """
        Elasticsearch connection configuration block.
        """
        return pulumi.get(self, "elasticsearch_connection")

    @elasticsearch_connection.setter
    def elasticsearch_connection(self, value: Optional[pulumi.Input['DataStreamElasticsearchConnectionArgs']]):
        pulumi.set(self, "elasticsearch_connection", value)

    @property
    @pulumi.getter
    def generation(self) -> Optional[pulumi.Input[int]]:
        """
        Current generation for the data stream.
        """
        return pulumi.get(self, "generation")

    @generation.setter
    def generation(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "generation", value)

    @property
    @pulumi.getter
    def hidden(self) -> Optional[pulumi.Input[bool]]:
        """
        If `true`, the data stream is hidden.
        """
        return pulumi.get(self, "hidden")

    @hidden.setter
    def hidden(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "hidden", value)

    @property
    @pulumi.getter(name="ilmPolicy")
    def ilm_policy(self) -> Optional[pulumi.Input[str]]:
        """
        Name of the current ILM lifecycle policy in the stream’s matching index template.
        """
        return pulumi.get(self, "ilm_policy")

    @ilm_policy.setter
    def ilm_policy(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "ilm_policy", value)

    @property
    @pulumi.getter
    def indices(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['DataStreamIndexArgs']]]]:
        """
        Array of objects containing information about the data stream’s backing indices. The last item in this array contains information about the stream’s current write index.
        """
        return pulumi.get(self, "indices")

    @indices.setter
    def indices(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['DataStreamIndexArgs']]]]):
        pulumi.set(self, "indices", value)

    @property
    @pulumi.getter
    def metadata(self) -> Optional[pulumi.Input[str]]:
        """
        Custom metadata for the stream, copied from the _meta object of the stream’s matching index template.
        """
        return pulumi.get(self, "metadata")

    @metadata.setter
    def metadata(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "metadata", value)

    @property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[str]]:
        """
        Name of the data stream to create.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "name", value)

    @property
    @pulumi.getter
    def replicated(self) -> Optional[pulumi.Input[bool]]:
        """
        If `true`, the data stream is created and managed by cross-cluster replication and the local cluster can not write into this data stream or change its mappings.
        """
        return pulumi.get(self, "replicated")

    @replicated.setter
    def replicated(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "replicated", value)

    @property
    @pulumi.getter
    def status(self) -> Optional[pulumi.Input[str]]:
        """
        Health status of the data stream.
        """
        return pulumi.get(self, "status")

    @status.setter
    def status(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "status", value)

    @property
    @pulumi.getter
    def system(self) -> Optional[pulumi.Input[bool]]:
        """
        If `true`, the data stream is created and managed by an Elastic stack component and cannot be modified through normal user interaction.
        """
        return pulumi.get(self, "system")

    @system.setter
    def system(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "system", value)

    @property
    @pulumi.getter
    def template(self) -> Optional[pulumi.Input[str]]:
        """
        Name of the index template used to create the data stream’s backing indices.
        """
        return pulumi.get(self, "template")

    @template.setter
    def template(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "template", value)

    @property
    @pulumi.getter(name="timestampField")
    def timestamp_field(self) -> Optional[pulumi.Input[str]]:
        """
        Contains information about the data stream’s @timestamp field.
        """
        return pulumi.get(self, "timestamp_field")

    @timestamp_field.setter
    def timestamp_field(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "timestamp_field", value)


class DataStream(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 elasticsearch_connection: Optional[pulumi.Input[pulumi.InputType['DataStreamElasticsearchConnectionArgs']]] = None,
                 name: Optional[pulumi.Input[str]] = None,
                 __props__=None):
        """
        Manages data streams. This resource can create, delete and show the information about the created data stream. See: https://www.elastic.co/guide/en/elasticsearch/reference/current/data-stream-apis.html

        ## Example Usage

        ```python
        import pulumi
        import json
        import pulumi_elasticstack as elasticstack

        # Create an ILM policy for our data stream
        my_ilm = elasticstack.IndexLifecycle("myIlm",
            hot=elasticstack.IndexLifecycleHotArgs(
                min_age="1h",
                set_priority=elasticstack.IndexLifecycleHotSetPriorityArgs(
                    priority=10,
                ),
                rollover=elasticstack.IndexLifecycleHotRolloverArgs(
                    max_age="1d",
                ),
                readonly=elasticstack.IndexLifecycleHotReadonlyArgs(),
            ),
            delete=elasticstack.IndexLifecycleDeleteArgs(
                min_age="2d",
                delete=elasticstack.IndexLifecycleDeleteDeleteArgs(),
            ))
        # First we must have a index template created
        my_data_stream_template = elasticstack.IndexTemplate("myDataStreamTemplate",
            index_patterns=["my-stream*"],
            template=elasticstack.IndexTemplateTemplateArgs(
                settings=my_ilm.name.apply(lambda name: json.dumps({
                    "lifecycle.name": name,
                })),
            ),
            data_stream=elasticstack.IndexTemplateDataStreamArgs())
        # and now we can create data stream based on the index template
        my_data_stream = elasticstack.DataStream("myDataStream", opts=pulumi.ResourceOptions(depends_on=[my_data_stream_template]))
        ```

        ## Import

        ```sh
         $ pulumi import elasticstack:index/dataStream:DataStream my_data_stream <cluster_uuid>/<data_stream_name>
        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[pulumi.InputType['DataStreamElasticsearchConnectionArgs']] elasticsearch_connection: Elasticsearch connection configuration block.
        :param pulumi.Input[str] name: Name of the data stream to create.
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: Optional[DataStreamArgs] = None,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        Manages data streams. This resource can create, delete and show the information about the created data stream. See: https://www.elastic.co/guide/en/elasticsearch/reference/current/data-stream-apis.html

        ## Example Usage

        ```python
        import pulumi
        import json
        import pulumi_elasticstack as elasticstack

        # Create an ILM policy for our data stream
        my_ilm = elasticstack.IndexLifecycle("myIlm",
            hot=elasticstack.IndexLifecycleHotArgs(
                min_age="1h",
                set_priority=elasticstack.IndexLifecycleHotSetPriorityArgs(
                    priority=10,
                ),
                rollover=elasticstack.IndexLifecycleHotRolloverArgs(
                    max_age="1d",
                ),
                readonly=elasticstack.IndexLifecycleHotReadonlyArgs(),
            ),
            delete=elasticstack.IndexLifecycleDeleteArgs(
                min_age="2d",
                delete=elasticstack.IndexLifecycleDeleteDeleteArgs(),
            ))
        # First we must have a index template created
        my_data_stream_template = elasticstack.IndexTemplate("myDataStreamTemplate",
            index_patterns=["my-stream*"],
            template=elasticstack.IndexTemplateTemplateArgs(
                settings=my_ilm.name.apply(lambda name: json.dumps({
                    "lifecycle.name": name,
                })),
            ),
            data_stream=elasticstack.IndexTemplateDataStreamArgs())
        # and now we can create data stream based on the index template
        my_data_stream = elasticstack.DataStream("myDataStream", opts=pulumi.ResourceOptions(depends_on=[my_data_stream_template]))
        ```

        ## Import

        ```sh
         $ pulumi import elasticstack:index/dataStream:DataStream my_data_stream <cluster_uuid>/<data_stream_name>
        ```

        :param str resource_name: The name of the resource.
        :param DataStreamArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(DataStreamArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 elasticsearch_connection: Optional[pulumi.Input[pulumi.InputType['DataStreamElasticsearchConnectionArgs']]] = None,
                 name: Optional[pulumi.Input[str]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = DataStreamArgs.__new__(DataStreamArgs)

            __props__.__dict__["elasticsearch_connection"] = elasticsearch_connection
            __props__.__dict__["name"] = name
            __props__.__dict__["generation"] = None
            __props__.__dict__["hidden"] = None
            __props__.__dict__["ilm_policy"] = None
            __props__.__dict__["indices"] = None
            __props__.__dict__["metadata"] = None
            __props__.__dict__["replicated"] = None
            __props__.__dict__["status"] = None
            __props__.__dict__["system"] = None
            __props__.__dict__["template"] = None
            __props__.__dict__["timestamp_field"] = None
        super(DataStream, __self__).__init__(
            'elasticstack:index/dataStream:DataStream',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            elasticsearch_connection: Optional[pulumi.Input[pulumi.InputType['DataStreamElasticsearchConnectionArgs']]] = None,
            generation: Optional[pulumi.Input[int]] = None,
            hidden: Optional[pulumi.Input[bool]] = None,
            ilm_policy: Optional[pulumi.Input[str]] = None,
            indices: Optional[pulumi.Input[Sequence[pulumi.Input[pulumi.InputType['DataStreamIndexArgs']]]]] = None,
            metadata: Optional[pulumi.Input[str]] = None,
            name: Optional[pulumi.Input[str]] = None,
            replicated: Optional[pulumi.Input[bool]] = None,
            status: Optional[pulumi.Input[str]] = None,
            system: Optional[pulumi.Input[bool]] = None,
            template: Optional[pulumi.Input[str]] = None,
            timestamp_field: Optional[pulumi.Input[str]] = None) -> 'DataStream':
        """
        Get an existing DataStream resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[pulumi.InputType['DataStreamElasticsearchConnectionArgs']] elasticsearch_connection: Elasticsearch connection configuration block.
        :param pulumi.Input[int] generation: Current generation for the data stream.
        :param pulumi.Input[bool] hidden: If `true`, the data stream is hidden.
        :param pulumi.Input[str] ilm_policy: Name of the current ILM lifecycle policy in the stream’s matching index template.
        :param pulumi.Input[Sequence[pulumi.Input[pulumi.InputType['DataStreamIndexArgs']]]] indices: Array of objects containing information about the data stream’s backing indices. The last item in this array contains information about the stream’s current write index.
        :param pulumi.Input[str] metadata: Custom metadata for the stream, copied from the _meta object of the stream’s matching index template.
        :param pulumi.Input[str] name: Name of the data stream to create.
        :param pulumi.Input[bool] replicated: If `true`, the data stream is created and managed by cross-cluster replication and the local cluster can not write into this data stream or change its mappings.
        :param pulumi.Input[str] status: Health status of the data stream.
        :param pulumi.Input[bool] system: If `true`, the data stream is created and managed by an Elastic stack component and cannot be modified through normal user interaction.
        :param pulumi.Input[str] template: Name of the index template used to create the data stream’s backing indices.
        :param pulumi.Input[str] timestamp_field: Contains information about the data stream’s @timestamp field.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _DataStreamState.__new__(_DataStreamState)

        __props__.__dict__["elasticsearch_connection"] = elasticsearch_connection
        __props__.__dict__["generation"] = generation
        __props__.__dict__["hidden"] = hidden
        __props__.__dict__["ilm_policy"] = ilm_policy
        __props__.__dict__["indices"] = indices
        __props__.__dict__["metadata"] = metadata
        __props__.__dict__["name"] = name
        __props__.__dict__["replicated"] = replicated
        __props__.__dict__["status"] = status
        __props__.__dict__["system"] = system
        __props__.__dict__["template"] = template
        __props__.__dict__["timestamp_field"] = timestamp_field
        return DataStream(resource_name, opts=opts, __props__=__props__)

    @property
    @pulumi.getter(name="elasticsearchConnection")
    def elasticsearch_connection(self) -> pulumi.Output[Optional['outputs.DataStreamElasticsearchConnection']]:
        """
        Elasticsearch connection configuration block.
        """
        return pulumi.get(self, "elasticsearch_connection")

    @property
    @pulumi.getter
    def generation(self) -> pulumi.Output[int]:
        """
        Current generation for the data stream.
        """
        return pulumi.get(self, "generation")

    @property
    @pulumi.getter
    def hidden(self) -> pulumi.Output[bool]:
        """
        If `true`, the data stream is hidden.
        """
        return pulumi.get(self, "hidden")

    @property
    @pulumi.getter(name="ilmPolicy")
    def ilm_policy(self) -> pulumi.Output[str]:
        """
        Name of the current ILM lifecycle policy in the stream’s matching index template.
        """
        return pulumi.get(self, "ilm_policy")

    @property
    @pulumi.getter
    def indices(self) -> pulumi.Output[Sequence['outputs.DataStreamIndex']]:
        """
        Array of objects containing information about the data stream’s backing indices. The last item in this array contains information about the stream’s current write index.
        """
        return pulumi.get(self, "indices")

    @property
    @pulumi.getter
    def metadata(self) -> pulumi.Output[str]:
        """
        Custom metadata for the stream, copied from the _meta object of the stream’s matching index template.
        """
        return pulumi.get(self, "metadata")

    @property
    @pulumi.getter
    def name(self) -> pulumi.Output[str]:
        """
        Name of the data stream to create.
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter
    def replicated(self) -> pulumi.Output[bool]:
        """
        If `true`, the data stream is created and managed by cross-cluster replication and the local cluster can not write into this data stream or change its mappings.
        """
        return pulumi.get(self, "replicated")

    @property
    @pulumi.getter
    def status(self) -> pulumi.Output[str]:
        """
        Health status of the data stream.
        """
        return pulumi.get(self, "status")

    @property
    @pulumi.getter
    def system(self) -> pulumi.Output[bool]:
        """
        If `true`, the data stream is created and managed by an Elastic stack component and cannot be modified through normal user interaction.
        """
        return pulumi.get(self, "system")

    @property
    @pulumi.getter
    def template(self) -> pulumi.Output[str]:
        """
        Name of the index template used to create the data stream’s backing indices.
        """
        return pulumi.get(self, "template")

    @property
    @pulumi.getter(name="timestampField")
    def timestamp_field(self) -> pulumi.Output[str]:
        """
        Contains information about the data stream’s @timestamp field.
        """
        return pulumi.get(self, "timestamp_field")

