# -*- coding: utf-8 -*-
from setuptools import setup

packages = \
['mkdocs_literate_nav']

package_data = \
{'': ['*']}

install_requires = \
['mkdocs>=1.0.3,<2.0.0']

extras_require = \
{':python_version < "3.7"': ['dataclasses>=0.7,<1.0']}

entry_points = \
{'mkdocs.plugins': ['literate-nav = '
                    'mkdocs_literate_nav.plugin:LiterateNavPlugin']}

setup_kwargs = {
    'name': 'mkdocs-literate-nav',
    'version': '0.4.1',
    'description': 'MkDocs plugin to specify the navigation in Markdown instead of YAML',
    'long_description': '# mkdocs-literate-nav\n\n**[Plugin][] for [MkDocs][] to specify the navigation in Markdown instead of YAML**\n\n[![PyPI](https://img.shields.io/pypi/v/mkdocs-literate-nav)](https://pypi.org/project/mkdocs-literate-nav/)\n[![GitHub](https://img.shields.io/github/license/oprypin/mkdocs-literate-nav)](https://github.com/oprypin/mkdocs-literate-nav/blob/master/LICENSE.md)\n[![GitHub Workflow Status](https://img.shields.io/github/workflow/status/oprypin/mkdocs-literate-nav/CI)](https://github.com/oprypin/mkdocs-literate-nav/actions?query=event%3Apush+branch%3Amaster)\n\n```shell\npip install mkdocs-literate-nav\n```\n\nWorks well with **[section-index][]** and **[gen-files][]**. Supplants **[awesome-pages][]**.\n\n[mkdocs]: https://www.mkdocs.org/\n[plugin]: https://www.mkdocs.org/user-guide/plugins/\n[section-index]: https://oprypin.github.io/mkdocs-section-index/\n[gen-files]: https://oprypin.github.io/mkdocs-gen-files/\n[awesome-pages]: https://github.com/lukasgeiter/mkdocs-awesome-pages-plugin\n\n## Usage\n\nActivate the plugin in **mkdocs.yml**:\n\n```yaml\nplugins:\n  - search\n  - literate-nav:\n      nav_file: SUMMARY.md\n```\n\nand **drop** the `nav` section if it\'s present there; it will be ignored now. ([Unless you want to keep it?](#hybrid-nav))\n\n<table markdown="1"><tr>\n<td>To get this navigation,</td>\n<td>create the file <b>SUMMARY.md</b>:</td>\n<td>(old YAML equivalent:)</td>\n</tr><tr><td>\n\n* [Frob](#index.md)\n* [Baz](#baz.md)\n* [Borgs](#borgs/index.md)\n    * [Bar](#borgs/bar.md)\n    * [Foo](#borgs/foo.md)\n\n</td><td>\n\n```markdown\n* [Frob](index.md)\n* [Baz](baz.md)\n* [Borgs](borgs/index.md)\n    * [Bar](borgs/bar.md)\n    * [Foo](borgs/foo.md)\n```\n\n</td><td>\n\n```yaml\nnav:\n  - Frob: index.md\n  - Baz: baz.md\n  - Borgs:\n    - borgs/index.md\n    - Bar: borgs/bar.md\n    - Foo: borgs/foo.md\n```\n\n</td></tr></table>\n\nIMPORTANT: The nav file must be put inside the [`docs` directory][docs_dir] -- at the root of it.\n\nSo, the plugin lets you specify your site\'s navigation with lists of links that are parsed according to normal Markdown rules.\n\nNote that, the way we wrote the Markdown, a section seems to also have a page associated with it. MkDocs doesn\'t actually support that, and neither is it representable in YAML directly, so the plugin tries to do the next best thing: include the link as the first page of the section. However, this structure is perfectly suited for the *[section-index][]* plugin, which actually makes that work. Or you could just *not* associate a link with sections:\n\n<table markdown="1"><tr>\n<td>To get this navigation,</td>\n<td>create the file <b>SUMMARY.md</b>:</td>\n<td>(old YAML equivalent:)</td>\n</tr><tr><td>\n\n* [Frob](#index.md)\n* [Baz](#baz.md)\n* Borgs\n    * [Bar](#borgs/bar.md)\n    * [Foo](#borgs/foo.md)\n\n</td><td>\n\n```markdown\n* [Frob](index.md)\n* [Baz](baz.md)\n* Borgs\n    * [Bar](borgs/bar.md)\n    * [Foo](borgs/foo.md)\n```\n\n</td><td>\n\n```yaml\nnav:\n  - Frob: index.md\n  - Baz: baz.md\n  - Borgs:\n    - Bar: borgs/bar.md\n    - Foo: borgs/foo.md\n```\n\n</td></tr></table>\n\n**[See syntax details about literate nav files.](https://oprypin.github.io/mkdocs-literate-nav/reference.html)**\n\nYou can find more examples of the "literate nav" syntax [in the testcases directory](https://github.com/oprypin/mkdocs-literate-nav/tree/master/tests/nav).\n\n### Nav cross-link\n\nBut why stop there? Each directory can have its own decoupled navigation list (see how the trailing slash initiates a nav cross-link):\n\n<table markdown="1"><tr>\n<td>To get this navigation,</td>\n<td>create the file <b>SUMMARY.md</b>:</td>\n<td>(old YAML equivalent:)</td>\n</tr><tr><td rowspan="3">\n\n* [Frob](#index.md)\n* [Baz](#baz.md)\n* Borgs\n    * [Bar](#borgs/bar.md)\n    * [Foo](#borgs/foo.md)\n\n</td><td>\n\n```markdown\n* [Frob](index.md)\n* [Baz](baz.md)\n* [Borgs](borgs/)\n```\n\n</td><td rowspan="3">\n\n```yaml\nnav:\n  - Frob: index.md\n  - Baz: baz.md\n  - Borgs:\n    - Bar: borgs/bar.md\n    - Foo: borgs/foo.md\n```\n\n</td></tr><tr>\n<td>and the file <b>borgs/SUMMARY.md</b>:</td>\n</tr><tr><td>\n\n```markdown\n* [Bar](bar.md)\n* [Foo](foo.md)\n```\n\n</td></tr></table>\n\n> NOTE: The nav file in the subdirectory is picked up *only* because its directory is explicitly mentioned in a parent nav file. **SUMMARY.md** (generally [`nav-file`](customizing-nav_file)) files are **not** picked up implicitly (only the root nav file is "implicit").\n>\n> So you might say that the nav construction approach is exactly the opposite from the *[awesome-pages][]* plugin.\n>\n> That said, an [inferred cross-linked directory](#inferred-sub-directory) (whether directly or through [wildcards](#wildcards)) gets resolved recursively, so that way you actually go back to implicit resolution.\n\n#### Inferred sub-directory\n\nOr perhaps you don\'t care about the order of the pages under the **borgs/** directory? Just drop the file __borgs/SUMMARY.md__ and let it be inferred (recursively, if applicable). For our particular example, the final result would be the same.\n\nThe fallback behavior follows the [default behavior of MkDocs when nav isn\'t specified][mkdocs-nav], except that you can leave out only some directory trees, rather than an all-or-nothing choice.\n\n### Wildcards\n\nBetween the two extremes of entirely specifying a nav and entirely inferring it, there\'s the option of applying wildcards.\n\nInstead of putting links like `[Foo 1](foo_1.md)`, `[Foo 2](foo_2.md)` into the nav list, you can write a wildcard item: `foo_*.md` (bare, not as a link). The asterisk indicates that any number of characters can go there, and the file name has to match the rest of the pattern.\n\nA wildcard item is always required to have at least one `*` asterisk in it, because if it doesn\'t, then it\'s *just* a bare item, which are disallowed.\n\n**[See details about wildcards.](https://oprypin.github.io/mkdocs-literate-nav/reference.html#wildcards)**\n\nSo this can be used to fully specify order for items that matter and apply wildcards for all other cases. Example:\n\n<table markdown="1"><tr>\n<td>By writing this literate nav file,</td>\n<td>you may get a nav like this:</td>\n<td>(assuming the files exist:)</td>\n</tr><tr><td>\n\n```markdown\n- [Welcome](index.md)\n- Usage\n    - [Foo](usage/foo.md)\n    - usage/*.md\n- */\n- *.md\n- [API docs](api/)\n- [License](license.md)\n```\n\n</td><td>\n\n```yaml\n- Welcome: index.md\n- Usage:\n    - Foo: usage/foo.md\n    - usage/bar.md\n    - usage/baz.md\n- Tips:\n    - tips/other-stuff.md\n    - tips/stuff.md\n- changelog.md\n- credits.md\n- API docs:\n    - api/Foo.md\n    - Bar:\n        - api/Bar/index.md\n        - api/Bar/Baz.md\n- License: license.md\n```\n\n</td><td>\n\n* index.md\n* changelog.md\n* credits.md\n* usage / bar.md\n* usage / baz.md\n* usage / foo.md\n* tips / stuff.md\n* tips / other-stuff.md\n* api / Foo.md\n* api / Bar / index.md\n* api / Bar / Baz.md\n\n</td></tr></table>\n\nTIP: Speaking of API docs... Want to fine-tune file ordering in a large directory tree? Check out [integrations with other plugins](#extras).\n\nThe paths are relative to the directory that the nav file is in. Matching files in subdirectories also works, in both ways: `*/foo.md` and `foo/*.md`.\n\nAs it\'s impossible for a user to specify the titles of items produced by a wildcard, they have to be inferred, based on [normal rules of MkDocs][mkdocs-nav].\n\n> TIP: The ordering of items matches MkDocs\' default, so first go all files, alphabetically (but with the index file first), then all directories. But, as an example, you could actually swap that, by writing:\n>\n> ```markdown\n> - */\n> - *\n> ```\n\nYou can find more examples of the wildcard syntax [in the testcases directory](https://github.com/oprypin/mkdocs-literate-nav/tree/master/tests/nav/wildcard).\n\n### Customizing `nav_file`\n\nWe\'ve been using **SUMMARY.md** as the name of the file that specifies the nav (actually that is also the default value of `nav_file`), but naturally, you can use any other file name.\n\n**[See details about the `nav_file` config.](https://oprypin.github.io/mkdocs-literate-nav/reference.html#nav_file)**\n\nThe plugin takes care to not let MkDocs complain if you don\'t end up using the nav document as an actual page of your doc site.\n\n#### Show off your nav on the front page\n\nOr maybe you want the opposite -- make the nav page very prominent? You can actually use the index page, **README.md**, for the nav!\n\nWhy would one do this? Well, GitHub (or another source hosting) also displays the Markdown files, and it\'s quite a nice perk to show off your navigation right in the index page of a directory. Of course, then you\'d probably refrain from using [wildcards](#wildcards). [Directory cross linking](#nav-cross-link) still looks great, though.\n\nWhat\'s that, you ask? If the index page is taken up by navigation, we can\'t put any other content there, can we? Actually, we can! The nav list can just be put at the bottom of the page that also has whatever other content before that.\n\n[See an example of all this in action](https://github.com/oprypin/crsfml/tree/master/docs/tutorials)\n\n#### Explicit nav mark\n\nIf the plugin is confused where in the document the nav is, or if you want to explicitly put it in a particular location, please precede the Markdown list with this HTML comment (verbatim) on a line of its own:\n\n```html\n<!--nav-->\n```\n\n### Hybrid nav\n\nDo the features of this plugin interest you but you\'re not on board with the idea of migrating your whole nav?\n\nYou can actually keep using [MkDocs\' own nav specification][mkdocs-nav] at the root, *but* defer only some subdirectories to the *literate-nav* plugin. In that case make sure to *not* put a nav file at the [`docs` root][docs_dir], otherwise the native nav will be ignored.\n\n<table markdown="1"><tr>\n<td>To get this navigation,</td>\n<td>put this into <b>mkdocs.yml</b>:</td>\n<td>(old YAML equivalent:)</td>\n</tr><tr><td rowspan="3">\n\n* [Frob](#index.md)\n* [Baz](#baz.md)\n* Borgs\n    * [Bar](#borgs/bar.md)\n    * [Foo](#borgs/foo.md)\n\n</td><td>\n\n```yaml\nnav:\n  - Frob: index.md\n  - Baz: baz.md\n  - Borgs: borgs/\n```\n\n</td><td rowspan="3">\n\n```yaml\nnav:\n  - Frob: index.md\n  - Baz: baz.md\n  - Borgs:\n    - Bar: borgs/bar.md\n    - Foo: borgs/foo.md\n```\n\n</td></tr><tr>\n<td>& create the file <b>borgs/SUMMARY.md</b>:</td>\n</tr><tr><td>\n\n```markdown\n* [Bar](bar.md)\n* [Foo](foo.md)\n```\n\n</td></tr></table>\n\nThe syntax to defer to a subdirectory, just like [in a literate nav](#nav-cross-link), is to write an item that *ends* with a slash.\n\nNOTE: There is no way to use a YAML nav for a subdirectory, only a literate nav can be deferred.\n\nWildcards also work very similarly.\n\n**[See details about syntax additions for MkDocs native nav.](https://oprypin.github.io/mkdocs-literate-nav/reference.html#mkdocs-native-nav)**\n\nYou can find examples of the hybrid nav syntax [in the testcases directory](https://github.com/oprypin/mkdocs-literate-nav/tree/master/tests/nav/hybrid).\n\n#### MkDocs native nav with inferred subdirectories\n\nAs before, whenever you have the option of using a literate nav file for a sub-directory, you can also *not* put any nav file there and infer the sub-directory instead. So, *not* creating the file **borgs/SUMMARY.md** would have yielded the same result in the above example.\n\nSo basically, you can use the *literate-nav* plugin just for its ability to infer only sub-directories, without ever writing any actual "literate navs".\n\n#### Details about hybrid nav\n\nAs a final example, note that there are two ways to include a subdirectory, with significant difference:\n\n<table markdown="1"><tr>\n<td>To get this navigation,</td>\n<td>put this into <b>mkdocs.yml</b>:</td>\n<td>To get this navigation,</td>\n<td>put this into <b>mkdocs.yml</b>:</td>\n</tr><tr><td>\n\n* [Frob](#index.md)\n* [Baz](#baz.md)\n* Borgs\n    * [Bar](#borgs/bar.md)\n    * [Foo](#borgs/foo.md)\n\n</td><td>\n\n```yaml\nnav:\n  - Frob: index.md\n  - Baz: baz.md\n  - Borgs: borgs/\n```\n\n</td><td>\n\n* [Frob](#index.md)\n* [Baz](#baz.md)\n* [Bar](#borgs/bar.md)\n* [Foo](#borgs/foo.md)\n\n</td><td>\n\n```yaml\nnav:\n  - Frob: index.md\n  - Baz: baz.md\n  - borgs/*\n```\n\n</td></tr></table>\n\nSo, a directory item with a title becomes a section titled as such. And a wildcard (which can\'t have a title specified) gets inlined into the existing section. This simple example has no sub-sub-directories, but the relative subdirectory structure would be preserved in both cases if it did.\n\n### Extras\n\n#### Programmatic control over the nav\n\nLet\'s say you need the ability to infer nav for a sub-directory, but are unhappy with the default naming/layout behavior, and you don\'t want to write all that out manually either. Then, definitely check out the ***[gen-files][]* plugin**. Its normal usage is to programmatically add files to the site during the build, but that also includes literate nav files! Moreover, you don\'t even have to teach your program to write Markdown. There\'s a more direct integration: `mkdocs_gen_files.Nav.build_literate_nav`.\n\n[See an example that generates both the files and the navigation covering them](https://github.com/mkdocstrings/mkdocstrings/blob/5802b1ef5ad9bf6077974f777bd55f32ce2bc219/docs/gen_doc_stubs.py#L25).\n\n#### Migrating from GitBook?\n\nIt might be very easy! Just beware of the stricter Markdown parser; it will *not* accept 2-space indentation for sub-lists.\n\nAnd use this for **mkdocs.yml**:\n\n<table><tr><td>\n\n```yaml\nuse_directory_urls: false\n```\n```yaml\nplugins:\n  - search\n  - same-dir\n  - section-index\n  - literate-nav:\n      nav_file: SUMMARY.md\n```\n\n</td><td>\n\n```yaml\ntheme:\n  name: material\n```\n```yaml\nmarkdown_extensions:\n  - pymdownx.highlight\n  - pymdownx.magiclink\n  - pymdownx.superfences\n```\n\n</td></tr></table>\n\n\n\n[mkdocs-nav]: https://www.mkdocs.org/user-guide/writing-your-docs/#configure-pages-and-navigation\n[docs_dir]: https://www.mkdocs.org/user-guide/configuration/#docs_dir\n',
    'author': 'Oleh Prypin',
    'author_email': 'oleh@pryp.in',
    'maintainer': None,
    'maintainer_email': None,
    'url': 'https://github.com/oprypin/mkdocs-literate-nav',
    'packages': packages,
    'package_data': package_data,
    'install_requires': install_requires,
    'extras_require': extras_require,
    'entry_points': entry_points,
    'python_requires': '>=3.6,<4.0',
}


setup(**setup_kwargs)
