# coding: utf-8

"""
    Collibra Search API

    The Search API allows you to create your own integration with the Collibra Search Engine.<br /> Find your data!  # noqa: E501

    The version of the OpenAPI document: 2.0
    Generated by: https://openapi-generator.tech
"""


import pprint
import re  # noqa: F401

import six

from collibra_search.configuration import Configuration


class SearchResult(object):
    """NOTE: This class is auto generated by OpenAPI Generator.
    Ref: https://openapi-generator.tech

    Do not edit the class manually.
    """

    """
    Attributes:
      openapi_types (dict): The key is attribute name
                            and the value is attribute type.
      attribute_map (dict): The key is attribute name
                            and the value is json key in definition.
    """
    openapi_types = {
        'resource': 'SearchResultResource',
        'highlights': 'list[SearchResultHighlight]'
    }

    attribute_map = {
        'resource': 'resource',
        'highlights': 'highlights'
    }

    def __init__(self, resource=None, highlights=None, local_vars_configuration=None):  # noqa: E501
        """SearchResult - a model defined in OpenAPI"""  # noqa: E501
        if local_vars_configuration is None:
            local_vars_configuration = Configuration()
        self.local_vars_configuration = local_vars_configuration

        self._resource = None
        self._highlights = None
        self.discriminator = None

        if resource is not None:
            self.resource = resource
        self.highlights = highlights

    @property
    def resource(self):
        """Gets the resource of this SearchResult.  # noqa: E501


        :return: The resource of this SearchResult.  # noqa: E501
        :rtype: SearchResultResource
        """
        return self._resource

    @resource.setter
    def resource(self, resource):
        """Sets the resource of this SearchResult.


        :param resource: The resource of this SearchResult.  # noqa: E501
        :type: SearchResultResource
        """

        self._resource = resource

    @property
    def highlights(self):
        """Gets the highlights of this SearchResult.  # noqa: E501

        Highlights in related resource and its sub-entries (for example in asset and its attributes). This field has value only when highlights were defined in the search request.  # noqa: E501

        :return: The highlights of this SearchResult.  # noqa: E501
        :rtype: list[SearchResultHighlight]
        """
        return self._highlights

    @highlights.setter
    def highlights(self, highlights):
        """Sets the highlights of this SearchResult.

        Highlights in related resource and its sub-entries (for example in asset and its attributes). This field has value only when highlights were defined in the search request.  # noqa: E501

        :param highlights: The highlights of this SearchResult.  # noqa: E501
        :type: list[SearchResultHighlight]
        """

        self._highlights = highlights

    def to_dict(self):
        """Returns the model properties as a dict"""
        result = {}

        for attr, _ in six.iteritems(self.openapi_types):
            value = getattr(self, attr)
            if isinstance(value, list):
                result[attr] = list(map(
                    lambda x: x.to_dict() if hasattr(x, "to_dict") else x,
                    value
                ))
            elif hasattr(value, "to_dict"):
                result[attr] = value.to_dict()
            elif isinstance(value, dict):
                result[attr] = dict(map(
                    lambda item: (item[0], item[1].to_dict())
                    if hasattr(item[1], "to_dict") else item,
                    value.items()
                ))
            else:
                result[attr] = value

        return result

    def to_str(self):
        """Returns the string representation of the model"""
        return pprint.pformat(self.to_dict())

    def __repr__(self):
        """For `print` and `pprint`"""
        return self.to_str()

    def __eq__(self, other):
        """Returns true if both objects are equal"""
        if not isinstance(other, SearchResult):
            return False

        return self.to_dict() == other.to_dict()

    def __ne__(self, other):
        """Returns true if both objects are not equal"""
        if not isinstance(other, SearchResult):
            return True

        return self.to_dict() != other.to_dict()
