# coding: utf-8

"""
    Collibra Search API

    The Search API allows you to create your own integration with the Collibra Search Engine.<br /> Find your data!  # noqa: E501

    The version of the OpenAPI document: 2.0
    Generated by: https://openapi-generator.tech
"""


import pprint
import re  # noqa: F401

import six

from collibra_search.configuration import Configuration


class SearchAggregation(object):
    """NOTE: This class is auto generated by OpenAPI Generator.
    Ref: https://openapi-generator.tech

    Do not edit the class manually.
    """

    """
    Attributes:
      openapi_types (dict): The key is attribute name
                            and the value is attribute type.
      attribute_map (dict): The key is attribute name
                            and the value is json key in definition.
    """
    openapi_types = {
        'field': 'str',
        'limit': 'int'
    }

    attribute_map = {
        'field': 'field',
        'limit': 'limit'
    }

    def __init__(self, field=None, limit=10, local_vars_configuration=None):  # noqa: E501
        """SearchAggregation - a model defined in OpenAPI"""  # noqa: E501
        if local_vars_configuration is None:
            local_vars_configuration = Configuration()
        self.local_vars_configuration = local_vars_configuration

        self._field = None
        self._limit = None
        self.discriminator = None

        if field is not None:
            self.field = field
        self.limit = limit

    @property
    def field(self):
        """Gets the field of this SearchAggregation.  # noqa: E501

        The reference field for aggregation. Distinct values of the field are counted in the search results, ignoring pagination, and the top most common are presented in the response.<br /> Possible values are `rootCommunity`, `resourceType`, `assetType`, `domainType`, `status`, `lastModifiedOn`, `createdOn`, `createdBy` and `tags`.  # noqa: E501

        :return: The field of this SearchAggregation.  # noqa: E501
        :rtype: str
        """
        return self._field

    @field.setter
    def field(self, field):
        """Sets the field of this SearchAggregation.

        The reference field for aggregation. Distinct values of the field are counted in the search results, ignoring pagination, and the top most common are presented in the response.<br /> Possible values are `rootCommunity`, `resourceType`, `assetType`, `domainType`, `status`, `lastModifiedOn`, `createdOn`, `createdBy` and `tags`.  # noqa: E501

        :param field: The field of this SearchAggregation.  # noqa: E501
        :type: str
        """

        self._field = field

    @property
    def limit(self):
        """Gets the limit of this SearchAggregation.  # noqa: E501

        Optional limit for the number of top aggregated results to return. If not set, the default limit of `10` is used.<br /> The maximum possible value is 1000.  # noqa: E501

        :return: The limit of this SearchAggregation.  # noqa: E501
        :rtype: int
        """
        return self._limit

    @limit.setter
    def limit(self, limit):
        """Sets the limit of this SearchAggregation.

        Optional limit for the number of top aggregated results to return. If not set, the default limit of `10` is used.<br /> The maximum possible value is 1000.  # noqa: E501

        :param limit: The limit of this SearchAggregation.  # noqa: E501
        :type: int
        """
        if (self.local_vars_configuration.client_side_validation and
                limit is not None and limit > 1000):  # noqa: E501
            raise ValueError("Invalid value for `limit`, must be a value less than or equal to `1000`")  # noqa: E501
        if (self.local_vars_configuration.client_side_validation and
                limit is not None and limit < 0):  # noqa: E501
            raise ValueError("Invalid value for `limit`, must be a value greater than or equal to `0`")  # noqa: E501

        self._limit = limit

    def to_dict(self):
        """Returns the model properties as a dict"""
        result = {}

        for attr, _ in six.iteritems(self.openapi_types):
            value = getattr(self, attr)
            if isinstance(value, list):
                result[attr] = list(map(
                    lambda x: x.to_dict() if hasattr(x, "to_dict") else x,
                    value
                ))
            elif hasattr(value, "to_dict"):
                result[attr] = value.to_dict()
            elif isinstance(value, dict):
                result[attr] = dict(map(
                    lambda item: (item[0], item[1].to_dict())
                    if hasattr(item[1], "to_dict") else item,
                    value.items()
                ))
            else:
                result[attr] = value

        return result

    def to_str(self):
        """Returns the string representation of the model"""
        return pprint.pformat(self.to_dict())

    def __repr__(self):
        """For `print` and `pprint`"""
        return self.to_str()

    def __eq__(self, other):
        """Returns true if both objects are equal"""
        if not isinstance(other, SearchAggregation):
            return False

        return self.to_dict() == other.to_dict()

    def __ne__(self, other):
        """Returns true if both objects are not equal"""
        if not isinstance(other, SearchAggregation):
            return True

        return self.to_dict() != other.to_dict()
