# -*- coding: utf-8 -*-
from setuptools import setup

packages = \
['trakt_scrobbler', 'trakt_scrobbler.player_monitors']

package_data = \
{'': ['*']}

install_requires = \
['appdirs>=1.4.3,<2.0.0',
 'cleo>=0.7.6,<0.8.0',
 'confuse>=1.0.0,<2.0.0',
 'guessit>=3.1.0,<4.0.0',
 'requests>=2.22.0,<3.0.0',
 'toml>=0.10.0,<0.11.0']

extras_require = \
{':sys_platform == "win32"': ['pywin32>=227,<228', 'win10toast>=0.9,<0.10']}

entry_points = \
{'console_scripts': ['trakts = trakt_scrobbler.commands:main']}

setup_kwargs = {
    'name': 'trakt-scrobbler',
    'version': '1.0.0b0',
    'description': 'Scrobbler for trakt.tv that supports VLC, Plex, MPC-HC, and MPV',
    'long_description': '# Trakt Scrobbler\n\nA trakt.tv scrobbler for your computer.\n\n## What is Trakt?\n\nAutomatically scrobble TV show episodes and movies you are watching to [Trakt.tv](https://trakt.tv)! It keeps a history of everything you\'ve watched!\n\n## What is trakt-scrobbler?\n\nTrakt.tv has a lot of [plugins](https://trakt.tv/apps) to automatically scrobble the movies and episodes you watch from your media center. But there is a dearth of up-to-date apps for syncing your progress on Desktop environments. This is where `trakt-scrobbler` comes in! It is a Python application that runs in the background and monitors your media players for any new activity. When it detects some file being played, it determines the media info (such as name of the movie/show, episode number, etc.) and sends this to trakt servers, so that it can be marked as "Currently Watching" on your profile. No manual intervention required!\n\n## Features\n\n*   Full featured command line interface to control the service. Just run `trakts`.\n*   Automatic media metadata extraction using [guessit](https://github.com/guessit-io/guessit).\n*   For cases when it misidentifies the files, you can specify a regex to manually extract the necessary details.\n*   Scrobbling is independent of the player(s) where the media is played. Support for new players can thus be easily added.\n*   Currently supports:\n    *   [VLC](https://www.videolan.org/vlc/) (via web interface)\n    *   [Plex](https://www.plex.tv) (doesn\'t require Plex Pass)\n    *   [MPV](https://mpv.io) (via IPC server)\n    *   [MPC-BE](https://sourceforge.net/projects/mpcbe/)/[MPC-HC](https://mpc-hc.org) (via web interface).\n*   **Folder whitelisting:** Only media files from subdirectories of these folders are synced with trakt.\n\nFor more information, see the [`How it works`](#how-it-works) section.\n\n## Getting started\n\n### Players\n\n*   **VLC:** Enable the Lua Web Interface from advanced options. Don\'t forget to specify the password in Lua options.\n\n      ![VLC Web Interface](https://wiki.videolan.org/images/thumb/VLC_2.0_Activate_HTTP.png/450px-VLC_2.0_Activate_HTTP.png)\n\n*   **Plex:** No server side set up is required, as the app uses the existing API. Do note that since this is a polling based approach, it will be inferior to Webhooks. So if you are a premium user of Plex, it is recommended to use that directly. This app is mainly useful for those users who don\'t need most of the features of Plex Pass.\n\n*   **MPV:** Enable the [JSON IPC](https://mpv.io/manual/master/#json-ipc), either via the mpv.conf file, or by passing it as a command line option.\n\n*   **MPC-BE/MPC-HC:** Enable the web interface from Options.\n\n### Installation\n\n1.  Ensure you have [Python 3.7](https://www.python.org/downloads/) or higher installed, and in your system `PATH`. (Check by running `python --version`)\n2.  Ensure `pip` is installed. (Check: `pip --version`)\n3.  Open a terminal/powershell.\n4.  Install [`pipx`](https://pipxproject.github.io/pipx/):\n    MacOS:\n    ```bash\n    brew install pipx\n    pipx ensurepath\n    ```\n    Linux and windows (replace `python3` with `python` if the commands fail):\n    ```bash\n    python3 -m pip install --user pipx\n    python3 -m pipx ensurepath\n    ```\n5.  Run `pipx install trakt-scrobbler`. You will now have the `trakts` command available.\n6.  Run `trakts init`. You will be prompted to authorize the program to access the Trakt.tv API. Follow the steps on screen to finish the process.\n\n**For Linux:**\nTo enable notification support on Linux, `libnotify` needs to be installed (Reboot after installation).\n\n*   Arch/Manjaro: `pacman -S libnotify`\n*   Ubuntu: `apt install libnotify-bin`\n\n## FAQs\n\n#### It doesn\'t work. What do I do?\n\nFirst, look through the [log file](#where-is-the-log-fileother-data-stored) to see what went wrong. If you are unable to fix the problem, feel free to create an [Issue](https://github.com/iamkroot/trakt-scrobbler/issues).\n\n#### `trakts` usage:\n\nThe various commands available are:\n\n*   `auth`: Runs the authetication flow for trakt.tv\n*   `autostart`: Controls the autostart behaviour of the scrobbler\n*   `config`: Edits the scrobbler config settings\n\n    *   `list`: This command will list the parameters in the config, along with their current values.\n          Eg: `trakts config list`\n\n            players.monitored = [\'mpv\', \'vlc\']\n            players.skip_interval = 5\n            general.enable_notifs = True\n            fileinfo.whitelist = [\'/path/to/movies\', \'/path/to/anime\', \'/path/to/TV\']\n\n          Additionally, it also accepts a `--all` option, which can be used to list *ALL* the config parameters, including those not overriden by the user.\n\n    *   `set`: Set the value for a config parameter.\n\n        *   Separate multiple values with spaces. \n              Eg: `trakts config set players.monitored mpv vlc mpc-be`\n\n                User config updated with \'players.monitored = [\'mpv\', \'vlc\', \'mpc-be\']\'\n\n        *   For values containing space(s), surround them with double-quotes. \n              Eg: `trakts config set fileinfo.whitelist D:\\Media\\Movies "C:\\Users\\My Name\\Shows"`\n\n                User config updated with \'fileinfo.whitelist = [\'D:MediaMovies\', \'C:\\\\Users\\\\My Name\\\\Shows\']\'\n\n        *   Use `--add` to avoid overwriting the previous list values (whitelist, monitored, etc.):\n              `trakts config set players.monitored mpv vlc`\n              `trakts config set --add players.monitored plex mpc-hc`\n              will have final value: \n\n                User config updated with \'players.monitored = [\'mpv\', \'vlc\', \'plex\', \'mpc-hc\']\'\n\n*   `init`: Runs the initial setup of the scrobbler.\n*   `run`: Run the scrobbler in the foreground. Mainly needed in case you have disabled the autostart service, and want to run the app manually.\n*   `start`: Starts the trakt-scrobbler service. If already running, does nothing.\n    *   Use `--restart` to force restart the service.\n*   `status`: Shows the status trakt-scrobbler service.\n*   `stop`: Stops the trakt-scrobbler service.\n*   `whitelist`: Shortcut command to add folder(s) to whitelist in config.\n    *   For folders containing spaces, use double quotes:\n          `trakts whitelist D:\\Media\\Movies "C:\\Users\\My Name\\Shows"`\n    *   Run `trakts whitelist --show` to list the current folders in whitelist.\n\n#### How to update?\n\n1.  Stop the app using `trakts stop`\n2.  Run `pipx upgrade trakt-scrobbler`\n\n#### Where is the log file/other data stored?\n\n*   **Linux:** `~/.local/share/trakt-scrobbler/`\n*   **Mac:** Same as config file (see above)\n*   **Windows:** Same as config file (see above)\n\nThe latest log is stored in a file named `trakt_scrobbler.log`; older logs can be found in the files `...log.1`, `...log.2`, and so on.\nEverything is in human readable form, so that you can figure out what data is used by the app. While submitting a bug report, be sure to include the log file contents.\n\n## How it works\n\nThis is an application written in the Python programming language, designed for hassle-free integration of your media players with Trakt. Once set up, you can forget that it exists.\n\n*   The app is designed to start with your PC, and remain running in the backgroud.\n*   It has a "monitor" for each media player you specify. This monitor keeps checking if the media player is running or not. If not, you get the "Could not connect..." message in the log file.\n*   When the player is running, the monitor extracts the currently playing media information from the player.\n*   This media file path is parsed using `guessit` (or regexes, if specified) to recognize the metadata such as "Title", "Season", etc.\n*   This info, along with the playing state (`playing`, `stopped` or `paused`) and progress are then sent to trakt.tv using their API to update their side and mark the media as "Currently Watching", "Finished", etc and you get a notification of the same.\n*   Once the player is closed, the monitor goes back to "dormant" state, where it waits for the player to start again.\n\n### Other details\n\n*   The checking for media info from player happens at a set interval (`poll_interval` in config, 10 secs by default), which is the maximum delay between you starting/stopping/pausing the player, and the monitor recognizing that activity.\n*   Generally, this app provides "live" updates to trakt regarding your playing status. However, in cases where the internet is down, when you finish playback, the app remembers the media that you have finished watching (progress > 90%) and will try to sync that information with trakt the next time internet becomes available.\n\n## Configuration\n\nThe config is stored in [YAML](https://yaml.org) format. Most parameters have default values, stored in [`config_default.yaml`](trakt_scrobbler/config_default.yaml). You can use the `config` command to override the alues.\n\n*   `fileinfo.whitelist`: (List of folder path strings | Default: `[]` aka Allow all)\n    *   List of directories you want to be scanned for shows or movies.\n    *   If empty, all files played in the player are scanned.\n    *   You can prevent the program from scanning all played files if your shows and movies are located in fixed directories.\n    *   If possible you should use this option to minimize traffic on the Trakt API.\n*   `fileinfo.include_regexes`: (Default: `{movie = [], episode = []}`)\n    *   If you find that the default module for identifying media info ([guessit](https://github.com/guessit-io/guessit)) is misidentifying some titles, you can specify the regex for that file path.\n    *   The regex should have posix-like path, and not Windows\' `\\` to separate directories.\n    *   The minimum required information is the title of the file, and episode number in the case of TV Shows. If season is not found, it defaults to 1.\n    *   Mainly useful for Anime since they don\'t follow the season convention.\n*   `players.monitored`: (List of player names)\n    Specify players which are to be monitored for scrobbling.\n*   Other player specific parameters: For most installations, you won\'t have to fiddle with these as the app can automatically read the settings of the players and extract the necessary values.\n\n## TODO\n\n*   [x] Switch to poetry for dependency management\n*   [x] Make a unified installer script for all OSes\n*   [x] Proper configuration management module with autodetection for players\n*   [x] A CLI for controlling the app (start, stop, config, etc.)\n*   [ ] Use a proper [Windows Service](http://thepythoncorner.com/dev/how-to-create-a-windows-service-in-python/) instead of an autostart script\n\n## Contributing\n\nFeel free to create a new issue in case you find a bug/want to have a feature added. Proper PRs are welcome.\n\n## Authors\n\n*   [iamkroot](https://www.github.com/iamkroot)\n\n## Acknowledgements\n\n*   Inspired from [TraktForVLC](https://github.com/XaF/TraktForVLC)\n*   [mpv-trakt-sync-daemon](https://github.com/stareInTheAir/mpv-trakt-sync-daemon) was a huge help in making the mpv monitor',
    'author': 'iamkroot',
    'author_email': 'kroot.patel@gmail.com',
    'maintainer': None,
    'maintainer_email': None,
    'url': 'https://github.com/iamkroot/trakt-scrobbler',
    'packages': packages,
    'package_data': package_data,
    'install_requires': install_requires,
    'extras_require': extras_require,
    'entry_points': entry_points,
    'python_requires': '>=3.7,<4.0',
}


setup(**setup_kwargs)
