[![pypi](https://img.shields.io/pypi/v/hackerforms.svg)](https://pypi.python.org/pypi/hackerforms)
[![PyPI Downloads](https://img.shields.io/pypi/dm/hackerforms.svg)](https://pypi.org/project/hackerforms/)
[![Code check](https://github.com/abstra-app/hackerforms-lib/actions/workflows/code_check.yml/badge.svg)](https://github.com/abstra-app/hackerforms-lib/actions/workflows/code_check.yml)

# Hackerforms

Launch interactive Python scripts as beautiful form-like apps

![docs_editor](https://user-images.githubusercontent.com/8538337/200737655-7d212aef-e07a-4425-8cab-40000be3539d.gif)

No HTML, CSS, JS... With single line commands, get data from users and display info to them.

## Examples

- Customer checkout - [code](https://github.com/abstra-app/hackerforms-examples/blob/master/forms/customer_checkout.py) - [live example](https://examples.abstra.run/b97fd987-d9b2-4af3-802d-2400f2a546d4)
- Customer registration - [code](https://github.com/abstra-app/hackerforms-examples/blob/master/forms/customer_registration.py) - [live example](https://examples.abstra.run/81e15ebb-40bf-444e-8c83-35aafbc033b9)
- Generate documents from spreadsheet - [code](https://github.com/abstra-app/hackerforms-examples/blob/master/forms/generate_documents_from_spreadsheet.py) - [live example](https://examples.abstra.run/60b43bcc-766f-4ec7-b589-527e625c6f09)
- Investor registration - [code](https://github.com/abstra-app/hackerforms-examples/blob/master/forms/investor_registration.py) - [live example](https://examples.abstra.run/4b7ee890-1a3d-4ef3-9da6-0709040f60a4)
- Lead gen form - [code](https://github.com/abstra-app/hackerforms-examples/blob/master/forms/lead_gen_form.py) - [live example](https://examples.abstra.run/faf35181-6002-4220-a9cd-abbb87b711a1)
- Send customized emails from spreadsheet - [code](https://github.com/abstra-app/hackerforms-examples/blob/master/forms/send_customized_emails_from_spreadsheet.py) - [live example](https://examples.abstra.run/c0efcd04-9776-46fe-9690-98bcee9f41df)
- Send Stripe payment confirmation to Slack - [code](https://github.com/abstra-app/hackerforms-examples/blob/master/forms/send_stripe_payment_confirmation_to_slack.py) - [live example](nan)
- User-specific spreadsheet access - [code](https://github.com/abstra-app/hackerforms-examples/blob/master/forms/spreadsheet_access.py) - [live example](https://examples.abstra.run/ae267dde-c3dd-4ab0-968c-f0329b04fc66)
- Tax calculator - [code](https://github.com/abstra-app/hackerforms-examples/blob/master/forms/tax_calculator.py) - [live example](https://examples.abstra.run/cbdc145f-608d-4a13-a796-641f728aa6ee)
- Team registration - [code](https://github.com/abstra-app/hackerforms-examples/blob/master/forms/team_registration.py) - [live example](https://examples.abstra.run/db973900-5dfe-44e7-b03e-ce24fff08f54)
- Travel registration - [code](https://github.com/abstra-app/hackerforms-examples/blob/master/forms/travel_registration.py) - [live example](https://examples.abstra.run/d6d7a11f-c26d-46ec-bf77-5449fefaaf79)
- Vacation approval - [code](https://github.com/abstra-app/hackerforms-examples/blob/master/forms/vacation_approval.py) - [live example](https://examples.abstra.run/842f9872-59fd-4735-8b9a-4e6f5065a96e)

[See all widgets here](https://docs.abstracloud.com/library/widgets)

## Installation

```bash
pip install hackerforms
```

## Links

- [Examples](https://github.com/abstra-app/hackerforms-examples/tree/master/python)
- [Docs](https://docs.abstracloud.com/)
