/*
 * Decompiled with CFR 0.152.
 */
package org.gavrog.joss.pgraphs.io;

import junit.framework.TestCase;
import org.gavrog.joss.geometry.Vector;
import org.gavrog.joss.pgraphs.basic.INode;
import org.gavrog.joss.pgraphs.basic.PeriodicGraph;
import org.gavrog.joss.pgraphs.io.NetParser;

public class TestNetParser
extends TestCase {
    PeriodicGraph pcu;
    PeriodicGraph dia;
    PeriodicGraph srs;
    PeriodicGraph ths;
    PeriodicGraph tfa;

    public void setUp() throws Exception {
        super.setUp();
        this.pcu = NetParser.stringToNet("PERIODIC_GRAPH\n  1 1  1 0 0\n  1 1  0 1 0\n  1 1  0 0 1\nEND\n");
        this.dia = new PeriodicGraph(3);
        INode v1 = this.dia.newNode();
        INode v2 = this.dia.newNode();
        this.dia.newEdge(v1, v2, new int[3]);
        int[] nArray = new int[3];
        nArray[0] = 1;
        this.dia.newEdge(v1, v2, nArray);
        int[] nArray2 = new int[3];
        nArray2[1] = 1;
        this.dia.newEdge(v1, v2, nArray2);
        int[] nArray3 = new int[3];
        nArray3[2] = 1;
        this.dia.newEdge(v1, v2, nArray3);
        this.srs = NetParser.stringToNet("PERIODIC_GRAPH\n  1 2  0 0 0\n  1 3  0 0 0\n  1 4  0 0 0\n  2 3  1 0 0\n  2 4  0 1 0\n  3 4  0 0 1\nEND\n");
        this.ths = NetParser.stringToNet("PERIODIC_GRAPH\n  1 2  0 0 0\n  1 3  0 0 0\n  2 4  0 0 0\n  1 3  1 0 0\n  2 4  0 1 0\n  3 4  0 0 1\nEND\n");
        this.tfa = NetParser.stringToNet("PERIODIC_GRAPH\n  1 2  0 0 0\n  1 3  0 0 0\n  1 3  1 0 0\n  2 3  0 1 0\n  2 3  0 0 1\nEND\n");
    }

    public void tearDown() throws Exception {
        this.tfa = null;
        this.srs = null;
        this.dia = null;
        this.pcu = null;
        super.tearDown();
    }

    public void testParsePeriodicGraph() {
        PeriodicGraph G = NetParser.stringToNet("PERIODIC_GRAPH\n # the diamond net, of course\n 1 2 0 0 0\n 1 2 1 0 0\n 1 2 0 1 0\n 1 2 0 0 1\nEND\n");
        TestNetParser.assertEquals((String)"(1,2,[0,0,0])(1,2,[1,0,0])(1,2,[0,1,0])(1,2,[0,0,1])", (String)G.toString());
    }

    public void testParseSymmetricNet() {
        PeriodicGraph H = NetParser.stringToNet("NET # primitive cubic\n  Group P432\n  Node 1 0,0,0\n  Edge 1 1 x+1,y,z\nEND\n");
        TestNetParser.assertEquals((int)1, (int)H.numberOfNodes());
        TestNetParser.assertEquals((int)3, (int)H.numberOfEdges());
        INode v = H.nodes().next();
        TestNetParser.assertNotNull((Object)H.getEdge(v, v, new Vector(1, 0, 0)));
        TestNetParser.assertNotNull((Object)H.getEdge(v, v, new Vector(0, 1, 0)));
        TestNetParser.assertNotNull((Object)H.getEdge(v, v, new Vector(0, 0, 1)));
        PeriodicGraph D = NetParser.stringToNet("NET # the diamond net\n  Group Fd-3m\n  Node 1 3/8,3/8,3/8\n  Edge 1 1 1-x,1-y,1-z\nEND\n");
        TestNetParser.assertEquals((Object)this.dia, (Object)D);
        PeriodicGraph sq = NetParser.stringToNet("NET # square lattice on the plane\n  Group p4mm\n  Node 1 0,0\n  Edge 1 1 x+1,y\nEND\n");
        TestNetParser.assertEquals((int)1, (int)sq.numberOfNodes());
        TestNetParser.assertEquals((int)2, (int)sq.numberOfEdges());
        INode w = sq.nodes().next();
        TestNetParser.assertNotNull((Object)sq.getEdge(w, w, new Vector(1, 0)));
        TestNetParser.assertNotNull((Object)sq.getEdge(w, w, new Vector(0, 1)));
        PeriodicGraph hex1 = NetParser.stringToNet("NET # planar honeycombs\n  Group p6mm\n  Node 1 2/3,1/3\n  Edge 1 1 y,y-x\nEND\n");
        PeriodicGraph hex2 = NetParser.stringToNet("PERIODIC_GRAPH # planar honeycombs\n  1 2  0 0\n  1 2  1 0\n  1 2  0 1\nEND\n");
        TestNetParser.assertEquals((Object)hex2, (Object)hex1);
    }

    public void testParseCrystal() {
        PeriodicGraph _dia = NetParser.stringToNet("CRYSTAL # diamond again\n  Group Fd-3m\n  Cell  2.3094 2.3094 2.3094  90.0 90.0 90.0\n  Node  1 4 5/8 5/8 5/8\nEND\n");
        TestNetParser.assertEquals((Object)this.dia, (Object)_dia);
        PeriodicGraph _srs = NetParser.stringToNet("CRYSTAL\nNAME srs\nGROUP I4132\nCELL 2.8284 2.8284 2.8284 90.0 90.0 90.0\nVERTICES\n  1 3 0.125 0.125 0.125\nEND\n");
        TestNetParser.assertEquals((Object)this.srs, (Object)_srs);
        PeriodicGraph _pcu = NetParser.stringToNet("CRYSTAL\n  Name pcu\n  Group P1\n  Cell 2.3 2.3 2.9 90.0 90.0 90.0\n  Node 1 6 0.345 0.128 0.743\nEND\n");
        TestNetParser.assertEquals((Object)this.pcu, (Object)_pcu);
        PeriodicGraph _ths = NetParser.stringToNet("CRYSTAL\nNAME ths\nGROUP I41/amd\nCELL 1.8856 1.8856 5.3344 90.0 90.0 90.0\nVERTICES\n  1 3 0.0 0.25 0.9687\nEND\n");
        TestNetParser.assertEquals((Object)this.ths, (Object)_ths);
        PeriodicGraph _tfa = NetParser.stringToNet("CRYSTAL\nNAME tfa\nGROUP I-4m2\nCELL 1.8016 1.8016 3.737 90.0 90.0 90.0\nVERTICES\n  1 3 0.0 0.5 0.3838\n  2 4 0.0 0.0 0.0\nEND\n");
        TestNetParser.assertEquals((Object)this.tfa, (Object)_tfa);
        PeriodicGraph tri1 = NetParser.stringToNet("CRYSTAL # regular triangle tiling\nGROUP p1\nCELL 1.0 1.0 60.0\nNODE 1 6 0 0\nEND\n");
        PeriodicGraph tri2 = NetParser.stringToNet("PERIODIC_GRAPH # regular triangle tiling\n  1 1  1 0\n  1 1  0 1\n  1 1  1 1\nEND\n");
        TestNetParser.assertEquals((Object)tri2, (Object)tri1);
        PeriodicGraph bathroom1 = NetParser.stringToNet("CRYSTAL\nGROUP p4mm\nCELL 2.4142 2.4142 90.0\nNODE 1 3 0.2929 0.0\nEND\n");
        PeriodicGraph bathroom2 = NetParser.stringToNet("PERIODIC_GRAPH\n  1 2  0 0\n  2 3  0 0\n  3 4  0 0\n  4 1  0 0\n  1 3  1 0\n  2 4  0 1\nEND\n");
        TestNetParser.assertEquals((Object)bathroom2, (Object)bathroom1);
        PeriodicGraph hex1 = NetParser.stringToNet("CRYSTAL # planar honeycombs\nGROUP p6mm\nCELL 1.732 1.732 120.0\nVERTEX 1 3 2/3 1/3\nEND\n");
        PeriodicGraph hex2 = NetParser.stringToNet("PERIODIC_GRAPH # planar honeycombs\n  1 2  0 0\n  1 2  1 0\n  1 2  0 1\nEND\n");
        TestNetParser.assertEquals((Object)hex2, (Object)hex1);
        PeriodicGraph cds1 = NetParser.stringToNet("CRYSTAL\nGROUP Pmn21\nCELL  6.558 4.698 4.719 90.0 90.0 90.0\nATOM  1 4  0.0000  0.6657  0.7306\nEDGE  1 2\nEDGE  1    0.0000  0.1416  0.2500\nEDGE  0.0000  0.6657  0.7306    0.0000  1.1416  1.2500\n     1   -0.5000  0.8584  0.7500\nATOM  2 4  0.5000  0.8584  0.7500\nEDGE  2    0.0000  0.6657  0.7306\n      2    1.0000  0.6657  0.7306\n      2    0.5000  1.3343  0.2306\n      2    0.5000  0.3343  1.2306\nEND\n");
        PeriodicGraph cds2 = NetParser.stringToNet("PERIODIC_GRAPH\n1 3 -1 0 0\n1 3 0 0 0\n1 4 0 0 0\n1 4 0 1 1\n2 3 0 -1 0\n2 3 0 0 -1\n2 4 0 0 0\n2 4 1 0 0\nEND\n");
        TestNetParser.assertEquals((String)cds2.canonical().toString(), (String)cds1.canonical().toString());
        PeriodicGraph lon1 = NetParser.stringToNet("PERIODIC_GRAPH\n1 2 0 0 0\n1 2 0 1 0\n1 2 1 0 0\n1 3 0 0 0\n2 4 0 0 0\n3 4 0 0 1\n3 4 0 1 1\n3 4 1 0 1\nEND\n");
        PeriodicGraph lon2 = NetParser.stringToNet("CRYSTAL\nNAME lon\nGROUP P63/mmc\nCELL 1.6331 1.6331 2.6667 90.0 90.0 120.0\nVERTICES\n  \"V1\" 4 0.3333 0.6667 0.0625\nCOORDINATION_SEQUENCES\n  4 12 25 44 67 96 130 170 214 264\nVERTEX_SYMBOLS\n  6(2).6(2).6(2).6(2).6(2).6(2)\nEDGE_CENTERS\n  \"E1\" 2 0.3333 0.6667 0.25\n  \"E2\" 2 0.5 0.0 0.0\nEND\n");
        TestNetParser.assertEquals((Object)lon1, (Object)lon2);
    }
}

