/*
 * Decompiled with CFR 0.152.
 */
package org.gavrog.joss.pgraphs.basic;

import java.io.BufferedReader;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import junit.framework.TestCase;
import org.gavrog.box.collections.IteratorAdapter;
import org.gavrog.box.collections.Iterators;
import org.gavrog.box.collections.Pair;
import org.gavrog.jane.compounds.Matrix;
import org.gavrog.jane.numbers.FloatingPoint;
import org.gavrog.jane.numbers.Whole;
import org.gavrog.joss.geometry.CoordinateChange;
import org.gavrog.joss.geometry.Operator;
import org.gavrog.joss.geometry.Point;
import org.gavrog.joss.geometry.Vector;
import org.gavrog.joss.pgraphs.basic.Cover;
import org.gavrog.joss.pgraphs.basic.IEdge;
import org.gavrog.joss.pgraphs.basic.INode;
import org.gavrog.joss.pgraphs.basic.Morphism;
import org.gavrog.joss.pgraphs.basic.PeriodicGraph;
import org.gavrog.joss.pgraphs.io.Archive;
import org.gavrog.joss.pgraphs.io.NetParser;

public class TestPeriodicGraph
extends TestCase {
    private PeriodicGraph G;
    private PeriodicGraph dia;
    private PeriodicGraph cds;
    private INode v1;
    private INode v2;
    private PeriodicGraph.CoverNode w1;
    private PeriodicGraph.CoverNode w2;
    private IEdge e1;
    private IEdge e2;
    private IEdge e3;
    private IEdge e4;
    private PeriodicGraph.CoverEdge f1;
    private PeriodicGraph.CoverEdge f2;
    private PeriodicGraph.CoverEdge f3;
    private PeriodicGraph.CoverEdge f4;

    protected void setUp() throws Exception {
        super.setUp();
        this.G = new PeriodicGraph(3);
        this.v1 = this.G.newNode();
        this.v2 = this.G.newNode();
        this.e1 = this.G.newEdge(this.v1, this.v2);
        int[] nArray = new int[3];
        nArray[0] = 1;
        this.e2 = this.G.newEdge(this.v2, this.v2, nArray);
        int[] nArray2 = new int[3];
        nArray2[1] = -1;
        this.e3 = this.G.newEdge(this.v2, this.v1, nArray2);
        int[] nArray3 = new int[3];
        nArray3[2] = 1;
        this.e4 = this.G.newEdge(this.v1, this.v1, nArray3);
        PeriodicGraph periodicGraph = this.G;
        periodicGraph.getClass();
        this.w1 = periodicGraph.new PeriodicGraph.CoverNode(this.v1, new Vector(1, 2, 3));
        PeriodicGraph periodicGraph2 = this.G;
        periodicGraph2.getClass();
        this.w2 = periodicGraph2.new PeriodicGraph.CoverNode(this.v2, new Vector(1, 0, 2));
        PeriodicGraph periodicGraph3 = this.G;
        periodicGraph3.getClass();
        this.f1 = periodicGraph3.new PeriodicGraph.CoverEdge(this.e1);
        PeriodicGraph periodicGraph4 = this.G;
        periodicGraph4.getClass();
        this.f2 = periodicGraph4.new PeriodicGraph.CoverEdge(this.e2, new Vector(0, 1, 0));
        PeriodicGraph periodicGraph5 = this.G;
        periodicGraph5.getClass();
        this.f3 = periodicGraph5.new PeriodicGraph.CoverEdge(this.e3, new Vector(1, 0, 1));
        PeriodicGraph periodicGraph6 = this.G;
        periodicGraph6.getClass();
        this.f4 = periodicGraph6.new PeriodicGraph.CoverEdge(this.e4, new Vector(0, -1, 40));
        this.dia = this.diamond();
        this.cds = this.CdSO4();
    }

    protected void tearDown() throws Exception {
        super.tearDown();
        this.v2 = null;
        this.v1 = null;
        this.e4 = null;
        this.e3 = null;
        this.e2 = null;
        this.e1 = null;
        this.cds = null;
        this.dia = null;
        this.G = null;
    }

    private PeriodicGraph diamond() {
        PeriodicGraph dia = new PeriodicGraph(3);
        INode v1 = dia.newNode();
        INode v2 = dia.newNode();
        dia.newEdge(v1, v2, new int[3]);
        int[] nArray = new int[3];
        nArray[0] = -1;
        dia.newEdge(v1, v2, nArray);
        int[] nArray2 = new int[3];
        nArray2[1] = -1;
        dia.newEdge(v1, v2, nArray2);
        int[] nArray3 = new int[3];
        nArray3[2] = -1;
        dia.newEdge(v1, v2, nArray3);
        return dia;
    }

    private PeriodicGraph doubleHexGrid() {
        PeriodicGraph H = new PeriodicGraph(2);
        INode v1 = H.newNode();
        INode v2 = H.newNode();
        INode v3 = H.newNode();
        INode v4 = H.newNode();
        H.newEdge(v1, v2, new int[2]);
        int[] nArray = new int[2];
        nArray[0] = 1;
        H.newEdge(v1, v2, nArray);
        int[] nArray2 = new int[2];
        nArray2[1] = 1;
        H.newEdge(v1, v2, nArray2);
        H.newEdge(v3, v4, new int[2]);
        int[] nArray3 = new int[2];
        nArray3[0] = 1;
        H.newEdge(v3, v4, nArray3);
        int[] nArray4 = new int[2];
        nArray4[1] = 1;
        H.newEdge(v3, v4, nArray4);
        H.newEdge(v1, v3, new int[]{-1, -1});
        return H;
    }

    private PeriodicGraph hexGrid() {
        PeriodicGraph H = new PeriodicGraph(2);
        INode v1 = H.newNode();
        INode v2 = H.newNode();
        H.newEdge(v1, v2, new int[2]);
        int[] nArray = new int[2];
        nArray[0] = 1;
        H.newEdge(v1, v2, nArray);
        int[] nArray2 = new int[2];
        nArray2[1] = 1;
        H.newEdge(v1, v2, nArray2);
        return H;
    }

    private PeriodicGraph CdSO4() {
        PeriodicGraph cds = new PeriodicGraph(3);
        INode w1 = cds.newNode();
        INode w2 = cds.newNode();
        INode w3 = cds.newNode();
        INode w4 = cds.newNode();
        int[] nArray = new int[3];
        nArray[0] = -1;
        cds.newEdge(w1, w3, nArray);
        cds.newEdge(w1, w3, new int[3]);
        cds.newEdge(w1, w4, new int[3]);
        int[] nArray2 = new int[3];
        nArray2[1] = 1;
        nArray2[2] = 1;
        cds.newEdge(w1, w4, nArray2);
        int[] nArray3 = new int[3];
        nArray3[1] = -1;
        cds.newEdge(w2, w3, nArray3);
        int[] nArray4 = new int[3];
        nArray4[2] = -1;
        cds.newEdge(w2, w3, nArray4);
        cds.newEdge(w2, w4, new int[3]);
        int[] nArray5 = new int[3];
        nArray5[0] = 1;
        cds.newEdge(w2, w4, nArray5);
        return cds;
    }

    public void testCopyConstructor() {
        PeriodicGraph copy = new PeriodicGraph(this.cds);
        TestPeriodicGraph.assertEquals((Object)this.cds, (Object)copy);
    }

    public void testNewEdge() {
        IEdge e1 = this.G.newEdge(this.v1, this.v2, new int[]{1, 1, 1});
        TestPeriodicGraph.assertEquals((Object)new Vector(1, 1, 1), (Object)this.G.getShift(e1));
        String s1 = "(1,1,[0,0,-1])(1,2,[0,0,0])(1,2,[0,1,0])(1,2,[1,1,1])(2,2,[-1,0,0])";
        TestPeriodicGraph.assertEquals((String)"(1,1,[0,0,-1])(1,2,[0,0,0])(1,2,[0,1,0])(1,2,[1,1,1])(2,2,[-1,0,0])", (String)this.G.toString());
        this.G.delete(e1);
        INode v3 = this.G.newNode();
        IEdge e2 = this.G.newEdge(this.v1, v3);
        TestPeriodicGraph.assertEquals((Object)new Vector(0, 0, 0), (Object)this.G.getShift(e2));
        String s2 = "(1,1,[0,0,-1])(1,2,[0,0,0])(1,2,[0,1,0])(1,3,[0,0,0])(2,2,[-1,0,0])";
        TestPeriodicGraph.assertEquals((String)"(1,1,[0,0,-1])(1,2,[0,0,0])(1,2,[0,1,0])(1,3,[0,0,0])(2,2,[-1,0,0])", (String)this.G.toString());
        try {
            this.G.newEdge(this.v1, this.v2);
            TestPeriodicGraph.fail((String)"should throw an IllegalArgumentException");
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
        try {
            this.G.newEdge(v3, v3);
            TestPeriodicGraph.fail((String)"should throw an IllegalArgumentException");
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
        try {
            this.G.newEdge(v3, v3, new int[]{1, 2, 3, 4});
            TestPeriodicGraph.fail((String)"should throw an IllegalArgumentException");
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
        this.G.newEdge(v3, v3, new int[]{1, 2, 3});
    }

    public void testDelete() {
        this.G.delete(this.e3);
        try {
            this.G.getShift(this.e3);
            TestPeriodicGraph.fail((String)"should throw an IllegalArgumentException");
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
        TestPeriodicGraph.assertEquals((String)"(1,1,[0,0,-1])(1,2,[0,0,0])(2,2,[-1,0,0])", (String)this.G.toString());
    }

    public void testShiftNode() {
        TestPeriodicGraph.assertTrue((boolean)this.G.isBarycentric(this.G.barycentricPlacement()));
        this.G.shiftNode(this.v2, new Vector(1, 1, 0));
        String s = "(1,1,[0,0,-1])(1,2,[-1,-1,0])(1,2,[-1,0,0])(2,2,[-1,0,0])";
        TestPeriodicGraph.assertEquals((String)"(1,1,[0,0,-1])(1,2,[-1,-1,0])(1,2,[-1,0,0])(2,2,[-1,0,0])", (String)this.G.toString());
        TestPeriodicGraph.assertTrue((boolean)this.G.isBarycentric(this.G.barycentricPlacement()));
    }

    public void testGetShift() {
        TestPeriodicGraph.assertEquals((Object)new Vector(0, 0, 0), (Object)this.G.getShift(this.e1));
        TestPeriodicGraph.assertEquals((Object)new Vector(1, 0, 0), (Object)this.G.getShift(this.e2));
        TestPeriodicGraph.assertEquals((Object)new Vector(0, -1, 0), (Object)this.G.getShift(this.e3));
        TestPeriodicGraph.assertEquals((Object)new Vector(0, 0, 1), (Object)this.G.getShift(this.e4));
        TestPeriodicGraph.assertEquals((Object)new Vector(0, 0, 0), (Object)this.G.getShift(this.e1.reverse()));
        TestPeriodicGraph.assertEquals((Object)new Vector(-1, 0, 0), (Object)this.G.getShift(this.e2.reverse()));
        TestPeriodicGraph.assertEquals((Object)new Vector(0, 1, 0), (Object)this.G.getShift(this.e3.reverse()));
        TestPeriodicGraph.assertEquals((Object)new Vector(0, 0, -1), (Object)this.G.getShift(this.e4.reverse()));
    }

    public void testGetEdge() {
        IEdge test1 = this.G.getEdge(this.v1, this.v2, new Vector(0, 1, 0));
        TestPeriodicGraph.assertEquals((Object)this.e3.reverse(), (Object)test1);
        TestPeriodicGraph.assertEquals((Object)this.G.getShift(this.e3.reverse()), (Object)this.G.getShift(test1));
        TestPeriodicGraph.assertEquals((Object)this.e3, (Object)this.G.getEdge(this.v2, this.v1, new Vector(0, -1, 0)));
        TestPeriodicGraph.assertNull((Object)this.G.getEdge(this.v2, this.v1, new Vector(1, -1, 0)));
        TestPeriodicGraph.assertEquals((Object)this.e2, (Object)this.G.getEdge(this.v2, this.v2, new Vector(1, 0, 0)));
        IEdge test2 = this.G.getEdge(this.v2, this.v2, new Vector(-1, 0, 0));
        TestPeriodicGraph.assertEquals((Object)this.e2.reverse(), (Object)test2);
        TestPeriodicGraph.assertEquals((Object)this.G.getShift(this.e2.reverse()), (Object)this.G.getShift(test2));
    }

    public void testCoverNodeDegree() {
        TestPeriodicGraph.assertEquals((int)4, (int)this.w1.degree());
        TestPeriodicGraph.assertEquals((int)4, (int)this.w2.degree());
    }

    public void testCoverEdgeSource() {
        PeriodicGraph periodicGraph = this.G;
        periodicGraph.getClass();
        TestPeriodicGraph.assertEquals((Object)periodicGraph.new PeriodicGraph.CoverNode(this.v1), (Object)this.f1.source());
        PeriodicGraph periodicGraph2 = this.G;
        periodicGraph2.getClass();
        TestPeriodicGraph.assertEquals((Object)periodicGraph2.new PeriodicGraph.CoverNode(this.v2, new Vector(0, 1, 0)), (Object)this.f2.source());
        PeriodicGraph periodicGraph3 = this.G;
        periodicGraph3.getClass();
        TestPeriodicGraph.assertEquals((Object)periodicGraph3.new PeriodicGraph.CoverNode(this.v2, new Vector(1, 0, 1)), (Object)this.f3.source());
        PeriodicGraph periodicGraph4 = this.G;
        periodicGraph4.getClass();
        TestPeriodicGraph.assertEquals((Object)periodicGraph4.new PeriodicGraph.CoverNode(this.v1, new Vector(0, -1, 40)), (Object)this.f4.source());
    }

    public void testCoverEdgeTarget() {
        PeriodicGraph periodicGraph = this.G;
        periodicGraph.getClass();
        TestPeriodicGraph.assertEquals((Object)periodicGraph.new PeriodicGraph.CoverNode(this.v2), (Object)this.f1.target());
        PeriodicGraph periodicGraph2 = this.G;
        periodicGraph2.getClass();
        TestPeriodicGraph.assertEquals((Object)periodicGraph2.new PeriodicGraph.CoverNode(this.v2, new Vector(1, 1, 0)), (Object)this.f2.target());
        PeriodicGraph periodicGraph3 = this.G;
        periodicGraph3.getClass();
        TestPeriodicGraph.assertEquals((Object)periodicGraph3.new PeriodicGraph.CoverNode(this.v1, new Vector(1, -1, 1)), (Object)this.f3.target());
        PeriodicGraph periodicGraph4 = this.G;
        periodicGraph4.getClass();
        TestPeriodicGraph.assertEquals((Object)periodicGraph4.new PeriodicGraph.CoverNode(this.v1, new Vector(0, -1, 41)), (Object)this.f4.target());
    }

    public void testCoverEdgeOpposite() {
        PeriodicGraph periodicGraph = this.G;
        periodicGraph.getClass();
        PeriodicGraph.CoverNode w1 = periodicGraph.new PeriodicGraph.CoverNode(this.v1);
        PeriodicGraph periodicGraph2 = this.G;
        periodicGraph2.getClass();
        PeriodicGraph.CoverNode w2 = periodicGraph2.new PeriodicGraph.CoverNode(this.v2);
        PeriodicGraph periodicGraph3 = this.G;
        periodicGraph3.getClass();
        PeriodicGraph.CoverNode w3 = periodicGraph3.new PeriodicGraph.CoverNode(this.v2, new Vector(0, 1, 0));
        PeriodicGraph periodicGraph4 = this.G;
        periodicGraph4.getClass();
        PeriodicGraph.CoverNode w4 = periodicGraph4.new PeriodicGraph.CoverNode(this.v2, new Vector(1, 1, 0));
        TestPeriodicGraph.assertEquals((Object)w2, (Object)this.f1.opposite(w1));
        TestPeriodicGraph.assertEquals((Object)w1, (Object)this.f1.opposite(w2));
        TestPeriodicGraph.assertEquals((Object)w3, (Object)this.f2.opposite(w4));
        TestPeriodicGraph.assertEquals((Object)w4, (Object)this.f2.opposite(w3));
    }

    public void testCoverEdgeReverse() {
        PeriodicGraph.CoverEdge r1 = this.f1.reverse();
        TestPeriodicGraph.assertEquals((Object)this.f1.target(), (Object)r1.source());
        TestPeriodicGraph.assertEquals((Object)this.f1.source(), (Object)r1.target());
        TestPeriodicGraph.assertEquals((Object)this.f1.unoriented(), (Object)r1.unoriented());
        TestPeriodicGraph.assertFalse((boolean)this.f1.oriented().equals(r1.unoriented()));
        TestPeriodicGraph.assertFalse((boolean)this.f1.equals(r1));
    }

    public void testCoverElementOwner() {
        TestPeriodicGraph.assertEquals((Object)this.G, (Object)this.w1.owner());
        TestPeriodicGraph.assertEquals((Object)this.G, (Object)this.f1.owner());
    }

    public void testCoverElementIncidences() {
        List<PeriodicGraph.CoverEdge> incidences = Iterators.asList(this.w2.incidences());
        TestPeriodicGraph.assertEquals((int)4, (int)incidences.size());
        PeriodicGraph periodicGraph = this.G;
        periodicGraph.getClass();
        TestPeriodicGraph.assertTrue((boolean)incidences.contains(periodicGraph.new PeriodicGraph.CoverEdge(this.e1.reverse(), new Vector(1, 0, 2))));
        PeriodicGraph periodicGraph2 = this.G;
        periodicGraph2.getClass();
        TestPeriodicGraph.assertTrue((boolean)incidences.contains(periodicGraph2.new PeriodicGraph.CoverEdge(this.e3, new Vector(1, 0, 2))));
        PeriodicGraph periodicGraph3 = this.G;
        periodicGraph3.getClass();
        TestPeriodicGraph.assertTrue((boolean)incidences.contains(periodicGraph3.new PeriodicGraph.CoverEdge(this.e2, new Vector(1, 0, 2))));
        PeriodicGraph periodicGraph4 = this.G;
        periodicGraph4.getClass();
        TestPeriodicGraph.assertTrue((boolean)incidences.contains(periodicGraph4.new PeriodicGraph.CoverEdge(this.e2.reverse(), new Vector(1, 0, 2))));
    }

    public void testHashCodes() {
        INode v = this.v1;
        INode w = this.G.getNode(v.id());
        TestPeriodicGraph.assertNotSame((Object)v, (Object)w);
        TestPeriodicGraph.assertEquals((Object)v, (Object)w);
        TestPeriodicGraph.assertEquals((int)v.hashCode(), (int)w.hashCode());
        IEdge e = this.e1;
        IEdge f = this.G.getEdge(e.id());
        TestPeriodicGraph.assertNotSame((Object)e, (Object)f);
        TestPeriodicGraph.assertEquals((Object)e, (Object)f);
        TestPeriodicGraph.assertEquals((int)e.hashCode(), (int)f.hashCode());
    }

    public void testToString() {
        String s = "(1,1,[0,0,-1])(1,2,[0,0,0])(1,2,[0,1,0])(2,2,[-1,0,0])";
        TestPeriodicGraph.assertEquals((String)"(1,1,[0,0,-1])(1,2,[0,0,0])(1,2,[0,1,0])(2,2,[-1,0,0])", (String)this.G.toString());
    }

    public void testCoordinationSequence() {
        INode start = this.dia.nodes().next();
        Iterator<Integer> cs = this.dia.coordinationSequence(start);
        TestPeriodicGraph.assertEquals((Object)new Integer(1), (Object)cs.next());
        TestPeriodicGraph.assertEquals((Object)new Integer(4), (Object)cs.next());
        TestPeriodicGraph.assertEquals((Object)new Integer(12), (Object)cs.next());
        TestPeriodicGraph.assertEquals((Object)new Integer(24), (Object)cs.next());
        TestPeriodicGraph.assertEquals((Object)new Integer(42), (Object)cs.next());
        TestPeriodicGraph.assertEquals((Object)new Integer(64), (Object)cs.next());
        TestPeriodicGraph.assertEquals((Object)new Integer(92), (Object)cs.next());
        TestPeriodicGraph.assertEquals((Object)new Integer(124), (Object)cs.next());
        TestPeriodicGraph.assertEquals((Object)new Integer(162), (Object)cs.next());
        TestPeriodicGraph.assertEquals((Object)new Integer(204), (Object)cs.next());
        TestPeriodicGraph.assertEquals((Object)new Integer(252), (Object)cs.next());
    }

    public void testShortestCycleAtAngle() {
        IteratorAdapter<INode> diaNodes = this.dia.nodes();
        INode a = (INode)diaNodes.next();
        INode b = (INode)diaNodes.next();
        PeriodicGraph periodicGraph = this.dia;
        periodicGraph.getClass();
        PeriodicGraph.CoverNode u = periodicGraph.new PeriodicGraph.CoverNode(b);
        PeriodicGraph periodicGraph2 = this.dia;
        periodicGraph2.getClass();
        PeriodicGraph.CoverNode v = periodicGraph2.new PeriodicGraph.CoverNode(a);
        PeriodicGraph periodicGraph3 = this.dia;
        periodicGraph3.getClass();
        PeriodicGraph.CoverNode w = periodicGraph3.new PeriodicGraph.CoverNode(b, new Vector(-1, 0, 0));
        List<PeriodicGraph.CoverNode> cycle = this.dia.shortestCycleAtAngle(u, v, w);
        TestPeriodicGraph.assertEquals((int)6, (int)cycle.size());
        TestPeriodicGraph.assertEquals((Object)v, (Object)cycle.get(0));
        TestPeriodicGraph.assertTrue((cycle.get(1).equals(u) || cycle.get(1).equals(w) ? 1 : 0) != 0);
        if (cycle.get(1).equals(u)) {
            TestPeriodicGraph.assertEquals((Object)w, (Object)cycle.get(5));
        } else {
            TestPeriodicGraph.assertEquals((Object)u, (Object)cycle.get(5));
        }
    }

    private INode firstNode(PeriodicGraph g) {
        return g.nodes().next();
    }

    public void testPointSymbol() {
        PeriodicGraph hex = this.hexGrid();
        PeriodicGraph hexd = this.doubleHexGrid();
        TestPeriodicGraph.assertEquals((String)"6^6", (String)this.dia.pointSymbol(this.firstNode(this.dia)));
        TestPeriodicGraph.assertEquals((String)"6^5.8", (String)this.cds.pointSymbol(this.firstNode(this.cds)));
        TestPeriodicGraph.assertEquals((String)"6^3", (String)hex.pointSymbol(this.firstNode(hex)));
        TestPeriodicGraph.assertEquals((String)"6^6", (String)hexd.pointSymbol(this.firstNode(hexd)));
    }

    public void testIsConnected() {
        PeriodicGraph H = new PeriodicGraph(3);
        INode v1 = H.newNode();
        INode v2 = H.newNode();
        TestPeriodicGraph.assertFalse((boolean)H.isConnected());
        int[] nArray = new int[3];
        nArray[0] = 1;
        H.newEdge(v1, v2, nArray);
        int[] nArray2 = new int[3];
        nArray2[1] = 1;
        H.newEdge(v1, v2, nArray2);
        int[] nArray3 = new int[3];
        nArray3[2] = 1;
        H.newEdge(v1, v2, nArray3);
        TestPeriodicGraph.assertFalse((boolean)H.isConnected());
        int[] nArray4 = new int[3];
        nArray4[0] = 3;
        H.newEdge(v1, v2, nArray4);
        TestPeriodicGraph.assertFalse((boolean)H.isConnected());
        int[] nArray5 = new int[3];
        nArray5[0] = 2;
        IEdge e = H.newEdge(v1, v2, nArray5);
        TestPeriodicGraph.assertTrue((boolean)H.isConnected());
        H.delete(e);
        H.newEdge(v1, v2, new int[3]);
        TestPeriodicGraph.assertTrue((boolean)H.isConnected());
    }

    public void testConnectedComponents() {
        PeriodicGraph P = new PeriodicGraph(0);
        P.newNode();
        PeriodicGraph H = new PeriodicGraph(3);
        INode v1 = H.newNode();
        INode v2 = H.newNode();
        List<PeriodicGraph.Component> components = H.connectedComponents();
        TestPeriodicGraph.assertEquals((int)2, (int)components.size());
        PeriodicGraph.Component c = components.get(0);
        TestPeriodicGraph.assertEquals((int)0, (int)c.getDimension());
        TestPeriodicGraph.assertEquals((Object)Whole.ZERO, (Object)c.getMultiplicity());
        TestPeriodicGraph.assertEquals((Object)P, (Object)c.getGraph());
        int[] nArray = new int[3];
        nArray[0] = 1;
        H.newEdge(v1, v2, nArray);
        int[] nArray2 = new int[3];
        nArray2[1] = 1;
        H.newEdge(v1, v2, nArray2);
        int[] nArray3 = new int[3];
        nArray3[2] = 1;
        H.newEdge(v1, v2, nArray3);
        components = H.connectedComponents();
        TestPeriodicGraph.assertEquals((int)1, (int)components.size());
        c = components.get(0);
        TestPeriodicGraph.assertEquals((int)2, (int)c.getDimension());
        TestPeriodicGraph.assertEquals((Object)Whole.ZERO, (Object)c.getMultiplicity());
        TestPeriodicGraph.assertEquals((Object)this.hexGrid(), (Object)c.getGraph());
        int[] nArray4 = new int[3];
        nArray4[0] = 2;
        nArray4[1] = 1;
        H.newEdge(v1, v2, nArray4);
        components = H.connectedComponents();
        TestPeriodicGraph.assertEquals((int)1, (int)components.size());
        c = components.get(0);
        TestPeriodicGraph.assertEquals((int)3, (int)c.getDimension());
        TestPeriodicGraph.assertEquals((Object)new Whole(2L), (Object)c.getMultiplicity());
        TestPeriodicGraph.assertEquals((Object)this.diamond(), (Object)c.getGraph());
    }

    public void testBarycentricPositions() {
        TestPeriodicGraph.assertTrue((boolean)this.G.isBarycentric(this.G.barycentricPlacement()));
        TestPeriodicGraph.assertTrue((boolean)this.dia.isBarycentric(this.dia.barycentricPlacement()));
        TestPeriodicGraph.assertTrue((boolean)this.cds.isBarycentric(this.cds.barycentricPlacement()));
    }

    public void testStabilityAndLadderness() {
        TestPeriodicGraph.assertTrue((boolean)this.G.isStable());
        TestPeriodicGraph.assertTrue((boolean)this.dia.isStable());
        TestPeriodicGraph.assertTrue((boolean)this.cds.isStable());
        TestPeriodicGraph.assertTrue((boolean)this.G.isLocallyStable());
        TestPeriodicGraph.assertTrue((boolean)this.dia.isLocallyStable());
        TestPeriodicGraph.assertTrue((boolean)this.cds.isLocallyStable());
        TestPeriodicGraph.assertFalse((boolean)this.G.isLadder());
        TestPeriodicGraph.assertFalse((boolean)this.dia.isLadder());
        TestPeriodicGraph.assertFalse((boolean)this.cds.isLadder());
        PeriodicGraph H = this.doubleHexGrid();
        TestPeriodicGraph.assertFalse((boolean)H.isStable());
        TestPeriodicGraph.assertTrue((boolean)H.isLocallyStable());
        TestPeriodicGraph.assertTrue((boolean)H.isLadder());
        PeriodicGraph H2 = new PeriodicGraph(2);
        INode w1 = H2.newNode();
        INode w2 = H2.newNode();
        INode w3 = H2.newNode();
        int[] nArray = new int[2];
        nArray[0] = 1;
        H2.newEdge(w1, w1, nArray);
        H2.newEdge(w1, w2, new int[2]);
        int[] nArray2 = new int[2];
        nArray2[1] = 1;
        IEdge e1 = H2.newEdge(w1, w2, nArray2);
        H2.newEdge(w1, w3, new int[2]);
        int[] nArray3 = new int[2];
        nArray3[1] = 1;
        IEdge e2 = H2.newEdge(w1, w3, nArray3);
        IEdge e3 = H2.newEdge(w2, w3, new int[2]);
        TestPeriodicGraph.assertFalse((boolean)H2.isStable());
        TestPeriodicGraph.assertFalse((boolean)H2.isLocallyStable());
        TestPeriodicGraph.assertFalse((boolean)H2.isLadder());
        H2.delete(e1);
        H2.delete(e2);
        H2.delete(e3);
        H2.newEdge(w1, w2, new int[]{1, 1});
        H2.newEdge(w1, w3, new int[]{-1, 1});
        TestPeriodicGraph.assertFalse((boolean)H2.isStable());
        TestPeriodicGraph.assertTrue((boolean)H2.isLocallyStable());
        TestPeriodicGraph.assertFalse((boolean)H2.isLadder());
        PeriodicGraph H3 = new PeriodicGraph(3);
        INode u1 = H3.newNode();
        INode u2 = H3.newNode();
        int[] nArray4 = new int[3];
        nArray4[0] = 1;
        H3.newEdge(u1, u1, nArray4);
        int[] nArray5 = new int[3];
        nArray5[1] = 1;
        H3.newEdge(u1, u1, nArray5);
        int[] nArray6 = new int[3];
        nArray6[2] = 1;
        H3.newEdge(u2, u2, nArray6);
        H3.newEdge(u1, u2, new int[3]);
        TestPeriodicGraph.assertFalse((boolean)H3.isStable());
        TestPeriodicGraph.assertTrue((boolean)H3.isLocallyStable());
        TestPeriodicGraph.assertFalse((boolean)H3.isLadder());
    }

    public void testTranslationalEquivalenceClasses() {
        TestPeriodicGraph.assertFalse((boolean)this.dia.translationalEquivalenceClasses().hasNext());
        TestPeriodicGraph.assertFalse((boolean)this.G.translationalEquivalenceClasses().hasNext());
        List<Set<INode>> classes = Iterators.asList(this.cds.translationalEquivalenceClasses());
        TestPeriodicGraph.assertEquals((int)2, (int)classes.size());
        classes = Iterators.asList(this.doubleHexGrid().translationalEquivalenceClasses());
        TestPeriodicGraph.assertEquals((int)2, (int)classes.size());
        classes = Iterators.asList(this.doubleHexGrid().translationalEquivalenceClasses());
        TestPeriodicGraph.assertEquals((int)2, (int)classes.size());
        PeriodicGraph H = new PeriodicGraph(3);
        INode w1 = H.newNode();
        INode w2 = H.newNode();
        int[] nArray = new int[3];
        nArray[0] = 1;
        H.newEdge(w1, w1, nArray);
        int[] nArray2 = new int[3];
        nArray2[1] = 1;
        H.newEdge(w1, w1, nArray2);
        int[] nArray3 = new int[3];
        nArray3[0] = 1;
        H.newEdge(w2, w2, nArray3);
        int[] nArray4 = new int[3];
        nArray4[1] = 1;
        H.newEdge(w2, w2, nArray4);
        H.newEdge(w1, w2, new int[3]);
        int[] nArray5 = new int[3];
        nArray5[2] = 1;
        H.newEdge(w1, w2, nArray5);
        new Morphism(w1, w2, Matrix.one(3));
        classes = Iterators.asList(H.translationalEquivalenceClasses());
        TestPeriodicGraph.assertEquals((int)1, (int)classes.size());
    }

    public void testMinimalImage() {
        int i = 0;
        while (i < 3) {
            PeriodicGraph cds1 = this.cds.minimalImage();
            TestPeriodicGraph.assertEquals((int)3, (int)cds1.getDimension());
            TestPeriodicGraph.assertEquals((int)2, (int)cds1.numberOfNodes());
            TestPeriodicGraph.assertEquals((int)4, (int)cds1.numberOfEdges());
            TestPeriodicGraph.assertTrue((boolean)cds1.isConnected());
            TestPeriodicGraph.assertTrue((boolean)cds1.isStable());
            IteratorAdapter<INode> nodes = cds1.nodes();
            INode w1 = (INode)nodes.next();
            INode w2 = (INode)nodes.next();
            List<IEdge> loops1 = Iterators.asList(cds1.connectingEdges(w1, w1));
            List<IEdge> loops2 = Iterators.asList(cds1.connectingEdges(w2, w2));
            TestPeriodicGraph.assertEquals((int)1, (int)loops1.size());
            TestPeriodicGraph.assertEquals((int)1, (int)loops2.size());
            ++i;
        }
        try {
            this.doubleHexGrid().minimalImage();
            TestPeriodicGraph.fail((String)"should throw an UnsupportedOperationException");
        }
        catch (UnsupportedOperationException unsupportedOperationException) {
            // empty catch block
        }
        TestPeriodicGraph.assertSame((Object)this.dia, (Object)this.dia.minimalImage());
    }

    public void testCharacteristicBases() {
        this.testCharacteristicBases(this.dia, 48);
        this.testCharacteristicBases(this.G, 16);
        this.testCharacteristicBases(this.cds.minimalImage(), 16);
        this.testCharacteristicBases(this.doubleHexGrid(), 24);
    }

    public void testCharacteristicBases(PeriodicGraph G, int expectedNr) {
        List<List<IEdge>> bases = G.characteristicBases();
        TestPeriodicGraph.assertEquals((int)expectedNr, (int)bases.size());
        int d = G.getDimension();
        Map<INode, Point> pos = G.barycentricPlacement();
        HashSet seen = new HashSet();
        for (List<IEdge> basis : bases) {
            ArrayList<Pair<IEdge, Vector>> key = new ArrayList<Pair<IEdge, Vector>>();
            Matrix M = new Matrix(d, d);
            int i = 0;
            while (i < basis.size()) {
                IEdge e = basis.get(i);
                INode v = e.source();
                INode w = e.target();
                Point pv = pos.get(v);
                Point pw = pos.get(w);
                Vector s = G.getShift(e);
                M.setRow(i, ((Vector)pw.minus(pv).plus(s)).getCoordinates());
                key.add(new Pair<IEdge, Vector>(e, s));
                ++i;
            }
            TestPeriodicGraph.assertEquals((int)d, (int)M.rank());
            TestPeriodicGraph.assertFalse((boolean)seen.contains(key));
            seen.add(key);
            TestPeriodicGraph.assertTrue((boolean)seen.contains(key));
        }
    }

    public void testSymmetries() {
        this.testSymmetries(this.dia, 48);
        this.testSymmetries(this.G, 16);
        this.testSymmetries(this.cds.minimalImage(), 16);
        this.testSymmetries(this.doubleHexGrid(), 12);
    }

    public void testSymmetries(PeriodicGraph G, int expectedNr) {
        Set<Morphism> symmetries = G.symmetries();
        TestPeriodicGraph.assertEquals((int)expectedNr, (int)symmetries.size());
    }

    public void testSymmetricBasis() {
        this.testSymmetricBasis(this.G);
        this.testSymmetricBasis(this.dia);
        this.testSymmetricBasis(this.doubleHexGrid());
    }

    public void testSymmetricBasis(PeriodicGraph G) {
        FloatingPoint eps = new FloatingPoint(1.0E-12);
        int d = G.getDimension();
        Matrix I = Matrix.one(d + 1);
        CoordinateChange c = new CoordinateChange(G.symmetricBasis());
        Iterator<Morphism> syms = G.symmetries().iterator();
        while (syms.hasNext()) {
            Operator op = syms.next().getLinearOperator();
            Matrix A = ((Operator)op.times(c)).getCoordinates();
            Matrix D = (Matrix)A.times(A.transposed());
            TestPeriodicGraph.assertTrue((boolean)D.minus(I).norm().isLessThan(eps));
        }
    }

    public void testNodeOrbits() {
        List<Set<INode>> nodeOrbits = Iterators.asList(this.G.nodeOrbits());
        TestPeriodicGraph.assertEquals((int)1, (int)nodeOrbits.size());
        TestPeriodicGraph.assertEquals((int)2, (int)nodeOrbits.get(0).size());
    }

    public void testNodeStabilizer() {
        TestPeriodicGraph.assertEquals((int)8, (int)this.G.nodeStabilizer(this.v1).size());
        TestPeriodicGraph.assertEquals((int)8, (int)this.G.nodeStabilizer(this.v2).size());
    }

    public void testEdgeOrbits() {
        List<Set<IEdge>> edgeOrbits = Iterators.asList(this.G.edgeOrbits());
        TestPeriodicGraph.assertEquals((int)2, (int)edgeOrbits.size());
        TestPeriodicGraph.assertEquals((int)2, (int)edgeOrbits.get(0).size());
        TestPeriodicGraph.assertEquals((int)2, (int)edgeOrbits.get(1).size());
    }

    public void testCanonical() {
        TestPeriodicGraph.assertEquals((String)"(1,2,[0,0,0])(1,2,[0,0,1])(1,2,[0,1,0])(1,2,[1,0,0])", (String)this.dia.canonical().toString());
        TestPeriodicGraph.assertEquals((String)this.G.canonical().toString(), (String)this.cds.minimalImage().canonical().toString());
        TestPeriodicGraph.assertFalse((boolean)this.G.canonical().toString().equals(this.dia.canonical().toString()));
        TestPeriodicGraph.assertEquals((String)this.makeTestGraph(2).canonical().toString(), (String)this.makeTestGraph(1).canonical().toString());
    }

    public void testHex() {
        this.verifyKey("3 1 1 -1 -1 0 1 1 -1 0 0 1 1 0 -1 0 1 1 0 0 -1");
    }

    public void testInvariant() {
        TestPeriodicGraph.assertEquals(this.G.invariant(), this.cds.minimalImage().invariant());
        TestPeriodicGraph.assertFalse((boolean)this.G.invariant().equals(this.dia.invariant()));
        TestPeriodicGraph.assertEquals(this.makeTestGraph(2).invariant(), this.makeTestGraph(1).invariant());
        TestPeriodicGraph.assertEquals((String)"3 1 2 0 0 0 1 2 0 0 1 1 2 0 1 0 1 2 1 0 0", (String)this.dia.invariant().toString());
        TestPeriodicGraph.assertEquals((String)"3 1 1 -1 0 0 1 2 0 0 0 1 2 0 1 0 2 2 0 0 -1", (String)this.cds.minimalImage().invariant().toString());
        this.verifyKey("3 1 2 0 0 0 1 2 0 0 1 1 2 0 1 0 1 2 1 0 0");
        this.verifyKey("3 1 1 -1 0 0 1 2 0 0 0 1 2 0 1 0 2 2 0 0 -1");
        this.verifyKey("2 1 2 0 0 1 2 0 1 1 2 1 0");
        this.verifyKey("3 1 2 0 0 0 1 3 0 0 0 1 4 0 0 0 2 3 0 1 0 2 4 1 0 0 3 4 0 0 1");
        this.verifyKey("3 1 2 0 0 0 1 3 0 0 0 1 4 0 0 0 2 5 0 0 0 2 6 0 0 0 3 4 0 0 0 3 7 0 0 0 4 8 0 0 0 5 6 0 0 0 5 9 0 0 0 6 10 0 0 0 7 10 1 0 0 7 11 0 0 0 8 9 0 1 0 8 12 0 0 0 9 12 0 -1 0 10 11 -1 0 0 11 12 0 0 1");
        this.verifyKey("3 1 2 0 0 0 1 2 0 1 0 1 3 0 0 0 1 3 1 0 0 2 3 0 0 1 2 3 1 -1 -1");
        this.verifyKey("3 1 2 0 0 0 1 3 0 0 0 1 4 0 0 0 2 5 0 0 0 2 6 0 0 0 3 7 0 0 0 3 8 0 0 0 4 8 0 0 0 4 9 0 0 0 5 10 0 0 0 5 11 0 0 0 6 10 0 0 0 6 12 0 0 0 7 11 0 1 0 7 12 1 0 0 8 10 0 0 1 9 11 -1 0 1 9 12 0 -1 1");
        this.verifyKey("3 1 2 0 0 0 1 3 0 0 0 1 4 0 0 0 2 5 0 0 0 3 6 0 0 0 4 7 0 0 0 5 8 0 0 0 5 9 0 0 0 6 9 1 0 0 6 10 0 0 0 7 8 0 0 1 7 10 0 1 0");
        this.verifyKey("3 1 1 -1 0 0 1 2 0 0 0 1 2 0 0 1 1 3 0 0 0 1 3 0 1 0 1 4 0 0 0 2 2 -1 0 0 2 3 0 0 0 2 4 -1 -1 -1 2 4 0 0 -1 3 3 -1 0 0 3 4 -1 -1 -1 3 4 0 -1 0 4 4 -1 0 0");
    }

    private PeriodicGraph makeTestGraph(int type) {
        Vector x = new Vector(1, 0);
        Vector y = new Vector(0, 1);
        PeriodicGraph G = new PeriodicGraph(2);
        INode v1 = G.newNode();
        INode v2 = G.newNode();
        INode v3 = G.newNode();
        INode v4 = G.newNode();
        G.newEdge(v1, v2);
        G.newEdge(v1, v3);
        G.newEdge(v1, v4);
        G.newEdge(v2, v3, x);
        if (type == 1) {
            G.newEdge(v2, v4, x);
        } else {
            G.newEdge(v2, v4, y);
        }
        G.newEdge(v3, v4, y);
        return G;
    }

    private void verifyKey(String key) {
        ArrayList<Integer> numbers = new ArrayList<Integer>();
        String[] fields = key.split("\\s+");
        int i = 0;
        while (i < fields.length) {
            numbers.add(new Integer(fields[i]));
            ++i;
        }
        int d = (Integer)numbers.get(0);
        int n = (numbers.size() - 1) / (d + 2);
        PeriodicGraph G = new PeriodicGraph(d);
        ArrayList<INode> nodes = new ArrayList<INode>();
        nodes.add(null);
        int i2 = 0;
        while (i2 < n) {
            int offset = 1 + i2 * (d + 2);
            int s = (Integer)numbers.get(offset);
            int t = (Integer)numbers.get(offset + 1);
            if (s == nodes.size()) {
                nodes.add(G.newNode());
            }
            if (t == nodes.size()) {
                nodes.add(G.newNode());
            }
            if (s >= nodes.size() || t >= nodes.size()) {
                throw new RuntimeException("something's wrong here");
            }
            int[] shift = new int[d];
            int j = 0;
            while (j < d) {
                Integer x = (Integer)numbers.get(offset + 2 + j);
                shift[j] = x;
                ++j;
            }
            G.newEdge((INode)nodes.get(s), (INode)nodes.get(t), shift);
            ++i2;
        }
        TestPeriodicGraph.assertEquals((String)key, (String)G.getSystreKey());
    }

    public void xtestInvariantsRCSR() {
        Package pkg = Archive.class.getPackage();
        String packagePath = pkg.getName().replaceAll("\\.", "/");
        String archivePath = String.valueOf(packagePath) + "/rcsr.arc";
        Archive rcsr = new Archive("1.0");
        InputStream inStream = ClassLoader.getSystemResourceAsStream(archivePath);
        BufferedReader reader = new BufferedReader(new InputStreamReader(inStream));
        rcsr.addAll(reader);
        ArrayList<String> keys = new ArrayList<String>();
        keys.addAll(rcsr.keySet());
        Collections.sort(keys, new Comparator(){

            public int compare(Object arg0, Object arg1) {
                String s0 = (String)arg0;
                String s1 = (String)arg1;
                int d = s0.length() - s1.length();
                if (d != 0) {
                    return d;
                }
                return s0.compareTo(s1);
            }
        });
        for (String key : keys) {
            this.verifyKey(key);
        }
    }

    public void testEquals() {
        TestPeriodicGraph.assertEquals((Object)this.G, (Object)this.G);
        TestPeriodicGraph.assertEquals((Object)this.dia, (Object)this.dia);
        TestPeriodicGraph.assertEquals((Object)this.G, (Object)this.cds.minimalImage());
        TestPeriodicGraph.assertFalse((boolean)this.dia.equals(this.G));
        TestPeriodicGraph.assertEquals((Object)this.makeTestGraph(2), (Object)this.makeTestGraph(1));
    }

    public void testHashCode() {
        TestPeriodicGraph.assertEquals((int)this.G.hashCode(), (int)this.G.hashCode());
        TestPeriodicGraph.assertEquals((int)this.dia.hashCode(), (int)this.dia.hashCode());
        TestPeriodicGraph.assertEquals((int)this.G.hashCode(), (int)this.cds.minimalImage().hashCode());
        TestPeriodicGraph.assertFalse((this.dia.hashCode() == this.G.hashCode() ? 1 : 0) != 0);
    }

    public void testConventionalCellCover() {
        this.testConventionalCellCover(this.dia);
        this.testConventionalCellCover(this.cds.minimalImage());
        this.testConventionalCellCover(NetParser.stringToNet("PERIODIC_GRAPH\n  ID    sqc15\n  EDGES\n  1 1 1 0 1\n  1 1 0 1 0\n  1 1 1 1 0\n  1 1 1 0 0\n  1 1 0 0 1\n  1 1 0 1 1\nEND\n"));
        this.testConventionalCellCover(NetParser.stringToNet("PERIODIC_GRAPH\n   ID    sqc1135\n   EDGES\n     1   3 -1  -1  -1\n     1   1  0   0   1\n     1   2  0   0   0\n     1   3 -1   0   0\n     3   3  1   1   1\n     2   3  0   0   0\n     1   1  1   1   1\n     1   2  0   1   0\n     3   3  0   0   1\n     2   3  0  -1   0\n     1   4  0   0  -1\n     3   4  0   0   0\n     3   4  1   0   0\n     1   4 -1   0  -1\nEND\n"));
    }

    public void testConventionalCellCover(PeriodicGraph G) {
        Cover cov = G.conventionalCellCover();
        Map<INode, Point> pos = cov.barycentricPlacement();
        Map<INode, Point> posG = G.barycentricPlacement();
        TestPeriodicGraph.assertTrue((boolean)cov.isBarycentric(pos));
        TestPeriodicGraph.assertEquals((Object)G, (Object)cov.minimalImage());
        IteratorAdapter<INode> iter = cov.nodes();
        while (iter.hasNext()) {
            INode v = (INode)iter.next();
            Point p = pos.get(v);
            TestPeriodicGraph.assertEquals((Object)p, (Object)p.modZ());
            TestPeriodicGraph.assertEquals((Object)p, (Object)cov.liftedPosition(v, posG));
        }
    }
}

