/*
 * Decompiled with CFR 0.152.
 */
package org.gavrog.joss.pgraphs.basic;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import java.util.TreeSet;
import org.gavrog.box.collections.Pair;
import org.gavrog.box.collections.Partition;
import org.gavrog.jane.compounds.Matrix;
import org.gavrog.jane.numbers.ArithmeticBase;
import org.gavrog.joss.geometry.CoordinateChange;
import org.gavrog.joss.geometry.Operator;
import org.gavrog.joss.geometry.Point;
import org.gavrog.joss.geometry.Vector;
import org.gavrog.joss.pgraphs.basic.IEdge;
import org.gavrog.joss.pgraphs.basic.INode;
import org.gavrog.joss.pgraphs.basic.Morphism;
import org.gavrog.joss.pgraphs.basic.PeriodicGraph;

public class Cover
extends PeriodicGraph {
    private final Morphism coverMorphism;
    private final PeriodicGraph image;

    public Cover(PeriodicGraph periodicGraph, Vector[] vectorArray) {
        super(periodicGraph.getDimension());
        Object object;
        ArithmeticBase arithmeticBase;
        Point point;
        Point point2;
        Object object2;
        Object object32;
        Iterator iterator;
        HashMap hashMap2;
        Object object4;
        Object object7;
        Object object8;
        Object object9;
        Object object10;
        if (vectorArray == null) {
            throw new IllegalArgumentException("No cell given.");
        }
        int n = periodicGraph.getDimension();
        if (vectorArray.length != n) {
            throw new IllegalArgumentException("Expected exactly " + n + " cell vectors.");
        }
        for (int i = 0; i < vectorArray.length; ++i) {
            if (!vectorArray[i].isIntegral()) {
                throw new IllegalArgumentException("Cell vectors must be integral.");
            }
            if (vectorArray[i].getDimension() == n) continue;
            throw new IllegalArgumentException("Cell vectors must have same dimension as base graph.");
        }
        Matrix matrix = Vector.toMatrix(vectorArray);
        if (matrix.rank() < n) {
            throw new IllegalArgumentException("Cell vectors must form a basis.");
        }
        CoordinateChange coordinateChange = new CoordinateChange(matrix);
        HashSet<Vector> hashSet = new HashSet<Vector>();
        int n2 = this.getDimension();
        for (int i = 0; i < n2; ++i) {
            object10 = Vector.unit(n2, i);
            object9 = ((Vector)((Vector)object10).times(coordinateChange)).modZ();
            if (hashSet.contains(object9)) continue;
            hashSet.add((Vector)object9);
        }
        LinkedList<Vector> linkedList = new LinkedList<Vector>();
        linkedList.addAll(hashSet);
        object10 = new HashSet();
        object10.addAll(hashSet);
        while (linkedList.size() > 0) {
            object9 = (Vector)linkedList.removeFirst();
            object8 = object10.iterator();
            while (object8.hasNext()) {
                object7 = (Vector)object8.next();
                Vector object62 = ((Vector)((Vector)object9).plus(object7)).modZ();
                if (hashSet.contains(object62)) continue;
                hashSet.add(object62);
                linkedList.addFirst(object62);
            }
        }
        object9 = periodicGraph.barycentricPlacement();
        object8 = new ArrayList();
        for (INode iNode : periodicGraph.nodes()) {
            object8.add(new Pair<INode, Point>(iNode, (Point)((Point)object9.get(iNode)).times(coordinateChange)));
        }
        object7 = new HashMap();
        for (IEdge iEdge : periodicGraph.edges()) {
            object4 = (Point)object9.get(iEdge.source());
            hashMap2 = (Point)object9.get(iEdge.target());
            iterator = (Point)((Point)object4).times(coordinateChange);
            Point point3 = (Point)((Point)((Object)hashMap2)).plus(periodicGraph.getShift(iEdge)).times(coordinateChange);
            object7.put(iEdge, new Pair(iterator, point3));
        }
        ArrayList arrayList = new ArrayList();
        Iterator iterator2 = object8.iterator();
        while (iterator2.hasNext()) {
            object4 = (Pair)iterator2.next();
            hashMap2 = (INode)((Pair)object4).getFirst();
            iterator = (Point)((Pair)object4).getSecond();
            for (Object object32 : hashSet) {
                object2 = (Point)((Point)((Object)iterator)).plus(object32);
                arrayList.add(new Pair(hashMap2, ((Point)object2).modZ()));
            }
        }
        ArrayList arrayList2 = new ArrayList();
        for (HashMap hashMap2 : object7.keySet()) {
            iterator = (Pair)object7.get(hashMap2);
            Point point4 = (Point)((Pair)((Object)iterator)).getFirst();
            object32 = (Point)((Pair)((Object)iterator)).getSecond();
            for (Vector vector : hashSet) {
                point2 = (Point)point4.plus(vector);
                point = (Point)((Point)object32).plus(vector);
                arithmeticBase = point2.modZ();
                object = (Point)point.minus(point2).plus(arithmeticBase);
                arrayList2.add(new Pair(hashMap2, new Pair<Point, Point>((Point)arithmeticBase, (Point)object)));
            }
        }
        object4 = new HashMap();
        hashMap2 = new HashMap();
        for (Pair pair : arrayList) {
            object32 = this.newNode();
            object4.put(pair, object32);
            hashMap2.put(object32, pair.getSecond());
        }
        for (Pair pair : arrayList2) {
            object32 = (IEdge)pair.getFirst();
            object2 = (Pair)pair.getSecond();
            Point point5 = (Point)((Pair)object2).getFirst();
            point2 = (Point)((Pair)object2).getSecond();
            point = point2.modZ();
            arithmeticBase = (Vector)point2.minus(point);
            object = (INode)object4.get(new Pair<INode, Point>(object32.source(), point5));
            INode iNode = (INode)object4.get(new Pair<INode, Point>(object32.target(), point));
            this.newEdge((INode)object, iNode, (Vector)arithmeticBase);
        }
        this.cache.put(BARYCENTRIC_PLACEMENT, hashMap2);
        this.coverMorphism = new Morphism(this.nodes().next(), periodicGraph.nodes().next(), ((CoordinateChange)coordinateChange.inverse()).getOperator());
        this.image = periodicGraph;
    }

    public Morphism getCoverMorphism() {
        return this.coverMorphism;
    }

    public PeriodicGraph getImage() {
        return this.image;
    }

    public INode image(INode iNode) {
        return this.getCoverMorphism().getImage(iNode);
    }

    public IEdge image(IEdge iEdge) {
        return this.getCoverMorphism().getImage(iEdge);
    }

    public Point liftedPosition(INode iNode, Point point) {
        PeriodicGraph periodicGraph = this.getImage();
        Operator operator = this.getCoverMorphism().getAffineOperator();
        Point point2 = this.barycentricPlacement().get(iNode);
        Point point3 = (Point)point2.times(operator);
        Vector vector = (Vector)point3.minus(periodicGraph.barycentricPlacement().get(this.image(iNode)));
        return (Point)point.plus(vector).times(operator.inverse());
    }

    public Point liftedPosition(INode iNode, Map<INode, Point> map) {
        return this.liftedPosition(iNode, map.get(this.image(iNode)));
    }

    @Override
    public Iterator<Set<INode>> nodeOrbits() {
        PeriodicGraph periodicGraph = this.getImage();
        Partition<INode> partition = new Partition<INode>();
        for (Morphism object2 : periodicGraph.symmetries()) {
            for (INode iNode : periodicGraph.nodes()) {
                partition.unite(iNode, object2.getImage(iNode));
            }
        }
        Map map = partition.representativeMap();
        TreeMap treeMap = new TreeMap();
        for (INode iNode : this.nodes()) {
            INode iNode2 = (INode)map.get(this.image(iNode));
            if (!treeMap.containsKey(iNode2)) {
                treeMap.put(iNode2, new TreeSet());
            }
            ((Set)treeMap.get(iNode2)).add(iNode);
        }
        return treeMap.values().iterator();
    }

    @Override
    public Iterator<Set<IEdge>> edgeOrbits() {
        IEdge iEdge;
        PeriodicGraph periodicGraph = this.getImage();
        Partition<IEdge> partition = new Partition<IEdge>();
        for (Morphism object2 : periodicGraph.symmetries()) {
            for (IEdge iEdge2 : periodicGraph.edges()) {
                iEdge = object2.getImage(iEdge2.oriented()).unoriented();
                partition.unite(iEdge2, iEdge);
            }
        }
        Map map = partition.representativeMap();
        HashMap hashMap = new HashMap();
        for (IEdge iEdge2 : this.edges()) {
            iEdge = this.image(iEdge2.oriented()).unoriented();
            IEdge iEdge3 = (IEdge)map.get(iEdge);
            if (!hashMap.containsKey(iEdge3)) {
                hashMap.put(iEdge3, new HashSet());
            }
            ((Set)hashMap.get(iEdge3)).add(iEdge2);
        }
        return hashMap.values().iterator();
    }
}

