/*
 * Decompiled with CFR 0.152.
 */
package org.gavrog.joss.graphics;

public class Vec {
    public static double[] copy(double[] dst, double[] src) {
        if (dst == null) {
            dst = new double[src.length];
        }
        int n = Math.min(src.length, dst.length);
        int i = 0;
        while (i < n) {
            dst[i] = src[i];
            ++i;
        }
        return dst;
    }

    public static double[] plus(double[] dst, double[] a, double[] b) {
        if (dst == null) {
            dst = new double[a.length];
        }
        int n = Math.min(dst.length, Math.min(a.length, b.length));
        int i = 0;
        while (i < n) {
            dst[i] = a[i] + b[i];
            ++i;
        }
        return dst;
    }

    public static double[] minus(double[] dst, double[] a, double[] b) {
        if (dst == null) {
            dst = new double[a.length];
        }
        int n = Math.min(dst.length, Math.min(a.length, b.length));
        int i = 0;
        while (i < n) {
            dst[i] = a[i] - b[i];
            ++i;
        }
        return dst;
    }

    public static double[] times(double[] dst, double f, double[] src) {
        if (dst == null) {
            dst = new double[src.length];
        }
        int n = Math.min(src.length, dst.length);
        int i = 0;
        while (i < n) {
            dst[i] = f * src[i];
            ++i;
        }
        return dst;
    }

    public static double[] linearCombination(double[] dst, double fa, double[] a, double fb, double[] b) {
        if (dst == null) {
            dst = new double[a.length];
        }
        int n = Math.min(dst.length, Math.min(a.length, b.length));
        int i = 0;
        while (i < n) {
            dst[i] = fa * a[i] + fb * b[i];
            ++i;
        }
        return dst;
    }

    public static double innerProduct(double[] a, double[] b) {
        if (a.length != b.length) {
            throw new IllegalArgumentException("vectors must have same length");
        }
        int n = a.length;
        double result = 0.0;
        int i = 0;
        while (i < n) {
            result += a[i] * b[i];
            ++i;
        }
        return result;
    }

    public static double[] crossProduct(double[] dst, double[] a, double[] b) {
        if (a.length < 3 || b.length < 3 || dst != null && dst.length < 3) {
            throw new IllegalArgumentException("vectors too short");
        }
        if (dst == null) {
            dst = new double[]{a[1] * b[2] - a[2] * b[1], a[2] * b[0] - a[0] * b[2], a[0] * b[1] - a[1] * b[0]};
        }
        return dst;
    }

    public static double norm(double[] a) {
        return Math.sqrt(Vec.innerProduct(a, a));
    }

    public static double[] normalized(double[] dst, double[] a) {
        double f = Vec.norm(a);
        if (f == 0.0) {
            return Vec.copy(dst, a);
        }
        return Vec.times(dst, 1.0 / f, a);
    }

    public static double[] projection(double[] dst, double[] src, double[] fixed) {
        double[] n = Vec.normalized(null, fixed);
        return Vec.times(dst, Vec.innerProduct(src, n), n);
    }

    public static double[] complementProjection(double[] dst, double[] src, double[] fixed) {
        return Vec.minus(dst, src, Vec.projection(null, src, fixed));
    }

    public static double angle(double[] a, double[] b) {
        double aabb = Vec.innerProduct(a, a) * Vec.innerProduct(b, b);
        if (aabb == 0.0) {
            return 0.0;
        }
        double f = Vec.innerProduct(a, b) / Math.sqrt(Math.abs(aabb));
        return Math.acos(Math.min(1.0, Math.max(-1.0, f)));
    }
}

