/*
 * Decompiled with CFR 0.152.
 */
package org.gavrog.joss.dsyms.generators;

import java.io.FileWriter;
import java.io.OutputStreamWriter;
import java.io.Writer;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.NoSuchElementException;
import java.util.Set;
import org.gavrog.box.collections.IteratorAdapter;
import org.gavrog.box.simple.Stopwatch;
import org.gavrog.jane.numbers.Fraction;
import org.gavrog.joss.algorithms.CheckpointEvent;
import org.gavrog.joss.dsyms.basic.DSymbol;
import org.gavrog.joss.dsyms.basic.DynamicDSymbol;
import org.gavrog.joss.dsyms.basic.IndexList;
import org.gavrog.joss.dsyms.basic.Subsymbol;
import org.gavrog.joss.dsyms.derived.Covers;
import org.gavrog.joss.dsyms.derived.DSCover;
import org.gavrog.joss.dsyms.derived.EuclidicityTester;
import org.gavrog.joss.dsyms.generators.FrankKasperExtended;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Kelvin
extends FrankKasperExtended {
    private static final IndexList iTiles = new IndexList(0, 1, 2);
    private static final IndexList iFaces2d = new IndexList(0, 1);
    private final Writer output;
    private final boolean countOnly;
    private final int start;
    private final int stop;
    private int count = 0;
    private final Stopwatch timer = new Stopwatch();
    private final Set<DSymbol> goodVertexFigures = new HashSet<DSymbol>();
    private final Set<DSymbol> badVertexFigures = new HashSet<DSymbol>();
    private final int interval;

    public Kelvin(int k, boolean verbose, boolean testParts, boolean countOnly, int start, int stop, int checkpointInterval, Writer output) {
        super(k, verbose, testParts);
        this.countOnly = countOnly;
        this.start = start;
        this.stop = stop;
        this.interval = checkpointInterval * 1000;
        this.output = output;
        this.timer.start();
        this.addEventLink(CheckpointEvent.class, this);
    }

    @Override
    protected boolean partsListOkay(List<DSymbol> parts) {
        boolean ok = super.partsListOkay(parts);
        if (ok) {
            ++this.count;
        }
        if (this.countOnly) {
            return false;
        }
        return ok && this.start <= this.count && (this.stop <= 0 || this.stop > this.count);
    }

    @Override
    protected boolean vertexFigureOkay(DSymbol ds) {
        if (this.goodVertexFigures.contains(ds)) {
            return true;
        }
        if (this.goodVertexFigures.contains(ds)) {
            return false;
        }
        final DynamicDSymbol t = new DynamicDSymbol(ds.dual());
        IndexList idx = new IndexList(0, 1);
        final LinkedList<Integer> choices = new LinkedList<Integer>();
        Iterator iterator = t.orbitReps(idx).iterator();
        while (iterator.hasNext()) {
            int D = (Integer)iterator.next();
            int r = t.r(0, 1, D);
            if (r == 4 || r == 5) {
                t.redefineV(0, 1, D, 1);
                continue;
            }
            if (r == 3 || r == 6) {
                t.redefineV(0, 1, D, 6 / r);
                continue;
            }
            if (r == 1 || r == 2) {
                t.redefineV(0, 1, D, 4 / r);
                choices.add(D);
                continue;
            }
            throw new RuntimeException("Oops!");
        }
        if (t.curvature2D().isLessThan(new Fraction((long)t.size(), 42L))) {
            return false;
        }
        IteratorAdapter<DSymbol> iter = new IteratorAdapter<DSymbol>(){
            final int n;
            int[] a;
            {
                this.n = list.size();
                this.a = null;
            }

            @Override
            protected DSymbol findNext() throws NoSuchElementException {
                if (this.a == null) {
                    this.a = new int[this.n + 1];
                    int i = 0;
                    while (i < this.n) {
                        this.choose(i, 4);
                        ++i;
                    }
                } else {
                    int i = this.n - 1;
                    while (i >= 0 && this.a[i] == 6) {
                        --i;
                    }
                    if (i < 0) {
                        throw new NoSuchElementException("at end");
                    }
                    this.choose(i, 6);
                    while (i < this.n - 1) {
                        this.choose(++i, 4);
                    }
                }
                return new DSymbol(t);
            }

            private void choose(int i, int m) {
                int D = (Integer)choices.get(i);
                int r = t.r(0, 1, D);
                t.redefineV(0, 1, D, m / r);
                this.a[i] = m;
            }
        };
        boolean good = false;
        while (iter.hasNext()) {
            DSCover<Integer> cover;
            int n;
            DSymbol x = (DSymbol)iter.next();
            if (!x.isSpherical2D() || (n = (cover = Covers.finiteUniversalCover(x)).numberOfOrbits(iFaces2d)) < 12 || n > 16) continue;
            good = true;
            break;
        }
        if (good) {
            this.goodVertexFigures.add(ds);
        } else {
            this.badVertexFigures.add(ds);
        }
        return good;
    }

    public int getCount() {
        return this.count;
    }

    protected void processEvent(Object event) {
        CheckpointEvent ce = (CheckpointEvent)event;
        if (ce.getMessage() != null || this.interval == 0 || this.timer.elapsed() > (long)this.interval) {
            this.writeCheckpoint(ce.isOld(), ce.getMessage());
        }
    }

    public void writeCheckpoint(boolean isOld, String msg) {
        try {
            this.timer.reset();
            String p = isOld ? "# OLD" : "#@";
            String c = this.getCheckpoint();
            String s = msg != null ? String.format(" (%s)", msg) : "";
            this.output.write(String.format("%s CHECKPOINT %s%s\n", p, c, s));
            this.output.flush();
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }

    private static boolean allTileSizesBetween(DSymbol ds, int min, int max) {
        Iterator iterator = ds.orbitReps(iTiles).iterator();
        while (iterator.hasNext()) {
            int D = (Integer)iterator.next();
            DSymbol tile = new DSymbol(new Subsymbol<Integer>(ds, iTiles, D));
            DSCover<Integer> cover = Covers.finiteUniversalCover(tile);
            int n = cover.numberOfOrbits(iFaces2d);
            if (n >= min && n <= max) continue;
            return false;
        }
        return true;
    }

    private static String info(DSymbol ds) {
        StringBuffer buf = new StringBuffer(50);
        DSCover<Integer> cover = Covers.pseudoToroidalCover3D(ds);
        int[] count = new int[5];
        int nt = 0;
        int sum_nf = 0;
        int sum_nfsqr = 0;
        Iterator iterator = cover.orbitReps(iTiles).iterator();
        while (iterator.hasNext()) {
            int D = (Integer)iterator.next();
            DSymbol tile = new DSymbol(new Subsymbol<Integer>(cover, iTiles, D));
            int k = tile.numberOfOrbits(iFaces2d);
            if (k < 12) {
                return "found tile with less than 12 faces";
            }
            if (k > 16) {
                return "found tile with more than 16 faces";
            }
            int n = k - 12;
            count[n] = count[n] + 1;
            sum_nf += k;
            sum_nfsqr += k * k;
            ++nt;
        }
        buf.append("composition: [");
        int i = 0;
        while (i < 5) {
            buf.append(' ');
            buf.append(count[i] > 0 ? String.valueOf(count[i]) : "-");
            ++i;
        }
        double avg_nf = (double)sum_nf / (double)nt;
        buf.append(" ]   <f> = ");
        buf.append(avg_nf);
        buf.append("   stdev = ");
        buf.append(Math.sqrt((double)sum_nfsqr / (double)nt - avg_nf * avg_nf));
        return buf.toString();
    }

    public static void usage() {
        System.err.print("Usage: java -jar Kelvin.jar [OPTION]... K [FILE]\n\nRecognized options:\n  -e        skip euclidicity test\n  -i N      interval in seconds between writing checkpoints\n  -p        skip pre-filtering by vertex stabilizers\n  -r A-B-C  resume generation at a checkpoint\n  -s P/Q    generate the P-th of Q parts\n  -t        skip on-the-fly testing of completed tiles\n  -v        run in verbose mode\n");
        System.exit(1);
    }

    public static void main(String[] args) {
        try {
            boolean verbose = false;
            boolean testParts = true;
            boolean testTiles = true;
            boolean testEuclidicity = true;
            int start = 0;
            int stop = 0;
            int section = 0;
            int nrOfSections = 0;
            int checkpointInterval = 3600;
            String resume = null;
            int i = 0;
            while (i < args.length && args[i].startsWith("-")) {
                String[] tmp;
                if (args[i].equals("-v")) {
                    verbose = !verbose;
                } else if (args[i].equals("-e")) {
                    testEuclidicity = !testEuclidicity;
                } else if (args[i].equals("-i")) {
                    checkpointInterval = Integer.parseInt(args[++i]);
                } else if (args[i].equals("-p")) {
                    testParts = !testParts;
                } else if (args[i].equals("-r")) {
                    resume = args[++i];
                } else if (args[i].equals("-s")) {
                    String msg;
                    tmp = args[++i].split("/");
                    section = Integer.parseInt(tmp[0]);
                    nrOfSections = Integer.parseInt(tmp[1]);
                    if (nrOfSections < 1) {
                        msg = "Number of sections must be positive.";
                        System.err.println(msg);
                        System.exit(1);
                    } else if (section < 1 || section > nrOfSections) {
                        msg = "Section # must be between 1 and " + nrOfSections;
                        System.err.println(msg);
                        System.exit(1);
                    }
                } else if (args[i].equals("-t")) {
                    testTiles = !testTiles;
                } else if (args[i].equals("-x")) {
                    tmp = args[++i].split("-");
                    start = Integer.parseInt(tmp[0]);
                    stop = Integer.parseInt(tmp[1]) + 1;
                } else {
                    Kelvin.usage();
                }
                ++i;
            }
            if (args.length <= i) {
                Kelvin.usage();
            }
            int k = Integer.parseInt(args[i]);
            OutputStreamWriter output = args.length > i + 1 ? new FileWriter(args[i + 1]) : new OutputStreamWriter(System.out);
            int countTileSizeOk = 0;
            int countGood = 0;
            int countAmbiguous = 0;
            Stopwatch timer = new Stopwatch();
            Stopwatch eTestTimer = new Stopwatch();
            int n = 0;
            timer.start();
            output.write("# Program Kelvin with k = " + k + ".\n");
            output.write("# Options:\n");
            output.write("#     verbose mode:                    ");
            output.write(String.valueOf(verbose ? "on" : "off") + "\n");
            output.write("#     pre-filter by vertex symmetries: ");
            output.write(String.valueOf(testParts ? "on" : "off") + "\n");
            output.write("#     test completed tiles on the fly: ");
            output.write(String.valueOf(testTiles ? "on" : "off") + "\n");
            output.write("#     euclidicity test:                ");
            output.write(String.valueOf(testEuclidicity ? "on" : "off") + "\n");
            if (checkpointInterval > 0) {
                output.write("#     checkpoint interval:             ");
                output.write(String.valueOf(checkpointInterval) + "sec\n");
            } else {
                output.write("#     checkpoints:                     off\n");
            }
            ((Writer)output).flush();
            if (nrOfSections > 0) {
                Kelvin tmp = new Kelvin(k, verbose, testParts, true, 0, 0, 0, null);
                while (tmp.hasNext()) {
                    tmp.next();
                }
                n = tmp.getCount();
                int m = nrOfSections;
                int s = section;
                start = (int)Math.round((double)n / (double)m * (double)(s - 1)) + 1;
                stop = (int)Math.round((double)n / (double)m * (double)s) + 1;
            }
            if (nrOfSections > 0) {
                output.write("# Running section " + section + " of " + nrOfSections + " (cases " + start + " to " + (stop - 1) + " of " + n + ").\n");
            } else if (stop > 0) {
                output.write("# Running cases " + start + " to " + stop + ".\n");
            }
            if (resume != null) {
                output.write(String.format("# Resuming at %s.\n", resume));
            }
            output.write("\n");
            ((Writer)output).flush();
            Kelvin iter = new Kelvin(k, verbose, testParts, false, start, stop, checkpointInterval, output);
            if (resume != null) {
                iter.setResumePoint(resume);
            }
            iter.setTestVertexFigures(testTiles);
            for (DSymbol ds : iter) {
                DSymbol out = ds.dual();
                if (!Kelvin.allTileSizesBetween(out, 12, 16)) continue;
                ++countTileSizeOk;
                if (testEuclidicity) {
                    eTestTimer.start();
                    EuclidicityTester tester = new EuclidicityTester(out);
                    boolean bad = tester.isBad();
                    boolean ambiguous = tester.isAmbiguous();
                    eTestTimer.stop();
                    if (!bad) {
                        iter.writeCheckpoint(false, "new symbol found");
                        if (ambiguous) {
                            output.write("#@ name euclidicity dubious\n");
                            ++countAmbiguous;
                        }
                        output.write("# " + Kelvin.info(out) + "\n");
                        output.write(out + "\n");
                        ++countGood;
                    }
                } else {
                    output.write(out + "\n");
                }
                ((Writer)output).flush();
            }
            timer.stop();
            output.write("\n");
            output.write("# Total execution time in user mode was " + timer.format() + ".\n");
            output.write("#   Time for generating 3d sets was " + Stopwatch.global("CombineTiles.total").format() + ".\n");
            output.write("#     Time for computing signatures was " + Stopwatch.global("CombineTiles.signatures").format() + ".\n");
            output.write("#     Total time for computing deductions was " + iter.getTimeForComputingDeductions() + ".\n");
            output.write("#       Time for finding cuts was " + iter.getTimeForFindingCuts() + ".\n");
            if (testTiles) {
                output.write("#       Time for testing tiles was " + iter.getTimeForVertexFigureTests() + ".\n");
            }
            if (testEuclidicity) {
                output.write("#   Time for euclidicity tests was " + eTestTimer.format() + ".\n");
            }
            output.write("# [timing method: " + eTestTimer.mode() + "]\n");
            output.write("\n");
            output.write("# " + iter.statistics() + "\n");
            output.write("# Of the latter, " + countTileSizeOk + " had between 12 and 16 faces in each tile.\n");
            if (testEuclidicity) {
                output.write("# Of those, " + countGood + " were found euclidean.\n");
                if (countAmbiguous > 0) {
                    output.write("# For " + countAmbiguous + " symbols, euclidicity remains undetermined.\n");
                }
            }
            ((Writer)output).flush();
        }
        catch (Exception ex) {
            ex.printStackTrace(System.err);
        }
    }
}

