/*
 * Decompiled with CFR 0.152.
 */
package org.gavrog.joss.dsyms.derived;

import junit.framework.Assert;
import junit.framework.TestCase;
import org.gavrog.joss.dsyms.basic.DSymbol;
import org.gavrog.joss.dsyms.basic.DelaneySymbol;
import org.gavrog.joss.dsyms.derived.Covers;
import org.gavrog.joss.dsyms.derived.DSCover;
import org.gavrog.joss.dsyms.derived.Simplifier;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TestSimplifier
extends TestCase {
    private final DSymbol good1 = new DSymbol("48 3:2 4 6 8 10 12 14 16 18 20 22 24 26 28 30 32 34 36 38 40 42 44 46 48,8 3 5 7 16 11 13 15 24 19 21 23 32 27 29 31 40 35 37 39 48 43 45 47,9 10 17 18 25 26 33 34 24 23 41 42 36 35 32 31 47 48 40 39 45 46 43 44,42 41 48 47 46 45 44 43 26 25 32 31 30 29 28 27 34 33 40 39 38 37 36 35:4 4 4 4 4 4,3 3 3 3 3 3 3 3,4 4 4 4 4 4");
    private final DSymbol good2 = new DSymbol("64 3:2 4 6 8 10 12 14 16 18 20 22 24 26 28 30 32 34 36 38 40 42 44 46 48 50 52 54 56 58 60 62 64,6 3 5 12 9 11 18 15 17 26 21 23 25 32 29 31 38 35 37 46 41 43 45 52 49 51 58 55 57 64 61 63,7 8 13 14 19 20 27 28 22 21 33 34 39 40 47 48 53 54 59 60 42 41 46 45 56 55 61 62 58 57 63 64,59 60 61 62 63 64 33 34 35 36 37 38 47 48 49 50 51 52 39 40 41 42 43 44 45 46 54 53 58 57 56 55:3 3 3 4 3 3 4 3 3 3,3 5 5 5 3 3 3 5,4 4 3 3 3 3 3 3 3 3");

    public void testSimplifier1() {
        this.testSimplifier(new DSymbol("2 3:1 2,1 2,1 2,2:3 3,3 4,4"), true);
    }

    public void testSimplifier2() {
        this.testSimplifier(new DSymbol("1 3:1,1,1,1:4,3,4"), true);
    }

    public void testSimplifier3() {
        this.testSimplifier(new DSymbol("20 3:2 4 6 8 10 12 14 16 18 20, 10 3 5 7 9 20 13 15 17 19,4 3 11 12 16 15 19 20 17 18,16 15 14 13 12 11 20 19 18 17:5 5,3 6 3 3,4 4 4"), false);
    }

    public <T> void testSimplifier(DelaneySymbol<T> ds, boolean good) {
        DSCover<T> cover = Covers.pseudoToroidalCover3D(ds);
        DelaneySymbol<Integer> simpler = new Simplifier(cover).getSimplifiedSymbol();
        Assert.assertEquals((boolean)good, (simpler.equals(this.good1) || simpler.equals(this.good2) ? 1 : 0) != 0);
    }
}

