/*
 * Decompiled with CFR 0.152.
 */
package org.gavrog.joss.dsyms.derived;

import java.util.List;
import java.util.Map;
import java.util.Set;
import junit.framework.Assert;
import junit.framework.TestCase;
import org.gavrog.box.collections.Pair;
import org.gavrog.jane.fpgroups.Alphabet;
import org.gavrog.jane.fpgroups.FiniteAlphabet;
import org.gavrog.jane.fpgroups.FreeWord;
import org.gavrog.joss.dsyms.basic.DSPair;
import org.gavrog.joss.dsyms.basic.DSymbol;
import org.gavrog.joss.dsyms.basic.DelaneySymbol;
import org.gavrog.joss.dsyms.derived.FundamentalGroup;

public class TestFundamentalGroup
extends TestCase {
    private static final String spec1 = "1 3:1,1,1,1:4,3,4";
    private static final String spec2 = "48 3:2 4 6 8 10 12 14 16 18 20 22 24 26 28 30 32 34 36 38 40 42 44 46 48,8 3 5 7 16 11 13 15 24 19 21 23 32 27 29 31 40 35 37 39 48 43 45 47,9 10 17 18 25 26 33 34 24 23 41 42 36 35 32 31 47 48 40 39 45 46 43 44,42 41 48 47 46 45 44 43 26 25 32 31 30 29 28 27 34 33 40 39 38 37 36 35:4 4 4 4 4 4,3 3 3 3 3 3 3 3,4 4 4 4 4 4";
    private DelaneySymbol ds1;
    private DelaneySymbol ds2;
    private FundamentalGroup fg1;
    private FundamentalGroup fg2;
    private Alphabet al1;
    private Alphabet al2;

    protected void setUp() throws Exception {
        super.setUp();
        this.ds1 = new DSymbol(spec1);
        this.fg1 = new FundamentalGroup(this.ds1);
        this.al1 = this.fg1.getPresentation().getAlphabet();
        this.ds2 = new DSymbol(spec2);
        this.fg2 = new FundamentalGroup(this.ds2);
        this.al2 = this.fg2.getPresentation().getAlphabet();
    }

    protected void tearDown() throws Exception {
        this.ds1 = null;
        this.al1 = null;
        this.ds2 = null;
        this.al2 = null;
        super.tearDown();
    }

    public void testGetAlphabet() {
        Assert.assertEquals(FiniteAlphabet.fromPrefix("g_", 4), (Object)this.al1);
        Assert.assertEquals(FiniteAlphabet.fromPrefix("g_", 3), (Object)this.al2);
    }

    public void testGetRelators() {
        List<FreeWord<String>> rels1 = this.fg1.getPresentation().getRelators();
        Assert.assertEquals((int)10, (int)rels1.size());
        Assert.assertTrue((boolean)rels1.contains(FreeWord.parsedWord(this.al1, "g_1^2")));
        Assert.assertTrue((boolean)rels1.contains(FreeWord.parsedWord(this.al1, "g_2^2")));
        Assert.assertTrue((boolean)rels1.contains(FreeWord.parsedWord(this.al1, "g_3^2")));
        Assert.assertTrue((boolean)rels1.contains(FreeWord.parsedWord(this.al1, "g_4^2")));
        Assert.assertTrue((boolean)rels1.contains(FreeWord.parsedWord(this.al1, "(g_1*g_2)^4")));
        Assert.assertTrue((boolean)rels1.contains(FreeWord.parsedWord(this.al1, "(g_1*g_3)^2")));
        Assert.assertTrue((boolean)rels1.contains(FreeWord.parsedWord(this.al1, "(g_1*g_4)^2")));
        Assert.assertTrue((boolean)rels1.contains(FreeWord.parsedWord(this.al1, "(g_2*g_3)^3")));
        Assert.assertTrue((boolean)rels1.contains(FreeWord.parsedWord(this.al1, "(g_2*g_4)^2")));
        Assert.assertTrue((boolean)rels1.contains(FreeWord.parsedWord(this.al1, "(g_3*g_4)^4")));
        List<FreeWord<String>> rels2 = this.fg2.getPresentation().getRelators();
        Assert.assertTrue((rels2.size() == 3 ? 1 : 0) != 0);
        Assert.assertTrue((boolean)rels2.contains(FreeWord.parsedWord(this.al2, "g_1*g_2*g_1^-1*g_2^-1")));
        Assert.assertTrue((boolean)rels2.contains(FreeWord.parsedWord(this.al2, "g_1*g_3*g_1^-1*g_3^-1")));
        Assert.assertTrue((boolean)rels2.contains(FreeWord.parsedWord(this.al2, "g_2*g_3*g_2^-1*g_3^-1")));
    }

    public void testGetSymbol() {
        Assert.assertEquals((Object)this.ds1, this.fg1.getSymbol());
        Assert.assertEquals((Object)this.ds2, this.fg2.getSymbol());
    }

    public void testGetEdgeToWord() {
        Integer D1 = new Integer(1);
        Integer D9 = new Integer(9);
        DSPair<Integer> e0 = new DSPair<Integer>(0, D1);
        DSPair<Integer> e1 = new DSPair<Integer>(1, D1);
        DSPair<Integer> e2 = new DSPair<Integer>(2, D1);
        DSPair<Integer> e3 = new DSPair<Integer>(3, D1);
        Map e2w1 = this.fg1.getEdgeToWord();
        Assert.assertEquals(FreeWord.parsedWord(this.al1, "g_1"), e2w1.get(e0));
        Assert.assertEquals(FreeWord.parsedWord(this.al1, "g_2"), e2w1.get(e1));
        Assert.assertEquals(FreeWord.parsedWord(this.al1, "g_3"), e2w1.get(e2));
        Assert.assertEquals(FreeWord.parsedWord(this.al1, "g_4"), e2w1.get(e3));
        Map e2w2 = this.fg2.getEdgeToWord();
        FreeWord al2g1 = FreeWord.parsedWord(this.al2, "g_1");
        Assert.assertEquals(FreeWord.parsedWord(this.al2, ""), e2w2.get(e0));
        Assert.assertEquals(al2g1, e2w2.get(e3));
        Assert.assertEquals(al2g1.inverse(), e2w2.get(e3.reverse(this.ds2)));
        Assert.assertEquals(FreeWord.parsedWord(this.al2, "g_2"), e2w2.get(new DSPair<Integer>(3, D9)));
    }

    public void testGetGeneratorToEdge() {
        Integer D1 = new Integer(1);
        DSPair<Integer> e0 = new DSPair<Integer>(0, D1);
        DSPair<Integer> e1 = new DSPair<Integer>(1, D1);
        DSPair<Integer> e2 = new DSPair<Integer>(2, D1);
        DSPair<Integer> e3 = new DSPair<Integer>(3, D1);
        Map g2e1 = this.fg1.getGeneratorToEdge();
        Assert.assertEquals(e0, g2e1.get(FreeWord.parsedWord(this.al1, "g_1")));
        Assert.assertEquals(e1, g2e1.get(FreeWord.parsedWord(this.al1, "g_2")));
        Assert.assertEquals(e2, g2e1.get(FreeWord.parsedWord(this.al1, "g_3")));
        Assert.assertEquals(e3, g2e1.get(FreeWord.parsedWord(this.al1, "g_4")));
        Map e2w2 = this.fg2.getEdgeToWord();
        Map g2e2 = this.fg2.getGeneratorToEdge();
        FreeWord g1 = FreeWord.parsedWord(this.al2, "g_1");
        FreeWord g2 = FreeWord.parsedWord(this.al2, "g_2");
        FreeWord g3 = FreeWord.parsedWord(this.al2, "g_3");
        Assert.assertEquals(g1, e2w2.get(g2e2.get(g1)));
        Assert.assertEquals(g2, e2w2.get(g2e2.get(g2)));
        Assert.assertEquals(g3, e2w2.get(g2e2.get(g3)));
    }

    public void testGetAxes() {
        Integer two = new Integer(2);
        Integer three = new Integer(3);
        Integer four = new Integer(4);
        Set<Pair<FreeWord<String>, Integer>> ax1 = this.fg1.getAxes();
        Assert.assertEquals((int)6, (int)ax1.size());
        Assert.assertTrue((boolean)ax1.contains(new Pair(FreeWord.parsedWord(this.al1, "g_1*g_2"), four)));
        Assert.assertTrue((boolean)ax1.contains(new Pair(FreeWord.parsedWord(this.al1, "g_1*g_3"), two)));
        Assert.assertTrue((boolean)ax1.contains(new Pair(FreeWord.parsedWord(this.al1, "g_1*g_4"), two)));
        Assert.assertTrue((boolean)ax1.contains(new Pair(FreeWord.parsedWord(this.al1, "g_2*g_3"), three)));
        Assert.assertTrue((boolean)ax1.contains(new Pair(FreeWord.parsedWord(this.al1, "g_2*g_4"), two)));
        Assert.assertTrue((boolean)ax1.contains(new Pair(FreeWord.parsedWord(this.al1, "g_3*g_4"), four)));
        Assert.assertEquals((int)0, (int)this.fg2.getAxes().size());
    }
}

