/*
 * Decompiled with CFR 0.152.
 */
package org.gavrog.joss.dsyms.derived;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.gavrog.box.collections.IteratorAdapter;
import org.gavrog.box.collections.Iterators;
import org.gavrog.box.collections.Pair;
import org.gavrog.joss.dsyms.basic.DSPair;
import org.gavrog.joss.dsyms.basic.DSymbol;
import org.gavrog.joss.dsyms.basic.DelaneySymbol;
import org.gavrog.joss.dsyms.basic.DynamicDSymbol;
import org.gavrog.joss.dsyms.basic.IndexList;
import org.gavrog.joss.dsyms.basic.Traversal;
import org.gavrog.joss.dsyms.derived.FundamentalEdges;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Simplifier {
    private static int LOGGING_LEVEL = 0;
    final DSymbol originalSymbol;
    DynamicDSymbol ds;
    DSymbol simplifiedSymbol = null;

    public <T> Simplifier(DelaneySymbol<T> inputSymbol) {
        int i2;
        if (LOGGING_LEVEL > 0) {
            System.out.println("Simplifyer: constructor called on symbol of size " + inputSymbol.size());
        }
        if (inputSymbol == null) {
            throw new IllegalArgumentException("null pointer received");
        }
        if (inputSymbol.dim() != 3) {
            String s = "symbol must be 3-dimensional";
            throw new UnsupportedOperationException("symbol must be 3-dimensional");
        }
        DSymbol symbol = new DSymbol(inputSymbol);
        for (int i2 : symbol.indices()) {
            for (int D : symbol.elements()) {
                if (symbol.definesOp(i2, D)) continue;
                String s = "symbol must define all neighbors";
                throw new UnsupportedOperationException("symbol must define all neighbors");
            }
        }
        if (!symbol.isOriented()) {
            throw new UnsupportedOperationException("symbol must be oriented");
        }
        i2 = 0;
        while (i2 < symbol.dim() - 1) {
            int j = i2 + 2;
            while (j <= symbol.dim()) {
                for (int D : symbol.orbitReps(new IndexList(i2, j))) {
                    int E2;
                    int E1 = symbol.op(j, symbol.op(i2, D));
                    if (E1 == (E2 = symbol.op(i2, symbol.op(j, D)).intValue())) continue;
                    String s = "symbol has oversized (" + i2 + "," + j + ") orbit";
                    throw new IllegalArgumentException(s);
                }
                ++j;
            }
            ++i2;
        }
        i2 = 0;
        while (i2 < symbol.dim()) {
            Iterator iterator = symbol.orbitReps(new IndexList(i2, i2 + 1)).iterator();
            while (iterator.hasNext()) {
                int D = (Integer)iterator.next();
                if (symbol.v(i2, i2 + 1, D) == 1) continue;
                String s = "symbol must be trivially branched";
                throw new UnsupportedOperationException("symbol must be trivially branched");
            }
            ++i2;
        }
        this.originalSymbol = symbol;
    }

    public DelaneySymbol<Integer> getSimplifiedSymbol() {
        if (this.simplifiedSymbol == null) {
            this.compute();
        }
        return this.simplifiedSymbol;
    }

    /*
     * Could not resolve type clashes
     */
    private void compute() {
        if (LOGGING_LEVEL > 0) {
            System.out.println("Simplifyer: starting");
        }
        this.ds = new DynamicDSymbol(this.originalSymbol);
        if (this.countOrbits(1, 2, 3) < this.countOrbits(0, 1, 2)) {
            if (LOGGING_LEVEL > 0) {
                this.log("dualizing");
            }
            this.ds = this.ds.dual();
        }
        LinkedList<Integer> disposable = new LinkedList<Integer>();
        boolean dualized = false;
        boolean modified = true;
        while (modified) {
            int[] cut;
            Object e3;
            int D;
            modified = false;
            if (this.countOrbits(0, 1, 2) > 1 || this.hasSize2Orbit(2, 3)) {
                disposable.clear();
                for (DSPair e2 : new FundamentalEdges<Integer>(this.ds)) {
                    int i = e2.getIndex();
                    if (i != 3) continue;
                    D = (Integer)e2.getElement();
                    disposable.add(D);
                    disposable.add(this.ds.op(3, D));
                }
                if (disposable.size() > 0) {
                    if (LOGGING_LEVEL > 0) {
                        this.log("merging volumes and removing intruding faces");
                    }
                    this.ds.collapse(disposable, 3);
                    modified = true;
                }
            }
            disposable.clear();
            IndexList idcs = new IndexList(2, 3);
            Iterator<Object> iterator = this.ds.orbitReps(idcs).iterator();
            while (iterator.hasNext()) {
                int D2 = (Integer)iterator.next();
                if (this.ds.r(2, 3, D2) != 2) continue;
                disposable.add(D2);
                disposable.add(this.ds.op(2, D2));
                disposable.add(this.ds.op(3, D2));
                disposable.add(this.ds.op(3, this.ds.op(2, D2)));
            }
            if (disposable.size() > 0) {
                if (LOGGING_LEVEL > 0) {
                    this.log("removing degree 2 edges");
                }
                this.ds.collapse(disposable, 2);
                modified = true;
            }
            if (this.countOrbits(1, 2, 3) > 1 || this.hasSize2Orbit(0, 1)) {
                disposable.clear();
                idcs = new IndexList(this.ds);
                Collections.reverse(idcs);
                Traversal<IteratorAdapter<Integer>> trav = new Traversal<IteratorAdapter<Integer>>((DelaneySymbol<IteratorAdapter<Integer>>)this.ds, (List<Integer>)idcs, this.ds.elements());
                for (Object e3 : new FundamentalEdges<IteratorAdapter<Integer>>(this.ds, trav)) {
                    int i = ((DSPair)e3).getIndex();
                    if (i != 0) continue;
                    int D3 = (Integer)((DSPair)e3).getElement();
                    disposable.add(D3);
                    disposable.add(this.ds.op(0, D3));
                }
                if (disposable.size() > 0) {
                    if (LOGGING_LEVEL > 0) {
                        this.log("contracting edges");
                    }
                    this.ds.collapse(disposable, 0);
                    modified = true;
                }
            }
            disposable.clear();
            idcs = new IndexList(0, 1);
            e3 = this.ds.orbitReps(idcs).iterator();
            while (e3.hasNext()) {
                int D4 = (Integer)e3.next();
                if (this.ds.r(0, 1, D4) != 2) continue;
                disposable.add(D4);
                disposable.add(this.ds.op(0, D4));
                disposable.add(this.ds.op(1, D4));
                disposable.add(this.ds.op(1, this.ds.op(0, D4)));
            }
            if (disposable.size() > 0) {
                if (LOGGING_LEVEL > 0) {
                    this.log("removing degree 2 faces");
                }
                this.ds.collapse(disposable, 1);
                modified = true;
            }
            if (!modified) {
                e3 = this.ds.orbitReps(new IndexList(1, 2)).iterator();
                while (e3.hasNext()) {
                    int C = (Integer)e3.next();
                    if (this.ds.m(1, 2, C) != 1) continue;
                    if (LOGGING_LEVEL > 0) {
                        this.log("removing local degree one vertex");
                    }
                    int D5 = this.ds.op(0, this.ds.op(1, C));
                    int E = this.ds.op(1, this.ds.op(0, C));
                    int F = this.ds.op(3, D5);
                    int G = this.ds.op(3, E);
                    int D1 = this.ds.op(1, D5);
                    int E1 = this.ds.op(1, E);
                    int F1 = this.ds.op(1, F);
                    int G1 = this.ds.op(1, G);
                    this.ds.redefineOp(1, D5, E1);
                    this.ds.redefineOp(1, E, D1);
                    this.ds.redefineOp(1, F, G1);
                    this.ds.redefineOp(1, G, F1);
                    disposable.clear();
                    Iterators.addAll(disposable, this.ds.orbit(new IndexList(0, 1, 3), C));
                    this.ds.collapse(disposable, 3);
                    modified = true;
                    break;
                }
            }
            if (!modified) {
                idcs = new IndexList(1, 2);
                e3 = this.ds.orbitReps(idcs).iterator();
                while (e3.hasNext()) {
                    int E;
                    int D6 = (Integer)e3.next();
                    if (this.ds.r(1, 2, D6) != 2 || D6 == (E = this.ds.op(3, this.ds.op(2, D6)).intValue()) || D6 == this.ds.op(1, this.ds.op(0, E)) || D6 == this.ds.op(0, this.ds.op(1, E))) continue;
                    if (LOGGING_LEVEL > 0) {
                        this.log("removing vertex of local degree 2");
                    }
                    E = this.ds.op(2, this.ds.op(1, D6));
                    if (this.ds.r(0, 1, D6) > 3) {
                        this.cutFace3D(this.ds.op(0, D6), this.ds.op(0, this.ds.op(1, D6)));
                    }
                    if (this.ds.r(0, 1, E) > 3) {
                        this.cutFace3D(this.ds.op(0, E), this.ds.op(0, this.ds.op(1, E)));
                    }
                    this.squeezeTile3D(this.ds.op(1, this.ds.op(0, D6)), this.ds.op(1, this.ds.op(0, E)));
                    disposable.clear();
                    Iterators.addAll(disposable, this.ds.orbit(new IndexList(0, 1, 3), D6));
                    this.ds.collapse(disposable, 3);
                    modified = true;
                    break;
                }
            }
            if (!modified) {
                HashMap<Integer, Integer> face2rep = new HashMap<Integer, Integer>();
                HashMap<Integer, Integer> vert2rep = new HashMap<Integer, Integer>();
                IndexList idcsFace = new IndexList(0, 1);
                Iterator F = this.ds.orbitReps(idcsFace).iterator();
                while (F.hasNext()) {
                    D = (Integer)F.next();
                    IteratorAdapter<Integer> orb = this.ds.orbit(idcsFace, D);
                    while (orb.hasNext()) {
                        face2rep.put((Integer)orb.next(), D);
                    }
                }
                IndexList idcsVert = new IndexList(1, 2);
                Iterator orb = this.ds.orbitReps(idcsVert).iterator();
                while (orb.hasNext()) {
                    int D7 = (Integer)orb.next();
                    IteratorAdapter<Integer> orb2 = this.ds.orbit(idcsVert, D7);
                    while (orb2.hasNext()) {
                        vert2rep.put((Integer)orb2.next(), D7);
                    }
                }
                HashMap<Pair<Integer, Integer>, Integer> sig2chamber = new HashMap<Pair<Integer, Integer>, Integer>();
                Map sign = this.ds.partialOrientation();
                for (int D8 : this.ds.elements()) {
                    if (sign.get(D8) < 0) continue;
                    Pair<Integer, Integer> signature = new Pair<Integer, Integer>((Integer)face2rep.get(D8), (Integer)vert2rep.get(D8));
                    Integer E = (Integer)sig2chamber.get(signature);
                    if (E == null) {
                        sig2chamber.put(signature, D8);
                        continue;
                    }
                    if (LOGGING_LEVEL > 0) {
                        this.log("removing non-cellular face");
                    }
                    int F2 = this.ds.op(3, D8);
                    int G = this.ds.op(3, E);
                    int D1 = this.ds.op(1, D8);
                    int E1 = this.ds.op(1, E);
                    int F1 = this.ds.op(1, F2);
                    int G1 = this.ds.op(1, G);
                    this.ds.redefineOp(1, D8, E1);
                    this.ds.redefineOp(1, E, D1);
                    this.ds.redefineOp(1, F2, G1);
                    this.ds.redefineOp(1, G, F1);
                    modified = true;
                    break;
                }
            }
            if (!modified && (cut = this.firstLiftableTwoCut()) != null) {
                if (LOGGING_LEVEL > 0) {
                    this.log("removing disconnected face intersection");
                }
                int[] D9 = new int[2];
                int i = 0;
                while (i < 2) {
                    int A = cut[2 * i];
                    int B = cut[2 * i + 1];
                    if (this.ds.op(0, A).equals(B)) {
                        D9[i] = this.ds.op(2, A);
                    } else {
                        if (!this.ds.op(1, this.ds.op(0, this.ds.op(1, A))).equals(B)) {
                            this.cutFace3D(A, B);
                        }
                        D9[i] = this.ds.op(1, A);
                    }
                    ++i;
                }
                this.squeezeTile3D(D9[0], D9[1]);
                modified = true;
            }
            if (modified) {
                dualized = false;
                continue;
            }
            if (dualized) continue;
            if (LOGGING_LEVEL > 0) {
                this.log("dualizing");
            }
            this.ds = this.ds.dual();
            modified = true;
            dualized = true;
        }
        if (LOGGING_LEVEL > 0) {
            this.log("exporting");
        }
        this.simplifiedSymbol = new DSymbol(this.ds);
        if (LOGGING_LEVEL > 0) {
            System.out.println("Simplifyer: finished");
            if (LOGGING_LEVEL >= 2) {
                System.out.println("  final result: " + this.simplifiedSymbol);
            }
        }
    }

    private void log(String action) {
        if (LOGGING_LEVEL >= 2) {
            int kfComplexity = 0;
            Iterator iterator = this.ds.orbitReps(new IndexList(0, 1, 3)).iterator();
            while (iterator.hasNext()) {
                int D = (Integer)iterator.next();
                kfComplexity += this.ds.r(0, 1, D) - 2;
            }
            System.out.println("  Symbol of size " + this.ds.size() + " and kf-complexity " + kfComplexity);
            System.out.println(" with    " + this.countComponents() + " components, " + this.countOrbits(0, 1, 2) + " tiles, " + this.countOrbits(0, 1, 3) + " faces, " + this.countOrbits(0, 2, 3) + " edges, " + this.countOrbits(1, 2, 3) + " vertices.");
        }
        if (LOGGING_LEVEL >= 3) {
            System.out.println("    " + new DSymbol(this.ds));
        }
        if (LOGGING_LEVEL >= 1) {
            System.out.println("    " + action + "...");
        }
    }

    private int countOrbits(int i, int j, int k) {
        return Iterators.size(this.ds.orbitReps(new IndexList(i, j, k)));
    }

    private int countComponents() {
        return Iterators.size(this.ds.orbitReps(new IndexList(this.ds)));
    }

    private boolean hasSize2Orbit(int i, int j) {
        Iterator iterator = this.ds.orbitReps(new IndexList(i, j)).iterator();
        while (iterator.hasNext()) {
            int D = (Integer)iterator.next();
            if (!this.ds.op(i, D).equals(this.ds.op(j, D))) continue;
            return true;
        }
        return false;
    }

    private void cutFace3D(int D1, int D2) {
        if (D1 == D2 || D1 == this.ds.op(1, D2)) {
            throw new IllegalArgumentException("vertices not distinct");
        }
        int E = D1;
        while ((E = this.ds.op(0, E).intValue()) != D2) {
            if ((E = this.ds.op(1, E).intValue()) == D2) {
                D2 = this.ds.op(1, D2);
                break;
            }
            if (E != D1) continue;
            throw new IllegalArgumentException("vertices not in a common face");
        }
        Integer[] nu = this.ds.grow(8).toArray(new Integer[0]);
        int k = 0;
        while (k < 8) {
            int D = nu[k];
            int i = 0;
            while (i <= 2) {
                this.ds.redefineV(i, i + 1, D, 1);
                ++i;
            }
            ++k;
        }
        this.ds.redefineOp(0, nu[0], nu[1]);
        this.ds.redefineOp(0, nu[2], nu[3]);
        this.ds.redefineOp(0, nu[4], nu[5]);
        this.ds.redefineOp(0, nu[6], nu[7]);
        this.ds.redefineOp(3, nu[1], nu[2]);
        this.ds.redefineOp(3, nu[3], nu[0]);
        this.ds.redefineOp(3, nu[5], nu[6]);
        this.ds.redefineOp(3, nu[7], nu[4]);
        this.ds.redefineOp(2, nu[0], nu[4]);
        this.ds.redefineOp(2, nu[1], nu[5]);
        this.ds.redefineOp(2, nu[2], nu[6]);
        this.ds.redefineOp(2, nu[3], nu[7]);
        int[] old = new int[]{D1, D2, this.ds.op(3, D2), this.ds.op(3, D1), this.ds.op(1, D1), this.ds.op(1, D2), this.ds.op(3, this.ds.op(1, D2)), this.ds.op(3, this.ds.op(1, D1))};
        int i = 0;
        while (i < 8) {
            this.ds.redefineOp(1, nu[i], old[i]);
            ++i;
        }
    }

    private void squeezeTile3D(int D, int E) {
        int d = this.ds.op(0, E);
        int e = this.ds.op(0, D);
        int d2 = this.ds.op(2, d);
        int e2 = this.ds.op(2, e);
        int E2 = this.ds.op(2, E);
        int D2 = this.ds.op(2, D);
        this.ds.redefineOp(2, d, D);
        this.ds.redefineOp(2, e, E);
        this.ds.redefineOp(2, d2, D2);
        this.ds.redefineOp(2, e2, E2);
    }

    private int[] firstLiftableTwoCut() {
        IndexList idcsFace = new IndexList(0, 1);
        IndexList idcsVertex = new IndexList(1, 2);
        int n = this.ds.numberOfOrbits(idcsFace);
        ArrayList faces = new ArrayList();
        IteratorAdapter faceReps = this.ds.orbitReps(idcsFace);
        int i = 0;
        while (i < n) {
            int D = (Integer)faceReps.next();
            HashSet<Integer> f = new HashSet<Integer>();
            IteratorAdapter<Integer> iter = this.ds.orbit(idcsFace, D);
            while (iter.hasNext()) {
                f.add((Integer)iter.next());
            }
            faces.add(f);
            ++i;
        }
        i = 0;
        while (i < n - 1) {
            Set f1 = (Set)faces.get(i);
            HashSet<Integer> marked = new HashSet<Integer>();
            Iterator iterator = f1.iterator();
            while (iterator.hasNext()) {
                int D = (Integer)iterator.next();
                for (int E : this.ds.orbit(idcsVertex, D)) {
                    if (f1.contains(this.ds.op(2, E))) continue;
                    marked.add(E);
                }
            }
            int j = i + 1;
            while (j < n) {
                Set f2 = (Set)faces.get(j);
                HashSet<Integer> intersection = new HashSet<Integer>();
                Iterator iterator2 = f2.iterator();
                while (iterator2.hasNext()) {
                    int D = (Integer)iterator2.next();
                    if (!marked.contains(D)) continue;
                    intersection.add(D);
                }
                if (intersection.size() >= 4) {
                    int D1 = 0;
                    Iterator iter = intersection.iterator();
                    while (iter.hasNext()) {
                        D1 = (Integer)iter.next();
                        if (!intersection.contains(this.ds.op(0, D1))) break;
                    }
                    int D2 = this.ds.op(0, D1);
                    while (!intersection.contains(D2)) {
                        D2 = this.ds.op(0, this.ds.op(1, D2));
                    }
                    int D3 = this.ds.op(2, D2);
                    while (!f1.contains(D3)) {
                        D3 = this.ds.op(2, this.ds.op(1, D3));
                    }
                    int D4 = this.ds.op(2, D1);
                    while (!f1.contains(D4)) {
                        D4 = this.ds.op(2, this.ds.op(1, D4));
                    }
                    int E = D4;
                    int count = 0;
                    while (!this.ds.op(0, E).equals(D3)) {
                        int E3 = this.ds.op(3, E = this.ds.op(1, this.ds.op(0, E)).intValue());
                        if (E3 != D1 && E3 != this.ds.op(1, D2)) continue;
                        ++count;
                    }
                    if (count != 1) {
                        return new int[]{D1, D2, D3, D4};
                    }
                }
                ++j;
            }
            ++i;
        }
        return null;
    }
}

