/*
 * Decompiled with CFR 0.152.
 */
package org.gavrog.joss.dsyms.derived;

import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.OutputStreamWriter;
import java.io.Writer;
import java.util.HashSet;
import java.util.List;
import org.gavrog.jane.numbers.Whole;
import org.gavrog.joss.dsyms.basic.DSymbol;
import org.gavrog.joss.dsyms.basic.DelaneySymbol;
import org.gavrog.joss.dsyms.derived.FundamentalGroup;
import org.gavrog.joss.dsyms.derived.OrbifoldGraph;
import org.gavrog.joss.dsyms.generators.InputIterator;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class OrbifoldInvariant<T> {
    private final DelaneySymbol<T> ds;
    private final OrbifoldGraph ograph;
    private final List<Whole> abelian;

    public OrbifoldInvariant(DelaneySymbol<T> ds) {
        this.ds = ds;
        this.ograph = new OrbifoldGraph(ds);
        this.abelian = new FundamentalGroup<T>(ds).getPresentation().abelianInvariants();
    }

    public String toString() {
        StringBuffer buf = new StringBuffer(200);
        String[] stabs = this.ograph.getStabilizers();
        buf.append(stabs.length);
        buf.append('/');
        int i = 0;
        while (i < stabs.length) {
            buf.append(stabs[i]);
            buf.append('/');
            ++i;
        }
        if (this.ds.isOriented()) {
            buf.append("2/");
        } else if (this.ds.isWeaklyOriented()) {
            buf.append("1/");
        } else {
            buf.append("0/");
        }
        buf.append(this.ograph.getEdges().size());
        buf.append('/');
        buf.append(this.abelian.size());
        buf.append('/');
        for (Whole n : this.abelian) {
            buf.append(n);
            buf.append('/');
        }
        return buf.toString();
    }

    public static void main(String[] args) {
        try {
            int i = 0;
            while (i < args.length && args[i].startsWith("-")) {
                System.err.println("Unknown option '" + args[i] + "'");
                ++i;
            }
            InputStreamReader in = args.length > i ? new FileReader(args[i]) : new InputStreamReader(System.in);
            OutputStreamWriter out = args.length > i + 1 ? new FileWriter(args[i + 1]) : new OutputStreamWriter(System.out);
            long before = System.currentTimeMillis();
            HashSet<String> seen = new HashSet<String>();
            int inCount = 0;
            int dups = 0;
            for (DSymbol ds : new InputIterator(in)) {
                ++inCount;
                String inv = new OrbifoldInvariant<Integer>(ds).toString();
                if (seen.contains(inv)) {
                    out.write("# Dup: ");
                    ++dups;
                } else {
                    seen.add(inv);
                }
                out.write(inv);
                ((Writer)out).write(10);
                ((Writer)out).flush();
            }
            long after = System.currentTimeMillis();
            out.write("### Processed " + inCount + " symbols in " + (after - before) / 1000L + " seconds.\n");
            out.write("### Found " + dups + " duplicates.\n");
            ((Writer)out).flush();
        }
        catch (IOException ex) {
            ex.printStackTrace();
        }
    }
}

