/*
 * Decompiled with CFR 0.152.
 */
package org.gavrog.joss.algorithms;

import org.gavrog.joss.algorithms.ResumableGenerator;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CheckpointEvent {
    private final ResumableGenerator<?> source;
    private final boolean old;
    private final String message;

    public CheckpointEvent(ResumableGenerator<?> source, boolean old, String message) {
        this.source = source;
        this.old = old;
        this.message = message;
    }

    public ResumableGenerator<?> getSource() {
        return this.source;
    }

    public String getCheckpoint() {
        return this.getSource().getCheckpoint();
    }

    public boolean isOld() {
        return this.old;
    }

    public String getMessage() {
        return this.message;
    }

    public String toString() {
        String msg = this.getMessage();
        String p = this.isOld() ? "# OLD" : "#@";
        String c = this.getCheckpoint();
        String s = msg != null ? String.format(" (%s)", msg) : "";
        return String.format("%s CHECKPOINT %s%s", p, c, s);
    }
}

