/*
 * Decompiled with CFR 0.152.
 */
package org.gavrog.jane.compounds;

import org.gavrog.box.simple.TaskController;
import org.gavrog.jane.numbers.ArithmeticBase;
import org.gavrog.jane.numbers.Complex;
import org.gavrog.jane.numbers.FloatingPoint;
import org.gavrog.jane.numbers.IArithmetic;
import org.gavrog.jane.numbers.Real;
import org.gavrog.jane.numbers.Whole;

public class Matrix
extends ArithmeticBase {
    private static final boolean DEBUG = false;
    private final IArithmetic[] data;
    private final int nrows;
    private final int ncols;
    private boolean mutable;

    public Matrix(int n, int n2) {
        this.nrows = n;
        this.ncols = n2;
        this.data = new IArithmetic[n * n2];
        this.mutable = true;
    }

    public Matrix(Matrix matrix) {
        this.nrows = matrix.nrows;
        this.ncols = matrix.ncols;
        this.data = matrix.mutable ? (IArithmetic[])matrix.data.clone() : matrix.data;
        this.mutable = matrix.mutable;
    }

    public Matrix(IArithmetic[][] iArithmeticArray) {
        this.nrows = iArithmeticArray.length;
        this.ncols = iArithmeticArray[0].length;
        this.data = new IArithmetic[this.nrows * this.ncols];
        this.mutable = false;
        int n = 0;
        for (int i = 0; i < this.nrows; ++i) {
            for (int j = 0; j < this.ncols; ++j) {
                this.data[n] = iArithmeticArray[i][j];
                ++n;
            }
        }
    }

    public Matrix(int[][] nArray) {
        this.nrows = nArray.length;
        this.ncols = nArray[0].length;
        this.data = new IArithmetic[this.nrows * this.ncols];
        this.mutable = false;
        int n = 0;
        for (int i = 0; i < this.nrows; ++i) {
            for (int j = 0; j < this.ncols; ++j) {
                this.data[n] = new Whole(nArray[i][j]);
                ++n;
            }
        }
    }

    public Matrix(long[][] lArray) {
        this.nrows = lArray.length;
        this.ncols = lArray[0].length;
        this.data = new IArithmetic[this.nrows * this.ncols];
        this.mutable = false;
        int n = 0;
        for (int i = 0; i < this.nrows; ++i) {
            for (int j = 0; j < this.ncols; ++j) {
                this.data[n] = new Whole(lArray[i][j]);
                ++n;
            }
        }
    }

    public Matrix(double[][] dArray) {
        this.nrows = dArray.length;
        this.ncols = dArray[0].length;
        this.data = new IArithmetic[this.nrows * this.ncols];
        this.mutable = false;
        int n = 0;
        for (int i = 0; i < this.nrows; ++i) {
            for (int j = 0; j < this.ncols; ++j) {
                this.data[n] = new FloatingPoint(dArray[i][j]);
                ++n;
            }
        }
    }

    public int[] getShape() {
        int[] nArray = new int[]{this.nrows, this.ncols};
        return nArray;
    }

    public int numberOfRows() {
        return this.nrows;
    }

    public int numberOfColumns() {
        return this.ncols;
    }

    public double[][] asDoubleArray() {
        double[][] dArray = new double[this.numberOfRows()][this.numberOfColumns()];
        for (int i = 0; i < this.numberOfRows(); ++i) {
            for (int j = 0; j < this.numberOfColumns(); ++j) {
                dArray[i][j] = ((Real)this.get(i, j)).doubleValue();
            }
        }
        return dArray;
    }

    @Override
    public boolean equals(Object object) {
        if (object instanceof Matrix) {
            Matrix matrix = (Matrix)object;
            if (this.nrows != matrix.nrows || this.ncols != matrix.ncols) {
                return false;
            }
            for (int i = 0; i < this.nrows; ++i) {
                for (int j = 0; j < this.ncols; ++j) {
                    if (this.get(i, j).equals(matrix.get(i, j))) continue;
                    return false;
                }
            }
            return true;
        }
        return false;
    }

    public void makeImmutable() {
        this.mutable = false;
    }

    public boolean isMutable() {
        return this.mutable;
    }

    public IArithmetic get(int n, int n2) {
        if (n < 0 || n >= this.nrows) {
            throw new ArrayIndexOutOfBoundsException("first index = " + n);
        }
        if (n2 < 0 || n2 >= this.ncols) {
            throw new ArrayIndexOutOfBoundsException("second index = " + n2);
        }
        return this.data[this.ncols * n + n2];
    }

    public void set(int n, int n2, IArithmetic iArithmetic) {
        if (!this.mutable) {
            throw new IllegalArgumentException("Matrix is immutable");
        }
        if (n < 0 || n >= this.nrows) {
            throw new ArrayIndexOutOfBoundsException("first index = " + n);
        }
        if (n2 < 0 || n2 >= this.ncols) {
            throw new ArrayIndexOutOfBoundsException("second index = " + n2);
        }
        this.data[this.ncols * n + n2] = iArithmetic;
    }

    public Matrix getSubMatrix(int n, int n2, int n3, int n4) {
        Matrix matrix = new Matrix(n3, n4);
        for (int i = 0; i < n3; ++i) {
            for (int j = 0; j < n4; ++j) {
                matrix.set(i, j, this.get(n + i, n2 + j));
            }
        }
        return matrix;
    }

    public Matrix getMinor(int n, int n2) {
        int n3 = this.nrows;
        int n4 = this.ncols;
        Matrix matrix = new Matrix(n3 - 1, n4 - 1);
        int n5 = 0;
        for (int i = 0; i < n3; ++i) {
            if (i == n) continue;
            int n6 = 0;
            for (int j = 0; j < n4; ++j) {
                if (j == n2) continue;
                matrix.set(n5, n6, this.get(i, j));
                ++n6;
            }
            ++n5;
        }
        return matrix;
    }

    public void setSubMatrix(int n, int n2, Matrix matrix) {
        for (int i = 0; i < matrix.numberOfRows(); ++i) {
            for (int j = 0; j < matrix.numberOfColumns(); ++j) {
                this.set(n + i, n2 + j, matrix.get(i, j));
            }
        }
    }

    public Matrix getRow(int n) {
        Matrix matrix = new Matrix(1, this.ncols);
        for (int i = 0; i < this.ncols; ++i) {
            matrix.set(0, i, this.get(n, i));
        }
        matrix.makeImmutable();
        return matrix;
    }

    public Matrix[] getRows() {
        Matrix[] matrixArray = new Matrix[this.nrows];
        for (int i = 0; i < this.nrows; ++i) {
            matrixArray[i] = this.getRow(i);
        }
        return matrixArray;
    }

    public void setRow(int n, Matrix matrix) {
        if (matrix.numberOfRows() != 1 || matrix.numberOfColumns() != this.ncols) {
            throw new IllegalArgumentException("bad shape for row");
        }
        for (int i = 0; i < this.ncols; ++i) {
            this.set(n, i, matrix.get(0, i));
        }
    }

    public Matrix getColumn(int n) {
        Matrix matrix = new Matrix(this.nrows, 1);
        for (int i = 0; i < this.nrows; ++i) {
            matrix.set(i, 0, this.get(i, n));
        }
        matrix.makeImmutable();
        return matrix;
    }

    public void setColumn(int n, Matrix matrix) {
        if (matrix.numberOfRows() != this.nrows || matrix.numberOfColumns() != 1) {
            throw new IllegalArgumentException("bad shape for column");
        }
        for (int i = 0; i < this.nrows; ++i) {
            this.set(i, n, matrix.get(i, 0));
        }
    }

    @Override
    public IArithmetic zero() {
        Matrix matrix = new Matrix(this.nrows, this.ncols);
        for (int i = 0; i < this.nrows; ++i) {
            for (int j = 0; j < this.ncols; ++j) {
                matrix.set(i, j, this.get(i, j).zero());
            }
        }
        matrix.makeImmutable();
        return matrix;
    }

    @Override
    public IArithmetic one() {
        Matrix matrix = new Matrix(this.ncols, this.ncols);
        for (int i = 0; i < this.ncols; ++i) {
            for (int j = 0; j < this.ncols; ++j) {
                if (i == j) {
                    if (i < this.nrows) {
                        matrix.set(i, j, this.get(i, j).one());
                        continue;
                    }
                    matrix.set(i, j, Whole.ONE);
                    continue;
                }
                if (i < this.nrows) {
                    matrix.set(i, j, this.get(i, j).zero());
                    continue;
                }
                matrix.set(i, j, Whole.ZERO);
            }
        }
        matrix.makeImmutable();
        return matrix;
    }

    public static Matrix zero(int n, int n2) {
        Matrix matrix = new Matrix(n, n2);
        for (int i = 0; i < n; ++i) {
            for (int j = 0; j < n2; ++j) {
                matrix.set(i, j, Whole.ZERO);
            }
        }
        return matrix;
    }

    public static Matrix one(int n) {
        Matrix matrix = Matrix.zero(n, n);
        for (int i = 0; i < n; ++i) {
            matrix.set(i, i, Whole.ONE);
        }
        return matrix;
    }

    public boolean isScalar() {
        return false;
    }

    @Override
    public boolean isExact() {
        for (int i = 0; i < this.nrows; ++i) {
            for (int j = 0; j < this.ncols; ++j) {
                if (this.get(i, j).isExact()) continue;
                return false;
            }
        }
        return true;
    }

    public Matrix transposed() {
        Matrix matrix = new Matrix(this.ncols, this.nrows);
        for (int i = 0; i < matrix.nrows; ++i) {
            for (int j = 0; j < matrix.ncols; ++j) {
                matrix.set(i, j, this.get(j, i));
            }
        }
        matrix.makeImmutable();
        return matrix;
    }

    public Matrix symmetric() {
        int n = this.nrows;
        if (n != this.ncols) {
            throw new IllegalArgumentException("must be a square matrix");
        }
        Whole whole = new Whole(2L);
        Matrix matrix = new Matrix(n, n);
        for (int i = 0; i < n; ++i) {
            matrix.set(i, i, this.get(i, i));
            for (int j = 0; j < i; ++j) {
                IArithmetic iArithmetic = this.get(i, j).plus(this.get(j, i)).dividedBy(whole);
                matrix.set(i, j, iArithmetic);
                matrix.set(j, i, iArithmetic);
            }
        }
        matrix.makeImmutable();
        return matrix;
    }

    public Object clone() {
        Matrix matrix = new Matrix(this.nrows, this.ncols);
        for (int i = 0; i < this.nrows; ++i) {
            for (int j = 0; j < this.ncols; ++j) {
                matrix.set(i, j, this.get(i, j));
            }
        }
        matrix.makeImmutable();
        return matrix;
    }

    public Matrix mutableClone() {
        Matrix matrix = new Matrix(this.nrows, this.ncols);
        for (int i = 0; i < this.nrows; ++i) {
            for (int j = 0; j < this.ncols; ++j) {
                matrix.set(i, j, this.get(i, j));
            }
        }
        return matrix;
    }

    public Matrix dot(Matrix matrix) {
        return (Matrix)this.times(matrix.transposed());
    }

    public Matrix scaled(IArithmetic iArithmetic) {
        Matrix matrix = new Matrix(this.nrows, this.ncols);
        for (int i = 0; i < this.nrows; ++i) {
            for (int j = 0; j < this.ncols; ++j) {
                matrix.set(i, j, this.get(i, j).times(iArithmetic));
            }
        }
        matrix.makeImmutable();
        return matrix;
    }

    public Matrix rscaled(IArithmetic iArithmetic) {
        Matrix matrix = new Matrix(this.nrows, this.ncols);
        for (int i = 0; i < this.nrows; ++i) {
            for (int j = 0; j < this.ncols; ++j) {
                matrix.set(i, j, iArithmetic.times(this.get(i, j)));
            }
        }
        matrix.makeImmutable();
        return matrix;
    }

    @Override
    public IArithmetic negative() {
        Matrix matrix = new Matrix(this.nrows, this.ncols);
        for (int i = 0; i < this.nrows; ++i) {
            for (int j = 0; j < this.ncols; ++j) {
                matrix.set(i, j, this.get(i, j).negative());
            }
        }
        matrix.makeImmutable();
        return matrix;
    }

    public boolean isUnimodularIntegerMatrix() {
        for (int i = 0; i < this.numberOfRows(); ++i) {
            for (int j = 0; j < this.numberOfColumns(); ++j) {
                if (this.get(i, j) instanceof Whole) continue;
                return false;
            }
        }
        return this.determinant().norm().isOne();
    }

    public static int triangulate(Matrix matrix, Matrix matrix2, boolean bl, boolean bl2) {
        IArithmetic iArithmetic;
        int n;
        TaskController taskController = TaskController.getInstance();
        if (!matrix.isMutable()) {
            throw new IllegalArgumentException("first argument must be mutable");
        }
        if (matrix2 != null) {
            if (!matrix2.isMutable()) {
                throw new IllegalArgumentException("second argument must be mutable");
            }
            if (matrix2.nrows != matrix.nrows) {
                throw new IllegalArgumentException("shapes don't match");
            }
        }
        int n2 = 1;
        int n3 = 0;
        int n4 = 0;
        while (n3 < matrix.nrows && n4 < matrix.ncols) {
            IArithmetic iArithmetic2;
            taskController.bailOutIfCancelled();
            IArithmetic iArithmetic3 = null;
            int n5 = -1;
            for (n = n3; n < matrix.nrows; ++n) {
                iArithmetic2 = matrix.get(n, n4).norm();
                if (iArithmetic2 instanceof FloatingPoint && ((Real)iArithmetic2).doubleValue() < 1.0E-12) {
                    iArithmetic2 = new FloatingPoint(0.0);
                }
                if (iArithmetic2.isZero() || iArithmetic3 != null && !iArithmetic2.isLessThan(iArithmetic3)) continue;
                iArithmetic3 = iArithmetic2;
                n5 = n;
            }
            if (iArithmetic3 == null) {
                ++n4;
                continue;
            }
            if (n5 != n3) {
                for (n = n4; n < matrix.ncols; ++n) {
                    iArithmetic2 = matrix.get(n3, n);
                    matrix.set(n3, n, matrix.get(n5, n));
                    matrix.set(n5, n, iArithmetic2);
                }
                if (matrix2 != null) {
                    for (n = 0; n < matrix2.ncols; ++n) {
                        iArithmetic2 = matrix2.get(n3, n);
                        matrix2.set(n3, n, matrix2.get(n5, n));
                        matrix2.set(n5, n, iArithmetic2);
                    }
                }
                n2 = -n2;
            }
            if (matrix.get(n3, n4).isNegative()) {
                for (n = n4; n < matrix.ncols; ++n) {
                    matrix.set(n3, n, matrix.get(n3, n).negative());
                }
                if (matrix2 != null) {
                    for (n = 0; n < matrix2.ncols; ++n) {
                        matrix2.set(n3, n, matrix2.get(n3, n).negative());
                    }
                }
                n2 = -n2;
            }
            n = 1;
            for (int i = n3 + 1; i < matrix.nrows; ++i) {
                IArithmetic iArithmetic4;
                IArithmetic iArithmetic5;
                int n6;
                if (matrix.get(i, n4).isZero()) continue;
                n = 0;
                iArithmetic = bl ? ((Real)matrix.get(i, n4)).div(matrix.get(n3, n4)) : matrix.get(i, n4).dividedBy(matrix.get(n3, n4));
                for (n6 = n4; n6 < matrix.ncols; ++n6) {
                    iArithmetic5 = matrix.get(n3, n6);
                    iArithmetic4 = matrix.get(i, n6);
                    matrix.set(i, n6, iArithmetic4.minus(iArithmetic.times(iArithmetic5)));
                }
                if (!bl) {
                    matrix.set(i, n4, Whole.ZERO);
                }
                if (matrix2 == null) continue;
                for (n6 = 0; n6 < matrix2.ncols; ++n6) {
                    iArithmetic5 = matrix2.get(n3, n6);
                    iArithmetic4 = matrix2.get(i, n6);
                    matrix2.set(i, n6, iArithmetic4.minus(iArithmetic.times(iArithmetic5)));
                }
            }
            if (n == 0) continue;
            ++n3;
            ++n4;
        }
        if (bl2) {
            n4 = 0;
            for (n3 = 0; n3 < matrix.nrows; ++n3) {
                while (n4 < matrix.ncols && matrix.get(n3, n4).isZero()) {
                    ++n4;
                }
                if (n4 >= matrix.ncols) break;
                for (int i = 0; i < n3; ++i) {
                    IArithmetic iArithmetic6;
                    if (matrix.get(i, n4).isZero()) continue;
                    IArithmetic iArithmetic7 = bl ? ((Real)matrix.get(i, n4)).div(matrix.get(n3, n4)) : matrix.get(i, n4).dividedBy(matrix.get(n3, n4));
                    for (n = n4; n < matrix.ncols; ++n) {
                        iArithmetic6 = matrix.get(n3, n);
                        iArithmetic = matrix.get(i, n);
                        matrix.set(i, n, iArithmetic.minus(iArithmetic7.times(iArithmetic6)));
                    }
                    if (!bl) {
                        matrix.set(i, n4, Whole.ZERO);
                    }
                    if (matrix2 == null) continue;
                    for (n = 0; n < matrix2.ncols; ++n) {
                        iArithmetic6 = matrix2.get(n3, n);
                        iArithmetic = matrix2.get(i, n);
                        matrix2.set(i, n, iArithmetic.minus(iArithmetic7.times(iArithmetic6)));
                    }
                }
            }
        }
        return n2;
    }

    public int rank() {
        Matrix matrix = this.mutableClone();
        Matrix.triangulate(matrix, null, false, false);
        int n = 0;
        for (int i = 0; i < this.numberOfColumns(); ++i) {
            if (n >= this.numberOfRows() || matrix.get(n, i).isZero()) continue;
            ++n;
        }
        return n;
    }

    public IArithmetic determinant() {
        if (this.numberOfRows() != this.numberOfColumns()) {
            throw new IllegalArgumentException("only defined for square matrices");
        }
        if (this.numberOfRows() == 0 || this.numberOfColumns() == 0) {
            return Whole.ZERO;
        }
        Matrix matrix = this.mutableClone();
        int n = Matrix.triangulate(matrix, null, false, false);
        IArithmetic iArithmetic = new Whole(n);
        int n2 = Math.min(this.numberOfRows(), this.numberOfColumns());
        for (int i = 0; i < n2; ++i) {
            iArithmetic = iArithmetic.times(matrix.get(i, i));
        }
        return iArithmetic;
    }

    public static Matrix solve(Matrix matrix, Matrix matrix2) {
        if (matrix == null || matrix2 == null) {
            throw new IllegalArgumentException("null argument");
        }
        if (matrix.numberOfRows() != matrix2.numberOfRows()) {
            throw new IllegalArgumentException("matrix shapes don't match");
        }
        int n = matrix.numberOfRows();
        int n2 = matrix.numberOfColumns();
        int n3 = matrix2.numberOfColumns();
        Matrix matrix3 = matrix.mutableClone();
        Matrix matrix4 = matrix2.mutableClone();
        Matrix.triangulate(matrix3, matrix4, false, false);
        Matrix matrix5 = new Matrix(n2, n3);
        int n4 = Math.min(n, n2);
        for (int i = 0; i < n3; ++i) {
            for (int j = n4 - 1; j >= 0; --j) {
                IArithmetic iArithmetic = null;
                for (int k = n4 - 1; k > j; --k) {
                    IArithmetic iArithmetic2 = matrix3.get(j, k).times(matrix5.get(k, i));
                    iArithmetic = iArithmetic == null ? iArithmetic2 : iArithmetic.plus(iArithmetic2);
                }
                IArithmetic iArithmetic3 = iArithmetic == null ? matrix4.get(j, i) : matrix4.get(j, i).minus(iArithmetic);
                if (iArithmetic3.isZero()) {
                    matrix5.set(j, i, iArithmetic3);
                    continue;
                }
                if (matrix3.get(j, j).isZero()) {
                    return null;
                }
                matrix5.set(j, i, iArithmetic3.dividedBy(matrix3.get(j, j)));
            }
        }
        return matrix5;
    }

    @Override
    public IArithmetic inverse() {
        if (this.numberOfRows() == this.numberOfColumns()) {
            Matrix matrix = Matrix.solve(this, (Matrix)this.one());
            if (matrix == null) {
                throw new ArithmeticException("matrix has no inverse");
            }
            return matrix;
        }
        throw new IllegalArgumentException("mmust be a square matrix");
    }

    @Override
    public IArithmetic plus(Object object) {
        if (object instanceof Matrix) {
            Matrix matrix = (Matrix)object;
            if (this.nrows != matrix.nrows || this.ncols != matrix.ncols) {
                throw new IllegalArgumentException();
            }
            Matrix matrix2 = new Matrix(this.nrows, this.ncols);
            for (int i = 0; i < this.nrows; ++i) {
                for (int j = 0; j < this.ncols; ++j) {
                    matrix2.set(i, j, this.get(i, j).plus(matrix.get(i, j)));
                }
            }
            matrix2.makeImmutable();
            return matrix2;
        }
        if (object instanceof IArithmetic) {
            return ((IArithmetic)object).rplus(this);
        }
        throw new IllegalArgumentException();
    }

    @Override
    public IArithmetic rplus(IArithmetic iArithmetic) {
        if (iArithmetic instanceof Matrix) {
            return ((Matrix)iArithmetic).plus(this);
        }
        throw new IllegalArgumentException();
    }

    @Override
    public IArithmetic minus(Object object) {
        if (object instanceof Matrix) {
            Matrix matrix = (Matrix)object;
            if (this.nrows != matrix.nrows || this.ncols != matrix.ncols) {
                throw new IllegalArgumentException("shapes don't match");
            }
            Matrix matrix2 = new Matrix(this.nrows, this.ncols);
            for (int i = 0; i < this.nrows; ++i) {
                for (int j = 0; j < this.ncols; ++j) {
                    IArithmetic iArithmetic = this.get(i, j).minus(matrix.get(i, j));
                    matrix2.set(i, j, iArithmetic);
                }
            }
            matrix2.makeImmutable();
            return matrix2;
        }
        if (object instanceof IArithmetic) {
            return ((IArithmetic)object).rminus(this);
        }
        throw new IllegalArgumentException();
    }

    @Override
    public IArithmetic rminus(IArithmetic iArithmetic) {
        if (iArithmetic instanceof Matrix) {
            return ((Matrix)iArithmetic).minus(this);
        }
        throw new IllegalArgumentException();
    }

    @Override
    public IArithmetic times(Object object) {
        if (object instanceof Matrix) {
            Matrix matrix = (Matrix)object;
            if (this.ncols != matrix.nrows) {
                throw new IllegalArgumentException("shapes don't match");
            }
            Matrix matrix2 = new Matrix(this.nrows, matrix.ncols);
            for (int i = 0; i < this.nrows; ++i) {
                for (int j = 0; j < matrix.ncols; ++j) {
                    IArithmetic iArithmetic = this.get(i, 0).times(matrix.get(0, j));
                    for (int k = 1; k < this.ncols; ++k) {
                        iArithmetic = iArithmetic.plus(this.get(i, k).times(matrix.get(k, j)));
                    }
                    matrix2.set(i, j, iArithmetic);
                }
            }
            matrix2.makeImmutable();
            return matrix2;
        }
        if (object instanceof IArithmetic) {
            return this.scaled((IArithmetic)object);
        }
        throw new IllegalArgumentException();
    }

    @Override
    public IArithmetic rtimes(IArithmetic iArithmetic) {
        if (iArithmetic instanceof Matrix) {
            return ((Matrix)iArithmetic).times(this);
        }
        if (iArithmetic instanceof Complex) {
            return this.rscaled(iArithmetic);
        }
        throw new UnsupportedOperationException("operation not supported");
    }

    @Override
    public IArithmetic norm() {
        IArithmetic iArithmetic = this.get(0, 0).zero();
        for (int i = 0; i < this.nrows; ++i) {
            for (int j = 0; j < this.ncols; ++j) {
                iArithmetic = iArithmetic.plus(this.get(i, j).norm());
            }
        }
        return iArithmetic;
    }

    @Override
    public String toString() {
        StringBuffer stringBuffer = new StringBuffer(1000);
        stringBuffer.append("Matrix([");
        for (int i = 0; i < this.nrows; ++i) {
            if (i > 0) {
                stringBuffer.append(",");
            }
            stringBuffer.append("[");
            for (int j = 0; j < this.ncols; ++j) {
                if (j > 0) {
                    stringBuffer.append(",");
                }
                if (this.get(i, j) == null) continue;
                stringBuffer.append(this.get(i, j).toString());
            }
            stringBuffer.append("]");
        }
        stringBuffer.append("])");
        return stringBuffer.toString();
    }

    @Override
    public int hashCode() {
        int n = 31 * this.nrows + this.ncols;
        for (int i = 0; i < this.nrows * this.ncols; ++i) {
            n = 31 * n + this.data[i].hashCode();
        }
        return n;
    }

    @Override
    public int compareTo(Object object) {
        throw new ArithmeticException("matrices are not ordered");
    }

    @Override
    public IArithmetic floor() {
        throw new ArithmeticException("matrices are not ordered");
    }

    public IArithmetic __getitem__(int[] nArray) {
        return this.get(nArray[0], nArray[1]);
    }

    public void __setitem__(int[] nArray, IArithmetic iArithmetic) {
        this.set(nArray[0], nArray[1], iArithmetic);
    }

    public void __setitem__(int[] nArray, long l) {
        this.set(nArray[0], nArray[1], new Whole(l));
    }

    public void __setitem__(int[] nArray, double d) {
        this.set(nArray[0], nArray[1], new FloatingPoint(d));
    }
}

