/*
 * Decompiled with CFR 0.152.
 */
package org.gavrog.box.gui;

import buoy.event.MouseDraggedEvent;
import buoy.event.MousePressedEvent;
import buoy.event.MouseReleasedEvent;
import buoy.event.RepaintEvent;
import buoy.event.ValueChangedEvent;
import buoy.event.WidgetMouseEvent;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Graphics2D;
import org.gavrog.box.gui.SliderBase;

public class Slider
extends SliderBase {
    private double value;
    private double oldValue;

    public Slider(double value, double min, double max) {
        this.min = min;
        this.max = Math.max(min, max);
        this.addEventLink(MousePressedEvent.class, (Object)this, "mousePressed");
        this.addEventLink(MouseReleasedEvent.class, (Object)this, "mouseReleased");
        this.addEventLink(MouseDraggedEvent.class, (Object)this, "mouseDragged");
        this.addEventLink(RepaintEvent.class, (Object)this, "paint");
        this.setValue(value);
    }

    public Dimension getPreferredSize() {
        int width = this.showValue ? 210 : 180;
        int height = this.showTicks ? 14 : 11;
        return new Dimension(width, height);
    }

    public void paint(RepaintEvent ev) {
        double base;
        Graphics2D g = ev.getGraphics();
        if (g == null) {
            return;
        }
        g.setStroke(new BasicStroke(1.0f));
        this.clearCanvas(g);
        this.drawGuide(g);
        this.drawTicks(g);
        if (this.showValue) {
            this.showValue(g);
        }
        if (this.value < (base = this.max < 0.0 ? this.max : (this.min < 0.0 ? 0.0 : this.min))) {
            this.fillGuide(g, this.value, base);
        } else {
            this.fillGuide(g, base, this.value);
        }
        this.drawMarker(g, this.value);
    }

    protected void showValue(Graphics2D g) {
        Font f = new Font("Verdana", 0, 10);
        g.setFont(f);
        g.setColor(new Color(0.0f, 0.4f, 0.6f));
        String s = this.value == (double)((int)this.value) ? String.format("%d", (int)this.value) : String.format("%.2f", this.value);
        g.drawString(s, this.sliderWidth() + 8, 10);
    }

    protected int sliderWidth() {
        return this.getBounds().width - 7 - (this.showValue ? 30 : 0);
    }

    protected void mousePressed(MousePressedEvent ev) {
        this.oldValue = this.value;
        this.mouseDragged(ev);
    }

    protected void mouseDragged(WidgetMouseEvent ev) {
        this.setValue(this.xToValue(ev.getPoint().x));
    }

    protected void mouseReleased(MouseReleasedEvent ev) {
        if (this.value != this.oldValue) {
            this.dispatchEvent(new ValueChangedEvent(this));
        }
    }

    public double getValue() {
        return this.value;
    }

    public void setValue(double newValue) {
        this.value = newValue;
        if (this.snapInterval > 0.0) {
            this.value = (double)Math.round((this.value - this.min) / this.snapInterval) * this.snapInterval + this.min;
        }
        if (this.value < this.min) {
            this.value = this.min;
        }
        if (this.value > this.max) {
            this.value = this.max;
        }
        this.repaint();
    }
}

