/*
 * Decompiled with CFR 0.152.
 */
package org.gavrog.box.gui;

import java.awt.Color;
import java.lang.reflect.Field;
import java.util.HashMap;
import java.util.Map;

public class ColorWrapper
extends Color {
    private static final long serialVersionUID = 7656257584537188197L;
    private static final Map<String, Color> name2color = new HashMap<String, Color>();
    private static final Map<Color, String> color2name = new HashMap<Color, String>();

    public ColorWrapper(Color color) {
        super(color.getRGB());
    }

    public ColorWrapper(String string) {
        super(ColorWrapper.parseColor(string));
    }

    public static int parseColor(String string) {
        Color color = name2color.get(string = string.trim());
        if (color != null) {
            return color.getRGB();
        }
        int n = 0;
        try {
            n = string.startsWith("#") ? Integer.parseInt(string.substring(1), 16) : (string.startsWith("0x") ? Integer.parseInt(string.substring(2), 16) : (string.startsWith("0") ? Integer.parseInt(string.substring(1), 8) : Integer.parseInt(string)));
        }
        catch (NumberFormatException numberFormatException) {
            // empty catch block
        }
        return n;
    }

    @Override
    public String toString() {
        String string = color2name.get(this);
        if (string != null) {
            return string;
        }
        return String.valueOf(this.getRGB());
    }

    static {
        Field[] fieldArray = Color.class.getDeclaredFields();
        for (int i = 0; i < fieldArray.length; ++i) {
            try {
                Field field = fieldArray[i];
                if (!field.getType().isAssignableFrom(Color.class)) continue;
                Color color = (Color)fieldArray[i].get(null);
                String string = fieldArray[i].getName();
                name2color.put(string, color);
                if (color2name.containsKey(color)) continue;
                color2name.put(color, string);
                continue;
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }
}

