/*
 * Decompiled with CFR 0.152.
 */
package org.gavrog.box.collections;

import java.io.BufferedWriter;
import java.io.IOException;
import java.io.StringWriter;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.NoSuchElementException;
import junit.framework.Assert;
import junit.framework.TestCase;
import org.gavrog.box.collections.IteratorAdapter;
import org.gavrog.box.collections.Iterators;
import org.gavrog.box.collections.Pair;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TestIterators
extends TestCase {
    private Integer x;
    private String[] letters;
    private Iterator<Integer> singleton;
    private Iterator<Integer> range;
    private Iterator<Integer> emptyRange;
    private Iterator<Pair<Integer, Integer>> product;
    private Iterator<List<String>> perms;

    protected void setUp() throws Exception {
        super.setUp();
        this.x = 27;
        this.letters = new String[]{"a", "b", "c", "d"};
        this.singleton = Iterators.singleton(this.x);
        this.range = Iterators.range(3, 7);
        this.emptyRange = Iterators.range(3, 3);
        this.product = Iterators.cantorProduct(Iterators.range(1, 3), Iterators.range(4, 7));
        this.perms = Iterators.permutations(this.letters);
    }

    protected void tearDown() throws Exception {
        super.tearDown();
        this.x = null;
        this.letters = null;
        this.singleton = null;
        this.range = null;
        this.emptyRange = null;
        this.product = null;
        this.perms = null;
    }

    public void testSingleton() {
        Assert.assertTrue((boolean)this.singleton.hasNext());
        Assert.assertSame((Object)this.singleton.next(), (Object)this.x);
        Assert.assertFalse((boolean)this.singleton.hasNext());
        try {
            this.singleton.next();
            TestIterators.fail((String)"Should raise a NoSuchElementException");
        }
        catch (NoSuchElementException noSuchElementException) {
            // empty catch block
        }
    }

    public void testRange() {
        Assert.assertTrue((boolean)this.range.hasNext());
        Assert.assertEquals((Object)this.range.next(), (Object)new Integer(3));
        Assert.assertTrue((boolean)this.range.hasNext());
        Assert.assertEquals((Object)this.range.next(), (Object)new Integer(4));
        Assert.assertTrue((boolean)this.range.hasNext());
        Assert.assertEquals((Object)this.range.next(), (Object)new Integer(5));
        Assert.assertTrue((boolean)this.range.hasNext());
        Assert.assertEquals((Object)this.range.next(), (Object)new Integer(6));
        Assert.assertFalse((boolean)this.range.hasNext());
        try {
            this.range.next();
            TestIterators.fail((String)"Should raise a NoSuchElementException");
        }
        catch (NoSuchElementException noSuchElementException) {
            // empty catch block
        }
    }

    public void testEmptyRange() {
        Assert.assertFalse((boolean)this.emptyRange.hasNext());
        try {
            this.emptyRange.next();
            TestIterators.fail((String)"Should raise a NoSuchElementException");
        }
        catch (NoSuchElementException noSuchElementException) {
            // empty catch block
        }
    }

    private Pair<Integer, Integer> intPair(int a, int b) {
        return new Pair<Integer, Integer>(a, b);
    }

    public void testProduct() {
        Assert.assertTrue((boolean)this.product.hasNext());
        Assert.assertEquals(this.intPair(1, 4), this.product.next());
        Assert.assertTrue((boolean)this.product.hasNext());
        Assert.assertEquals(this.intPair(1, 5), this.product.next());
        Assert.assertTrue((boolean)this.product.hasNext());
        Assert.assertEquals(this.intPair(2, 4), this.product.next());
        Assert.assertTrue((boolean)this.product.hasNext());
        Assert.assertEquals(this.intPair(1, 6), this.product.next());
        Assert.assertTrue((boolean)this.product.hasNext());
        Assert.assertEquals(this.intPair(2, 5), this.product.next());
        Assert.assertTrue((boolean)this.product.hasNext());
        Assert.assertEquals(this.intPair(2, 6), this.product.next());
        Assert.assertFalse((boolean)this.product.hasNext());
        try {
            this.product.next();
            TestIterators.fail((String)"Should raise a NoSuchElementException");
        }
        catch (NoSuchElementException noSuchElementException) {
            // empty catch block
        }
    }

    public void testPermutations() {
        HashSet<List<String>> seen = new HashSet<List<String>>();
        Assert.assertTrue((boolean)this.perms.hasNext());
        List<String> first = this.perms.next();
        Assert.assertEquals(Arrays.asList(this.letters), first);
        seen.add(first);
        Assert.assertTrue((boolean)seen.contains(first));
        int i = 1;
        while (i < 24) {
            List<String> a = this.perms.next();
            Assert.assertFalse((boolean)seen.contains(a));
            seen.add(a);
            Assert.assertTrue((boolean)seen.contains(a));
            ++i;
        }
        Assert.assertFalse((boolean)this.perms.hasNext());
        try {
            this.perms.next();
            TestIterators.fail((String)"Should raise a NoSuchElementException");
        }
        catch (NoSuchElementException noSuchElementException) {
            // empty catch block
        }
    }

    public void testCombinations() {
        IteratorAdapter<List<String>> combinations = Iterators.combinations(this.letters, 3);
        HashSet<List> seen = new HashSet<List>();
        while (combinations.hasNext()) {
            List a = (List)combinations.next();
            Assert.assertFalse((boolean)seen.contains(a));
            seen.add(a);
            Assert.assertTrue((boolean)seen.contains(a));
        }
        TestIterators.assertEquals((int)24, (int)seen.size());
        Assert.assertFalse((boolean)combinations.hasNext());
        try {
            combinations.next();
            TestIterators.fail((String)"Should raise a NoSuchElementException");
        }
        catch (NoSuchElementException noSuchElementException) {
            // empty catch block
        }
        TestIterators.assertFalse((boolean)seen.contains(Arrays.asList("a", "a", "c")));
        TestIterators.assertFalse((boolean)seen.contains(Arrays.asList("a", "d", "d")));
        TestIterators.assertTrue((boolean)seen.contains(Arrays.asList("a", "d", "c")));
        TestIterators.assertTrue((boolean)seen.contains(Arrays.asList("a", "c", "d")));
    }

    public void testSelections() {
        IteratorAdapter<List<String>> selections = Iterators.selections(this.letters, 3);
        HashSet<List> seen = new HashSet<List>();
        while (selections.hasNext()) {
            List a = (List)selections.next();
            Assert.assertFalse((boolean)seen.contains(a));
            seen.add(a);
            Assert.assertTrue((boolean)seen.contains(a));
        }
        TestIterators.assertEquals((int)20, (int)seen.size());
        Assert.assertFalse((boolean)selections.hasNext());
        try {
            selections.next();
            TestIterators.fail((String)"Should raise a NoSuchElementException");
        }
        catch (NoSuchElementException noSuchElementException) {
            // empty catch block
        }
        TestIterators.assertTrue((boolean)seen.contains(Arrays.asList("a", "a", "c")));
        TestIterators.assertTrue((boolean)seen.contains(Arrays.asList("a", "d", "d")));
        TestIterators.assertFalse((boolean)seen.contains(Arrays.asList("a", "d", "c")));
    }

    public void testEqual() {
        Assert.assertTrue((boolean)Iterators.equal(this.range, Iterators.range(3, 7)));
        Assert.assertFalse((boolean)Iterators.equal(this.range, Iterators.range(4, 8)));
        Assert.assertFalse((boolean)Iterators.equal(this.range, Iterators.range(3, 8)));
    }

    public void testContains() {
        TestIterators.assertTrue((boolean)Iterators.contains(this.range, new Integer(3)));
        TestIterators.assertTrue((boolean)Iterators.contains(this.range, new Integer(6)));
        TestIterators.assertFalse((boolean)Iterators.contains(this.range, new Integer(7)));
    }

    public void testWrite() {
        int count;
        StringWriter out = new StringWriter(100);
        try {
            count = Iterators.write(new BufferedWriter(out), this.range, ", ");
        }
        catch (IOException ex) {
            throw new RuntimeException(ex);
        }
        TestIterators.assertEquals((int)4, (int)count);
        TestIterators.assertEquals((String)"3, 4, 5, 6, ", (String)out.toString());
    }
}

