/*
 * Decompiled with CFR 0.152.
 */
package org.gavrog.apps.systre;

import buoy.event.EventSource;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.PrintStream;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.io.Writer;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import org.gavrog.apps.systre.SystreException;
import org.gavrog.box.collections.Iterators;
import org.gavrog.box.collections.Pair;
import org.gavrog.box.gui.Config;
import org.gavrog.box.simple.DataFormatException;
import org.gavrog.box.simple.Misc;
import org.gavrog.box.simple.Strings;
import org.gavrog.jane.numbers.FloatingPoint;
import org.gavrog.jane.numbers.IArithmetic;
import org.gavrog.jane.numbers.Real;
import org.gavrog.jane.numbers.Whole;
import org.gavrog.joss.geometry.CoordinateChange;
import org.gavrog.joss.geometry.Operator;
import org.gavrog.joss.geometry.Point;
import org.gavrog.joss.geometry.SpaceGroup;
import org.gavrog.joss.geometry.SpaceGroupCatalogue;
import org.gavrog.joss.geometry.SpaceGroupFinder;
import org.gavrog.joss.geometry.Vector;
import org.gavrog.joss.pgraphs.basic.INode;
import org.gavrog.joss.pgraphs.basic.Morphism;
import org.gavrog.joss.pgraphs.basic.PeriodicGraph;
import org.gavrog.joss.pgraphs.embed.Embedder;
import org.gavrog.joss.pgraphs.embed.ProcessedNet;
import org.gavrog.joss.pgraphs.io.Archive;
import org.gavrog.joss.pgraphs.io.Net;
import org.gavrog.joss.pgraphs.io.NetParser;

public class SystreCmdline
extends EventSource {
    static final boolean DEBUG = false;
    ProcessedNet lastStructure = null;
    private PrintStream out = System.out;
    private final Archive builtinArchive;
    private final Map<String, Archive> name2archive = new HashMap<String, Archive>();
    private final Archive internalArchive = new Archive("1.0");
    private boolean computeEmbedding = true;
    private boolean useOriginalEmbedding = false;
    private boolean relaxPositions = true;
    private int relaxPasses = 3;
    private int relaxSteps = 10000;
    private boolean skipOutputTest = false;
    private boolean computePointSymbols = false;
    private boolean useBuiltinArchive = true;
    private boolean outputFullCell = false;
    private boolean outputSystreKey = false;
    private boolean duplicateIsError = false;
    private BufferedWriter outputArchive = null;
    private String lastFileNameWithoutExtension;
    private boolean cancelled = false;
    private String lastStatus;

    public SystreCmdline() {
        this.builtinArchive = new Archive("1.0");
        Package package_ = this.getClass().getPackage();
        String string = package_.getName().replaceAll("\\.", "/");
        String string2 = string + "/rcsr.arc";
        InputStream inputStream = ClassLoader.getSystemResourceAsStream(string2);
        this.builtinArchive.addAll(new InputStreamReader(inputStream));
    }

    public void processArchive(String string) {
        String string2 = string;
        if (this.name2archive.containsKey(string2)) {
            this.out.println("!!! WARNING (USAGE) - Archive \"" + string2 + "\" was given twice.");
        } else {
            Archive archive = new Archive("1.0");
            try {
                archive.addAll(new FileReader(string));
            }
            catch (FileNotFoundException fileNotFoundException) {
                this.out.println("!!! ERROR (FILE) - Could not find file \"" + string + "\".");
                return;
            }
            catch (Exception exception) {
                this.out.println("!!! ERROR (FILE) - " + exception.getMessage() + " - ignoring archive \"" + string + "\".");
                return;
            }
            this.name2archive.put(string2, archive);
            int n = archive.size();
            this.out.println("Read " + n + " entr" + (n == 1 ? "y" : "ies") + " from archive \"" + string2 + "\"");
            this.out.println();
        }
    }

    public void processGraph(Net net, String string, boolean bl) {
        this.status("Initializing...");
        this.cancelled = false;
        this.setLastStructure(null);
        PeriodicGraph periodicGraph = net;
        int n = periodicGraph.getDimension();
        String string2 = net.getGivenGroup();
        this.out.println("   Input structure described as " + n + "-periodic.");
        this.out.println("   Given space group is " + string2 + ".");
        this.out.flush();
        int n2 = periodicGraph.numberOfNodes();
        int n3 = periodicGraph.numberOfEdges();
        this.out.println("   " + n2 + " node" + (n2 > 1 ? "s" : "") + " and " + n3 + " edge" + (n3 > 1 ? "s" : "") + " in repeat unit as given.");
        this.out.flush();
        if (!periodicGraph.isConnected()) {
            this.processDisconnectedGraph(net, string);
            return;
        }
        this.status("Computing barycentric placement...");
        Map<INode, Point> map = periodicGraph.barycentricPlacement();
        if (!periodicGraph.isBarycentric(map)) {
            throw new RuntimeException("Incorrect barycentric placement.");
        }
        this.out.println();
        this.out.flush();
        this.quitIfCancelled();
        if (!periodicGraph.isLocallyStable()) {
            throw new SystreException(SystreException.STRUCTURE, "Structure has collisions between next-nearest neighbors. Systre does not currently support such structures.");
        }
        if (periodicGraph.isLadder()) {
            throw new SystreException(SystreException.STRUCTURE, "Structure is non-crystallographic (a 'ladder')");
        }
        if (periodicGraph.hasSecondOrderCollisions()) {
            throw new SystreException(SystreException.STRUCTURE, "Structure has second-order collisions. Systre does not currently support such structures.");
        }
        if (!periodicGraph.isStable()) {
            this.out.println("Structure has collisions.");
            this.out.println();
        }
        this.quitIfCancelled();
        this.status("Computing ideal repeat unit...");
        Morphism morphism = periodicGraph.minimalImageMap();
        periodicGraph = morphism.getImageGraph();
        this.showRepeatUnit(periodicGraph, n2, n3);
        this.quitIfCancelled();
        this.status("Computing ideal symmetry group...");
        List<Operator> list = periodicGraph.symmetryOperators();
        this.showSymmetryOperators(periodicGraph, list);
        this.quitIfCancelled();
        this.status("Mapping node names...");
        Map<INode, String> map2 = this.nodeNameMapping(periodicGraph, morphism);
        this.quitIfCancelled();
        this.status("Computing coordination sequences...");
        this.showCoordinationSequences(periodicGraph, (Net)morphism.getSourceGraph(), map2);
        this.quitIfCancelled();
        if (this.getComputePointSymbols() && periodicGraph.getDimension() >= 3) {
            this.status("Computing Wells point symbols...");
            this.showPointSymbols(periodicGraph, map2);
            this.quitIfCancelled();
        }
        this.status("Determining and verifying the space group...");
        SpaceGroupFinder spaceGroupFinder = new SpaceGroupFinder(new SpaceGroup(n, list));
        this.showSpaceGroup(n, string2, list, spaceGroupFinder);
        this.quitIfCancelled();
        this.status("Computing the unique invariant (a.k.a. Systre key) for this net...");
        String string3 = periodicGraph.getSystreKey();
        if (this.getOutputSystreKey()) {
            this.out.println("   Systre key: \"" + string3 + "\"");
        }
        this.status("Looking for isomorphic nets...");
        int n4 = this.lookupGraphAndShowMatches(string3);
        if (n4 == 0) {
            this.status("Storing the Systre key for this net...");
            this.doStoreGraph(periodicGraph, string3, string == null ? "nameless" : string);
        }
        this.out.flush();
        this.quitIfCancelled();
        if (this.getComputeEmbedding()) {
            if (this.getUseOriginalEmbedding() && periodicGraph.nodes().hasNext() && net.getNodeInfo(periodicGraph.nodes().next(), NetParser.POSITION) != null) {
                HashMap<INode, Point> hashMap = new HashMap<INode, Point>();
                Point point = (Point)net.getNodeInfo(periodicGraph.nodes().next(), NetParser.POSITION);
                Vector vector = new Vector(point.getCoordinates());
                for (INode iNode : periodicGraph.nodes()) {
                    hashMap.put(iNode, (Point)((Point)net.getNodeInfo(iNode, NetParser.POSITION)).minus(vector));
                }
                this.embedGraph(periodicGraph, string, map2, spaceGroupFinder, hashMap, false, "adjusted");
            } else {
                this.embedGraph(periodicGraph, string, map2, spaceGroupFinder, null, true, "barycentric");
            }
        } else {
            this.setLastStructure(new ProcessedNet(periodicGraph, string, map2, spaceGroupFinder, null));
        }
    }

    private int lookupGraphAndShowMatches(String string) {
        int n = 0;
        Archive.Entry entry = null;
        if (this.useBuiltinArchive && (entry = this.builtinArchive.getByKey(string)) != null) {
            ++n;
            this.out.println("   Structure was identified with RCSR symbol:");
            this.writeEntry(this.out, entry);
            this.out.println();
        }
        for (String string2 : this.name2archive.keySet()) {
            Archive archive = this.name2archive.get(string2);
            entry = archive.getByKey(string);
            if (entry == null) continue;
            ++n;
            this.out.println("   Structure was found in archive \"" + string2 + "\":");
            this.writeEntry(this.out, entry);
            this.out.println();
        }
        entry = this.internalArchive.getByKey(string);
        if (entry != null) {
            if (this.duplicateIsError) {
                String string3 = "Duplicates structure " + Strings.parsable(entry.getName(), true);
                throw new SystreException(SystreException.INPUT, string3);
            }
            ++n;
            this.out.println("   Structure already seen in this run.");
            this.writeEntry(this.out, entry);
            this.out.println();
        }
        return n;
    }

    private void doStoreGraph(PeriodicGraph periodicGraph, String string, String string2) {
        this.out.println("   Structure is new for this run.");
        this.out.println();
        if (this.internalArchive.get(string) != null) {
            this.out.println("!!! WARNING (ARCHIVE) - Overwriting previous isomorphic net.");
            this.out.println();
        }
        if (this.internalArchive.get(string2) != null) {
            this.out.println("!!! WARNING (ARCHIVE) - Overwriting previous net with the same name");
            this.out.println();
        }
        Archive.Entry entry = this.internalArchive.add(periodicGraph, string2);
        if (this.outputArchive != null) {
            try {
                this.outputArchive.write(entry.toString());
                this.outputArchive.write("\n");
                this.outputArchive.flush();
            }
            catch (IOException iOException) {
                throw new SystreException(SystreException.FILE, "Could not write to archive");
            }
        }
    }

    private void showRepeatUnit(PeriodicGraph periodicGraph, int n, int n2) {
        int n3 = n / periodicGraph.numberOfNodes();
        if (n3 > 1) {
            this.out.println("   Ideal repeat unit smaller than given (" + periodicGraph.numberOfEdges() + " vs " + n2 + " edges).");
        } else {
            this.out.println("   Given repeat unit is accurate.");
        }
    }

    private void showSymmetryOperators(PeriodicGraph periodicGraph, List<Operator> list) {
        this.out.println("   Point group has " + list.size() + " elements.");
        this.out.flush();
        int n = Iterators.size(periodicGraph.nodeOrbits());
        this.out.println("   " + n + " kind" + (n > 1 ? "s" : "") + " of node.");
        this.out.println();
        this.out.flush();
    }

    private void showSpaceGroup(int n, String string, List<Operator> list, SpaceGroupFinder spaceGroupFinder) {
        String string2;
        String string3 = spaceGroupFinder.getExtendedGroupName();
        CoordinateChange coordinateChange = spaceGroupFinder.getToStd();
        String string4 = spaceGroupFinder.getGroupName();
        this.out.println("   Ideal space group is " + string4 + ".");
        String string5 = SpaceGroupCatalogue.normalizedName(string);
        if (!string5.equals(string4)) {
            this.out.println("   Ideal group or setting differs from given (" + string4 + " vs " + string5 + ").");
        }
        if ("1".equals(string2 = spaceGroupFinder.getExtension())) {
            this.out.println("     (using first origin choice)");
        } else if ("2".equals(string2)) {
            this.out.println("     (using second origin choice)");
        } else if ("H".equals(string2)) {
            this.out.println("     (using hexagonal setting)");
        } else if ("R".equals(string2)) {
            this.out.println("     (using rhombohedral setting)");
        }
        this.out.println();
        this.out.flush();
        CoordinateChange coordinateChange2 = SpaceGroupCatalogue.transform(n, string3);
        if (!coordinateChange2.isOne()) {
            throw new RuntimeException("Produced non-conventional space group setting.");
        }
        Set<Operator> set = new SpaceGroup(n, string3).primitiveOperators();
        HashSet<Operator> hashSet = new HashSet<Operator>();
        hashSet.addAll(list);
        for (int i = 0; i < n; ++i) {
            hashSet.add(new Operator(Vector.unit(n, i)));
        }
        Set<Operator> set2 = new SpaceGroup(n, coordinateChange.applyTo(hashSet)).primitiveOperators();
        if (!set2.equals(set)) {
            this.out.println("Problem with space group operators - should be:");
            for (Operator operator : set) {
                this.out.println(operator);
            }
            this.out.println("but was:");
            for (Operator operator : coordinateChange.applyTo(hashSet)) {
                this.out.println(operator);
            }
            throw new RuntimeException("Spacegroup finder messed up operators.");
        }
    }

    private Map<INode, String> nodeNameMapping(PeriodicGraph periodicGraph, Morphism morphism) {
        Object object;
        String string;
        Object object2;
        Object object3;
        Object object4;
        HashMap<INode, Object> hashMap = new HashMap<INode, Object>();
        Object object5 = periodicGraph.nodeOrbits();
        while (object5.hasNext()) {
            object4 = object5.next();
            object3 = object4.iterator();
            while (object3.hasNext()) {
                object2 = object3.next();
                hashMap.put((INode)object2, object4);
            }
        }
        object5 = new HashMap();
        object4 = new HashMap();
        object3 = new HashMap();
        object2 = new LinkedHashSet();
        Net net = (Net)morphism.getSourceGraph();
        for (INode object6 : net.nodes()) {
            string = net.getNodeName(object6);
            object = morphism.getImage(object6);
            Set set = (Set)hashMap.get(object);
            if (object5.containsKey(set) && !string.equals(object5.get(set))) {
                object2.add(new Pair(string, object5.get(set)));
            } else {
                object5.put(set, string);
                Integer n = (Integer)net.getNodeInfo(object6, NetParser.CONNECTIVITY);
                if (n != null && n != 0 && n.intValue() != object6.degree()) {
                    String string2 = "Node " + object6 + " has connectivity " + object6.degree() + ", where " + n + " was expected";
                    throw new SystreException(SystreException.INPUT, string2);
                }
            }
            object3.put(object, object5.get(set));
            if (!object4.containsKey(string)) {
                object4.put(string, set);
                continue;
            }
            if (object4.get(string) == set) continue;
            throw new SystreException(SystreException.INTERNAL, "Some input symmetries were lost");
        }
        if (object2.size() > 0) {
            this.out.println("   Equivalences for non-unique nodes:");
            Iterator<INode> iterator = object2.iterator();
            while (iterator.hasNext()) {
                Pair pair = (Pair)((Object)iterator.next());
                string = Strings.parsable((String)pair.getFirst(), false);
                object = Strings.parsable((String)pair.getSecond(), false);
                this.out.println("      " + string + " --> " + (String)object);
            }
            this.out.println();
        }
        return object3;
    }

    private void showCoordinationSequences(PeriodicGraph periodicGraph, Net net, Map<INode, String> map) {
        this.out.println("   Coordination sequences:");
        int n = 0;
        boolean bl = true;
        Iterator<Set<INode>> iterator = periodicGraph.nodeOrbits();
        while (iterator.hasNext()) {
            Set<INode> set = iterator.next();
            INode iNode = set.iterator().next();
            this.out.print("      Node " + Strings.parsable(map.get(iNode), false) + ":   ");
            List list = (List)net.getNodeInfo(iNode, NetParser.COORDINATION_SEQUENCE);
            Iterator<Integer> iterator2 = periodicGraph.coordinationSequence(iNode);
            iterator2.next();
            int n2 = 1;
            boolean bl2 = false;
            for (int i = 0; i < 10; ++i) {
                int n3;
                if (n2 > 100000) {
                    bl = false;
                    this.out.print(" ...");
                    break;
                }
                int n4 = iterator2.next();
                this.out.print(" " + n4);
                this.out.flush();
                n2 += n4;
                if (list == null || i >= list.size() || n4 == (n3 = ((Whole)list.get(i)).intValue())) continue;
                bl2 = true;
            }
            this.out.println();
            n += set.size() * n2;
            if (!bl2) continue;
            throw new SystreException(SystreException.INPUT, "Computed CS does not match input");
        }
        this.out.println();
        if (bl) {
            double d = (double)n / (double)periodicGraph.numberOfNodes();
            this.out.println("   TD10 = " + (int)(d + 0.5));
        } else {
            this.out.println("   TD10 not computed.");
        }
        this.out.println();
        this.out.flush();
    }

    private void showPointSymbols(PeriodicGraph periodicGraph, Map<INode, String> map) {
        this.out.println("   Wells point symbols:");
        Iterator<Set<INode>> iterator = periodicGraph.nodeOrbits();
        while (iterator.hasNext()) {
            Set<INode> set = iterator.next();
            INode iNode = set.iterator().next();
            this.out.println("      Node " + Strings.parsable(map.get(iNode), false) + ":   " + periodicGraph.pointSymbol(iNode));
        }
        this.out.println();
        this.out.flush();
    }

    private void processDisconnectedGraph(Net net, String string) {
        this.out.println();
        this.out.println("   Structure is not connected.");
        this.out.println("   Processing components separately.");
        this.out.println();
        this.out.println("   ==========");
        List<PeriodicGraph.Component> list = net.connectedComponents();
        for (int i = 1; i <= list.size(); ++i) {
            PeriodicGraph.Component component = list.get(i - 1);
            this.out.println("   Processing component " + i + ":");
            if (component.getDimension() < net.getDimension()) {
                this.out.println("      dimension = " + component.getDimension());
            } else {
                this.out.println("      multiplicity = " + component.getMultiplicity());
            }
            String string2 = string + "_component_" + i;
            this.processGraph(new Net(component.getGraph(), string2, "P1"), string2, false);
            this.out.println();
            this.out.println("   Finished component " + i + ".");
            this.out.println();
            this.out.println("   ==========");
        }
    }

    private void writeEntry(PrintStream printStream, Archive.Entry entry) {
        printStream.println("       Name:\t\t" + entry.getName());
        if (entry.getDescription() != null) {
            printStream.println("       Description:\t" + entry.getDescription());
        }
        if (entry.getReference() != null) {
            printStream.println("       Reference:\t" + entry.getReference());
        }
        if (entry.getURL() != null) {
            printStream.println("       URL:\t\t" + entry.getURL());
        }
    }

    private void embedGraph(PeriodicGraph periodicGraph, String string, Map<INode, String> map, SpaceGroupFinder spaceGroupFinder, Map<INode, Point> map2, boolean bl, String string2) {
        for (int i = 0; i <= 1; ++i) {
            Object object;
            Object object2;
            Object object3;
            Object object4;
            this.status("Computing an embedding...");
            Embedder embedder = new Embedder(periodicGraph, map2, bl);
            try {
                embedder.setRelaxPositions(false);
                embedder.setPasses(0);
                embedder.go(500);
                embedder.setRelaxPositions(this.relaxPositions && i == 0);
                embedder.setPasses(this.relaxPasses);
                embedder.go(this.relaxSteps);
            }
            catch (Exception exception) {
                this.out.println("==================================================");
                this.out.println("!!! WARNING (INTERNAL) - Could not relax - " + exception.getMessage());
                this.out.println(Misc.stackTrace(exception));
                this.out.println("==================================================");
                embedder.reset();
            }
            embedder.normalize();
            this.quitIfCancelled();
            this.status("Verifying the embedding...");
            IArithmetic iArithmetic = embedder.getGramMatrix().determinant();
            if (iArithmetic.isLessThan(new FloatingPoint(0.001))) {
                this.out.println("==================================================");
                this.out.println("!!! WARNING (INTERNAL) - Unit cell degenerated in relaxation.Reverting to default unit cell.");
                this.out.println("==================================================");
                embedder.reset();
                embedder.normalize();
            }
            if (!embedder.positionsRelaxed() && bl) {
                object4 = embedder.getPositions();
                object3 = periodicGraph.barycentricPlacement();
                int n = 0;
                for (INode iNode : periodicGraph.nodes()) {
                    Point point;
                    object2 = (Point)object4.get(iNode);
                    Vector vector = (Vector)((Point)object2).minus(point = (Point)object3.get(iNode));
                    double d = ((Real)Vector.dot(vector, vector)).sqrt().doubleValue();
                    if (!(d > 1.0E-12)) continue;
                    this.out.println("\t\t@@@ " + iNode + " is at " + object2 + ", but should be " + point);
                    ++n;
                }
                if (n > 0) {
                    object = "Embedder misplaced " + n + " points";
                    throw new SystreException(SystreException.INTERNAL, (String)object);
                }
            }
            this.quitIfCancelled();
            this.status("Preparing the output...");
            object4 = new StringWriter();
            object3 = new PrintWriter((Writer)object4);
            ProcessedNet processedNet = new ProcessedNet(periodicGraph, string, map, spaceGroupFinder, embedder);
            this.setLastStructure(processedNet);
            processedNet.writeEmbedding((Writer)object3, true, this.getOutputFullCell(), "");
            object = ((StringWriter)object4).toString();
            boolean bl2 = false;
            try {
                if (!this.skipOutputTest && periodicGraph.isStable()) {
                    this.status("Consistency test: reading output back in...");
                    object2 = NetParser.stringToNet((String)object);
                    this.quitIfCancelled();
                    this.status("Consistency test: comparing with original net...");
                    if (!((PeriodicGraph)object2).minimalImage().equals(periodicGraph)) {
                        throw new RuntimeException("Output does not match original graph.");
                    }
                }
                this.out.println();
                bl2 = true;
                this.quitIfCancelled();
            }
            catch (Exception exception) {
                if (i == 0) {
                    if (this.relaxPositions) {
                        this.out.println("   Falling back to " + string2 + " positions.");
                    }
                }
                this.out.println("Could not verify output:");
                this.out.println((String)object);
                throw new RuntimeException(exception);
            }
            this.quitIfCancelled();
            if (!bl2) continue;
            this.status("Writing output...");
            processedNet.writeEmbedding(new PrintWriter(this.out), false, this.getOutputFullCell(), embedder.positionsRelaxed() ? "Relaxed" : Strings.capitalized(string2));
            processedNet.setVerified(true);
            this.status("Done!");
            break;
        }
    }

    public void processDataFile(String string) {
        Iterator<Net> iterator = null;
        int n = 0;
        try {
            iterator = Net.iterator(string);
        }
        catch (FileNotFoundException fileNotFoundException) {
            this.out.println("!!! ERROR (FILE) - Could not find file \"" + string + "\".");
            return;
        }
        catch (Net.IllegalFileNameException illegalFileNameException) {
            this.out.println("!!! ERROR (FILE) - " + illegalFileNameException.getMessage());
        }
        this.lastFileNameWithoutExtension = new File(string).getName().replaceFirst("\\..*$", "");
        this.out.println("Data file \"" + string + "\".");
        while (iterator.hasNext()) {
            String string2;
            String string3;
            String string4;
            Exception exception;
            Net net;
            block21: {
                net = null;
                exception = null;
                this.status("Reading...");
                try {
                    net = iterator.next();
                }
                catch (Exception exception2) {
                    exception = exception2;
                }
                this.out.println();
                if (++n > 1) {
                    this.out.println();
                    this.out.println();
                }
                string4 = null;
                try {
                    string4 = net.getName();
                }
                catch (Exception exception3) {
                    if (exception != null) break block21;
                    exception = exception3;
                }
            }
            if (exception == null && !net.isOk()) {
                exception = net.getErrors().next();
            }
            if (string4 == null) {
                string3 = this.lastFileNameWithoutExtension + "-#" + n;
                string2 = "";
            } else {
                string3 = string4;
                string2 = Strings.parsable(string4, true);
            }
            this.out.println("Structure #" + n + " - " + string2 + ".");
            this.out.println();
            if (net != null && net.getWarnings().hasNext()) {
                Iterator<String> iterator2 = net.getWarnings();
                while (iterator2.hasNext()) {
                    this.out.println("   (" + iterator2.next() + ")");
                }
                this.out.println();
            }
            if (exception != null) {
                if (exception instanceof DataFormatException) {
                    this.out.println("==================================================");
                    this.out.println("!!! ERROR (INPUT) - " + exception.getMessage());
                    this.reportErrorLocation(n, string2);
                    this.out.println("==================================================");
                } else {
                    this.reportError(exception, n, string2);
                }
            } else {
                try {
                    this.processGraph(net, string3, true);
                }
                catch (SystreException systreException) {
                    this.out.println("==================================================");
                    this.out.println("!!! ERROR (" + systreException.getType() + ") - " + systreException.getMessage() + ".");
                    this.reportErrorLocation(n, string2);
                    this.out.println("==================================================");
                }
                catch (Exception exception4) {
                    this.reportError(exception4, n, string2);
                }
            }
            this.out.println();
            this.out.println("Finished structure #" + n + " - " + string2 + ".");
        }
        this.out.println();
        this.out.println("Finished data file \"" + string + "\".");
    }

    private void reportError(Throwable throwable, int n, String string) {
        this.out.println("==================================================");
        this.out.println("!!! ERROR (INTERNAL) - Unexpected " + throwable.getClass().getName() + ": " + throwable.getMessage());
        this.reportErrorLocation(n, string);
        this.out.println("!!!    Stack trace:");
        this.out.print(Misc.stackTrace(throwable, "!!!       "));
        this.out.println("==================================================");
    }

    private void reportErrorLocation(int n, String string) {
        this.out.println("!!!    In structure #" + n + " - " + string + ".");
        this.out.println("!!!    Last status: " + this.lastStatus);
    }

    public int writeInternalArchive(Writer writer) throws IOException {
        return this.writeArchive(writer, this.internalArchive);
    }

    public int writeBuiltinArchive(Writer writer) throws IOException {
        return this.writeArchive(writer, this.builtinArchive);
    }

    private int writeArchive(Writer writer, Archive archive) throws IOException {
        int n = 0;
        for (String string : archive.keySet()) {
            Archive.Entry entry = archive.getByKey(string);
            writer.write(entry.toString());
            ++n;
        }
        return n;
    }

    public void run(String[] stringArray) {
        int n;
        LinkedList<String> linkedList = new LinkedList<String>();
        LinkedList<String> linkedList2 = new LinkedList<String>();
        boolean bl = false;
        String string = null;
        for (n = 0; n < stringArray.length; ++n) {
            String string2 = stringArray[n];
            if (string2.equals("-b") || string2.equalsIgnoreCase("--barycentric") || string2.equalsIgnoreCase("-barycentric")) {
                this.setRelaxPositions(false);
                continue;
            }
            if (string2.equals("-d")) {
                this.setDuplicateIsError(true);
                continue;
            }
            if (string2.equals("-a")) {
                if (n == stringArray.length - 1) {
                    this.out.println("!!! WARNING (USAGE) - Argument missing for \"" + string2 + "\".");
                    continue;
                }
                string = stringArray[++n];
                continue;
            }
            if (string2.equalsIgnoreCase("--skipEmbedding") || string2.equalsIgnoreCase("-skipEmbedding")) {
                this.setComputeEmbedding(false);
                continue;
            }
            if (string2.equalsIgnoreCase("--noBuiltin") || string2.equalsIgnoreCase("-noBuiltin")) {
                this.setUseBuiltinArchive(false);
                continue;
            }
            if (string2.equalsIgnoreCase("--firstOrigin") || string2.equalsIgnoreCase("-firstOrigin")) {
                SpaceGroupCatalogue.setPreferSecondOrigin(false);
                continue;
            }
            if (string2.equalsIgnoreCase("--rhombohedral") || string2.equalsIgnoreCase("-rhombohedral")) {
                SpaceGroupCatalogue.setPreferHexagonal(false);
                continue;
            }
            if (string2.equals("-e") || string2.equalsIgnoreCase("--equalEdges") || string2.equalsIgnoreCase("-equalEdges")) {
                if (n == stringArray.length - 1) {
                    this.out.println("!!! WARNING (USAGE) - Argument missing for \"" + string2 + "\".");
                    continue;
                }
                this.relaxPasses = Integer.parseInt(stringArray[++n]);
                continue;
            }
            if (string2.equals("-s") || string2.equalsIgnoreCase("--steps") || string2.equalsIgnoreCase("-steps")) {
                if (n == stringArray.length - 1) {
                    this.out.println("!!! WARNING (USAGE) - Argument missing for \"" + string2 + "\".");
                    continue;
                }
                this.relaxSteps = Integer.parseInt(stringArray[++n]);
                continue;
            }
            if (string2.equalsIgnoreCase("--skipOutputTest") || string2.equalsIgnoreCase("-skipOutputTest")) {
                this.setSkipOutputTest(true);
                continue;
            }
            if (string2.equalsIgnoreCase("--arcAsInput") || string2.equalsIgnoreCase("-arcAsInput")) {
                bl = true;
                continue;
            }
            if (string2.equalsIgnoreCase("--fullUnitCell") || string2.equalsIgnoreCase("-fullUnitCell")) {
                this.setOutputFullCell(true);
                continue;
            }
            if (string2.equalsIgnoreCase("--systreKey") || string2.equalsIgnoreCase("-systreKey")) {
                this.setOutputSystreKey(true);
                continue;
            }
            if (string2.equalsIgnoreCase("--writeConfig") || string2.equalsIgnoreCase("-writeConfig")) {
                if (n == stringArray.length - 1) {
                    this.out.println("!!! WARNING (USAGE) - Argument missing for \"" + string2 + "\".");
                    continue;
                }
                this.saveOptions(stringArray[++n]);
                continue;
            }
            if (string2.equals("-c")) {
                if (n == stringArray.length - 1) {
                    this.out.println("!!! WARNING (USAGE) - Argument missing for \"" + string2 + "\".");
                    continue;
                }
                this.loadOptions(stringArray[++n]);
                continue;
            }
            if (string2.equals("-x")) {
                bl = !bl;
                continue;
            }
            if (stringArray[n].endsWith(".arc") && !bl) {
                linkedList2.add(stringArray[n]);
                continue;
            }
            linkedList.add(stringArray[n]);
        }
        if (linkedList.size() == 0) {
            this.out.println("!!! WARNING (USAGE) - No file names given.");
        }
        n = 0;
        if (string != null) {
            try {
                this.outputArchive = new BufferedWriter(new FileWriter(string));
            }
            catch (IOException iOException) {
                this.out.println("!!! ERROR (FILE) - Could not open output archive:" + iOException);
            }
        }
        for (String string3 : linkedList2) {
            this.processArchive(string3);
        }
        for (String string3 : linkedList) {
            if (++n > 1) {
                this.out.println();
                this.out.println();
                this.out.println();
            }
            this.processDataFile(string3);
        }
        if (this.outputArchive != null) {
            try {
                this.outputArchive.flush();
                this.outputArchive.close();
            }
            catch (IOException iOException) {
                this.out.println("!!! ERROR (FILE) - Output archive not completely written.");
            }
        }
    }

    public static void main(String[] stringArray) {
        new SystreCmdline().run(stringArray);
    }

    private void status(String string) {
        this.lastStatus = string;
        this.dispatchEvent(string);
    }

    public synchronized void cancel() {
        this.cancelled = true;
        this.status("Cancel request received!");
    }

    private void quitIfCancelled() {
        if (this.cancelled) {
            this.cancelled = false;
            throw new SystreException(SystreException.CANCELLED, "Execution stopped for this structure");
        }
    }

    void saveOptions(String string) {
        Properties properties;
        try {
            properties = Config.getProperties(this);
        }
        catch (Exception exception) {
            exception.printStackTrace();
            return;
        }
        try {
            properties.store(new FileOutputStream(string), "Systre options");
        }
        catch (FileNotFoundException fileNotFoundException) {
            this.out.println("Could not find configuration file " + string);
        }
        catch (IOException iOException) {
            this.out.println("Exception occurred while writing configuration file");
        }
    }

    void loadOptions(String string) {
        Properties properties = new Properties();
        try {
            properties.load(new FileInputStream(string));
        }
        catch (FileNotFoundException fileNotFoundException) {
            this.out.println("No configuration file " + string + " - will use default settings.");
            return;
        }
        catch (IOException iOException) {
            this.out.println("Exception occurred while reading configuration file");
            return;
        }
        for (Object object : properties.keySet()) {
            String string2 = (String)object;
            String string3 = System.getProperty(string2);
            if (string3 == null) continue;
            properties.setProperty(string2, string3);
        }
        try {
            Config.pushProperties(properties, this);
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    public ProcessedNet getLastStructure() {
        return this.lastStructure;
    }

    protected void setLastStructure(ProcessedNet processedNet) {
        this.lastStructure = processedNet;
    }

    public boolean getUseBuiltinArchive() {
        return this.useBuiltinArchive;
    }

    public void setUseBuiltinArchive(boolean bl) {
        this.useBuiltinArchive = bl;
    }

    public boolean getComputeEmbedding() {
        return this.computeEmbedding;
    }

    public void setComputeEmbedding(boolean bl) {
        this.computeEmbedding = bl;
    }

    public boolean getUseOriginalEmbedding() {
        return this.useOriginalEmbedding;
    }

    public void setUseOriginalEmbedding(boolean bl) {
        this.useOriginalEmbedding = bl;
    }

    public boolean getRelaxPositions() {
        return this.relaxPositions;
    }

    public void setRelaxPositions(boolean bl) {
        this.relaxPositions = bl;
    }

    public int getRelaxPasses() {
        return this.relaxPasses;
    }

    public void setRelaxPasses(int n) {
        this.relaxPasses = n;
    }

    public int getRelaxSteps() {
        return this.relaxSteps;
    }

    public void setRelaxSteps(int n) {
        this.relaxSteps = n;
    }

    public boolean getSkipOutputTest() {
        return this.skipOutputTest;
    }

    public void setSkipOutputTest(boolean bl) {
        this.skipOutputTest = bl;
    }

    public boolean getComputePointSymbols() {
        return this.computePointSymbols;
    }

    public void setComputePointSymbols(boolean bl) {
        this.computePointSymbols = bl;
    }

    public boolean getDuplicateIsError() {
        return this.duplicateIsError;
    }

    public void setDuplicateIsError(boolean bl) {
        this.duplicateIsError = bl;
    }

    protected PrintStream getOutStream() {
        return this.out;
    }

    protected void setOutStream(PrintStream printStream) {
        this.out = printStream;
    }

    public boolean getOutputFullCell() {
        return this.outputFullCell;
    }

    public void setOutputFullCell(boolean bl) {
        this.outputFullCell = bl;
    }

    public boolean getOutputSystreKey() {
        return this.outputSystreKey;
    }

    public void setOutputSystreKey(boolean bl) {
        this.outputSystreKey = bl;
    }

    static {
        Locale.setDefault(Locale.US);
    }
}

